<?php if (!empty($product['product_description']) && trim($product['product_description']) != '') { ?>
<div class="product-details">
    <h2 class="block-title">
        <?php echo Labels::getLabel('LBL_Description', $siteLangId); ?>
    </h2>
    <div class="cms">
        <?php echo CommonHelper::renderHtml($product['product_description'],true); ?>
    </div>
</div>
<?php } ?>
<?php if (!empty($product['selprodRentalTerms']) && trim($product['selprodRentalTerms']) != "") { ?>
<div class="product-details">
    <h2 class="block-title">
        <?php echo Labels::getLabel('LBL_Rental_Terms', $siteLangId); ?>
    </h2>
    <div class="cms">
        <?php echo CommonHelper::renderHtml($product['selprodRentalTerms']); ?>
    </div>
</div>
<?php } ?>



<?php $youtube_embed_code = UrlHelper::parseYoutubeUrl($product["product_youtube_video"]); ?>
<?php if (!empty($youtube_embed_code) && trim($youtube_embed_code) != '') { ?>
<div class="product-details">
    <div class="mb-4 video-wrapper">
        <iframe width="100%" height="315" src="//www.youtube.com/embed/<?php echo $youtube_embed_code ?>"
            allowfullscreen></iframe>
    </div>
</div>
<?php } ?>
<?php if ($shop['shop_payment_policy'] != '' || !empty($shop["shop_delivery_policy"] != "") || !empty($shop["shop_delivery_policy"] != "")) { ?>
<div class="detail__product--policy">
    <?php if ($shop['shop_payment_policy'] != '') { ?>
    <div class="product-details">
        <h2 class="block-title">
            <?php echo Labels::getLabel('LBL_Shop_Policies', $siteLangId); ?>
        </h2>
        <h5 class="description-title ">
            <?php echo Labels::getLabel('LBL_Payment_Policy', $siteLangId) ?>
        </h5>
        <div class="product-details__text">
            <?php echo nl2br($shop['shop_payment_policy']); ?>
        </div>
        <?php if (strlen($shop['shop_payment_policy']) > 300) { ?>
        <button type="button"  class="link-underline readmore--js">
            <?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?>
        </button>
        <?php } ?>
    </div>

    <?php } ?>
    <?php if ($shop['shop_delivery_policy'] != '') { ?>
    <div class="product-details">
        <h5 class="description-title ">
            <?php echo Labels::getLabel('LBL_Delivery_Policy', $siteLangId) ?>
        </h5>
        <div class="product-details__text">
            <?php echo nl2br($shop['shop_delivery_policy']); ?>
        </div>
        <?php if (strlen($shop['shop_delivery_policy']) > 300) { ?>
        <button type="button" class="link-underline readmore--js">
            <?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?>
        </button>
        <?php } ?>
    </div>
    <?php } ?>
    <?php if ($shop['shop_refund_policy'] != '') { ?>
    <div class="product-details">
        <h5 class="description-title ">
            <?php echo Labels::getLabel('LBL_Refund_Policy', $siteLangId) ?>
        </h5>
        <div class="product-details__text">
            <?php echo nl2br($shop['shop_refund_policy']); ?>
        </div>
        <?php if (strlen($shop['shop_refund_policy']) > 300) { ?>
        <button type="button"  class="link-underline readmore--js">
            <?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?>
        </button>
        <?php } ?>
    </div>
    <?php } ?>
</div>
<?php } ?>
<?php if (!empty($product['selprodComments'])) { ?>
<div class="product-details">
    <h5 class="description-title ">
        <?php echo Labels::getLabel('LBL_Additional_Comments_From_Seller', $siteLangId); ?>
    </h5>
    <div class="product-details__text">
        <?php echo CommonHelper::displayNotApplicable($siteLangId, nl2br($product['selprodComments'])); ?>
    </div>
    <?php if (strlen($product['selprodComments']) > 300) { ?>
    <button type="button" class="link-underline readmore--js">
        <?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?>
    </button>
    <?php } ?>
</div>
<?php } ?>
<style>
.product-details__text {
    display: -webkit-box;
    -webkit-line-clamp: 5;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.product-details__text.detail-expand--js {
    -webkit-line-clamp: initial;
}
</style>