<?php if (strtolower($controllerName) != 'guestuser' || (strtolower($controllerName) == 'guestuser' && strtolower($action) == 'registrationsuccess')) { ?>
<?php if (FatApp::getConfig('CONF_ENABLE_NEWSLETTER_SUBSCRIPTION', FatUtility::VAR_INT, 0) && !$isUserDashboard) { ?>
<section class="section collection-newsletter no-print" data-collection="collection-name">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="section-head section-head-center mb-0">
                    <div class="section-heading text-center">
                        <h5>
                            <?php echo Labels::getLabel('LBL_Sign_up_to_be_the_first_to_hear_about_big_news.', $siteLangId); ?>
                        </h5>
                        <h2>
                            <?php echo Labels::getLabel('LBL_Want_Yo!rent_updates_sent_straight_to_your_inbox?', $siteLangId); ?>
                        </h2>
                    </div>
                </div>
                <?php $this->includeTemplate('_partial/footerNewsLetterForm.php'); ?>
            </div>
        </div>
    </div>
</section>
<?php } ?>

<?php if ($isUserDashboard) { ?>
<footer class="footer">
    <?php include_once(CONF_THEME_PATH . 'default/_partial/copyright.php'); ?>
    <?php $this->includeTemplate('_partial/footerUserMobile.php', ['siteLangId' => $siteLangId]); ?>
</footer>
<?php } ?>
<div id="offcanvas-cart" tabindex="-1"></div>
<?php if (!$isUserDashboard) { ?>
<footer class="footer" data-collection="f-equipment">
    <section class="footer-top">
        <div class="container">
            <div class="footer-top-blocks">
                <?php Navigation::footerNavigation(); //$this->includeTemplate('_partial/footerNavigation.php'); 
                                ?>
                <div class="footer-top-social">
                    <h6 class="blocks-head">
                        <?php echo Labels::getLabel('LBL_social_platform', $siteLangId); ?>
                    </h6>
                    <?php $this->includeTemplate('_partial/footerSocialMedia.php'); ?>
                    <div class="drop-footer">
                        <?php $this->includeTemplate('_partial/headerLanguageArea.php'); ?>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <?php include_once(CONF_THEME_PATH . 'default/_partial/copyright.php'); ?>

    <?php if (CommonHelper::demoUrl()) { ?>
    <section class="footer-bottom footer__disclaimer">
        <div class="container">
            <?php $this->includeTemplate('_partial/disclaimer.php'); ?>
        </div>
    </section>
    <?php } ?>
</footer>
<?php
        if (strtolower($controllerName) != 'cart' && strtolower($controllerName) != 'checkout') {
            ?>
<div class="mobile-actions">
    <div class="mobile-actions-item" role="none">
        <a class="mobile-actions-link" href="<?php echo UrlHelper::generateFullUrl(); ?>">
            <svg class="svg" width="24" height="24">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#home">
                </use>
            </svg>
            <span class="txt">
                <?php echo Labels::getLabel('LBL_Home', $siteLangId) ?>
            </span>
        </a>
    </div>
    <div class="mobile-actions-item" role="none">
        <button type="button" class="mobile-actions-link btn-open first">
            <svg class="svg" width="24" height="24">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#category">
                </use>
            </svg>
            <span class="txt">
                <?php echo Labels::getLabel('LBL_Menu', $siteLangId) ?>
            </span>
        </button>
    </div>
    <div class="mobile-actions-item" role="none">
        <button class="mobile-actions-link" aria-label="<?php echo Labels::getLabel('LBL_Search', $siteLangId) ?>"
            data-bs-toggle="offcanvas" data-bs-target="#main-search-top" aria-controls="main-search-top">
            <svg class="svg" width="24" height="24">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#magnifier">
                </use>
            </svg>
            <span class="txt">
                <?php echo Labels::getLabel('LBL_Search', $siteLangId) ?>
            </span>
        </button>
    </div>

    <div class="mobile-actions-item" role="none">
        <?php if ((!UserAuthentication::isUserLogged() && UserAuthentication::isGuestUserLogged()) || UserAuthentication::isUserLogged()) { ?>
        <button class="mobile-actions-link" type="button" data-bs-toggle="offcanvas"
            data-bs-target="#offcanvas-account">
            <?php } else { ?>
            <button class="mobile-actions-link sign-in-popup-js" type="button">
                <?php } ?>
                <svg class="svg" width="24" height="24">
                    <use
                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#account">
                    </use>
                </svg>
                <span class="txt">
                    <?php echo Labels::getLabel("LBL_Account", $siteLangId); ?>
                </span>
            </button>
    </div>
    <div class="mobile-actions-item" role="none">
        <button class="mobile-actions-link" type="button" data-bs-toggle="offcanvas"
            data-bs-target="#offcanvas-gps-location">
            <svg class="svg" width="24" height="24">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#location">
                </use>
            </svg>
            <span class="txt">
                <?php echo Labels::getLabel('LBLL_Location', $siteLangId) ?>
            </span>
        </button>
    </div>
</div>
<div class="zeynep">
    <ul>
        <?php Navigation::mobileMegaNavigation(); ?>
        <?php Navigation::mobileNavigation(); ?>
    </ul>
</div>
<div class="zeynep-overlay"></div>
<?php } ?>
<?php } ?>
<?php $this->includeTemplate('_partial/footerMenuBarSlides.php'); ?>
<?php } ?>
<?php $this->includeTemplate('_partial/footerCookies.php', ['siteLangId' => $siteLangId]); ?>

<?php if (!isset($_SESSION['geo_location']) /* && FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '') != '' */) { ?>
<script
    src='https://maps.google.com/maps/api/js?key=<?php echo FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, ''); ?>&libraries=places&loading=async&callback=googleAddressAutocomplete'>
</script>
<?php
}

if (FatApp::getConfig('CONF_ENABLE_LIVECHAT', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_LIVE_CHAT_CODE', FatUtility::VAR_STRING, '');
}

if (FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '');
}
?>

<div class="no-print">
    <?php
    if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) {
        $this->includeTemplate('restore-system/page-content.php');
    }


    if (FatApp::getConfig('CONF_PWA_SERVICE_WORKER', FatUtility::VAR_INT, 1)) {
        ?>
    <script>
    $(document).ready(function() {
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register(
                    '<?php echo CONF_WEBROOT_URL; ?>sw.js?t=<?php echo filemtime(CONF_INSTALLATION_PATH . 'public/sw.js'); ?>&f'
                ).then(function(registration) {});
            });
        }
    });
    </script>
    <?php } ?>
</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-hidden="true"></div>
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-hidden="true"></div>
<?php
if (CommonHelper::demoUrl()) {
    $this->includeTemplate('_partial/requestDemoPopup.php');
    $this->includeTemplate('restore-system/page-content.php');
}
?>
<?php
if (FatApp::getConfig("CONF_ENABLE_ENGAGESPOT_PUSH_NOTIFICATION", FatUtility::VAR_STRING, '') && UserAuthentication::getLoggedUserId(true) > 0) { ?>
<script>
$.getScript("https://cdn.engagespot.co/engagespot-client.min.js", function(data, textStatus, jqxhr) {
    Engagespot.render('#engagespotUI', {
        apiKey: "<?php echo FatApp::getConfig("CONF_ENGAGESPOT_API_KEY", FatUtility::VAR_STRING, ''); ?>",
        userId: "<?php echo UserAuthentication::getLoggedUserAttribute("user_email", true); ?>",
        userSignature: "<?php echo base64_encode(hash_hmac('sha256', UserAuthentication::getLoggedUserAttribute("user_email", true), FatApp::getConfig("CONF_ENGAGESPOT_SECRET_KEY", FatUtility::VAR_STRING, ''), true)); ?>"
    });
});
</script>
<?php } ?>
</body>

</html>