<div class="wrapper">
    <!--Heavy-Equipment header start here-->
    <header class="header no-print" id="Heavy-Equipment">
        <?php if (CommonHelper::demoUrl()) {
            $this->includeTemplate('restore-system/top-header.php');
        } ?>
        <div class="header-top">
            <div class="container">
                <div class="header-top-inner">
                    <div class="header-top-left">
                        <?php
                        if (CommonHelper::isThemePreview() && isset($_SESSION['preview_theme'])) {
                            $logoUrl = UrlHelper::generateUrl('home', 'index');
                        } else {
                            $logoUrl = UrlHelper::generateUrl();
                        }
                        ?>
                        <?php
                        $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
                        $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);
                        $sizeType = 'CUSTOM';
                        $logoClass = "logo--custom";
                        if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                            $sizeType = '16X9';
                            $logoClass = "";
                        } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                            $sizeType = '1X1';
                            $logoClass = "";
                        }

                        $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                        $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                        ?>
                        <div class="logo <?php echo $logoClass; ?>">
                            <a class="logo-link" href="<?php echo $logoUrl; ?>">
                                <img fetchpriority="high" decoding="async" data-nimg="1"
                                    <?php if ($fileData['afile_aspect_ratio'] > 0) { ?>
                                    data-ratio="<?php echo $aspectRatioArr[$fileData['afile_aspect_ratio']]; ?>"
                                    <?php } ?> src="<?php echo $siteLogo; ?>"
                                    alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                                    title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                            </a>
                        </div>

                        <?php if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') { ?>
                        <?php
                                $geoAddress = '';
                                if ((!isset($_COOKIE['_ykGeoLat']) || !isset($_COOKIE['_ykGeoLng']) || !isset($_COOKIE['_ykGeoCountryCode'])) && FatApp::getConfig('CONF_DEFAULT_GEO_LOCATION', FatUtility::VAR_INT, 0)) {
                                    $geoAddress = FatApp::getConfig('CONF_GEO_DEFAULT_ADDR', FatUtility::VAR_STRING, '');
                                    if (empty($address)) {
                                        $address = FatApp::getConfig('CONF_GEO_DEFAULT_ZIPCODE', FatUtility::VAR_INT, 0) . '-' . FatApp::getConfig('CONF_GEO_DEFAULT_STATE', FatUtility::VAR_STRING, '');
                                    }
                                }
                                if (empty($geoAddress)) {
                                    $geoAddress = Labels::getLabel("Lbl_Select_Location", $siteLangId);
                                }
                                $defaultCheckoutType = isset($_COOKIE["locationCheckoutType"]) ? $_COOKIE["locationCheckoutType"] : FatApp::getConfig('CONF_DEFAULT_LOCATION_CHECKOUT_TYPE', FatUtility::VAR_STRING, Shipping::FULFILMENT_SHIP);
                                if ($defaultCheckoutType == Shipping::FULFILMENT_PICKUP) {
                                    $fullfillmentType = Shipping::FULFILMENT_PICKUP;
                                    $fullfillmentTypeLbl = Labels::getLabel('Lbl_Pickup_At', $siteLangId);
                                } else {
                                    $fullfillmentType = Shipping::FULFILMENT_SHIP;
                                    $fullfillmentTypeLbl = Labels::getLabel('Lbl_Shipping_to', $siteLangId);
                                }
                                ?>
                        <div class="location-actions">
                            <div class="select-by" id="fullfillment-type-js">
                                <span id="fullfillment-label-js">
                                    <?php echo $fullfillmentTypeLbl; ?>
                                </span>
                                <input type="hidden" name="fullfillment_type"
                                    value="<?php echo $fullfillmentType; ?>" />
                            </div>
                            <div class="geo-location">
                                <button class="button-geo-location geo-location-trigger" type="button"
                                    data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true"
                                    aria-expanded="false">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#location">
                                        </use>
                                    </svg>

                                    <span class="geo-location-selected">
                                        <?php echo isset($_COOKIE["_ykGeoAddress"]) ? $_COOKIE["_ykGeoAddress"] : $geoAddress; ?>
                                    </span>
                                </button>
                                <div class="dropdown-menu dropdown-menu-anim geo-location-dropdown-menu">
                                    <div class="geo-location-body">
                                        <button class="btn btn-brand btn-icon btn-block btn-detect" type="button"
                                            onclick="loadGeoLocation()">

                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#location-detect">
                                                </use>
                                            </svg>
                                            <span>
                                                <?php echo Labels::getLabel('Lbl_Detect_my_current_location', $siteLangId); ?>
                                            </span>
                                        </button>

                                        <div class="or">
                                            <span>
                                                <?php echo Labels::getLabel('Lbl_OR', $siteLangId); ?>
                                            </span>
                                        </div>

                                        <input class="location_input form-control omni-search pac-target-input"
                                            type="text" name="location"
                                            placeholder="<?php echo Labels::getLabel("LBL_Search_for_...", $siteLangId); ?>"
                                            id="ga-autoComplete" autocomplete="off"
                                            value="<?php echo (isset($_COOKIE['_ykGeoAddress'])) ? $_COOKIE['_ykGeoAddress'] : ""; ?>" />
                                    </div>

                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="header-top-right quick-nav">
                        <div class="quick-nav-item item-desktop">
                            <button class="quick-nav-links"
                                aria-label="<?php echo Labels::getLabel('LBL_Search', $siteLangId) ?>"
                                data-bs-toggle="offcanvas" data-bs-target="#main-search-top"
                                aria-controls="main-search-top">
                                <svg class="svg" height="18" width="18">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#magnifier">
                                    </use>
                                </svg>
                                <span class="quick-nav-txt">
                                    <?php echo Labels::getLabel('LBL_Search', $siteLangId); ?>
                                </span>
                            </button>
                        </div>
                        <div class="quick-nav-item item-desktop">
                            <?php $this->includeTemplate('_partial/headerUserArea.php'); ?>
                        </div>
                        <?php if ($controllerName != 'Cart') { ?>
                        <div class="quick-nav-item cart" id="cartSummary">
                            <?php $this->includeTemplate('_partial/headerWishListAndCartSummary.php'); ?>

                        </div>
                        <?php } ?>


                        <?php
                        if (FatApp::getConfig("CONF_ENABLE_ENGAGESPOT_PUSH_NOTIFICATION", FatUtility::VAR_STRING, '') && UserAuthentication::getLoggedUserId(true) > 0) {
                        ?>
                        <div class="quick-nav-item header__account">
                            <div class="btn-engagespot" id="engagespotUI"></div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-last">
            <div class="container">
                <div class="navigation-wrapper">
                    <ul class="navigation">
                        <?php Navigation::headerMegaNavigation(); ?>
                        <?php Navigation::headerNavigation(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php $postedData = Product::convertArrToSrchFiltersAssocArr(FatApp::getParameters());
        $this->includeTemplate('_partial/header/site-search-form.php', ['searchForm' => Common::getSiteSearchForm(), 'siteLangId' => $siteLangId, 'postedData' => $postedData, 'isHeader' => true], false); ?>
    </header>