<?php if (isset($collection['brands']) && count($collection['brands']) > 0) { ?>
    <section class="section section-brands" data-collection="collection-name">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-4">
                    <div class="section-head mb-0">
                        <div class="section-heading">
                            <?php echo ($collection['collection_description'] != '') ? ' <p  class="section-heading-little">' . $collection['collection_description'] . '</p>' : ''; ?>
                            <?php echo ($collection['collection_name'] != '') ? ' <h2>' . $collection['collection_name'] . '</h2>' : ''; ?>
                            <?php if ($collection['totBrands'] > 4) { ?>
                                <div class="section-head-action">
                                    <a href="<?php echo UrlHelper::generateUrl('Collections', 'View', array($collection['collection_id'])); ?>"
                                        class="link-arrow">
                                        <?php echo Labels::getLabel('LBL_View_More', $siteLangId); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <?php if ($collection['totBrands'] > 4) { ?>
                        <div class="slide-arrow arrowcontainer--<?php echo $collection['collection_id'] ?>">
                            <button class="slide--arrows arrow-prev" aria-label="prev"></button>
                            <button class="slide--arrows arrow-next" aria-label="next"></button>
                        </div>
                    <?php } ?>
                    <div class="brands <?php echo ($collection['totBrands'] > 4) ? "js-carousel slider-wrapper" : "brands"; ?>"
                        data-slides="4,3,2,1" data-infinite="false" data-arrows="true" data-slickdots="false"
                        dir="<?php echo CommonHelper::getLayoutDirection(); ?>"
                        data-arrowcontainer="arrowcontainer--<?php echo $collection['collection_id'] ?>"
                        data-customarrow="true" id="slider_<?php echo $collection['collection_id'] ?>">
                        <?php $i = 1;
                        foreach ($collection['brands'] as $brand) {
                            /*$class = ($i > 4) ? 'pd-tb-9' : '';*/
                            ?>

                            <?php
                            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_BRAND_FEATURED_IMAGE, $brand['brand_id'], 0, 0, false);
                            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId);
                            $ratio = "";
                            if (isset($fileData['afile_aspect_ratio']) && $fileData['afile_aspect_ratio'] > 0 && isset($aspectRatioArr[$fileData['afile_aspect_ratio']])) {
                                $ratio = $aspectRatioArr[$fileData['afile_aspect_ratio']];
                            } ?>
                            <a class="js-carousel-item brands-item"
                                href="<?php echo UrlHelper::generateUrl('brands', 'View', array($brand['brand_id'])); ?>">
                                <img class="brands-img" loading='lazy' data-ratio="<?php echo $ratio; ?>"
                                    src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'brandFeaturedImage', array($brand['brand_id'], $siteLangId, 'LOGONEW')), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                    alt="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $brand['brand_name']; ?>"
                                    title="<?php echo (!empty($fileData['afile_attribute_alt'])) ? $fileData['afile_attribute_alt'] : $brand['brand_name']; ?>">
                            </a>


                            <?php $i++;
                        }
                        ?>

                    </div>
                </div>
            </div>
		</div>	
    </section>
<?php } ?>