<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmBuyProduct->setFormTagAttribute('class', 'form');
$buyQuantity = $frmBuyProduct->getField('quantity');
$buyQuantity->addFieldTagAttribute('class', 'qty-input cartQtyTextBox productQty-js');
$buyQuantity->addFieldTagAttribute('data-page', 'product-view');

$rentalAvailableDate = date('Y-m-d');
$selectedFullfillmentType = (isset($_COOKIE['locationCheckoutType'])) ? FatUtility::int($_COOKIE['locationCheckoutType']) : FatApp::getConfig('CONF_DEFAULT_LOCATION_CHECKOUT_TYPE', FatUtility::VAR_INT, 1);
if ($selectedFullfillmentType == Shipping::FULFILMENT_SHIP && ($fulfillmentType == Shipping::FULFILMENT_ALL || $fulfillmentType == Shipping::FULFILMENT_SHIP)) {
    $rentalAvailableDate = date('Y-m-d', strtotime('+ ' . FatUtility::int($minShipDuration) . ' days', strtotime($rentalAvailableDate)));
}

if (strtotime($product['sprodata_rental_available_from']) > strtotime($rentalAvailableDate)) {
    $rentalAvailableDate = $product['sprodata_rental_available_from'];
}

if (!empty($extendedOrderData)) {
    $rentalAvailableDate = $extendedOrderData['opd_rental_end_date'];
}

$availableForSale = false;
if ($product['selprod_active'] == applicationConstants::ACTIVE) {
    $availableForSale = true;
}

$availableForRent = false;
if ($product['sprodata_rental_active'] == applicationConstants::ACTIVE) {
    $availableForRent = true;
}
$minDate  = date('Y-m-d', strtotime('-1 day'));
if($minDate < $rentalAvailableDate ){
    $minDate = $rentalAvailableDate;
}
?>
<section class="product-details--js">
    <div class="breadcrumbs-bar">
        <div class="container">
            <div class="breadcrumbs">
                <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="row">
                    <?php include(CONF_THEME_PATH_WITH_THEME_NAME . 'products/product-images.php'); ?>
                    <?php include(CONF_THEME_PATH_WITH_THEME_NAME . 'products/product-details.php'); ?>
                </div>
            </div>
        </div>
    </div>

</section>

<?php
$dataToSend = [
    'products' => array(),
    'siteLangId' => $siteLangId,
    'compProdCount' => (isset($compProdCount)) ? $compProdCount : 0,
    'prodInCompList' => (isset($prodInCompList)) ? $prodInCompList : [],
    'comparedProdSpecCatId' => (isset($comparedProdSpecCatId)) ? $comparedProdSpecCatId : 0,
    'heading' => '',
];
/*
if (!empty($upsellProducts) && ALLOW_SALE) {
    ?>
<section class="section detail-slide">
    <?php
        $dataToSend['products'] = $upsellProducts;
        $dataToSend['sectionId'] = 2;
        $dataToSend['heading'] = Labels::getLabel('LBL_Buy_Together_Products', $siteLangId);
        echo $this->includeTemplate('products/products-in-slider.php', $dataToSend);
        ?>
</section>
<?php } */ ?>

<!-- [ REVIEWS SECTION GOES HERE.... -->
<?php if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) { ?>
    <?php echo $frmReviewSearch->getFormHtml(); ?>
    <?php $this->includeTemplate('fashion/_partial/product-reviews.php', array('reviews' => $reviews, 'siteLangId' => $siteLangId, 'product_id' => $product['product_id'], 'canSubmitFeedback' => $canSubmitFeedback, 'ratingAspects' => $ratingAspects, 'sellerId' => $product['selprod_user_id']), false); ?>
<?php } ?>
<!-- ] -->

<?php if ($relatedProductsRs) {
    $dataToSend['products'] = $relatedProductsRs;
    $dataToSend['sectionId'] = 3;
    $dataToSend['heading'] = Labels::getLabel('LBL_Similar_Products', $siteLangId);

    ?>
    <section class="section  detail-slide" data-collection="collection-similar">
        <?php echo $this->includeTemplate('products/products-in-slider.php', $dataToSend); ?>
    </section>
<?php } ?>

<section class="section detail-slide" id="recentlyViewedProductsDiv" data-collection="collection-recently"></section>

<?php echo $this->includeTemplate('_partial/compareProducts.php', ['compProdCount' => $compProdCount]); ?>
<?php
$disableSlotsData = CommonHelper::getDisabledSlots($unavailableDates);
$fullDisabledDates = $disableSlotsData['disabledFullDays'];
$disableSlots = $disableSlotsData['disableSlots'];
$unavailableDatesSlots = $disableSlotsData['partialDisabledDates'];
$disabledDays = $disableSlotsData['disabledDays'];
?>
<?php echo $this->includeTemplate('_partial/product/datetimepicker-script.php', ['unavailableDatesSlots' => $unavailableDatesSlots,'disableSlots' => $disableSlots,'minDate' => $minDate,'rentalAvailableDate'=>$rentalAvailableDate,'fullDisabledDates'=>$fullDisabledDates,'disabledDays'=>$disabledDays]); ?>
<?php echo $this->includeTemplate('_partial/compareProducts.php', ['compProdCount' => $compProdCount]); ?>



<script type="text/javascript">
    productPage = 1;
    var mainSelprodId = <?php echo $product['selprod_id']; ?>;
    var layout = '<?php echo CommonHelper::getLayoutDirection(); ?>';
    $("document").ready(function() {
        recentlyViewedProducts(<?php echo $product['selprod_id']; ?>);
        window.setInterval(function() {
            var scrollPos = $(window).scrollTop();
            if (scrollPos > 0) {
                setProductWeightage('<?php echo $product['selprod_code']; ?>');
            }
        }, 5000);
    });
</script>
<script>
    $(function() {
        $('.popup-image--js, .images-gallery--js a, .images-gallery--js img').click(function(e) {
            e.preventDefault();
            e.stopPropagation();
            let path = "";
            if (e.target.tagName == "IMG") {
                path = $(e.target).parent("a").attr('href');
            } else {
                path = e.target.getAttribute('href');
            }
            $("#exampleModal").html(`
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                    <img src="${path}"/>
                    </div>
                </div>
            </div>
        `);
            $('#exampleModal').modal('show');
        });
    });
</script>

<?php
if (FatApp::getConfig("CONF_DEFAULT_SCHEMA_CODES_SCRIPT", FatUtility::VAR_STRING, '')) {
    $image = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_IMAGE, $product['product_id']);
    ?>
    <script type="application/ld+json">
        {
            "@context": "http://schema.org",
            "@type": "Product",
            "aggregateRating": {
                "@type": "AggregateRating",
                "ratingValue": "<?php echo round(FatUtility::convertToType($reviews['prod_rating'], FatUtility::VAR_FLOAT), 1); ?>",
        "reviewCount": "<?php echo FatUtility::int($reviews['totReviews']); ?>"
    },
    "description": "<?php echo CommonHelper::renderHtml($product['product_description'],true); ?>",
    "name": "<?php echo $product['selprod_title']; ?>",
    "image": "<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'product', array($product['product_id'], 'THUMB', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg'); ?>",
    "offers": {
        "@type": "Offer",
        "availability": "http://schema.org/InStock",
        "price": "<?php echo $product['theprice']; ?>",
        "priceCurrency": "<?php echo CommonHelper::getCurrencyCode(); ?>"
    }
}
    </script>
<?php } ?>
<!-- End Product Schema Code -->

<!--Here is the facebook OG for this product  -->
<?php echo $this->includeTemplate('_partial/shareThisScript.php'); ?>

<script>
    $('.readmore--js').on('click', function() {
        $(this).parents('.product-details').find('.product-details__text').toggleClass('detail-expand--js');
        if ($(this).parents('.product-details').find('.product-details__text').hasClass('detail-expand--js') ==
            true) {
            $(this).text('<?php echo Labels::getLabel('LBL_Read_Less', $siteLangId) ?>');
        } else {
            $(this).text('<?php echo Labels::getLabel('LBL_Read_More', $siteLangId) ?>');
        }
    });
</script>
