<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$listType = 'listing-products--grid';
if (isset($postedData['vtype']) && $postedData['vtype'] != 'map') {
    $listType = ($postedData['vtype'] == 'list') ? 'listing-products--list' : 'listing-products--grid';
}
$pageRecordCount = (isset($pageRecordCount)) ? $pageRecordCount : count($products);
$pageSize = (isset($pageSize)) ? $pageSize : $postedData['pageSize'];

?>
<div class="<?php echo $listType; ?>" id="productsList">
    <?php
    if (isset($postedData['vtype']) && $postedData['vtype'] == 'map') {
        include (CONF_THEME_PATH_WITH_THEME_NAME . 'products/products-list-map.php');
    } else {
        //$colMdVal = isset($colMdVal) ? $colMdVal : 4;
        $colMdVal = 4;
        $displayProductNotAvailableLable = false;
        if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') {
            $displayProductNotAvailableLable = true;
        }
        ?>

        <?php if ($products) { ?>
            <div class="product-listing" data-view="<?php echo $colMdVal; ?>">
                <?php
                $showActionBtns = !empty($showActionBtns) ? $showActionBtns : false;
                $isWishList = isset($isWishList) ? $isWishList : 0;
                ?>
                <?php
                foreach ($products as $product) {
                    $product['isListingPage'] = true;
                    $productUrl = UrlHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                    $extraClsss = '';
                    $this->includeTemplate(
                        '_partial/collection/product-listing-tile-layout.php',
                        array(
                            'product' => $product,
                            'siteLangId' => $siteLangId,
                            'extraClsss' => '',
                            'compProdCount' => $compProdCount,
                            'comparedProdSpecCatId' => $comparedProdSpecCatId,
                            'displayProductNotAvailableLable' => $displayProductNotAvailableLable,
                            'searchProductType' => (isset($postedData['producttype']) && !empty($postedData['producttype'])) ? $postedData['producttype'][0] : applicationConstants::PRODUCT_FOR_RENT,
                        )
                    );
                    ?>
                <?php } ?>
            </div>

            <?php
            $searchFunction = 'goToProductListingSearchPage';
            if (isset($pagingFunc)) {
                $searchFunction = $pagingFunc;
            }

            $postedData['page'] = (isset($page)) ? $page : 1;
            $postedData['recordDisplayCount'] = $recordCount;
            echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
            $pagingArr = array('pageCount' => $pageCount, 'page' => $postedData['page'], 'recordCount' => $recordCount, 'callBackJsFunc' => $searchFunction, 'removePageCentClass' => 1, 'siteLangId' => $siteLangId); ?>
            <div class="collection-pager">
                <?php
                $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
                if (!isset($removePageSize)) {
                    ?>
                    <select name="pageSizeSelect" id="pageSizeSelect" class="custom-select sorting-select nice-select">
                        <?php foreach ($pageSizeArr as $key => $val) { ?>
                            <option value="<?php echo $key; ?>" <?php echo ($key == $pageSize) ? 'selected' : ''; ?>><?php echo $val; ?>
                            </option>
                        <?php } ?>
                    </select>
                <?php } ?>
            </div>
        <?php } else { ?>
            <?php
            $arr['recordDisplayCount'] = $recordCount;
            echo FatUtility::createHiddenFormFromData($arr, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
            $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
            $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
            ?>
            <?php
        }
    }
    ?>
</div>
<script>
    $(document).ready(function () {
        var e = document.getElementById("pageSizeSelect");
        if (e != undefined && e != null) {
            var pageSize = e.options[e.selectedIndex].value;
            $('#pageSize').val(pageSize);
        }
    })
</script>