<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (!empty($products)) { ?>
    <div class="container">
        <div class="d-flex justify-content-between">
            <div class="section-head">
                <div class="section-heading">
                    <h2>
                        <?php echo $heading; ?>
                    </h2>
                </div>

                <?php if (count($products) > 4) { ?>
                    <div class="section-head-action">
                        <div
                            class="related_prod slide-arrow arrowcontainer--<?php echo (isset($sectionId)) ? $sectionId : 1; ?>">
                            <button class="slide--arrows arrow-prev" aria-label="prev"></button>
                            <button class="slide--arrows arrow-next" aria-label="next"></button>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="section-body">
            <div class="slider-wrapper <?php echo (count($products) > 4) ? "js-carousel" : ""; ?>" data-slides="5,3,1,1,1"
                data-infinite="false" data-arrows="true" data-slickdots="false" data-swipe="true"
                dir="<?php echo CommonHelper::getLayoutDirection(); ?>"
                data-arrowcontainer="arrowcontainer--<?php echo (isset($sectionId)) ? $sectionId : 1; ?>"
                id="slider_<?php echo (isset($sectionId)) ? $sectionId : 1; ?>" data-customarrow="true">
                <?php
                foreach ($products as $rproduct) {
                    $dataToSend = [
                        'product' => $rproduct,
                        'siteLangId' => $siteLangId,
                        'compProdCount' => (isset($compProdCount)) ? $compProdCount : 0,
                        'prodInCompList' => (isset($prodInCompList)) ? $prodInCompList : 0,
                        'comparedProdSpecCatId' => (isset($comparedProdSpecCatId)) ? $comparedProdSpecCatId : 0,
                    ];
                    echo $this->includeTemplate('_partial/collection/product-listing-tile-layout-2.php', $dataToSend);
                } ?>
            </div>
        </div>

    </div>
<?php } ?>