<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');

$frmProductSearch->setFormTagAttribute('onSubmit', 'searchProducts(this); return(false);');
$frmProductSearch->setFormTagAttribute('class', 'form form-search');
$keywordFld = $frmProductSearch->getField('keyword');
$keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search', $siteLangId));
$keywordFld = $frmProductSearch->getField('keyword');
$keywordFld->overrideFldType("hidden");

$sortByFld = $frmProductSearch->getField('sortBy');
$sortByFld->addFieldTagAttribute('class', 'custom-select sorting-select nice-select');

$pageSizeFld = $frmProductSearch->getField('pageSize');

$desktop_url = '';
$tablet_url = '';
$mobile_url = '';
$slideUrl = '';
$slideTarget = '';
$compProdCount = (!isset($compProdCount)) ? 0 : $compProdCount;

if (!isset($postedData['shop_id']) || (isset($postedData['shop_id']) && 1 > FatUtility::int($postedData['shop_id']))) {
    $category['banner'] = isset($category['banner']) ? (array) $category['banner'] : array();
    if (!empty($category['banner'])) {
        $desktop_url = UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'DESKTOP', applicationConstants::SCREEN_DESKTOP));
        $tablet_url = UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'TABLET', applicationConstants::SCREEN_MOBILE));
        $mobile_url = UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'MOBILE', applicationConstants::SCREEN_IPAD));
        $catBannerArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id'], 0, $siteLangId);
        foreach ($catBannerArr as $slideScreen) {
            $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
            switch ($slideScreen['afile_screen']) {
                case applicationConstants::SCREEN_MOBILE:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id'], 0, 0, applicationConstants::SCREEN_MOBILE);
                    $mobile_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'MOBILE', applicationConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
                case applicationConstants::SCREEN_IPAD:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id'], 0, 0, applicationConstants::SCREEN_IPAD);
                    $tablet_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'TABLET', applicationConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
                case applicationConstants::SCREEN_DESKTOP:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id'], 0, 0, applicationConstants::SCREEN_DESKTOP);
                    $desktop_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Category', 'Banner', array($category['prodcat_id'], $siteLangId, 'DESKTOP', applicationConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
            }

        }
    } else if (isset($banner) && !empty($banner)) {
        $slideUrl = $banner['banner_url'];
        $slideTarget = $banner['banner_target'];
        $uploadPath = UrlHelper::generateFileUrl() . CONF_UPLOADS_FOLDER_NAME . '/' . AttachedFile::FILETYPE_BANNER_PATH;
        $slideArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BANNER, $banner['banner_id'], 0, $siteLangId);
        if (!empty($slideArr)) {
            foreach ($slideArr as $slideScreen) {
                $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
                switch ($slideScreen['afile_screen']) {
                    case applicationConstants::SCREEN_MOBILE:
                        if (!file_exists(CONF_UPLOADS_PATH . '/' . AttachedFile::FILETYPE_BANNER_PATH . $slideScreen['afile_physical_path'])) {
                            $mobile_url = UrlHelper::generateFileUrl() . 'images/defaults/no_image.png';
                        } else {
                            $mobile_url = $uploadPath . $slideScreen['afile_physical_path'];
                        }
                        break;
                    case applicationConstants::SCREEN_IPAD:
                        if (!file_exists(CONF_UPLOADS_PATH . '/' . AttachedFile::FILETYPE_BANNER_PATH . $slideScreen['afile_physical_path'])) {
                            $tablet_url = UrlHelper::generateFileUrl() . 'images/defaults/no_image.png';
                        } else {
                            $tablet_url = $uploadPath . $slideScreen['afile_physical_path'];
                        }

                        break;
                    case applicationConstants::SCREEN_DESKTOP:
                        if (!file_exists(CONF_UPLOADS_PATH . '/' . AttachedFile::FILETYPE_BANNER_PATH . $slideScreen['afile_physical_path'])) {
                            $desktop_url = UrlHelper::generateFileUrl() . 'images/defaults/no_image.png';
                        } else {
                            $desktop_url = $uploadPath . $slideScreen['afile_physical_path'];
                        }
                        break;
                }
            }
            $screenTypeArr = array_column($slideArr, 'afile_screen');
            if (!in_array(applicationConstants::SCREEN_MOBILE, $screenTypeArr)) {
                $mobile_url = $desktop_url;
            }
            if (!in_array(applicationConstants::SCREEN_IPAD, $screenTypeArr)) {
                $tablet_url = $desktop_url;
            }

        }
    } else if (array_key_exists('brand_id', $postedData) && $postedData['brand_id'] > 0) {
        $brandImgArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, $siteLangId);
        if (!empty($brandImgArr)) {
            foreach ($brandImgArr as $slideScreen) {
                $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
                switch ($slideScreen['afile_screen']) {
                    case applicationConstants::SCREEN_MOBILE:
                        $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_MOBILE);
                        $mobile_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'MOBILE', 0, applicationConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                        break;
                    case applicationConstants::SCREEN_IPAD:
                        $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_IPAD);
                        $tablet_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'TABLET', 0, applicationConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                        break;
                    case applicationConstants::SCREEN_DESKTOP:
                        $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_DESKTOP);
                        $desktop_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'DESKTOP', 0, applicationConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                        break;
                }
            }
        }
    }

    if ($desktop_url != '') {
        ?>
        <section class="bg-shop">
            <?php if ($slideUrl != '') { echo '<a aria-label="" target="' . $slideTarget . '" href="' . $slideUrl . '">'; } ?>
                <picture class="shop-banner">
                    <source media="(max-width:767px)" srcset="<?php echo $mobile_url; ?>">
                    <source media="(max-width:1024px)" srcset="<?php echo $tablet_url; ?>">
                    <source srcset="<?php echo $desktop_url; ?>">
                    <img src="<?php echo $desktop_url; ?>" alt="slide">
                </picture>
            <?php if ($slideUrl != '') { echo '</a>'; } ?>
        </section>
    <?php }
} ?>

<?php $vtype = $postedData['vtype'] ?? false;
/* if (array_key_exists('brand_id', $postedData) && $postedData['brand_id'] > 0) {
    $brandImgArr = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, $siteLangId);
    if (!empty($brandImgArr)) {
        foreach ($brandImgArr as $slideScreen) {
            $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']);
            switch ($slideScreen['afile_screen']) {
                case applicationConstants::SCREEN_MOBILE:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_MOBILE);
                    $mobile_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'MOBILE', 0, applicationConstants::SCREEN_MOBILE)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
                case applicationConstants::SCREEN_IPAD:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_IPAD);
                    $tablet_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'TABLET', 0, applicationConstants::SCREEN_IPAD)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
                case applicationConstants::SCREEN_DESKTOP:
                    $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_BRAND_IMAGE, $postedData['brand_id'], 0, 0, applicationConstants::SCREEN_DESKTOP);
                    $desktop_url = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'BrandImage', array($postedData['brand_id'], $siteLangId, 'DESKTOP', 0, applicationConstants::SCREEN_DESKTOP)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg') . ",";
                    break;
            }
        }
        ?>
        <section class="bg-shop">
            <picture class="shop-banner">
                <source srcset="<?php echo $mobile_url; ?>" media="(max-width: 767px)">
                <source srcset="<?php echo $tablet_url; ?>" media="(max-width: 1024px)">
                <source data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>">
                <img data-aspect-ratio="4:1" srcset="<?php echo $desktop_url; ?>"
                    alt="<?php echo (!empty($fileRow['afile_attribute_alt'])) ? $fileRow['afile_attribute_alt'] : $pageTitle; ?>"
                    title="<?php echo (!empty($fileRow['afile_attribute_title'])) ? $fileRow['afile_attribute_title'] : $pageTitle; ?>">
            </picture>
        </section>
    <?php } ?>
<?php } */ ?>
<?php if (isset($pageTitle)) { ?>
    <section class="bg-brand pt-3 pb-3">
        <div class="container">
            <div class="section-head section-head-white section-head-center mb-0">
                <div class="section-heading">
                    <h1 class="mb-0">
                        <?php
                        $keywordStr = '';
                        if (isset($keyword) && !empty($keyword)) {
                            $short_keyword = (mb_strlen($keyword) > 20) ? mb_substr($keyword, 0, 20) . "..." : $keyword;
                            $keywordStr = '<span title="' . $keyword . '" class="search-results">"' . $short_keyword . '"</span>';
                        }
                        echo $pageTitle;
                        ?>
                        <?php echo $keywordStr; ?>
                    </h1>
                    <?php if (isset($showBreadcrumb) && $showBreadcrumb) { ?>
                        <div class="breadcrumbs breadcrumbs-white breadcrumbs-center">
                            <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
<?php $this->includeTemplate('_partial/productsSearchForm.php', array('frmProductSearch' => $frmProductSearch, 'siteLangId' => $siteLangId, 'recordCount' => $recordCount, 'pageTitle' => (isset($pageTitle)) ? $pageTitle : 'Products'), false); ?>
<section class="section" data-collection="collection-name dsfsdfsd">
    <div class="container">
        <div class="collection-listing <?php echo (isset($postedData['vtype']) && $postedData['vtype'] == 'map') ? 'filter-top' : 'filter-left'; ?>">
            <?php require_once('filters-layout.php'); ?>
            <main class="collection-content">
                <button class="btn btn-float link__filter btn--filters-control" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvas-filters">
                    <svg class="svg" width="20" height="20">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#filter"></use>
                    </svg>
                </button>
                <div class="page-sort-wrap">
                    <div class="total-products">
                        <?php echo isset($scollection_name) && !empty($scollection_name) ? $scollection_name : ''; ?>
                        <h4 class="hide_on_no_product">
                            <span id="total_records">
                                <?php echo $recordCount; ?>
                            </span>
                            <span class="product-type-items">
                                <?php echo (current($postedData['producttype']) == applicationConstants::PRODUCT_FOR_RENT) ? Labels::getLabel('LBL_Rental_Item(s)', $siteLangId) : Labels::getLabel('LBL_Sale_Item(s)', $siteLangId); ?>
                            </span>
                        </h4>
                    </div>
                    <div id="top-filters" class="page-sort hide_on_no_product">
                        <ul class="layout-types switch--link-js">
                            <li class="layout-types-item">
                                <?php echo $frmProductSearch->getFieldHtml('sortBy'); ?>
                            </li>
                            <li
                                class="layout-types-item <?php echo $vtype != 'map' && $vtype != 'list' ? 'active' : ''; ?>">
                                <button data-toggle="tooltip" class="layout-types-link listing-grid-toggle--js"
                                    title="<?php echo Labels::getLabel('LBL_Grid_View', $siteLangId); ?>"
                                    data-viewtype="grid">
                                    <svg class="svg" width="20" height="20">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-front.svg#show_grid">
                                        </use>
                                    </svg>

                                </button>
                            </li>
                            <li class="layout-types-item <?php echo $vtype == 'list' ? 'active' : ''; ?>">
                                <button data-toggle="tooltip" class="layout-types-link listing-grid-toggle--js"
                                    title="<?php echo Labels::getLabel('LBL_List_View', $siteLangId); ?>"
                                    data-viewtype="list">
                                    <svg class="svg" width="20" height="20">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-front.svg#show_list">
                                        </use>
                                    </svg>

                                </button>
                            </li>
                            <?php if ($vtype && empty($postedData['shop_id'])) { ?>
                                <li class="layout-types-item <?php echo $vtype == 'map' ? 'active' : ''; ?>">
                                    <button data-toggle="tooltip" class="layout-types-link listing-grid-toggle--js"
                                        title="<?php echo Labels::getLabel('LBL_Map_View', $siteLangId); ?>"
                                        data-viewtype="map">
                                        <svg class="svg" width="20" height="20">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-front.svg#location">
                                            </use>
                                        </svg> </button>
                                </li>
                            <?php } ?>
                        </ul>

                    </div>
                </div>
                <?php echo $frmProductSearch->getFieldHtml('pageSize'); ?>
                <?php
                $productsData = array(
                    'products' => $products,
                    'moreSellersProductsArr' => $moreSellersProductsArr ?? [],
                    'page' => $page,
                    'pageCount' => $pageCount,
                    'postedData' => $postedData,
                    'recordCount' => $recordCount,
                    'siteLangId' => $siteLangId,
                    'colMdVal' => 3,
                    'compProdCount' => $compProdCount,
                    'pageSizeArr' => $pageSizeArr,
                    'pageSize' => $pageSize,
                    'comparedProdSpecCatId' => (isset($comparedProdSpecCatId)) ? $comparedProdSpecCatId : 0,
                    'displayProductNotAvailableLable' => (isset($displayProductNotAvailableLable)) ? $displayProductNotAvailableLable : false,
                );

                if (isset($postedData['vtype']) && $postedData['vtype'] == "map") { ?>
                    <div class="interactive-stores">
                        <div class="interactive-stores__map">
                            <div class="map-loader is-loading">
                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="50px" height="50px"
                                    viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve">
                                    <path fill="#fff"
                                        d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,0-18.683,8.365-18.683,18.683h4.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,14.615,6.543,14.615,14.615H43.935z">
                                        <animateTransform attributeType="xml" attributeName="transform" type="rotate"
                                            from="0 25 25" to="360 25 25" dur="0.6s" repeatCount="indefinite">
                                        </animateTransform>
                                    </path>
                                </svg>
                            </div>
                            <div class="canvas-map" id="productMap--js"> </div>
                        </div>
                        <?php $this->includeTemplate('products/products-list.php', $productsData, false); ?>
                    </div>
                <?php } else { ?>
                    <div class="">
                        <?php $this->includeTemplate('products/products-list.php', $productsData, false); ?>
                    </div>
                <?php } ?>
            </main>
        </div>
    </div>
</section>
<section>
    <div class="container">
        <div class="row">
            <div class="col-md-3 col--left col--left-adds">
                <div class="wrapper--adds">
                    <div class="grids" id="searchPageBanners">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="gap"></div>
<?php $url = str_replace("'", "\'", $canonicalUrl); ?>

<?php if (isset($recordCount) && 12 > $recordCount) { ?>
    <style>
        select[name="pageSizeSelect"] {
            display: none;
        }
    </style>
<?php } ?>

<script type="text/javascript">
    $(document).ready(function () {
        $currentPageUrl = `<?php echo html_entity_decode($url, ENT_QUOTES, 'utf-8'); ?>`;
        $productSearchPageType = '<?php echo $productSearchPageType; ?>';
        $recordId = <?php echo $recordId; ?>;
        loadProductListingfilters(document.frmProductSearch);
    });
</script>
<?php echo $this->includeTemplate('_partial/compareProducts.php', ['compProdCount' => $compProdCount]); ?>