<?php
if (isset($postedData) && !empty($postedData)) {
    $searchForm->fill($postedData);
}

$searchForm->setFormTagAttribute('onSubmit', 'submitSiteSearch(this, 12); return(false);');
$keywordFld = $searchForm->getField('keyword');
$keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Keyword_Search', $siteLangId));

$geoAddress = '';
if ((!isset($_COOKIE['_ykGeoLat']) || !isset($_COOKIE['_ykGeoLng']) || !isset($_COOKIE['_ykGeoCountryCode'])) && FatApp::getConfig('CONF_DEFAULT_GEO_LOCATION', FatUtility::VAR_INT, 0)) {
    $geoAddress = FatApp::getConfig('CONF_GEO_DEFAULT_ADDR', FatUtility::VAR_STRING, '');
    if (empty($address)) {
        $address = FatApp::getConfig('CONF_GEO_DEFAULT_ZIPCODE', FatUtility::VAR_INT, 0) . '-' . FatApp::getConfig('CONF_GEO_DEFAULT_STATE', FatUtility::VAR_STRING, '');
    }
}

$locFld = $searchForm->getField('location');
$locFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Location_Search', $siteLangId));
$locFld->setFieldTagAttribute('id', 'ga-autoComplete-header');
$locFld->setFieldTagAttribute('class', 'location-selected');
$locFld->setFieldTagAttribute('onKeyup', "googleAddressAutocomplete('ga-autoComplete-header', 'formatted_address', true, 'googleSelectedAddress', 0)");
$locFld->value = isset($_COOKIE["_ykGeoAddress"]) ? $_COOKIE["_ykGeoAddress"] : $geoAddress;

$dateFld = $searchForm->getField('rentaldates');
$section = (isset($isHeader) && $isHeader) ? "search-section-fashion-header" : "search-section-fashion";

$dateFld->addFieldTagAttribute('data-section', $section);
$dateFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Add_Dates', $siteLangId));
if (isset($postedData['rentalstart']) && !empty($postedData['rentalstart'])) {
    $dateFld->addFieldTagAttribute('id', date('d/m/Y', strtotime($postedData['rentalstart'])) . ' - ' . date('d/m/Y', strtotime($postedData['rentalend'])));
    $dateFld->value = $postedData['rentalstart'] . ' to ' . $postedData['rentalend'];
}
?>
<div class="offcanvas offcanvas-top main-search-bar" tabindex="-1" id="main-search-top">
    <div class="offcanvas-header">
        <h5 id="hero-search">&nbsp;</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <?php echo $searchForm->getFormTag(); ?>
        <div class="site-search-form site-search-form-pop">
            <h3><?php echo Labels::getLabel('LBL_Search_For_Products', $siteLangId) ?></h3>
            <p><?php echo Labels::getLabel('LBL_Try_Breezy,_Fun_And_More_Vibrant_Looks_This_Season', $siteLangId) ?></p>
            <ul>
                <li class="site-search-form-item keyword">
                    <div class="field-cover">
                        <label class="form-label"><?php echo $searchForm->getField('keyword')->getCaption(); ?></label>
                        <?php echo $searchForm->getFieldHtml('keyword'); ?>
                    </div>

                </li>
                <?php if (!CommonHelper::isDistanceShippingEnabled()) { ?>
                <li class="site-search-form-item location">
                    <div class="field-cover">
                        <label class="form-label"><?php echo $searchForm->getField('location')->getCaption(); ?></label>
                        <?php echo $searchForm->getFieldHtml('location'); ?>
                    </div>
                </li>
                <?php } ?>
                <li class="site-search-form-item date-selector">
                    <div class="field-cover <?php echo $section; ?> date-selector">
                        <label
                            class="form-label"><?php echo $searchForm->getField('rentaldates')->getCaption(); ?></label>
                        <?php echo $searchForm->getFieldHtml('rentaldates'); ?>
                        <?php echo $searchForm->getFieldHtml('rentalstart'); ?>
                        <?php echo $searchForm->getFieldHtml('rentalend'); ?>
                    </div>
                </li>
                <li class="site-search-form-item submit">
                    <?php echo $searchForm->getFieldHtml('searchButton'); ?>
                </li>
            </ul>
        </div>
        </form>
    </div>
</div>