<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$btn = $sellerFrm->getField('btn_submit');
$btn->setFieldTagAttribute('class', "btn btn-brand btn-wide");
?>
<div class="after-header"></div>
<main id="body" class="body">
    <?php $haveBgImage = AttachedFile::getAttachment(AttachedFile::FILETYPE_SELLER_PAGE_SLOGAN_BG_IMAGE, $slogan['epage_id'], 0, $siteLangId);
    $bgImageUrl = ($haveBgImage) ? "background-image:url(" . CommonHelper::generateUrl('image', 'cblockBackgroundImage', array($slogan['epage_id'], $siteLangId, 'DEFAULT', AttachedFile::FILETYPE_SELLER_PAGE_SLOGAN_BG_IMAGE)) . ")" : "background-image:url(" . CONF_WEBROOT_URL . "images/seller-bg.png);"; ?>
    <div class="banner" style="<?php echo $bgImageUrl; ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="seller-slogan">
                        <div class="seller-slogan-txt">
							<?php if($slogan['epage_content'] != '') { ?>
                            <?php echo FatUtility::decodeHtmlEntities(nl2br($slogan['epage_content'])); ?>
							<?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="seller-register-form">
                        <div class="section-head">
                            <div class="section-heading">
                                <h2>
                                    <?php echo Labels::getLabel('L_Register_Today', $siteLangId); ?>
                                </h2>
                            </div>
                        </div>
                        <?php $sellerFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
                        $sellerFrm->developerTags['fld_default_col'] = 12;
                        echo $sellerFrm->getFormHtml(); ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="">
                                    <?php 
										if($formText['epage_content'] != '') {
											echo FatUtility::decodeHtmlEntities($formText['epage_content']); 
										}
									?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if (!empty($block1) && !empty($block1['epage_content'])) { ?>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <?php echo FatUtility::decodeHtmlEntities($block1['epage_content']); ?>
        </div>
    </section>
    <?php }
    if (!empty($block2) && !empty($block2['epage_content'])) { ?>
    <section class="section bg-gray" data-collection="collection-name">
        <div class="container">
            <?php echo FatUtility::decodeHtmlEntities($block2['epage_content']); ?>
        </div>
    </section>
    <?php }
    if (!empty($block3) && !empty($block3['epage_content'])) { ?>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <?php echo FatUtility::decodeHtmlEntities($block3['epage_content']); ?>
        </div>
    </section>
    <?php } ?>

    <?php if ($faqCount > 0) { ?>
    <section class="section bg-gray" data-collection="collection-name">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-6">
                    <div class="section-head section-head-white section-head-center mb-0">
                        <div class="section-heading">
                            <h2>
                                <?php echo Labels::getLabel('LBL_Frequently_Asked_Questions', $siteLangId); ?>
                            </h2>
                        </div>
                    </div>
                    <div class="faqsearch">
                        <form name="frmSearchFaqs" class="form" method="post"
                            onsubmit="searchFaqsListing(this); return(false);">
                            <input placeholder="<?php echo Labels::getLabel('LBL_SEARCH', $siteLangId); ?>"
                                id="faqQuestionJs" class="faq-input no-focus"
                                data-field-caption="<?php echo Labels::getLabel('LBL_ENTER_YOUR_QUESTION', $siteLangId); ?>"
                                type="search" name="question" value="">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 faqSectionJs">
                    <?php if ($faqCount > 0) { ?>
                    <div class="faq-filters mb-4" id="categoryPanel"></div>
                    <?php } ?>
                    <ul class="faqlist" id="listing"></ul>
                </div>
            </div>
        </div>
    </section>

    <?php } ?>

    <div class="divider"></div>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="text-center">
                <h3 class="h3">
                    <?php echo Labels::getLabel('LBL_Still_need_help', $siteLangId) ?> ?
                </h3>
                <a href="<?php echo UrlHelper::generateUrl('custom', 'contact-us'); ?>" class="btn btn-brand">
                    <?php echo Labels::getLabel('LBL_Contact_Customer_Care', $siteLangId) ?>
                </a>
            </div>

        </div>
    </section>

</main>
<script>
const faqsSearchStringLengthMsg =
    '<?php echo CommonHelper::replaceStringData(Labels::getLabel('LBL_TYPE_ATLEAST_{LEN}_CHARACTERS_TO_SEARCH_IN_FAQS.', $siteLangId), ['{LEN}' => Faq::FAQS_SEARCH_STRING_LENGTH]); ?>';
const faqsSearchStringLength = '<?php echo Faq::FAQS_SEARCH_STRING_LENGTH; ?>';
</script>