<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$cartTotal = isset($scartSummary['cartTotal']) ? $scartSummary['cartTotal'] : 0;
$cartAdjustableAmount = isset($scartSummary['cartAdjustableAmount']) ? $scartSummary['cartAdjustableAmount'] : 0;
$discountTotal = isset($scartSummary['cartDiscounts']) && isset($scartSummary['cartDiscounts']['coupon_discount_total']) ? $scartSummary['cartDiscounts']['coupon_discount_total'] : 0;
?>
<?php if (count($subscriptions)) { ?>
    <div id="shipping-summary" class="step">
        <div class="step-section">
            <div class="step-head">
                <h5 class="step-title">
                    <?php echo Labels::getLabel('LBL_REVIEW_CHECKOUT', $siteLangId); ?>
                </h5>
            </div>
            <div class="step-body p-0">
                <?php
                foreach ($subscriptions as $subscription) {
                    $spackageName = isset($subscription['spackage_name']) ? $subscription['spackage_name'] : '';
                    $spackagePrice = isset($subscription[SellerPackagePlans::DB_TBL_PREFIX . 'price']) ? $subscription[SellerPackagePlans::DB_TBL_PREFIX . 'price'] : '';
                    $interval = isset($subscription[SellerPackagePlans::DB_TBL_PREFIX . 'trial_interval']) ? $subscription[SellerPackagePlans::DB_TBL_PREFIX . 'trial_interval'] : 0;
                    ?>
                    <div class="cart-table list-shippings" data-list="SHIPPING SUMMARY">
                        <div class="cart-table-row">
                            <div class="cart-table-col cart-table-col-1">
                                <div class="product-profile">
                                    <div class="product-profile-data">
                                        <div class="title">
                                            <?php echo $spackageName; ?>
                                        </div>
                                        <div class="product-price">
                                            <div class="products-price-new">
                                                <?php echo CommonHelper::displayMoneyFormat($spackagePrice); ?>
                                            </div>
                                        </div>
                                        <div class="options">
                                            <p>
                                                <?php echo SellerPackagePlans::getPlanPeriod($subscription, $spackagePrice); ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="payment-option-js step-section"></div>
    </div>

<?php } ?>