<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$cartTotal = isset($cartSummary['cartTotal']) ? $cartSummary['cartTotal'] : 0;
$cartAdjustableAmount = isset($cartSummary['cartAdjustableAmount']) ? $cartSummary['cartAdjustableAmount'] : 0;
$discountTotal = isset($cartSummary['cartDiscounts']) && isset($cartSummary['cartDiscounts']['coupon_discount_total']) ? $cartSummary['cartDiscounts']['coupon_discount_total'] : 0;
$amount = CommonHelper::displayMoneyFormat($cartTotal - $cartAdjustableAmount - $discountTotal, true, false, true, false, true);
?>
<div class="cart-total-head">
    <h3 class="cart-total-title">
        <?php echo Labels::getLabel("LBL_Price_summary", $siteLangId); ?>
    </h3>
</div>

<div class="order-summary cart-total-body">
    <?php if ($spackage_type != SellerPackages::FREE_TYPE) { ?>
        <?php if (!empty($cartSummary['cartDiscounts']['coupon_code'])) { ?>
            <div class="coupons-applied">
                <div class="">
                    <h6>
                        <i class="icn">
                            <svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#tick">
                                </use>
                            </svg>
                        </i>
                        <?php echo $cartSummary['cartDiscounts']['coupon_code']; ?>
                    </h6>
                    <p>
                        <?php $arr = ['{AMOUNT}' => CommonHelper::displayMoneyFormat($cartSummary['cartDiscounts']['coupon_discount_total'])];
                        echo CommonHelper::replaceStringData(Labels::getLabel("LBL_YOU_SAVED_ADDITIONAL_{AMOUNT}", $siteLangId), $arr); ?>
                    </p>
                </div>
                <button class="close-layer" type="button" onClick="removePromoCode()"> </button>

            </div>
        <?php } else { ?>
            <div class="coupons">
                <button class="btn btn-coupon" type="button" onclick="getPromoCode()">
                    <p class="btn-coupon-txt">
                        <?php echo Labels::getLabel('LBL_Apply_Coupon', $siteLangId); ?>
                        <span>
                            <img class="" width="18" src="<?php echo CONF_WEBROOT_URL; ?>images/retina/party.svg" alt="">
                        </span>
                    </p>
                    <i>
                        <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 512 512" color="#3E688E"
                            class="style_arrow__VSmix" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"
                            style="color: rgb(62, 104, 142);">
                            <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="48"
                                d="M268 112l144 144-144 144m124-144H100">
                            </path>
                        </svg>
                    </i>
                </button>

            </div>
        <?php } ?>
    <?php } ?>
    <div class="order-summary__sections">
        <ul class="cart-summary">
            <li class="cart-summary-item">
                <span class="label"><?php echo Labels::getLabel('LBL_Sub_Total', $siteLangId); ?></span>
                <span
                    class="value"><?php echo CommonHelper::displayMoneyFormat($cartTotal, true, false, true, false, true); ?></span>
            </li>
            <?php if ($cartAdjustableAmount > 0) { ?>
                <li class="cart-summary-item">
                    <span class="label"><?php echo Labels::getLabel('LBL_Adjusted_Amount', $siteLangId); ?></span>
                    <span
                        class="value"><?php echo CommonHelper::displayMoneyFormat($cartAdjustableAmount, true, false, true, false, true); ?></span>
                </li>
            <?php } ?>
            <?php if ($discountTotal > 0) { ?>
                <li class="cart-summary-item">
                    <span class="label"><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?></span>
                    <span class="value">
                        <?php echo CommonHelper::displayMoneyFormat($discountTotal, true, false, true, false, true); ?></span>
                </li>
            <?php } ?>
            <li class="cart-summary-item highlighted">
                <span class="label"><?php echo Labels::getLabel('LBL_You_Pay', $siteLangId); ?></span>
                <span class="value">
                    <?php echo $amount; ?></span>
            </li>
        </ul>
    </div>
</div>