<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class="step-head">
    <h5 class="step-title">
        <?php echo Labels::getLabel('LBL_Add_Digital_Sign_in_Below_Box', $siteLangId); ?>
    </h5>
    <span class="text-uppercase">
        <?php echo Labels::getLabel('LBL_OR', $siteLangId); ?>
    </span>
    <div class="text-right">
        <button type="button" class="link-underline" onClick="signatureForm();"><span>
                <?php echo Labels::getLabel('LBL_Upload_Signature_File', $siteLangId); ?>
            </span></button>
    </div>
</div>
<div class="step-body">
    <div id="signature"></div>
    <label class="checkbox lable-signature mt-4" for="accept_term">
        <input type="checkbox" id="accept_term" name="accept_term" value="1">
        <?php echo Labels::getLabel('LBL_I_have_read_&_accept_the_rental_terms_mentioned_in_the_agreements', $siteLangId); ?>
    </label>
    <p class="error-warning--js text-danger mt-2" style="display:none">
        <?php echo Labels::getLabel('MSG_Please_accept_term_and_conditions', $siteLangId); ?>
    </p>
</div>

<script>
    var controllerName = '<?php echo (isset($updateController)) ? $updateController : "Signature" ?>';
    var $sigdiv = $("#signature").addClass("signature").jSignature({
        'UndoButton': true
    });

    /* Add Signature in the database */
    function saveImage() {
        if ($sigdiv.jSignature('getData', 'native').length == 0) {
            $.mbsmessage.close();
            $.mbsmessage("<?php echo Labels::getLabel('LBL_Please_Add_Your_Digital_Signature_To_Proceed', $siteLangId); ?>", false, 'alert--danger');
            return false;
        }
        var data = {
            'imgData': $sigdiv.jSignature('getData', 'image'),
            'record_id': '<?php echo (isset($recordId)) ? $recordId : "" ?>'
        }
        fcom.ajax(fcom.makeUrl(controllerName, 'store'), data, function (res) {
            var ans = $.parseJSON(res);
            if (ans.status == 1) {
                return true;
            } else {
                $.systemMessage(ans.msg, 'alert--danger');
                return false;
            }
        });
        return true;
    }
</script>