<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
$searchFrm->setFormTagAttribute('onSubmit', 'searchProfile(this); return false;');
$searchFrm->setFormTagAttribute('class', 'form form-search');
$searchFrm->developerTags['colClassPrefix'] = 'col-md-';
$searchFrm->developerTags['fld_default_col'] = 6;

$keywordFld = $searchFrm->getField('keyword');
$keywordFld->developerTags['col'] = 8;

$submitBtnFld = $searchFrm->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
$submitBtnFld->developerTags['col'] = 2;

$cancelBtnFld = $searchFrm->getField('btn_clear');
$cancelBtnFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
$cancelBtnFld->developerTags['col'] = 2;
?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Shipping_Profiles', $siteLangId); ?><i class="fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Create/Manage_shipping_based_on_products_and_location.', $siteLangId); ?>"></i>
                </h2>
            </div>
            <?php if ($canEdit) { ?>
                <div class="content-header-toolbar">
                    <div class="links-inline">
                        <a href="<?php echo UrlHelper::generateUrl('shippingProfile', 'form', [0]); ?>" class="btn btn-outline-gray qwer">
                            <svg class="svg" width="18" height="18">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#create-profile">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Create_Profile', $siteLangId); ?>
                        </a>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="content-form">
            <?php
            $submitFld = $searchFrm->getField('btn_submit');
            $fldClear = $searchFrm->getField('btn_clear');
            $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
            echo $searchFrm->getFormHtml();
            ?></div>
        <div class="content-body">
            <div class="card">
                <div class="card-table">
                    <div id="profilesListing">
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>