<?php if (0 < count($arr_listing)) { ?>

    <ul class="tax-rules">
        <?php foreach ($arr_listing as $sn => $row) {
            $ruleSpecificCombinedData = $combinedData[$row['taxrule_id']] ?? [];
        ?>
            <li class="tax-rules-item">
                <div class="row justify-content-between mb-3">
                    <div class="col">
                        <h6 class="h6"><?php echo Labels::getLabel('LBL_Rule', $siteLangId); ?>:
                            <?php echo $row['taxrule_name']; ?>
                        </h6>
                        <span class="muted-text"><?php echo Labels::getLabel('LBL_Tax_Rate(%)', $siteLangId); ?>: <?php echo !empty($row['user_rule_rate']) ? "<del>" . $row['trr_rate'] . "</del>" : $row['trr_rate']; ?></del>&nbsp; <?php echo $row['user_rule_rate']; ?>
                        </span>
                    </div>
                    <?php if ($canEdit) { ?>
                        <div class="col-auto"><button type="button" class="link-underline" onclick="editRule(<?php echo $row['taxrule_id']; ?>)" title="Edit"><?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?> </button></div>
                    <?php } ?>

                </div>

                <ul class="list-stats list-stats-double">
                    <?php if (!empty($ruleSpecificCombinedData) && $row['taxstr_is_combined'] > 0) { ?>
                        <li class="list-stats-item">
                            <h6 class="title-sub"> <?php echo Labels::getLabel('LBL_Combined_Taxes(%)', $siteLangId); ?></h6>
                        </li>
                        <?php
                        foreach ($ruleSpecificCombinedData as $comData) { ?>
                            <li class="list-stats-item">
                                <span class="label"><?php echo $comData['taxstr_name']; ?>:
                                </span>
                                <span class="value"> <?php echo !empty($comData['user_rate']) ? "<del>" . $comData['taxruledet_rate'] . "</del>" : $comData['taxruledet_rate']; ?></del>&nbsp; <?php echo $comData['user_rate']; ?></span>

                            </li>
                        <?php }
                    } else {
                        ?>
                        <li class="list-stats-item">
                            <span class="label">
                                <?php echo Labels::getLabel('LBL_Tax_Name', $siteLangId); ?>:
                            </span>
                            <span class="value">
                                <?php echo $row['taxstr_name']??$row['taxrule_name']; ?>
                            </span>
                        </li>
                    <?php } ?>
                    <li class="list-stats-item">
                        <span class="label"><?php echo Labels::getLabel('LBL_FROM_COUNTRY', $siteLangId); ?>:
                        </span>
                        <span class="value">
                            <?php echo $row['from_country'] ?? Labels::getLabel('LBL_Rest_of_the_world', $siteLangId); ?>
                        </span>
                    </li>
                    <li class="list-stats-item">
                        <span class="label"><?php echo Labels::getLabel('LBL_FROM_STATES', $siteLangId); ?>:
                        </span>
                        <span class="value"> <?php echo $row['from_state'] ?? Labels::getLabel('LBL_ALL_STATES', $siteLangId); ?></span>
                    </li>
                    <li class="list-stats-item">
                        <span class="label">
                            <?php echo Labels::getLabel('LBL_TO_COUNTRY', $siteLangId); ?>:
                        </span>
                        <span class="value">
                            <?php echo $row['to_country'] ?? Labels::getLabel('LBL_Rest_of_the_world', $siteLangId); ?>
                        </span>

                    </li>
                    <li class="list-stats-item">
                        <span class="label">
                            <?php echo Labels::getLabel('LBL_TO_STATES', $siteLangId); ?>:
                        </span>
                        <span class="value">
                            <?php
                            $taxRulesOptions = TaxRule::getTypeOptions($siteLangId);

                            echo (isset($taxRulesOptions[$row['taxruleloc_type']])) ? $taxRulesOptions[$row['taxruleloc_type']] : ""; ?><br>
                            <?php echo $row['to_state'] ?>
                        </span>

                    </li>
                </ul>
            </li>
        <?php } ?>
    </ul>

<?php
} else {
    $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
}

$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchPaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'siteLangId' => $siteLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
