<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$defaultProductName = [];
$defaultProductId  = '';

if (!empty($data)) {
    $defaultProductName = [$data['splprice_selprod_id'] => $data['selprod_title']];
    $defaultProductId = $data['splprice_selprod_id'];
}

$prodName = $frm->addSelectBox(Labels::getLabel('LBL_Product', $siteLangId), 'product_name', $defaultProductName, $defaultProductId, array('class' => 'selProd--js', 'placeholder' => Labels::getLabel('LBL_Select_Product', $siteLangId)));
$prodName->requirements()->setRequired();
if (!empty($data)) {
    $prodName->setFieldTagAttribute('disabled', 'disabled');
}
$startDate = $frm->getField('splprice_start_date');
$startDate->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Price_Start_Date', $siteLangId));
$startDate->setFieldTagAttribute('class', 'date_js calender');
if (empty($data)) {
    $startDate->setFieldTagAttribute('disabled', 'disabled');
}

$endDate = $frm->getField('splprice_end_date');
$endDate->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Price_End_Date', $siteLangId));
$endDate->setFieldTagAttribute('class', 'date_js calender');
if (empty($data)) {
    $endDate->setFieldTagAttribute('disabled', 'disabled');
}

$splHourPrice = $frm->getField('splprice_hour_price');
if (empty($data)) {
    $splHourPrice->setFieldTagAttribute('disabled', 'disabled');
}
$splHourPrice->setFieldTagAttribute('class', 'js-special-price js-special-hour-price');

$splDayPrice = $frm->getField('splprice_day_price');
if (empty($data)) {
    $splDayPrice->setFieldTagAttribute('disabled', 'disabled');
}
$splDayPrice->setFieldTagAttribute('class', 'js-special-price js-special-day-price');

$splWeekPrice = $frm->getField('splprice_week_price');
if (empty($data)) {
    $splWeekPrice->setFieldTagAttribute('disabled', 'disabled');
}
$splWeekPrice->setFieldTagAttribute('class', 'js-special-price js-special-week-price');

$splMonthPrice = $frm->getField('splprice_month_price');
if (empty($data)) {
    $splMonthPrice->setFieldTagAttribute('disabled', 'disabled');
}
$splMonthPrice->setFieldTagAttribute('class', 'js-special-price js-special-month-price');

$frm->setFormTagAttribute('class', 'form web_form');
$frm->setFormTagAttribute('onsubmit', 'updateSpecialPriceRow(this, ' . $selProdId . '); return(false);');
$frm->addHiddenField('', 'addMultiple');

$frm->setFormTagAttribute('id', 'frmAddSpecialPrice-' . $selProdId);
$frm->setFormTagAttribute('name', 'frmAddSpecialPrice-' . $selProdId);

$startDate = $frm->getField('splprice_start_date');
$startDate->setFieldTagAttribute('id', 'splprice_start_date' . $selProdId);

$endDate = $frm->getField('splprice_end_date');
$endDate->setFieldTagAttribute('id', 'splprice_end_date' . $selProdId);
$frm->addSubmitButton('', 'btn_update', Labels::getLabel('LBL_Save_Changes', $siteLangId), array('class' => 'btn btn-brand btn-submit'));

if (!empty($data) && 0 < count($data)) {
    $prodName->setFieldTagAttribute('readonly', 'readonly');
    $frm->fill($data);
}

$selProdPrice = isset($data['selprod_price']) ? $data['selprod_price'] : 0;
$selProdPriceLbl = 0 < $selProdPrice ? Labels::getLabel("LBL_CURRENT_PRICE:_{PRICE}", $siteLangId) : '';
$selProdPriceLbl = !empty($selProdPriceLbl) ? CommonHelper::replaceStringData($selProdPriceLbl, ['{PRICE}' => $selProdPrice]) : '';

$selProdHourPrice = isset($data['sprodata_hour_rental_price']) ? $data['sprodata_hour_rental_price'] : 0;
$selProdDayPrice = isset($data['sprodata_day_rental_price']) ? $data['sprodata_day_rental_price'] : 0;
$selProdWeekPrice = isset($data['sprodata_week_rental_price']) ? $data['sprodata_week_rental_price'] : 0;
$selProdMonthPrice = isset($data['sprodata_month_rental_price']) ? $data['sprodata_month_rental_price'] : 0;

?>
<div class="modal-dialog modal-dialog-centered modal-md" role="document" id="option-form">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo Labels::getLabel('LBL_Special_Price_setup', $siteLangId); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
            </button>
        </div>
        <div class="modal-body">
            <?php
            echo $frm->getFormTag();
            echo $frm->getFieldHtml('product_for');
            echo $frm->getFieldHtml('splprice_selprod_id');
            echo $frm->getFieldHtml('splprice_id');
            echo $frm->getFieldHtml('addMultiple');
            echo $frm->getFieldHtml('product_for');

            ?>

            <div class="row">
                <div class="col-lg-12 col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('product_name')->getCaption(); ?></label></div>
                        <div class="field-wraper">
                            <?php echo $frm->getFieldHtml('product_name'); ?>
                            <div class="js-prod-price form-text text-muted" data-price="<?php echo $selProdPrice; ?>" data-hour-price="<?php echo $selProdHourPrice; ?>" data-day-price="<?php echo $selProdDayPrice; ?>" data-week-price="<?php echo $selProdWeekPrice; ?>" data-month-price="<?php echo $selProdMonthPrice; ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 col-md-12">
                    <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_start_date')->getCaption(); ?></label></div>
                    <div class="field-set">
                        <div class="field-wraper">
                            <?php echo $frm->getFieldHtml('splprice_start_date'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12 col-md-12">
                    <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_end_date')->getCaption(); ?></label></div>
                    <div class="field-set">
                        <div class="field-wraper">
                            <?php echo $frm->getFieldHtml('splprice_end_date'); ?>
                        </div>
                    </div>
                </div>
                <?php
                if ((applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR) && !empty($data) && $data['sprodata_hour_rental_price'] > 0) || (empty($data) && applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR)) ) {
                ?>
                    <div class="col-lg-12 col-md-12">
                        <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_hour_price')->getCaption(); ?></label> <span class="form-text text-muted splprice_hour_price current_price"><?php echo !empty($data['sprodata_hour_rental_price']) ? Labels::getLabel("LBL_CURRENT_PRICE:", $siteLangId) . $data['sprodata_hour_rental_price'] : ''; ?></span></div>
                        <div class="field-set">
                            <div class="field-wraper">
                                <?php echo $frm->getFieldHtml('splprice_hour_price'); ?>
                                <div class="js-discount-percentage js-discount-percentage-duration-<?php echo ProductRental::DURATION_TYPE_HOUR ?> form-text text-muted"></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php
                if ((applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY) && !empty($data) &&  $data['sprodata_day_rental_price'] > 0) || (empty($data) && applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY))) {
                ?>
                    <div class="col-lg-12 col-md-12">
                        <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_day_price')->getCaption(); ?></label> <span class="form-text text-muted splprice_day_price current_price"><?php echo !empty($data['sprodata_day_rental_price']) ? Labels::getLabel("LBL_CURRENT_PRICE:", $siteLangId) . $data['sprodata_day_rental_price'] : ''; ?></span></div>
                        <div class="field-set">
                            <div class="field-wraper">
                                <?php echo $frm->getFieldHtml('splprice_day_price'); ?>
                                <div class="js-discount-percentage js-discount-percentage-duration-<?php echo ProductRental::DURATION_TYPE_DAY ?> form-text text-muted"></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php
                if ((applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK) && !empty($data) && $data['sprodata_week_rental_price'] > 0) || (empty($data) &&  applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK))) {
                ?>
                    <div class="col-lg-12 col-md-12">
                        <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_week_price')->getCaption(); ?></label> <span class="form-text text-muted splprice_week_price current_price"><?php echo !empty($data['sprodata_week_rental_price']) ? Labels::getLabel("LBL_CURRENT_PRICE:", $siteLangId) . $data['sprodata_week_rental_price'] : ''; ?></span></div>
                        <div class="field-set">
                            <div class="field-wraper">
                                <?php echo $frm->getFieldHtml('splprice_week_price'); ?>
                                <div class="js-discount-percentage js-discount-percentage-duration-<?php echo ProductRental::DURATION_TYPE_WEEK ?> form-text text-muted"></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <?php
                if ((applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH) && !empty($data) && $data['sprodata_month_rental_price'] > 0) || (empty($data) && applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH))) {
                ?>
                    <div class="col-lg-12 col-md-12">
                        <div class="caption-wraper"><label class="field_label"><?php echo $frm->getField('splprice_month_price')->getCaption(); ?></label> <span class="form-text text-muted splprice_month_price current_price"><?php echo !empty($data['sprodata_month_rental_price']) ? Labels::getLabel("LBL_CURRENT_PRICE:", $siteLangId) . $data['sprodata_month_rental_price'] : ''; ?></span></div>
                        <div class="field-set">
                            <div class="field-wraper">
                                <?php echo $frm->getFieldHtml('splprice_month_price'); ?>
                                <div class="js-discount-percentage js-discount-percentage-duration-<?php echo ProductRental::DURATION_TYPE_MONTH ?> form-text text-muted"></div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php
                                echo $frm->getFieldHtml('btn_update');
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
            <?php echo $frm->getExternalJs(); ?>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {

        $('.date_js').datepicker('option', {
            minDate: new Date()
        });
        var dropdownParent = $('.modal-body .web_form').length ? $('.modal-body .web_form') : undefined;

        $("select[name='product_name']").select2({
            closeOnSelect: true,
            dir: langLbl.layoutDirection,
            allowClear: true,
            dropdownParent: dropdownParent,
            placeholder: $("select[name='product_name']").attr('placeholder'),
            theme: "default custom-select2",
            ajax: {
                url: fcom.makeUrl('Seller', 'autoCompleteProducts', [0, 1]),
                dataType: 'json',
                delay: 250,
                method: 'post',
                data: function(params) {
                    return {
                        keyword: params.term,
                        page: params.page
                    };
                },
                processResults: function(data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.products,
                        pagination: {
                            more: params.page < data.pageCount
                        }
                    };
                },
                cache: true
            },
            minimumInputLength: 0,
            templateResult: function(result) {
                return result.name;
            },
            templateSelection: function(result) {
                return result.name || result.text;
            }
        }).on('select2:selecting', function(e) {
            var parentForm = $(this).closest('form').attr('id');

            $("#" + parentForm + " input[name='splprice_selprod_id']").val('');
            $("#" + parentForm + " input[name='splprice_start_date']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_end_date']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_hour_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_week_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_day_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_month_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " .js-prod-price").html('');
            $(".js-discount-percentage").html("");


            $("#" + parentForm + " input[name='splprice_selprod_id']").val(e.params.args.data.id);
            $("#" + parentForm + " input[name='splprice_start_date']").removeAttr('disabled');
            $("#" + parentForm + " input[name='splprice_end_date']").removeAttr('disabled');
            
            let sprodata_hour_rental_price = e.params.args.data.sprodata_hour_rental_price??0;
            let sprodata_day_rental_price = e.params.args.data.sprodata_day_rental_price??0;
            let sprodata_week_rental_price = e.params.args.data.sprodata_week_rental_price??0;
            let sprodata_month_rental_price = e.params.args.data.sprodata_month_rental_price??0;

            let currentHourPrice = langLbl.currentPrice + ': ' + sprodata_hour_rental_price;
            let currentDayPrice = langLbl.currentPrice + ': ' + sprodata_day_rental_price;
            let currentWeekPrice = langLbl.currentPrice + ': ' + sprodata_week_rental_price;
            let currentMonthPrice = langLbl.currentPrice + ': ' + sprodata_month_rental_price;


            $("#" + parentForm + " .current_price.splprice_hour_price").text(currentHourPrice);
            $("#" + parentForm + " .current_price.splprice_day_price").text(currentDayPrice);
            $("#" + parentForm + " .current_price.splprice_week_price").text(currentWeekPrice);
            $("#" + parentForm + " .current_price.splprice_month_price").text(currentMonthPrice);

            $("#" + parentForm + " .js-prod-price").attr('data-price', e.params.args.data.price);
            $("#" + parentForm + " .js-prod-price").attr('data-hour-price', sprodata_hour_rental_price);
            $("#" + parentForm + " .js-prod-price").attr('data-day-price', sprodata_day_rental_price);
            $("#" + parentForm + " .js-prod-price").attr('data-week-price', sprodata_week_rental_price);
            $("#" + parentForm + " .js-prod-price").attr('data-month-price', sprodata_month_rental_price);
            
            if(sprodata_hour_rental_price > 0){
                $("#" + parentForm + " input[name='splprice_hour_price']").removeAttr('disabled');
            }

            if(sprodata_day_rental_price > 0){
                $("#" + parentForm + " input[name='splprice_day_price']").removeAttr('disabled');
            }

            if(sprodata_week_rental_price > 0){
                $("#" + parentForm + " input[name='splprice_week_price']").removeAttr('disabled');
            }

            if(sprodata_month_rental_price > 0){
                $("#" + parentForm + " input[name='splprice_month_price']").removeAttr('disabled');
            }
            
            
            
            

        }).on('select2:unselecting', function(e) {
            var parentForm = $(this).closest('form').attr('id');
            $("#" + parentForm + " input[name='splprice_selprod_id']").val('');
            $("#" + parentForm + " input[name='splprice_start_date']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_end_date']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_hour_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_week_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_day_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " input[name='splprice_month_price']").attr('disabled', 'disabled').val('');
            $("#" + parentForm + " .js-prod-price").html('');
            $(".js-discount-percentage").html("");
        });

    });

    $(document).on('keyup', ".js-special-price", function() {
        var currObj = $(this);
        var dataDurationType = $(this).attr('data-duration-type');
        var parentForm = currObj.closest('form').attr('id');

        let selProdHourPrice = $("#" + parentForm + " .js-prod-price").attr('data-hour-price');
        let selProdDayPrice = $("#" + parentForm + " .js-prod-price").attr('data-day-price');
        let selProdWeekPrice = $("#" + parentForm + " .js-prod-price").attr('data-week-price');
        let selProdMonthPrice = $("#" + parentForm + " .js-prod-price").attr('data-month-price');

        let specialHourPrice = $("#" + parentForm + " .js-special-hour-price").val();
        let specialDayPrice = $("#" + parentForm + " .js-special-day-price").val();
        let specialWeekPrice = $("#" + parentForm + " .js-special-week-price").val();
        let specialMonthPrice = $("#" + parentForm + " .js-special-month-price").val();

        let hourType = $("#" + parentForm + " .js-special-hour-price").attr('data-duration-type');
        let dayType = $("#" + parentForm + " .js-special-day-price").attr('data-duration-type');
        let weekType = $("#" + parentForm + " .js-special-week-price").attr('data-duration-type');
        let monthType = $("#" + parentForm + " .js-special-month-price").attr('data-duration-type');

        calSpecialPriceAndDisplay(parentForm, selProdHourPrice, specialHourPrice, hourType);
        calSpecialPriceAndDisplay(parentForm, selProdDayPrice, specialDayPrice, dayType);
        calSpecialPriceAndDisplay(parentForm, selProdWeekPrice, specialWeekPrice, weekType);
        calSpecialPriceAndDisplay(parentForm, selProdMonthPrice, specialMonthPrice, monthType);
    });

    function calSpecialPriceAndDisplay(parentForm, selProdPrice, specialPrice, dataDurationType) {
        if (specialPrice != '') {
            var discountAmt = selProdPrice - specialPrice;
            var percentage = ((discountAmt / selProdPrice) * 100);
            if (percentage > 0) {
                percentage = Number(Number(percentage).toFixed(2));
                var discountPercentage = langLbl.discountPercentage + ': ' + percentage + '%';
                $("#" + parentForm + " .js-discount-percentage-duration-" + dataDurationType).html(discountPercentage);
            } else {
                if (percentage < 0) {
                    var extracharges = langLbl.extraCharges + ': ' + Math.abs(discountAmt);
                    $("#" + parentForm + " .js-discount-percentage-duration-" + dataDurationType).html(extracharges);
                } else {
                    $("#" + parentForm + " .js-discount-percentage-duration-" + dataDurationType).html('');
                }
            }
        } else {
            $("#" + parentForm + " .js-discount-percentage-duration-" + dataDurationType).html('');
        }
    }

    (function () {
        $('.js-special-price').trigger('keyup');
        updateSpecialPriceRow = function (frm, selProd_id) {
            if (!$(frm).validate()) return;
            var data = fcom.frmData(frm);
            fcom.updateWithAjax(fcom.makeUrl('Seller', 'updateSpecialPriceRow'), data, function (t) {
                if (t.status == true) {
                    searchSpecialPriceProducts(document.frmSearch);
                }
                $('#exampleModal').modal('hide');
                if (0 < frm.addMultiple.value) {
                    var splPriceRow = $("#" + frm.id).parent().parent();
                    splPriceRow.siblings('.divider:first').remove();
                    splPriceRow.remove();
                }
            });
            return false;
        };
    
    })();
</script>