<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head card-head-sub">
    <h5 class="card-title">
        <button type="button" class="btn btn-back" onClick="searchSocialPlatforms(this)">
            <svg class="svg" width="24" height="24">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                </use>
            </svg>
        </button>
        <?php echo Labels::getLabel('LBL_Social_Platforms', $siteLangId); ?>
    </h5>
</div>
<div class="card-body">
    <ul class="nav nav-tabs tabs-grcustom navTabsJs">
        <li class="nav-item"><button class="nav-link" type="button" onClick="addForm(<?php echo $splatform_id; ?>);"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></button></li>
        <li class="nav-item is-active">
            <button class="nav-link">
                <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
            </button>
        </li>
    </ul>
    <div class="row">
        <div class="col-lg-12">
            <?php
                                $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                                $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                                if (!empty($translatorSubscriptionKey) && $splatform_lang_id != $siteDefaultLangId) { ?>
            <div class="row justify-content-end">
                <div class="col-auto mb-4">
                    <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="addLangForm(<?php echo $splatform_id; ?>, <?php echo $splatform_lang_id; ?>, 1)">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                        </svg>
                    </button>
                </div>
            </div>
            <?php } ?>
            <?php
                                $langFrm->setFormTagAttribute('onsubmit', 'setupLang(this); return(false);');
                                $langFrm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
                                $langFrm->developerTags['colClassPrefix'] = 'col-lg-4 ';
                                $langFrm->developerTags['fld_default_col'] = 4;
                                $langFld = $langFrm->getField('lang_id');
                                $langFld->setfieldTagAttribute('onChange', "addLangForm(" . $splatform_id . ", this.value);");
                                $submitFld = $langFrm->getField('btn_submit');
                                $submitFld->setFieldTagAttribute('class', "btn btn-brand btn-wide");
                                echo $langFrm->getFormHtml();
                                ?>
        </div>
    </div>
</div>