<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$arr_flds = array(
    'prodspec_name' => Labels::getLabel('FRM_SPECIFICATION_NAME', $langId),
    'prodspec_value' => Labels::getLabel('FRM_SPECIFICATION_VALUE', $langId),
    'prodspec_group' => Labels::getLabel('FRM_SPECIFICATION_GROUP', $langId),
    'action' => Labels::getLabel('LBL_ACTION_BUTTONS', $langId)
);

$tbl = new HtmlElement('table', array('class' => 'table listingTableJs'));
$th = $tbl->appendElement('thead', ['class' => 'tableHeadJs'])->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ($key == 'action') {
        $e = $th->appendElement('th', array('class' => 'align-right', 'width' => '10%'), $val);
    } else {
        $e = $th->appendElement('th', array('width' => '30%'), $val);
    }
}
$tbody = $tbl->appendElement('tbody');
$count = 0;
foreach ($productSpecifications as  $specification) {
    $prodSpecId = $specification['prodspec_id'];
    $tr = $tbody->appendElement('tr', ['data-id' => $prodSpecId]);
    foreach ($arr_flds as $key => $val) {
        $tdAttr = ('action' == $key) ? ['class' => 'align-right'] : ['class' => str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . "Js text-break"];
        $td = $tr->appendElement('td', $tdAttr);
        switch ($key) {
            case 'action':
                $ul = new HtmlElement("ul", array('class' => 'actions'));
                $li = $ul->appendElement('li');
                $li->appendElement(
                    'input',
                    [
                        'name' => 'specifications[' . $count . '][id]',
                        'type' => 'hidden',
                        'value' => $specification['prodspec_id'],
                        'data-fatreq' => json_encode(['required' => false]),
                    ]
                );
                $li->appendElement(
                    'a',
                    [
                        'href' => 'javascript:void(0)',
                        'title' => Labels::getLabel('BTN_EDIT', $langId),
                        'onclick' => "editProdSpec(this)"
                    ],
                    '<i class="fa fa-edit"></i>',
                    true
                );

                $li = $ul->appendElement('li');
                $li->appendElement(
                    'a',
                    [
                        'href' => 'javascript:void(0)',
                        'title' => Labels::getLabel('BTN_DELETE', $langId),
                        'onclick' => "deleteProdSpec(this)",
                        'data-id' => $prodSpecId,
                        'data-lang-id' => $langId,
                    ],
                    '<i class="fa fa-trash"></i>',
                    true
                );
                $td->appendElement('plaintext', $tdAttr, $ul->getHtml(), true);

                break;
                case 'prodspec_name':
                    $inputIdentifier = new HtmlElement(
                        'input',
                        [
                            'name' => 'specifications[' . $count . '][identifier]',
                            'type' => 'hidden',
                            'value' => html_entity_decode($specification['prodspec_identifier'], ENT_QUOTES, 'utf-8'),
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => 'identifierJs'
                        ]
                    );
                    $input = new HtmlElement(
                        'input',
                        [
                            'name' => 'specifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
                            'type' => 'hidden',
                            'value' => html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8'),
                            'data-fatreq' => json_encode(['required' => false]),
                        ]
                    );
                    $td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml() . $inputIdentifier->getHtml(), true);
                    break;
            default:
                $input = new HtmlElement(
                    'input',
                    [
                        'name' => 'specifications[' . $count . '][' . str_replace(ProdSpecification::DB_TBL_PREFIX, '', $key) . ']',
                        'type' => 'hidden',
                        'value' => html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8'),
                        'data-fatreq' => json_encode(['required' => false]),
                    ]
                );
                $td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml(), true);
                break;
        }
    }
    $count++;
}
?>
<div class="js-scrollable table-wrap table-responsive">
    <?php
    echo $tbl->getHtml();
    ?>
</div>