<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');

$arr_flds = array(
    'prod_spec_name' => Labels::getLabel('LBL_Specification_Name', $siteLangId),
    'prod_spec_file' => Labels::getLabel('LBL_Specification_File', $siteLangId),
    'action' => ''
);

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ($key == 'prod_spec_name') {
        $e = $th->appendElement('th', array('width' => '50%'), $val);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}
$tbody = $tbl->appendElement('tbody');
$count = 0;

if (count($productSpecifications) > 0) {
    foreach ($productSpecifications as $keyData => $specification) {
        $i = 1;
        $tr = $tbody->appendElement('tr');
        foreach ($arr_flds as $key => $val) {
            $tdAttr = ('action' == $key) ? ['class' => 'align-right'] : ['class' => str_replace('prod_spec_', '', $key) . "Js text-break"];
            $td = $tr->appendElement('td', $tdAttr);
            switch ($key) {
                case 'prod_spec_file' :
                    $fileHtml = '';
                    $fileData = [];
                    if (FatUtility::int($specification['prod_spec_file_index']) > 0) {
                        $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $preqId, $specification['prod_spec_file_index'], $siteLangId);
                    } 
                    
                    if (!empty($fileData)) {
                        $tr->addValueToAttribute('data-index', $keyData);
                        $tr->addValueToAttribute('data-ofile_index', $specification['prod_spec_file_index']);
                        $tr->addValueToAttribute('data-file_index', $specification['prod_spec_file_index']);
                        /* $tr->addValueToAttribute('data-temp_file', 0); */
                        $fileArr = explode('.', $fileData['afile_name']);
                        $fileTypeIndex = count($fileArr) - 1;
                        $fileType = strtolower($fileArr[$fileTypeIndex]);
                        $imageTypes = array('gif', 'jpg', 'jpeg', 'png', 'svg', 'bmp', 'tiff');

                        $attachmentUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id']), CONF_WEBROOT_FRONT_URL);
                        if (in_array($fileType, $imageTypes)) {
                            $imageUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id'], 50, 50), CONF_WEBROOT_FRONT_URL) . '?t=' . strtotime($fileData['afile_updated_at']);

                            $fileHtml = "<a href='" . $attachmentUrl . "' target='_blank' title='" . $fileData['afile_name'] . "'><img src='" . $imageUrl . "' class='img-thumbnail image-small' /> </a>";
                        } else {
                            $fileHtml = "<a href='" . $attachmentUrl . "' title='" . $fileData['afile_name'] . "' download><i class='fa fa-download' aria-hidden='true'></i></a>";
                        }
                    }
                    $td->appendElement('plaintext', array(), $fileHtml, true);
                    break;
                case 'prod_spec_name':
                    $inputIdentifier = new HtmlElement(
                        'input',
                        [
                            'name' => 'filespecifications[' . $count . '][identifier]',
                            'type' => 'hidden',
                            'value' => html_entity_decode($specification['identifier'], ENT_QUOTES, 'utf-8'),
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => 'identifierJs'
                        ]
                    );
                    $input = new HtmlElement(
                        'input',
                        [
                            'name' => 'filespecifications[' . $count . '][' . str_replace('prod_spec_', '', $key) . ']',
                            'type' => 'hidden',
                            'value' => html_entity_decode($specification[$key], ENT_QUOTES, 'utf-8'),
                            'data-fatreq' => json_encode(['required' => false]),
                        ]
                    );
                    $td->appendElement('plaintext', $tdAttr, $specification[$key] . $input->getHtml() . $inputIdentifier->getHtml(), true);
                    break;
                case 'action':
                    $ul = $td->appendElement('ul', array('class' => 'actions'));
                    $li = $ul->appendElement('li');

                    $li->appendElement(
                        'input',
                        [
                            'name' => 'filespecifications[' . $keyData . '][file_index]',
                            'type' => 'hidden',
                            'value' => $specification['prod_spec_file_index'],
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => '',
                            'id' => 'file_index_' . $keyData
                        ]
                    );
                    
                    $li->appendElement(
                        'input',
                        [
                            'name' => 'filespecifications[' . $keyData . '][ofile_index]',
                            'type' => 'hidden',
                            'value' => $specification['prod_spec_file_index'],
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => '',
                            'id' => 'ofile_index_' . $keyData
                        ]
                    );
                    
                    /* $inputIdentifier = new HtmlElement(
                        'input',
                        [
                            'name' => 'filespecifications[' . $count . '][temp_file]',
                            'type' => 'hidden',
                            'value' => 0,
                            'data-fatreq' => json_encode(['required' => false]),
                            'class' => ''
                        ]
                    ); 
                    $fileHtml .= $inputIdentifier->getHtml();
                    */

                    $li->appendElement(
                        'a',
                        [
                            'href' => 'javascript:void(0)',
                            'title' => Labels::getLabel('BTN_EDIT', $langId),
                            'onclick' => "editFileSpec(this)"
                        ],
                        '<i class="fa fa-edit"></i>',
                        true
                    );
                    $li = $ul->appendElement('li');
                    $li->appendElement(
                        'a',
                        [
                            'href' => 'javascript:void(0)',
                            'title' => Labels::getLabel('BTN_DELETE', $langId),
                            'onclick' => "deleteFileSpec(this)",
                            'data-id' => $count,
                            'data-lang-id' => $langId,
                        ],
                        '<i class="fa fa-trash"></i>',
                        true
                    );

                   /*  $td->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'btn btn-sm btn-clean btn-icon btn-icon-md', 'title' => Labels::getLabel('LBL_Edit', $siteLangId), 'onClick' => 'prodSpecificationMediaSection(' . $langId . ',' . $keyData . ')'), '<i class="fa fa-edit"></i>', true);
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'class' => 'btn btn-sm btn-clean btn-icon btn-icon-md', 'title' => Labels::getLabel('LBL_Delete', $siteLangId), 'onClick' => 'deleteProdSpec(' . $keyData . ',' . $langId . ', 1)'), '<i class="fa fa-trash"></i>', true); */
                    break;
                default:
                    $td->appendElement('plaintext', array(), $specification[$key], true);
                    break;
            }
        }
        $count++;
    }
}
?>
<div class="js-scrollable table-wrap table-responsive">
    <?php echo $tbl->getHtml(); ?>
</div>