<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

HtmlHelper::formatFormFields($frm);
$frm->setFormTagAttribute('class', 'form');

$fld = $frm->getField('prod_image');
$fld->addFieldTagAttribute('data-frm', 'imageFrm');
$fld->addFieldTagAttribute('onChange', "loadImageCropper(this)");
$fld->addFieldTagAttribute('accept', "image/*");
$fld->addFieldTagAttribute('data-name', Labels::getLabel("FRM_PRODUCT_IMAGE", $siteLangId));
$fld->htmlAfterField = '<br/><small>' . Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than_' . $imageSize['width'] . '_x_' . $imageSize['height'], $siteLangId) . '</small>';


$fld = $frm->getField('option_id');
$fld->addFieldTagAttribute('id', "image_option_id");

$fld = $frm->getField('file_type');
if(null != $fld){
    $fld->addFieldTagAttribute('id', "image_file_type");
}

$fld = $frm->getField('lang_id');
$fld->addFieldTagAttribute('id', "image_lang_id");


$fld = $frm->getField('product_id');
$fld->addFieldTagAttribute('id', "image_product_id");


$fld = $frm->getField('images');
$fld->value= '<ul class="uploaded-media" id="productImagesJs"></ul>';

?>	
<div class="modal-dialog modal-dialog-centered modal-lg" role="document" id="images-form">
    <div class="modal-content">
		<div class="modal-header">
			<h5 class="modal-title">
				<?php echo Labels::getLabel('LBL_MEDIA_SETUP', $siteLangId); ?>
			</h5>
			<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
		</div>
		<div class="modal-body">
			<?php echo $frm->getFormHtml(); ?>
		</div>
	</div>
</div>