<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="content-wrapper content mainJs"
    <?php echo CommonHelper::getLayoutDirection() != $formLayout ? 'dir="' . $formLayout . '"' : ''; ?>>
    <div class="content-header">
        <div class="content-header-title">
            <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
            <h2 class="content-header-heading">
                <?php //if (strtolower($previousAction) == 'catalog') { ?>
                <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_To_My_Products', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>">
                    <svg class="svg" width="24" height="24">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                        </use>
                    </svg>
                </a>
                <?php /*} else { ?>
                <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_To_Inventory', $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>">
                    <svg class="svg" width="24" height="24">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                        </use>
                    </svg>
                </a>
                <?php } */ ?>
                <?php echo Labels::getLabel('LBL_Custom_Product_Setup', $siteLangId); ?>
            </h2>
        </div>
    </div>
    <div class="content-body">
        <!-- New Form Start -->
        <?php $frm->addFormTagAttribute('class', 'form');
        $frm->setFormTagAttribute('id', 'addProductfrm');
        $frm->setFormTagAttribute('onsubmit', 'setup($(\'#addProductfrm\'));return false;');
        echo $frm->getFormTag(); ?>
        <div class="add-stock" id="addStock">
            <div class="add-stock-column column-main">
                <div class="card" id="basic-details">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('LBL_BASIC_DETAILS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('LBL_MANAGE_PRODUCT_BASIC_INFORMATION', $siteLangId); ?></span>
                        </div>
                        <?php
                        $langFld = $frm->getField('lang_id');
                        if (1 > $productId) {
                            $langFld->addFieldTagAttribute('disabled', 'disabled');
                        } else {
                            $langFld->setfieldTagAttribute('class', 'form-control form-select select-language');
                            $langFld->setfieldTagAttribute('onchange', 'langForm()');
                            $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');

                            if (!empty($translatorSubscriptionKey) && $langFld->value != CommonHelper::getDefaultFormLangId()) {
                                $langFld->developerTags['fldWidthValues'] = ['d-flex', '', '', ''];
                                $langFld->htmlAfterField = '<div class="input-group-append">
                                                                        <a href="javascript:void(0);"  class="btn-outline-gray btn xxx" onclick="langForm(' . $langFld->value . ',' . $siteLangId . ')" class="btn" title="' . Labels::getLabel('BTN_AUTOFILL_LANGUAGE_DATA', $siteLangId) . '">
                                                                            <svg class="svg" width="18" height="18">
                                                                                <use xlink:href="' . CONF_WEBROOT_URL . 'images/dashboard/retina/sprite.svg#translate">
                                                                                </use>
                                                                            </svg>
                                                                        </a>
                                                                    </div>';
                            }
                        }

                        ?>
                        <div class="content-header-toolbar">
                            <div class="input-group">
                                <?php
                                echo $langFld->getHtml();
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <?php echo HtmlHelper::getFieldHtml($frm, 'product_identifier', 12, [], Labels::getLabel('MSG_A_UNIQUE_IDENTIFIER_ASSOCIATED_FOR_PRODUCT_NAME', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'product_name', 12, [], Labels::getLabel('MSG_A_NAME_OF_THE_PRODUCT_TO_BE_LISTED', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'product_brand_id', 6, ['id' => 'product_brand_id', 'placeholder' => Labels::getLabel('FRM_SELECT_BRAND', $siteLangId)], '', '', ['label' => FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) ? Labels::getLabel('FRM_REQUEST_FOR_BRAND', $siteLangId) : Labels::getLabel('FRM_ADD_BRAND', $siteLangId), 'attr' => ['onclick' => 'addBrandReqForm(0)', 'class' => 'lable-btn-underline', 'type' => 'button'], 'attrType' => 'button']);

                            //echo HtmlHelper::getFieldHtml($frm, 'brand_name', 6, ['onChange' => 'brandAutocomplete(this)', 'id' => 'brand_name'], '', '', ['label' => FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) ? Labels::getLabel('FRM_REQUEST_FOR_BRAND', $siteLangId) : Labels::getLabel('FRM_ADD_BRAND', $siteLangId), 'attr' => ['onclick' => 'addBrandReqForm(0)', 'class' => 'lable-btn-underline', 'type' => 'button'], 'attrType' => 'button']);
                            
                            echo HtmlHelper::getFieldHtml($frm, 'product_model', 6, ['id' => 'product_model']);

                            echo HtmlHelper::getFieldHtml($frm, 'ptc_prodcat_id', 6, ['id' => 'ptc_prodcat_id', 'placeholder' => Labels::getLabel('FRM_SELECT_CATEGORY', $siteLangId)], '', '', ['label' => FatApp::getConfig('CONF_PRODUCT_CATEGORY_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) ? Labels::getLabel('FRM_REQUEST_FOR_CATEGORY', $siteLangId) : Labels::getLabel('FRM_ADD_CATEGORY', $siteLangId), 'attr' => ['onclick' => 'addCategoryReqForm(0)', 'class' => 'lable-btn-underline', 'type' => 'button'], 'attrType' => 'button']);
                            // echo HtmlHelper::getFieldHtml($frm, 'product_model', 6);
                            if ($allowForSale) {
                                echo HtmlHelper::getFieldHtml($frm, 'product_min_selling_price', 6);
                            }

                            echo HtmlHelper::getFieldHtml($frm, 'ptt_taxcat_id_rent', 6, ['id' => 'ptt_taxcat_id_rent'], '', '', ['label' => Labels::getLabel('FRM_TAX_CATEGORIES', $siteLangId), 'attr' => ['target' => '__blank', 'href' => UrlHelper::generateUrl('seller', 'taxCategories'), 'class' => 'lable-btn-underline'], 'attrType' => 'anchor']);

                            echo HtmlHelper::getFieldHtml($frm, 'ptt_taxcat_id', 6, ['id' => 'ptt_taxcat_id']);


                            echo HtmlHelper::getFieldHtml($frm, 'product_warranty', 6, [], Labels::getLabel('MSG_Warranty_In_Days', $siteLangId));

                            echo HtmlHelper::getFieldHtml($frm, 'product_youtube_video', 6);
                            echo HtmlHelper::getFieldHtml($frm, 'product_description', 12);
                            ?>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="tax-shipping">
                    <div class="card-head dropdown-toggle-custom" data-bs-toggle="collapse"
                        data-bs-target="#stock-block4" aria-expanded="true" aria-controls="stock-block4">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_SHIPPING_INFORMATION', $siteLangId); ?>
                            </h3>
                            <span class="text-muted">
                                <?php echo Labels::getLabel('MSG_SETUP_SHIPPING_INFORMATION_OF_THE_PRODUCT', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse show" id="stock-block4">
                        <div class="card-body">
                            <div class="row">
                                <?php
                                echo HtmlHelper::getFieldHtml($frm, 'product_ship_package', 6);
                                echo HtmlHelper::getFieldHtml($frm, 'shipping_profile', 6, ['id' => 'shipping_profile']);
                                echo HtmlHelper::getFieldHtml($frm, 'product_weight', 6);
                                echo HtmlHelper::getFieldHtml($frm, 'product_weight_unit', 6);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="variants-options">
                    <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#variants-block" aria-expanded="false" aria-controls="variants-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_VARIANTS_&_OPTIONS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_CUSTOMIZE_PRODUCT_VARIENTS_INCLUDING_SIZE_COLOR_ETC', $siteLangId); ?></span>
                        </div>
                        <div class="card-toolbar">
                            <i class="dropdown-toggle-custom-arrow"></i>
                        </div>
                    </div>
                    <div class="collapse" id="variants-block">
                        <div class="card-body">
                            <?php if (0 < $productId) { ?>
                            <div class="alert alert-custom alert-danger" role="alert">
                                <svg class="svg" width="18" height="18" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 16 16" role="img" aria-label="Warning:">
                                    <path
                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </svg>
                                <div>
                                    <?php echo Labels::getLabel('ERR_IF_INVENTORY_IS_ALREADY_ADDED_THEN_YOU_CANNOT_UPDATE_OPTIONS.', $siteLangId); ?>
                                </div>
                            </div>

                            <?php } ?>
                            <?php
                            $fld = $frm->getField('option_groups');
                            //$fld->addFieldTagAttribute('class', 'form-tagify');
                            //$fld->addFieldTagAttribute('id', 'product-options-js');
                            
                            ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <?php echo $fld->getHtml(); ?>
                                    <div class="list-tag-wrapper scroll scroll-y">
                                        <ul class="list-tags" id="vaiants-list-js">
                                            <?php
                                            if (!empty($productOptions)) {
                                                foreach ($productOptions as $prodOption) {
                                                    $optionName = !empty($prodOption['option_name']) ? $prodOption['option_name'] : $prodOption['option_identifier'];
                                                    ?>
                                            <li class="list-tags-item"
                                                id="variants<?php echo $prodOption['option_id']; ?>">
                                                <span>
                                                    <?php echo $optionName; ?>
                                                    &nbsp; <i class="remove-variant-js remove_param btn-close"
                                                        data-id="<?php echo $prodOption['option_id']; ?>"></i>
                                                    <input type="hidden" name="prod_options[]"
                                                        value="<?php echo $prodOption['option_id']; ?>" />
                                                </span>
                                            </li>
                                            <?php
                                                }
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                </div>

                                <div class="col-md-12 option-values-js mt-4" <?php if (empty($prodOptValCombArr)) { ?>
                                    style="display:none;" <?php } ?>>
                                    <h3 class="card-head-title">
                                        <?php echo Labels::getLabel('MSG_Variants', $siteLangId); ?>
                                    </h3>
                                    <div class="list-tag-wrapper scroll scroll-y mt-2">
                                        <ul class="list-tags">
                                            <?php
                                            if (!empty($prodOptValCombArr)) {
                                                foreach ($prodOptValCombArr as $row) { ?>
                                            <li class="list-tags-item"><span><?php echo $row; ?></span></li>
                                            <?php }
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="card card-toggle" id="media">
                    <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#stock-block2" aria-expanded="false" aria-controls="stock-block2">
                        <div class="card-head-label">
                            <h3 class="card-head-title"><?php echo Labels::getLabel('NAV_MEDIA', $siteLangId); ?> </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_YOUR_PRODUCT_IMAGES_GALLERY', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar">
                            <i class="dropdown-toggle-custom-arrow"></i>
                        </div>
                    </div>
                    <div class="collapse" id="stock-block2">
                        <div class="card-body">
                            <div>
                                <div class="d-flex justify-content-between mb-3">
                                    <h6 class="h6 "><?php echo Labels::getLabel('LBL_UPLOADED_MEDIA', $siteLangId); ?>
                                    </h6>
                                    <a href="javascript:void(0)" onclick="imageForm();"
                                        class="link-underline"><?php echo Labels::getLabel('LBL_ADVANCED_MEDIA', $siteLangId); ?></a>
                                </div>
                                <div class="col-md-12">
                                    <?php
                                    /* [ MEDIA INSTRUCTIONS START HERE */
                                    $tpl = new FatTemplate('', '');
                                    $tpl->set('siteLangId', $siteLangId);
                                    echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                                    /* ] */
                                    ?>
                                </div>
                                <ul class="uploaded-stocks ui-sortable" id="productDefaultImagesJs">
                                    <li class="browse unsortableJs">
                                        <button type="button" class="browse-button"
                                            onclick="$('#hiddenMediaFrmFileJs').click();">
                                            <strong><?php echo Labels::getLabel('LBL_UPLOAD_IMAGES(S)', $siteLangId); ?></strong>
                                        </button>
                                    </li>
                                </ul>
                                <div class="form-text text-muted pt-2">
                                    <?php echo Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than', $siteLangId) . ' ' . $imageSize['width'] . ' x ' . $imageSize['height']; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="specifications">
                    <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#specifications-block" aria-expanded="false"
                        aria-controls="specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_SPECIFICATIONS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_SPECIFICATIONS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="specifications-block">
                        <div class="card-body">
                            <div id="specificationsFormJs">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_identifier" id="sp_identifier" value=""
                                                data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_label" id="sp_label" value="" data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_VALUE', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_value" id="sp_value" value="" data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_GROUP', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="sp_group" id="sp_group" value="" data-required="0">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label"></label>
                                            <input type="hidden" name="sp_id" id="sp_id" value="0" data-required="0">
                                            <button type="button" id="btnAddSpecJs" class="btn btn-brand btn-wide"
                                                onclick="addSpecification()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>
                                            </button>
                                            <button type="button" id="btnClearSpecJs"
                                                class="btn btn-outline-brand btn-wide" onclick="clearProdSpecForm()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_CLEAR', $siteLangId); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="specificationsListSeprJs" class="separator separator-dashed my-4"></div>
                            <div id="specificationsListJs"></div>
                        </div>
                    </div>
                </div>
                <div class="card card-toggle" id="file-specifications">
                    <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#file-specifications-block" aria-expanded="false"
                        aria-controls="file-specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_FILE_SPECIFICATIONS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_RELATED_FILE_SPECIFICATIONS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="file-specifications-block">
                        <div class="card-body">
                            <div class="col-md-12">
                                <?php
                                /* [ MEDIA INSTRUCTIONS START HERE */
                                $tpl = new FatTemplate('', '');
                                $tpl->set('siteLangId', $siteLangId);
                                echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                                /* ] */
                                ?>
                            </div>
                            <div id="file-specificationsFormJs">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_IDENTIFIER', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="fsp_identifier" id="fsp_identifier" value=""
                                                data-required="1">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <?php echo Labels::getLabel('FRM_SPECIFICATION_NAME', $siteLangId); ?>
                                            </label>
                                            <input type="text" name="fsp_name" id="fsp_name" value="" data-required="1">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label">
                                                <span
                                                    class="filename"><?php echo Labels::getLabel('LBL_Specification_File_Is_Mandatory', $siteLangId); ?></span>
                                            </label>
                                            <input id="hiddenSpecFileFrmFileJs" accept="image/*"
                                                data-name="<?php echo Labels::getLabel("FRM_SPECIFICATION_FILE", $siteLangId); ?>"
                                                data-ids="prodspec_file" type="file" data-frm="fileSpecFrm"
                                                name="prodspec_file" onChange="uploadFileSpecFile(this);">
                                            <div id="filespectempJs"></div>
                                            <input id="hiddenSpecFileIdJs" data-is_file="1" type="hidden"
                                                id="prodspecFileIdJs" name="prodspec_file_id" data-required="1">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="label"></label>
                                            <input type="hidden" name="fsp_id" id="fsp_id" value="0" data-required="0">
                                            <button type="button" id="btnAddFileSpecJs" class="btn btn-brand btn-wide"
                                                onclick="addFileSpecification()"
                                                data-updatelbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>
                                            </button>
                                            <button type="button" id="btnClearFileSpecJs"
                                                class="btn btn-outline-brand btn-wide" onclick="clearFileSpecForm()"
                                                data-updateLbl="<?php echo Labels::getLabel('BTN_UPDATE', $siteLangId); ?>"
                                                data-addLbl="<?php echo Labels::getLabel('BTN_ADD', $siteLangId); ?>">
                                                <?php echo Labels::getLabel('BTN_CLEAR', $siteLangId); ?>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="file-specificationsListSeprJs" class="separator separator-dashed my-4"></div>
                            <div id="file-specificationsListJs"></div>
                        </div>
                    </div>
                </div>
                
                <div class="card card-toggle disabled" id="customfields" style="display:none">
                    <div class="card-head dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                        data-bs-target="#customfields-block" aria-expanded="false" aria-controls="specifications-block">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('NAV_CUSTOM_FIELDS', $siteLangId); ?>
                            </h3>
                            <span
                                class="text-muted"><?php echo Labels::getLabel('MSG_MANAGE_PRODUCT_CUSTOM_FIELDS', $siteLangId); ?>
                            </span>
                        </div>
                        <div class="card-toolbar"> <i class="dropdown-toggle-custom-arrow"></i></div>
                    </div>
                    <div class="collapse" id="customfields-block">
                        <div class="card-body">
                            <div id="CustomFieldsFormJs"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="add-stock-column column-actions">
                <div class="sticky-top">
                    <div class="card">
                        <div class="card-body">
                            <?php
                            $fld = $frm->getField('btn_submit');
                            $fld->addFieldTagAttribute('class', 'btn btn-brand btn-block');
                            echo $frm->getFieldHtml('btn_submit');
                            echo $frm->getFieldHtml('product_id');
                            echo $frm->getFieldHtml('temp_record_id');
                            //echo $frm->getFieldHtml('ptc_prodcat_id');
                            //echo $frm->getFieldHtml('product_brand_id');
                            //echo $frm->getFieldHtml('ptt_taxcat_id');
                            //echo $frm->getFieldHtml('ptt_taxcat_id_rent');
                            echo $frm->getFieldHtml('product_type');
                            ?>
                            <div class="mt-3">
                                <?php
                                $fld = $frm->getField('product_active');
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
                                                <div class="setting-block">' . $fld->getHtml() . '</div>
                                            </div>';

                                $fld = $frm->getField('product_featured');
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group">
                                                <div class="setting-block">' . $fld->getHtml() . '</div>
                                            </div>';
                                $fld = $frm->getField('auto_update_other_langs_data');
                                if (null != $fld) {
                                    HtmlHelper::configureSwitchForCheckbox($fld);
                                    echo '<div class="form-group">
                                                    <div class="setting-block">' . $fld->getHtml() . '</div>
                                                </div>';
                                }
                                $fld = $frm->getField('product_cod_enabled');
                                if (null != $fld) {
                                    $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');

                                    HtmlHelper::configureSwitchForCheckbox($fld);
                                    echo '<div class="form-group">
                                                    <div class="setting-block">' . $fld->getHtml() . '</div>
                                                </div>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $fld = $frm->getField('product_tags');
                    if (null != $fld) {
                        $fld->addFieldTagAttribute('class', 'form-tagify');
                        $fld->addFieldTagAttribute('id', 'product_tags');
                        ?>
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('FRM_Tags', $langId); ?></h3>
                                <span class="text-muted">
                                    <?php echo Labels::getLabel('FRM_BIND_TAGS_TO_MAKE_IT_EASIER_TO_APPEAR_IN_SEARCH_RESULTS', $langId); ?>
                                </span>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php echo $fld->getHtml(); ?>
                        </div>
                    </div>
                    <?php } ?>

                    <div class="card size-chart-js size-chart-card-js" <?php if ($isOptWithSizeChart == false) { ?>
                        style="display:none" <?php } ?>>
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('FRM_Size_chart', $langId); ?>
                                </h3>
                                <span class="text-muted">
                                    <?php echo Labels::getLabel('FRM_Upload_Size_chart_for_better_clarity', $langId); ?>
                                </span>
                            </div>
                        </div>
                        <div class="card-body">


                            <?php
                            $fld = $frm->getField('auto_update_other_langs_data_prod_size_chart');
                            if (null != $fld) {
                                HtmlHelper::configureSwitchForCheckbox($fld);
                                echo '<div class="form-group"><div class="form-group">
                                                    <div class="setting-block">' . $fld->getHtml() . '</div>
                                                </div></div>';
                            }
                            ?>


                            <input onchange="popupSizeChartImage(this)" accept="image/*" type="file"
                                name="prod_size_chart" value="">
                            <input type="hidden" name="lang_id" value="<?php echo $langId ?>">
                            <input type="hidden" name="size_chart_temp_id" id="sizechart-temp-id-js">
                            <div id="size-chart-image-js">
                                <?php
                                if (!empty($sizeChart)) {
                                    $afileRecordId = $sizeChart['afile_record_id'];
                                    $afileId = $sizeChart['afile_id'];
                                    ?>

                                <ul class="uploaded-media">
                                    <li class="uploaded-media-item">
                                        <div class=" uploaded-file">
                                            <div class="uploaded-file-thumb no-accept-ratio">
                                                <img src="<?php echo CommonHelper::generateUrl('image', 'productSizeChart', array($sizeChart['afile_record_id'], "THUMB", $sizeChart['afile_id']), CONF_WEBROOT_FRONTEND); ?>"
                                                    title="<?php echo $sizeChart['afile_name']; ?>"
                                                    alt="<?php echo $sizeChart['afile_name']; ?>"
                                                    style="max-height:100px">
                                            </div>
                                            <button type="button" class="btn-close text-reset file-remove"
                                                onClick="deleteImage('<?php echo $afileRecordId; ?>', '<?php echo $afileId; ?>','<?php echo AttachedFile::FILETYPE_PRODUCT_SIZE_CHART; ?>', 1)">
                                            </button>
                                        </div>
                                    </li>
                                </ul>
                                <?php
                                }

                                ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        </form>
        <?php echo $frm->getExternalJS();
        $imgFrm->setFormTagAttribute('class', 'hidden');
        $imgFrm->setFormTagAttribute('name', 'hiddenMediaFrm');
        $imgFrm->setFormTagAttribute('id', 'hiddenMediaFrmJs');
        $fld = $imgFrm->getField('prod_image');
        $fld->addFieldTagAttribute('onChange', "loadCropper(this)");
        $fld->addFieldTagAttribute('id', "hiddenMediaFrmFileJs");
        $fld->addFieldTagAttribute('data-frm', 'hiddenMediaFrm');
        $fld->addFieldTagAttribute('accept', "image/*");
        $fld->addFieldTagAttribute('data-name', Labels::getLabel("FRM_PRODUCT_IMAGE", $siteLangId));
        echo $imgFrm->getFormHtml();

        $fileSpecFrm->setFormTagAttribute('class', 'hidden');
        $fileSpecFrm->setFormTagAttribute('name', 'fileSpecFrm');
        $fileSpecFrm->setFormTagAttribute('id', 'hiddenFileSpecFrmJs');
        $fld = $fileSpecFrm->getField('prodspec_is_file');
        $fld->addFieldTagAttribute('id', 'prodspec_is_file');
        echo $fileSpecFrm->getFormHtml();
        ?>
        <!-- New Form End -->
    </div>
</div>
</main>
<script>
var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
var CONF_ALLOW_MEMBERSHIP_MODULE =
    <?php echo FatApp::getConfig('CONF_ALLOW_MEMBERSHIP_MODULE', FatUtility::VAR_INT, 0); ?>;
var tempImageType = '<?php echo AttachedFile::FILETYPE_PRODUCT_IMAGE_TEMP; ?>';
var forAllOptionsLbl = '<?php echo Labels::getLabel('FRM_FOR_ALL_OPTIONS', $langId); ?>';
var canEditTags = '<?php echo $canEditTags; ?>';


$(function() {
    /*brandAutocomplete();
    categoryAutocomplete();
    taxCatNameRent();
    rentTaxCatNameRent();*/
    productDefaultImages();
    prodSpecifications();
    fileSpecifications();
    tagifyProducts();
    /*tagifyOptions();*/
    getCustomFields();
    /*validateAttachedOptions();*/
});

$("#product_brand_id").select2({
    closeOnSelect: true,
    dir: langLbl.layoutDirection,
    allowClear: true,
    placeholder: $("#product_brand_id").attr('placeholder'),
    ajax: {
        url: fcom.makeUrl('brands', 'autoCompleteForSelect2'),
        dataType: 'json',
        delay: 250,
        method: 'post',
        data: function(params) {
            return {
                keyword: params.term,
                page: params.page,
                fIsAjax: 1,
            };
        },
        processResults: function(data, params) {
            params.page = params.page || 1;
            return {
                results: data.results,
                pagination: {
                    more: params.page < data.pageCount
                }
            };
        },
        cache: true
    },
    processResults: function(data, params) {
        params.page = params.page || 1;
        return {
            results: data.results,
            pagination: {
                more: params.page < data.pageCount
            }
        };
    },
    cache: true,
    minimumInputLength: 0
});

$("#ptc_prodcat_id").select2({
    closeOnSelect: true,
    dir: langLbl.layoutDirection,
    allowClear: true,
    placeholder: $("#ptc_prodcat_id").attr('placeholder'),
    ajax: {
        url: fcom.makeUrl('products', 'categoriesAutocomplete'),
        dataType: 'json',
        delay: 250,
        method: 'post',
        data: function(params) {
            return {
                keyword: params.term,
                page: params.page,
                fIsAjax: 1,
            };
        },
        processResults: function(data, params) {
            params.page = 1;
            return {
                results: data.results,
            };
        },
        cache: true
    },
    minimumInputLength: 0
}).on('select2:selecting', function(e) {
    var item = e.params.args.data;
    console.log(item);
    console.log(item.id);

    getCustomFields(item.id);
});


$("select[name='option_groups']").select2({
    closeOnSelect: true,
    dir: langLbl.layoutDirection,
    allowClear: true,
    placeholder: $("select[name='option_groups']").attr('placeholder'),
    ajax: {
        url: fcom.makeUrl('Seller', 'autoCompleteOptions'),
        dataType: 'json',
        delay: 250,
        method: 'post',
        data: function(params) {
            var parentForm = $("select[name='option_groups']").closest('form').attr('id');
            var selectedFields = [];
            $('input[name="prod_options[]"]').each(function() {
                selectedFields.push($(this).val());
            });

            return {
                keyword: params.term,
                page: params.page,
                fIsAjax: 1,
                /*selProdId: $("#" + parentForm + " input[name='vflds_id']").val(),*/
                selectedFields: selectedFields,
            };
        },
        processResults: function(data, params) {
            params.page = 1;
            return {
                results: data
            };
        },
        cache: true
    },
    minimumInputLength: 0,
    templateResult: function(result) {
        return result.name;
    },
    templateSelection: function(result) {
        return result.name || result.text;
    }
}).on('select2:selecting', function(e) {
    var parentForm = $(this).closest('form').attr('id');
    var item = e.params.args.data;
    $('input[name=\'option_groups\']').val('');
    $('#variants' + item.id).remove();
    $('#vaiants-list-js').append('<li class="list-tags-item"  id="variants' + item.id + '"><span> ' + item
        .name +
        '&nbsp; <i class="remove-variant-js remove_param btn-close" data-id="' + item.id +
        '"></i><input type="hidden" name="prod_options[]" value="' + item.id + '" /></span></li>');

    setTimeout(function() {
        $("select[name='option_groups']").val('').trigger('change');
        validateAttachedOptions(item.id);
    }, 200);

});

$('#vaiants-list-js').delegate('.remove-variant-js', 'click', function(e) {
    var thisobj = this;
    let productId = getProductId();
    if (productId > 0) {
        var option_id = $(this).data('id');
        fcom.ajax(fcom.makeUrl("Seller", "checkOptionLinkedToInventory"), "product_id=" + productId +
            "&option_id=" + option_id,
            function(t) {
                ans = jQuery.parseJSON(t);
                if (ans.status != true) {
                    var agree = alert(ans.msg);
                    return false;
                }
                $(thisobj).parents('li').remove();
                validateAttachedOptions();
            });
    } else {
        $(this).parents('li').remove();
        validateAttachedOptions();
    }
});

validateAttachedOptions = function(selectedOptionId) {
    var optionsData = $('input[name="prod_options[]"]').serializeArray();
    fcom.ajax(fcom.makeUrl("Seller", "validateAttachedOptions"), optionsData, function(t) {
        var ans = $.parseJSON(t);
        if (ans.status == 0) {
            $.systemMessage(ans.msg, "alert--danger");
            $('#variants' + selectedOptionId).remove();
        } else {
            if (ans.isOptWithSizeChart == 1) {
                $('.size-chart-js').show();
            } else {
                $('.size-chart-js').hide();
            }
            var optionsValHtml = '';
            $.each(ans.optionValArr, function(id, name) {
                optionsValHtml += '<li><span>' + name + '</span></li>';
            });
            $('.option-values-js .list-tags').html(optionsValHtml);
            if (optionsValHtml == '') {
                $('.option-values-js').hide();
            } else {
                $('.option-values-js').show();
            }
        }
    });
}
fcom.resetEditorWidth();

var editors = oUtil.arrEditor;
for (x in editors) {
    var oEdit1 = eval(editors[x]);
    var layout = langLbl['language' + (parseInt(x) + parseInt(1))];
    $('#idContent' + editors[x]).contents().find("body").css('direction', layout);
    $('#idArea' + oEdit1.oName + ' td[dir="ltr"]').attr('dir', layout);
}
</script>

<style>
.disabled {
    color: #dcdcdc !important;
}

#customFormFieldsJs .list-inline-fluid {
	flex-flow: wrap;
}
</style>