<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$shopLogoFrm->setFormTagAttribute('onsubmit', 'setupShopMedia(this); return(false);');
$shopLogoFrm->setFormTagAttribute('class', 'form');
$shopLogoFrm->developerTags['colClassPrefix'] = 'col-md-';
$shopLogoFrm->developerTags['fld_default_col'] = 12;
$ratioFld = $shopLogoFrm->getField('ratio_type');
$ratioFld->addFieldTagAttribute('class', 'prefRatio-js');
$fld = $shopLogoFrm->getField('shop_logo');
$fld->addFieldTagAttribute('class', 'btn btn-sm');
$fld->addFieldTagAttribute('onChange', 'logoPopupImage(this)');
if (!$canEdit) {
    $fld->addFieldTagAttribute('disabled', 'disabled');
    $ratioFld->addFieldTagAttribute('disabled', 'disabled');
}

$shopBannerFrm->setFormTagAttribute('onsubmit', 'setupShopMedia(this); return(false);');
$shopBannerFrm->setFormTagAttribute('class', 'form');
$shopBannerFrm->developerTags['colClassPrefix'] = 'col-md-';
$shopBannerFrm->developerTags['fld_default_col'] = 12;
$screenFld = $shopBannerFrm->getField('slide_screen');
$screenFld->addFieldTagAttribute('class', 'prefDimensions-js');
$fld = $shopBannerFrm->getField('shop_banner');
$fld->addFieldTagAttribute('class', 'btn  btn-sm');
$fld->addFieldTagAttribute('onChange', 'bannerPopupImage(this)');
if (!$canEdit) {
    $fld->addFieldTagAttribute('disabled', 'disabled');
}

$shopBackgroundImageFrm->setFormTagAttribute('onsubmit', 'setupShopMedia(this); return(false);');
$shopBackgroundImageFrm->developerTags['colClassPrefix'] = 'col-md-';
$shopBackgroundImageFrm->developerTags['fld_default_col'] = 12;
$fld = $shopBackgroundImageFrm->getField('shop_background_image');
$fld->addFieldTagAttribute('class', 'btn btn-sm');
$shopLayout = SHOP::TEMPLATE_ONE;
?>
<?php $variables = array('language' => $language, 'siteLangId' => $siteLangId, 'shop_id' => $shop_id, 'action' => $action);
?>
<div class="tabs-content tabs-content-js">
    <div class="card card-tabs">
        <div class="card-head">
            <?php $this->includeTemplate('seller/_partial/shop-navigation.php', $variables, false); ?>

        </div>
        <div class="card-body">
            <div class="row" id="shopFormBlock">
                <div class="col-md-12">
                    <?php
                    /* [ MEDIA INSTRUCTIONS START HERE */
                    $tpl = new FatTemplate('', '');
                    $tpl->set('siteLangId', $siteLangId);
                    echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                    /* ] */
                    ?>
                </div>

                <div id="mediaResponse"></div>
                <div class="col-md-6">
                    <div class="preview">
                        <h5><?php echo Labels::getLabel('LBL_Banner_Setup', $siteLangId); ?></h5>
                        <small class="form-text text-muted preferredDimensions-js"><?php echo Labels::getLabel('LBL_Preferred_Dimensions', $siteLangId) . ' 2000 x 500'; ?></small>
                        <div class="gap"></div>
                        <?php echo $shopBannerFrm->getFormHtml(); ?>
                        <div class="row" id="banner-image-listing">

                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="preview">
                        <h5><?php echo Labels::getLabel('LBL_Logo_Setup', $siteLangId); ?></h5>
                        <small class="form-text text-muted logoPreferredDimensions-js"><?php echo Labels::getLabel('LBL_Preferred_Dimensions', $siteLangId) . ' 150 x 150 '; ?></small>
                        <div class="gap"></div>
                        <?php echo $shopLogoFrm->getFormHtml(); ?>
                        <div class="row" id="logo-image-listing"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
var RATIO_TYPE_SQUARE = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
var RATIO_TYPE_RECTANGULAR = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
var RATIO_TYPE_CUSTOM = <?php echo AttachedFile::RATIO_TYPE_CUSTOM; ?>;

$('input[name=banner_min_width]').val(2000);
$('input[name=banner_min_height]').val(500);
$('input[name=logo_min_width]').val(150);
$('input[name=logo_min_height]').val(150);


var aspectRatio = 4 / 1;
$(document).on('change', '.prefDimensions-js', function() {
    var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
    var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

    if ($(this).val() == screenDesktop) {
        $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 2000 x 500');
        $('input[name=banner_min_width]').val(2000);
        $('input[name=banner_min_height]').val(500);
        aspectRatio = 4 / 1;
    } else if ($(this).val() == screenIpad) {
        $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 1024 x 360');
        $('input[name=banner_min_width]').val(1024);
        $('input[name=banner_min_height]').val(360);
        aspectRatio = 128 / 45;
    } else {
        $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 640 x 360');
        $('input[name=banner_min_width]').val(640);
        $('input[name=banner_min_height]').val(360);
        aspectRatio = 16 / 9;
    }
});

var logoAspectRatio = '';
$(document).on('change', '.prefRatio-js', function() {
    if ($(this).val() == RATIO_TYPE_SQUARE) {
        logoAspectRatio = 1 / 1;
        $('input[name=logo_min_width]').val(150);
        $('input[name=logo_min_height]').val(150);
        $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 150 x 150');
    } else if ($(this).val() == RATIO_TYPE_RECTANGULAR) {
        logoAspectRatio = 16 / 9;
        $('input[name=logo_min_width]').val(150);
        $('input[name=logo_min_height]').val(85);
        $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 150 x 85');
    } else {
        logoAspectRatio = '';
        $('input[name=logo_min_width]').val(200);
        $('input[name=logo_min_height]').val(100);
        $('.logoPreferredDimensions-js').html(" ");
    }
});
</script>