<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head card-head-sub">
    <h5 class="card-title">
        <button type="button" onClick="shopCollections(this)" class="btn btn-back">
            <svg class="svg" width="24" height="24">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                </use>
            </svg>
        </button>
        <?php echo Labels::getLabel('LBL_Back_to_Collections', $siteLangId); ?>
    </h5>
</div>
<div class="card-body">
    <div class="col-lg-12">
        <ul class="nav nav-tabs tabs-grcustom navTabsJs">
            <li class="nav-item"><button type="button" class="nav-link" onclick="getShopCollectionGeneralForm(<?php echo $scollection_id; ?>);"><?php echo Labels::getLabel('TXT_Basic', $siteLangId); ?></button></li>
            <li class="nav-item <?php echo (0 == $scollection_id) ? 'fat-inactive' : ''; ?>">
                <button class="nav-link" <?php echo (0 < $scollection_id) ? "onclick='editShopCollectionLangForm(" . $scollection_id . "," . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ");'" : ""; ?>>
                    <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                </button>
            </li>
            <li class="nav-item is-active">
                <button type="button" class="nav-link" onclick="sellerCollectionProducts(<?php echo $scollection_id ?>)"> <?php echo Labels::getLabel('TXT_LINK', $siteLangId); ?> </button>
            </li>
            <li class="nav-item"><button type="button" class="nav-link" <?php if ($scollection_id > 0) { ?> onclick="collectionMediaForm(this, <?php echo $scollection_id; ?>);" <?php } ?>><?php echo Labels::getLabel('TXT_Media', $siteLangId); ?></button></li>
        </ul>
        <div class="row form__subcontent">
            <div class="col-lg-6 ">
                <?php
                $collectionLinkFrm->setFormTagAttribute('onsubmit', 'setUpSellerCollectionProductLinks(this); return(false);');
                $collectionLinkFrm->setFormTagAttribute('class', 'form form--horizontal');
                $collectionLinkFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md- ';
                $collectionLinkFrm->developerTags['fld_default_col'] = 12;

                $submitFld = $collectionLinkFrm->getField('btn_submit');
                $submitFld->setFieldTagAttribute('class', "btn btn-brand btn-wide");
                echo $collectionLinkFrm->getFormHtml(); ?>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$("document").ready(function() {
    $('#selprod-products').on('click', '.remove_link', function() {
        $(this).parent().remove();
    });
});

<?php
    if (isset($products) && !empty($products)) {
        foreach ($products as $key => $val) {
            $options = SellerProduct::getSellerProductOptions($val['selprod_id'], true, $siteLangId);
            $variantsStr = '';
            array_walk($options, function ($item, $key) use (&$variantsStr) {
                $variantsStr .= ' | ' . $item['option_name'] . ' : ' . $item['optionvalue_name'];
            });
            $productName = strip_tags(html_entity_decode(($val['product_name'] != '') ? $val['product_name'] : $val['product_identifier'], ENT_QUOTES, 'UTF-8'));
            $productName .=  $variantsStr; ?>
$('#selprod-products ul').append("<li id=\"selprod-products<?php echo $val['selprod_id']; ?>\"> <?php echo $productName; ?>[<?php echo $val['product_identifier']; ?>] <i class=\"fa fa-times remove_param remove_link\"></i> <input type=\"hidden\"  name=\"product_ids[]\" value=\"<?php echo $val['selprod_id']; ?>\" /></li>");
<?php }
    } ?>
</script>