<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $siteLangId),
    'product_name' => Labels::getLabel('LBL_Name', $siteLangId),
    'splprice_start_date' => Labels::getLabel('LBL_Start_Date', $siteLangId),
    'splprice_end_date' => Labels::getLabel('LBL_End_Date', $siteLangId),
    'splprice_hour_price' => Labels::getLabel('LBL_Hour_Price', $siteLangId),
    'splprice_day_price' => Labels::getLabel('LBL_Day_Price', $siteLangId),
    'splprice_week_price' => Labels::getLabel('LBL_Week_Price', $siteLangId),
    'splprice_month_price' => Labels::getLabel('LBL_Month_Price', $siteLangId),
    'action' => '',
);

if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_HOUR)){
    unset($arr_flds['splprice_hour_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_DAY)){
    unset($arr_flds['splprice_day_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_WEEK)){
    unset($arr_flds['splprice_week_price']);
}
if(!applicationConstants::checkActiveRentalDurations(ProductRental::DURATION_TYPE_MONTH)){
    unset($arr_flds['splprice_month_price']);
}
if (!$canEdit) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified splPriceList-js'));
$th = $tbl->appendElement('thead')->appendElement('tr', array('class' => 'hide--mobile'));
foreach ($arr_flds as $column => $lblTitle) {
    if ('select_all' == $column) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $lblTitle . '" type="checkbox" onclick="selectAll($(this))" class="selectAll-js"></label>', true);
    } else {
        $th->appendElement('th', array(), $lblTitle);
    }
}

foreach ($arrListing as $sn => $row) {
    $tr = $tbl->appendElement('tr', array());
    $splPriceId = $row['splprice_id'];
    $selProdId = $row['selprod_id'];
    
    foreach ($arr_flds as $column => $lblTitle) {
        $tr->setAttribute('id', 'row-' . $splPriceId);
        $td = $tr->appendElement('td');
        switch ($column) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="selprod_ids[' . $splPriceId . ']" value=' . $selProdId . '></label>', true);
                break;

            case 'product_name':
                $productName = SellerProduct::getProductDisplayTitle($selProdId, $siteLangId, true);
                $td->appendElement('plaintext', array(), $productName, true);
                break;

            case 'selprod_price':
                if ($productFor == Product::PRODUCT_FOR_RENT) {
                    $price = CommonHelper::displayMoneyFormat($row['sprodata_rental_price'], true, true);
                } else {
                    $price = CommonHelper::displayMoneyFormat($row[$column], true, true);
                }
                $td->appendElement('plaintext', array(), $price, true);
                break;
                
            case 'splprice_start_date':
            case 'splprice_end_date':
                $date = date('Y-m-d', strtotime($row[$column]));                
                $td->appendElement('plaintext', array(), $date, true);
                break;

            case 'splprice_hour_price':
                $selprodPrice = $row['sprodata_hour_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $siteLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat( $row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $siteLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $siteLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $siteLangId), true);
                }
                
                break;

            case 'splprice_day_price':
                $selprodPrice = $row['sprodata_day_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(),Labels::getLabel('LBL_Disabled', $siteLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $siteLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $siteLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $siteLangId), true);
                }
                break;

            case 'splprice_week_price':
                $selprodPrice = $row['sprodata_week_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $siteLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $siteLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $siteLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $siteLangId), true);
                }
                
                break;

            case 'splprice_month_price':
                $selprodPrice = $row['sprodata_month_rental_price'];
                if($selprodPrice <= 0){
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Disabled', $siteLangId), true);
                }else if($row[$column] > 0){
                    $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$column], true, true), true);
                    $discountText = '';
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice > $row[$column]) {
                        $discountPrice = $selprodPrice - $row[$column];
                        $discountPercentage = round(($discountPrice / $selprodPrice) * 100, 2);
                        $discountText = $discountPercentage . "% " . Labels::getLabel('LBL_off', $siteLangId);
                    }
                    if ($productFor == Product::PRODUCT_FOR_RENT && $selprodPrice < $row[$column]) {
                        $discountValue = $selprodPrice - $row[$column];
                        $discountValue = abs($discountValue);
                        $discountText = Labels::getLabel('LBL_Extra_charges', $siteLangId) . ": " . CommonHelper::displayMoneyFormat($discountValue, true, true);
                    }
                    $td->appendElement('div', array("class" => 'ml-3 js--percentVal'), $discountText, true);
                }else{
                    $td->appendElement('plaintext', array(), Labels::getLabel('LBL_Not_Configured', $siteLangId), true);
                }
                break;

            case 'action':
                $ul = $td->appendElement("ul", array("class" => "actions actions--centered"), '', true);
                $li = $ul->appendElement('li', array("class" => "actions-item"));
                $li->appendElement(
                    'button',
                        array(
                            'type'=>'button',
                            'class' => 'actions-link',
                            'title' => Labels::getLabel('LBL_Edit', $siteLangId), "onclick" => "addSpecialPriceForm(" . $splPriceId . ")"
                        ),
                    '<i class="fa fa-edit"></i>',
                    true
                );
                $li = $ul->appendElement('li', array("class" => "actions-item"));
                $li->appendElement(
                    'button',
                        array(
                            'type'=>'button',
                            'class' => 'actions-link',
                            'title' => Labels::getLabel('LBL_Delete', $siteLangId), "onclick" => "deleteSellerProductSpecialPrice(" . $splPriceId . ")"
                        ),
                    '<i class="fa fa-trash"></i>',
                    true
                );
                break;
                
            default:
                $td->appendElement('plaintext', array(), $row[$column], true);
                break;
        }
    }
}


$frm = new Form('frmSplPriceListing', array('id' => 'frmSplPriceListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap');

echo $frm->getFormTag();
echo $tbl->getHtml(); 
if (count($arrListing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId));
}
?>
</form>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmSearchSpecialPricePaging'));

$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToSearchPage', 'adminLangId' => $siteLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
