<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('id', 'returnAddressLangFrm');
$frm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 4;
$frm->setFormTagAttribute('onsubmit', 'setReturnAddressLang(this); return(false);');

$address1 = $frm->getField('ura_address_line_1');
$address1->developerTags['col'] = 6;

$address2 = $frm->getField('ura_address_line_2');
$address2->developerTags['col'] = 6;

$submitFld = $frm->getField('btn_submit');
$submitFld->setFieldTagAttribute('class', "btn btn-brand btn-wide");

$langFld = $frm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "returnAddressLangForm(this.value);");

$variables = array('language' => $language, 'siteLangId' => $siteLangId, 'shop_id' => $shop_id, 'action' => $action);?>
<div class="tabs-content tabs-content-js">
    <div class="card card-tabs">
        <div class="card-head">
            <?php $this->includeTemplate('seller/_partial/shop-navigation.php', $variables, false); ?>
        </div>
        <div class="card-head card-head-sub">
            <ul class="nav nav-tabs nav-tabs-sm tabs-grcustom navTabsJs">
                <li class="nav-item"><button type="button" class="nav-link" onClick="returnAddressForm()"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></button></li>
                <li class="nav-item is-active">
                    <button class="nav-link">
                        <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                    </button>
                </li>
                <?php /* foreach ($language as $langId => $langName) {?>
                <li <?php echo ($formLangId == $langId)?'class="is-active"':'';?>><button onclick="returnAddressLangForm(<?php echo $langId;?>);"><?php echo $langName;?></button></li>
                <?php } */ ?>
            </ul>
            <div class="card-head-toolbar">
                <?php
                    $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                    $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                    if (!empty($translatorSubscriptionKey) && $formLangId != $siteDefaultLangId && $canEdit) { ?>
                        <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="returnAddressLangForm(<?php echo $formLangId; ?>, 1)">
                            <svg class="svg" width="24" height="24">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                            </svg>
                        </button>
                    <?php } ?>
            </div>
        </div>
        <div class="card-body">
            <?php echo $frm->getFormHtml(); ?>
        </div>
    </div>
</div>
<script language="javascript">
<?php if (!$canEdit) { ?>
$(document).ready(function() {
    $("form[name='frmReturnAddressLang'] input").prop("disabled", true);
    $("form[name='frmReturnAddressLang'] select").prop("disabled", true);
    $("form[name='frmReturnAddressLang'] select[name='lang_id']").prop("disabled", false);
    $("form[name='frmReturnAddressLang'] textarea").prop("disabled", true);
});
<?php } ?>
</script>