<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('id', 'returnAddressFrm');
$frm->setFormTagAttribute('class', 'form form--horizontal');
$frm->developerTags['colClassPrefix'] = 'col-lg-4 ';
$frm->developerTags['fld_default_col'] = 4;
$frm->setFormTagAttribute('onsubmit', 'setReturnAddress(this); return(false);');

$countryFld = $frm->getField('ura_country_id');
$countryFld->setFieldTagAttribute('id', 'ura_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value,' . $stateId . ',\'#ura_state_id\')');

$stateFld = $frm->getField('ura_state_id');
$stateFld->setFieldTagAttribute('id', 'ura_state_id');

$btnSubmit = $frm->getField('btn_submit');
$btnSubmit->setFieldTagAttribute('class', "btn btn-brand btn-wide");

$variables = array('language' => $language, 'siteLangId' => $siteLangId, 'shop_id' => $shop_id, 'action' => $action); ?>
<div class="tabs-content tabs-content-js">
    <div class="card card-tabs">
        <div class="card-head">
            <?php $this->includeTemplate('seller/_partial/shop-navigation.php', $variables, false); ?>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs">
                        <li class="nav-item is-active"><button type="button" class="nav-link" onClick="returnAddressForm()"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></button></li>
                        <li class="nav-item">
                            <button type="button" class="nav-link" onclick="returnAddressLangForm(<?php echo FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1); ?>);">
                                <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                            </button>
                        </li>
                    </ul>
                    <?php echo $frm->getFormHtml(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<script language="javascript">
    $(document).ready(function() {
        getCountryStates($("#ura_country_id").val(), <?php echo $stateId; ?>, '#ura_state_id');
        stylePhoneNumberFld("input[name='ura_phone']", false, 'ura_dial_code', 'ura_country_iso');
    });
</script>
<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
    <script>
        langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
    </script>
<?php } ?>
<script language="javascript">
    <?php if (!$canEdit) { ?>
        $(document).ready(function() {
            $("form[name='frmReturnAddress'] input").prop("disabled", true);
            $("form[name='frmReturnAddress'] select").prop("disabled", true);
            $("form[name='frmReturnAddress'] textarea").prop("disabled", true);
        });
    <?php } ?>
</script>