var advanceMedia = false; /* open via advance media*/
var autoOpenSideBar = true;
$(document).ready(function(){

    fixWidthHelper = function (e, ui) {
        ui.children().each(function () {
            $(this).width($(this).width());
        });
        return ui;
    }

    fixPlaceholderStyle = function (e, ui) {
        ui.placeholder.height(ui.item.height());
        ui.placeholder.css("visibility", "visible");
        ui.placeholder.css('background-color', '#f3f6f9');
    }

    /* Fix width of table headings. */
    fixTableColumnWidth = function () {
        if (0 < $('.listingTableJs').length) {
            $('.listingTableJs').each(function () {
                let autoColumnWidth = $(this).attr('data-autoColumnWidth');
                if ('undefined' == typeof autoColumnWidth || 0 < autoColumnWidth || '' == autoColumnWidth) {
                    fixWidth($(this));
                }
            });
        } else {
            let autoTableColumWidth = $('.listingTableJs').data('autoColumnWidth');
            if (1 > autoTableColumWidth) {
                return false;
            }
            fixWidth($('.listingTableJs'));
        }
    }

    fixWidth = function (formObj) {
        var thWidthArr = [];

        $('.tableHeadJs th', formObj).each(function () {
            var arr = {
                'width': $(this).outerWidth(true),
                'element': $(this)
            };
            thWidthArr.push(arr);
        });
        
        thWidthArr.sort((a, b) => (a.width > b.width) ? 1 : -1)

        $.each(thWidthArr, function (index, value) {
            var width = value.width;
            var element = value.element;
            $(element).attr('width', width);
        });
    }
    getLangId = function() {
        return $("#addProductfrm [name='lang_id']").val();
    };

    getProductId = function() {
        return $("#addProductfrm [name='preq_id']").val();
    };

    getTempProductId = function() {
        return $("#addProductfrm [name='temp_record_id']").val();
    };

    getSelectedCats = () => {
        return $('#addProductfrm input[name="ptc_prodcat_id"]').val();
    }

    /* Product Brand Request [ */
    addBrandReqForm = function (id) {
        fcom.ajax(fcom.makeUrl('sellerRequests', 'addBrandReqForm', [id]), '', function (t) {
            $('#exampleModal').html(t);
            $('#exampleModal').modal('show');
        });
    };

    setupBrandReq = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(
          fcom.makeUrl("sellerRequests", "setupBrandReq"),
          data,
          function (t) {
            $.mbsmessage.close();
    
            if (t.langId > 0) {
              addBrandReqLangForm(t.brandReqId, t.langId);
              return;
            }
            $("#exampleModal .btn-close").click();
          }
        );
    };
    
    addBrandReqLangForm = function (brandReqId, langId, autoFillLangData = 0) {
        fcom.ajax(
            fcom.makeUrl("sellerRequests", "brandReqLangForm", [brandReqId,langId,autoFillLangData,]), "", function (t) {
                $("#exampleModal").html(t);
                $("#exampleModal").modal("show");
            }
        );
    };
    
    setupBrandReqLang = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax( fcom.makeUrl("sellerRequests", "brandReqLangSetup"), data, function (t) {
            if (t.langId > 0) {
                addBrandReqLangForm(t.brandReqId, t.langId);
                return;
            }
            if (t.openMediaForm) {
                brandMediaForm(t.brandReqId);
                return;
            }
            $("#exampleModal .btn-close").click();
        });
    };

    checkUniqueBrandName = function (obj, $langId, $brandId) {
        data = "brandName=" + $(obj).val() + "&langId= " + $langId + "&brandId= " + $brandId;
        fcom.ajax(fcom.makeUrl("Brands", "checkUniqueBrandName"), data, function (t) {
            $.mbsmessage.close();
            $res = $.parseJSON(t);
            if ($res.status == 0) { 
                $(obj).val("");
                $alertType = "alert--danger";
                $.mbsmessage($res.msg, true, $alertType);
            }
        });
    };
    
    brandMediaForm = function (brandId) {
        fcom.ajax( fcom.makeUrl("sellerRequests", "brandMediaForm", [brandId]), "", function (t) {
            $("#exampleModal").html(t);
            $("#exampleModal").modal("show");
        });
    };
    
    removeBrandLogo = function (brandId, langId) {
        if (!confirm(langLbl.confirmDelete)) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl("sellerRequests", "removeBrandLogo", [brandId, langId]), "", function (t) {
            brandMediaForm(brandId);
            reloadList();
        });
    };
    /* ] */

    /* Product Category  request [ */
    addCategoryReqForm = function (id) {
        fcom.ajax(fcom.makeUrl('sellerRequests', 'categoryReqForm', [id]), '', function (t) {
           $('#exampleModal').html(t);
           $('#exampleModal').modal('show');
        });
    };
    setupCategoryReq = function (frm) {
        if (!$(frm).validate()) return;
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl("sellerRequests", "setupCategoryReq"), data, function (t) {
            $("#exampleModal .btn-close").click();
        });
    };
    /* ] */

    setup = function (frm) {
        if (!$(frm).validate()) {
            $('html,body').stop().animate({
                scrollTop: $('.error:first').offset().top,
            });
            return;
        }
        var data = fcom.frmData(frm);
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'setupCustomCatalogProduct'), data, function (res) {
            window.history.replaceState({},'', fcom.makeUrl('Seller', 'customCatalogProductForm', [res.preqId]));
            setTimeout(function () {
                langForm(res.langId, 0, res.preqId);
            }, 500);
        });
    };

    langForm = function(langId = 0, autoFillLangData = 0, recordId = 0) {
        recordId = recordId || getProductId();
        langId = langId || $("#addProductfrm [name='lang_id']").val();
        $('.mainJs').prepend(fcom.getLoader());
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'customCatalogProductForm', [recordId]), { langId, autoFillLangData }, function(res) {
            $('.mainJs').replaceWith(res.html);
        });
    };

    productDefaultImages = function() {
        let productId = getProductId();
        fileType = 0;
        
        if (1 > productId) {
            productId = getTempProductId();
            fileType = tempImageType;
        }
        
        fcom.ajax(fcom.makeUrl('Seller', 'scrfImages', [productId, fileType, 0, 0]), { isDefaultLayout: 1 }, function(t) {
            $('#productDefaultImagesJs li').not(":first").remove();
            $('#productDefaultImagesJs').append(t.html);
        }, { fOutMode: 'json' });
    };

    productImages = function(product_id, file_type, option_id = 0, lang_id = 0) {
        alert('productImages');
        option_id = option_id || 0;
        lang_id = lang_id || 0;
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'scrfImages', [product_id, file_type, option_id, lang_id]), '', function(t) {
            $('#productImagesJs').html(t.html);
        });
    };

    imageForm = function() {
        let productId = getProductId();
        let tempProductId = getTempProductId();
        if (1 > productId) {
            if (tempProductId == undefined) {
                console.warn('temp product id is manatory');
                return;
            }
        }
        
        fcom.updateWithAjax(fcom.makeUrl('Seller', "scrfImageForm", [productId, tempProductId]), '', function(t) {
            $.yrmodal(t.html, '', 'modal-lg');
            loadImageOptions();
            var fileType = $('#image_file_type').val();
            var productId = $('#image_preq_id').val();
            productImages(productId, fileType);
        });
    };

    loadImageOptions = function() {
        $('#addProductfrm .optionsJs').each(function() {
            let data = $(this).select2('data');
            if (data.length) {
                data = data[0];
                if (data.option_is_separate_images == 1) {
                    let optionValueData = $.parseJSON($(this).closest('.rowJs').find('input.optionValuesJs').val());
                    let optionIdEl = $('#image_option_id');
                    optionIdEl.html(`<option value="0">
                    ${forAllOptionsLbl}
                    </option>`);

                    $.each(optionValueData, function(index, opval) {
                        optionIdEl.append(`<option value="${opval.id}">
                            ${opval.value}
                            </option>`);

                    });
                    return false;
                }
            }

        })
    };

    validateFileUpload = function (file) {
        if (file.size >= langLbl.allowedFileSize) {
            let msg = langLbl.fileSizeExceeded;
            msg = msg.replace("{size-limit}", bytesToSize(langLbl.allowedFileSize));
            fcom.displayErrorMessage(msg);
            return false;
        }
        return true;
    }

    loadImageCropper = function(inputBtn) {
        loadCropper(inputBtn, true);
    }

    loadCropper = function (inputBtn, isAdvanceMedia = false) {
        advanceMedia = isAdvanceMedia || false;
        autoOpenSideBar = true;
        
        if (inputBtn.files && inputBtn.files[0]) {
            if (!validateFileUpload(inputBtn.files[0])) {
                return;
            }

            fcom.ajax(fcom.makeUrl('Seller', 'imgCropper'), '', function (t) {
                $('#exampleModal').html(t);
                $('#exampleModal').modal('show');
				$("#exampleModal .btn-close").click();
                /*$.yrmodal.close();*/
                var file = inputBtn.files[0];
                var frmName = $(inputBtn).closest('form').attr('name');
                var options = {};
                var minWidth = document[frmName].min_width.value;
                var minHeight = document[frmName].min_height.value;
                var options = {
                    aspectRatio: minWidth / minHeight,
                    data: {
                        width: minWidth,
                        height: minHeight,
                    },
                    minCropBoxWidth: minWidth,
                    minCropBoxHeight: minHeight,
                    toggleDragModeOnDblclick: false,
                    imageSmoothingQuality: 'high',
                    imageSmoothingEnabled: true,
                };
                $(inputBtn).val('');
                return cropImage(file, options, 'mediaUpload', inputBtn);
            });
        }
    };
    
    mediaUpload = function(formData) {
        var frmName = formData.get("frmName");
        var frm = document.forms[frmName];
        var other_data = $('form[name="' + frmName + '"]').serializeArray();
        
        $.each(other_data, function(key, input) {
            formData.append(input.name, input.value);
        });

        action = 'scrfSetupCustomProductImages';
        if (frmName == 'fileSpecFrm') {
            action = 'scrfSetupCustomProductSpecFiles';
        }
            

        $.ajax({
            url: fcom.makeUrl('Seller', action),
            type: "post",
            dataType: "json",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function(ans) {
                if (ans.status == 0) {
                    $.mbsmessage(ans.msg, true, 'alert--danger');
                    return;
                }
                $("#exampleModal .btn-close").click();
                
                $.mbsmessage(ans.msg, true, 'alert--success');
                if (advanceMedia == true) {
                    $.yrmodal.show();
                    productImages(ans.preqId, ans.file_type, ans.option_id, ans.lang_id);
                }

                $.mbsmessage(ans.msg, true, 'alert--success');
                if (ans.isDefaultLayout) {
                    productDefaultImages();
                }
            },
            error: function(xhr, ajaxOptions, thrownError) {
                if (advanceMedia == true) {
                    $.yrmodal.show();
                }
                $.mbsmessage(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText, true, 'alert--danger');
            },
        });
    };
    
    deleteImage = function (product_id, image_id, file_type, isSizeChart = 0) {
        var agree = confirm(langLbl.confirmDelete);
        if (!agree) {
            return false;
        }
        fcom.ajax(fcom.makeUrl('Seller', 'deleteCustomCatalogProductImage', [product_id, image_id, isSizeChart, file_type]), '', function (t) {
            if (t.isDefaultLayout) {
                productDefaultImages();
            }
            productImages(product_id, file_type, t.optionId, t.langId);
        }, { fOutMode: 'json' });
    };

    addSpecification = function() {
        let appendEle = $('#specificationsListJs');
        let identifier = $('#sp_identifier').val();
        let label = $('#sp_label').val();
        let value = $('#sp_value').val();
        let group = $('#sp_group').val();
        let prodSpecId = parseInt($('#sp_id').val());
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }
        if (!validateSpeficationForm()) {
            return;
        }

        $('#specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;

        let html = '<tr data-id="' + rowCount + '">';
        html += '<td class="nameJs text-break">' + label + '<input type="hidden" name="specifications[' + rowCount + '][name]" value="' + label + '"  data-fatreq="{&quot;required&quot;:false}"/> <input class="identifierJs" type="hidden" name="specifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td>';
        html += '<td class="valueJs text-break">' + value + '<input type="hidden" name="specifications[' + rowCount + '][value]" value="' + value + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="groupJs text-break">' + group + '<input type="hidden" name="specifications[' + rowCount + '][group]"  value="' + group + '" data-fatreq="{&quot;required&quot;:false}" /> </td>';
        html += '<td class="align-right"><ul class="actions">' +
            '<a href="javascript:void(0)"  onclick="editProdSpec(this)">' +
            '<i class="fa fa-edit"></i>' +
            '</a></li>' +
            '<li>' +
            '<a href="javascript:void(0)" onclick="deleteProdSpec(this)">' +
            '<i class="fa fa-trash"></i>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';
        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
            fixTableColumnWidth();
        }

        $('#sp_identifier').val('');
        $('#sp_label').val('');
        $('#sp_value').val('');
        $('#sp_group').val('');
        $('#sp_id').val(0);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));

    };

    validateSpeficationForm = function() {
        let validate = true;
        $('#specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };

    prodSpecifications = function() {
        var preqId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();
        fcom.ajax(fcom.makeUrl('Seller', 'catalogSpecificationsByLangId'), { preq_id: preqId, langId }, function(res) {
            
            $('#specificationsListJs').html(res.html);
            if ($('#specificationsListJs').find('table tbody tr').length == 0) {
                $('#specificationsListJs').find('table').addClass('hidden');
                $('#specificationsListSeprJs').addClass('hidden');
            }
        }, { fOutMode: 'json' });
    };

    editProdSpec = function(el) {
        let trEle = $(el).closest('tr');
        let prodSpecId = parseInt(trEle.data('id'));
        if (prodSpecId == NaN) {
            prodSpecId = 0;
        }
        console.log(trEle);
        let identifier = trEle.find('.identifierJs').val();
        let label = trEle.find('.nameJs').text();
        let value = trEle.find('.valueJs').text();
        let group = trEle.find('.groupJs').text();
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#sp_identifier').val(identifier);
        $('#sp_label').val(label);
        $('#sp_value').val(value);
        $('#sp_group').val(group);
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#specifications').offset().top,
        });
    };

    clearProdSpecForm = function () {
        $('#sp_label, #sp_identifier, #sp_value, #sp_group').val('');
        $('#btnAddSpecJs').text($('#btnAddSpecJs').data('addlbl'));
        $('#specificationsListJs tr.editRowJs').removeClass('editRowJs');
    };

    deleteProdSpec = function(el) {
        let key = $(el).closest('tr').data('id');
        let langId = getLangId();
        let preqId = getProductId();
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'deleteCustomCatalogSpecification', [preqId]), { key: key, langId: langId }, function(t) {
            prodSpecifications();
        });
    };

    /** Specification Media [*/
    uploadFileSpecFile = (inputBtn) => {

        if (inputBtn.files && inputBtn.files[0]) {
            var frmName = $(inputBtn).attr('data-frm')
            
            var formData = new FormData();
            formData.append("frmName", frmName);
            var file = inputBtn.files[0];
            var fileName = file["name"];
            var ext = fileName.split(".").pop().toLowerCase();
            var imageTypes = ["gif", "jpg", "jpeg", "png", "svg", "bmp", "tiff"];
            let langId = getLangId();
            $('#prodspec_is_file').val(1);
            if ($.inArray(ext, imageTypes) != -1) {
                fcom.ajax(fcom.makeUrl("Seller", "imgCropper"), "", function (t) {
                    $("#exampleModal").html(t);
                    $("#exampleModal").modal("show");
                    var minWidth = 800;
                    var minHeight = 800;
                    var options = {
                        aspectRatio: 1,
                        minCropBoxWidth: minWidth,
                        minCropBoxHeight: minHeight,
                        toggleDragModeOnDblclick: false,
                    };
                    $(inputBtn).val("");
                    return cropImage(
                        file,
                        options,
                        "uploadSpecificationFile",
                        inputBtn,
                        langId
                        );
                });
            } else {
                formData.append('file', file);
                $(inputBtn).val("");
                uploadSpecificationFile(formData);
            }
        }
    }

    uploadSpecificationFile = function (formData) {

        var frmName = formData.get("frmName");
        var frm = document.forms[frmName];
        var other_data = $('form[name="' + frmName + '"]').serializeArray();
        
        $.each(other_data, function(key, input) {
            formData.append(input.name, input.value);
        });
        
        let ofileIndex = $('#ofile_index').val();
        
        formData.append('ofile_index', ofileIndex);

        $.ajax({
            url: fcom.makeUrl('Seller', 'scrfSetupCustomProductSpecFiles'),
            type: "post",
            dataType: "json",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function() {
                $('#loader-js').html(fcom.getLoader());
            },
            success: function(ans) {
                if (ans.status == 0) {
                    $.mbsmessage(ans.msg, true, 'alert--danger');
                    return;
                }
                $("#exampleModal .btn-close").click();
                
                $.mbsmessage(ans.msg, true, 'alert--success');
                $('#hiddenSpecFileIdJs').attr('data-is_file', ans.prodspec_is_file);
                $('#filespectempJs').html(ans.file_htm_tag);
            },
            error: function(xhr, ajaxOptions, thrownError) {
                if (advanceMedia == true) {
                    $.yrmodal.show();
                }
                $.mbsmessage(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText, true, 'alert--danger');
            },
        });
    }

    generateRandomNumber = () => {
        return Math.floor(Math.random()*90000) + 10000;
    }
    
    addFileSpecification = function() {
        let appendEle = $('#file-specificationsListJs');
        let identifier = $('#fsp_identifier').val();
        let name = $('#fsp_name').val();
        let tempFile = 1; 

        let ofileIndex = $('#ofile_index').val();
        if (ofileIndex > 1) {
            tempFile = 0;
        }
        
        let fileSpecFileIndex = $('#prod_spec_file_index').val();
        if (isNaN(fileSpecFileIndex)) {
            alert('Invalid file attached with ' + name);
        }

        $('#hiddenSpecFileIndexJs').val(0);

        $('#prod_spec_file_index').val(generateRandomNumber());
        if (!validateFileSpeficationForm()) {
            return;
        }
        $('#file-specificationsListSeprJs').removeClass('hidden');

        let rowCount = appendEle.find('tbody tr.editRowJs').length ? appendEle.find("tbody tr").index($(".editRowJs")) : appendEle.find('tbody tr').length;
        
        let fileEl = $('#filespectempJs').html();
        let fileRef = '';
        fileRef = '<input id="file_index_' + rowCount + '" type="hidden" name="filespecifications[' + rowCount + '][file_index]" value="' + fileSpecFileIndex + '"  data-fatreq="{&quot;required&quot;:false}"/>' +
        '<input id="ofile_index_' + rowCount + '" type="hidden" name="filespecifications[' + rowCount + '][ofile_index]" value="' + ofileIndex + '"  data-fatreq="{&quot;required&quot;:false}"/>';
        
        $('#filespectempJs').text('');
        let html = '<tr data-index="' + rowCount + '" data-file_index="' + fileSpecFileIndex + '" data-ofile_index="' + ofileIndex + '">'
        html += '<td class="nameJs text-break">' + name + '<input type="hidden" name="filespecifications[' + rowCount + '][name]" value="' + name + '"  data-fatreq="{&quot;required&quot;:false}"/><input class="identifierJs" type="hidden" name="filespecifications[' + rowCount + '][identifier]" value="' + identifier + '"  data-fatreq="{&quot;required&quot;:false}"/></td><td class="fileJs text-break">' + fileEl + '</td>';
        html += '<td class="align-right"><ul class="actions">' +
            '<li>' +
            '<a href="javascript:void(0)"  onclick="editFileSpec(this)">' +
            '<i class="fa fa-edit"></i>' +
            '</a>' + fileRef +
            '</li><li>' +
            '<a href="javascript:void(0)" onclick="deleteFileSpec(this)">' +
            '<i class="fa fa-trash"></i>' +
            '</a></li>' +
            '</td>';
        html += '</ul></tr>';

        if (appendEle.find('.editRowJs').length) {
            appendEle.find('.editRowJs').replaceWith(html);
        } else {
            appendEle.find('tbody').append(html);
        }

        if (appendEle.find('table').hasClass('hidden')) {
            appendEle.find('table').removeClass('hidden');
            fixTableColumnWidth();
        }

        $('#fsp_name').val('');
        $('#fsp_identifier').val('');
        $('#ofile_index').val(0);
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
    };

    validateFileSpeficationForm = function() {
        let validate = true;
        $('#file-specificationsFormJs input').each(function() {
            if ($(this).data('change-event-bind') != 1) {
                $("input").change(function() {
                    $(this).siblings('ul').remove();
                });
                $(this).data('change-event-bind', 1);
            }
            $(this).siblings('ul').remove();
            if ($(this).data('required') == 1 && '' == $(this).val()) {
                let caption = $(this).siblings('label').text().trim();
                errorlist = $(document.createElement("ul")).addClass('errorlist').append(
                    $(document.createElement('li')).append($(document.createElement('a')).html(caption + " " + langLbl.isMandatory, ).attr({ 'href': 'javascript:void(0);' }))
                );
                $(this).after(errorlist);
                validate = false;
            }
        });
        return validate;
    };

    fileSpecifications = function() {
        var productId = getProductId();
        var langId = $("#addProductfrm [name='lang_id']").val();
        fcom.ajax(fcom.makeUrl('Seller', 'catalogSpecificationsMediaByLangId'), { preq_id: productId, langId }, function(res) {
            $('#file-specificationsListJs').html(res.html);
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
        }, { fOutMode: 'json' });
    };

    editFileSpec = function(el) {
        let trEle = $(el).closest('tr');
        let ofileIndex = parseInt(trEle.data('ofile_index'));
        if (isNaN(ofileIndex)) {
            ofileIndex = 0;
        }
        
        let fileIndex = parseInt(trEle.data('file_index'));
        
        console.log([fileIndex, ofileIndex]);
        let name = trEle.find('.nameJs').text();
        let identifier = trEle.find('.identifierJs').val();
        let fileHtml = trEle.find('.fileJs').html();
        
        trEle.siblings().removeClass('editRowJs');
        trEle.addClass('editRowJs');

        $('#fsp_name').val(name);
        $('#fsp_identifier').val(identifier);
        $('#filespectempJs').html(fileHtml);
        $('#prod_spec_file_index').val(fileIndex);
        $('#ofile_index').val(ofileIndex);
        $('#file_index').val(fileIndex);

        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('updatelbl'));
        $('html,body').stop().animate({
            scrollTop: $('#file-specifications').offset().top,
        });
    };

    clearFileSpecForm = function () {
        $('#fsp_name, #fsp_identifier').val('');
        $('#filespectempJs').html('');
        $('#btnAddFileSpecJs').text($('#btnAddFileSpecJs').data('addlbl'));
        $('#file-specificationsListJs tr.editRowJs').removeClass('editRowJs');
        $('#prod_spec_file_index').val(generateRandomNumber());
    };

    deleteFileSpec = function(el) {
        let oldFileIndex = $(el).closest('tr').data('ofile_index');
        if (1 > oldFileIndex) {
            $(el).closest('tr').remove();
            if ($('#file-specificationsListJs').find('table tbody tr').length == 0) {
                $('#file-specificationsListJs').find('table').addClass('hidden');
                $('#file-specificationsListSeprJs').addClass('hidden');
            }
            return;
        }
        let index = $(el).closest('tr').data('index');
        let langId = getLangId();
        let preqId = getProductId();
        let data = "langId=" + langId + "&key=" + index;
        
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'deleteCustomCatalogSpecification', [preqId]), data, function(t) {
            fileSpecifications();
        });
    };
    /** Specification Media ends here]*/
    brandAutocomplete = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='product_brand_id']").val(0);
        }
        $('input[name=\'brand_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('brands', 'autoComplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            'select': function (event, ui) {
                $('input[name=\'product_brand_id\']').val(ui.item.id);
            }
        });
    }
    
    categoryAutocomplete = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptc_prodcat_id']").val(0);
        }
        $('input[name=\'category_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function (request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'linksAutocomplete'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            'select': function (event, ui) {
                $('input[name=\'ptc_prodcat_id\']').val(ui.item.id);
                getCustomFields();
            }
        });
    }

    getCustomFields = () => {
        let catId = getSelectedCats();
        if (catId < 1) {
            return;
        }

        let productId = getProductId();
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'scrfProdCatCustomFieldsForm', []), { preq_id: productId, cat_id: catId, lang_id: getLangId() }, function(res) {
            if (res.status == 1 && res.have_custom_fields == 1) {
                $('#customfields').removeClass('disabled');
                $('#customfields-block').collapse('show');
                $('#CustomFieldsFormJs').html(res.html);
                return;
            }
            disableCustomField();
        });
    }

    disableCustomField = () => {
        $('#customfields').addClass('disabled');
        $('#customfields-block').collapse('hide');
        $('#CustomFieldsFormJs').html('');
    }
    
    rentTaxCatNameRent = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptt_taxcat_id_rent']").val(0);
        }
        $('input[name=\'taxcat_name_rent\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'autoCompleteTaxCategories'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $('input[name=\'ptt_taxcat_id_rent\']').val(ui.item.id);
            }
        });
    }

    taxCatNameRent = function (ths) {
        if ($(ths).val() == '') {
            $("input[name='ptt_taxcat_id']").val(0);
        }  
        $('input[name=\'taxcat_name\']').autocomplete({
            'classes': {
                "ui-autocomplete": "custom-ui-autocomplete"
            },
            'source': function(request, response) {
                $.ajax({
                    url: fcom.makeUrl('products', 'autoCompleteTaxCategories'),
                    data: {
                        keyword: request['term'],
                        fIsAjax: 1
                    },
                    dataType: 'json',
                    type: 'post',
                    success: function(json) {
                        response($.map(json, function(item) {
                            return {
                                label: item['name'],
                                value: item['name'],
                                id: item['id']
                            };
                        }));
                    },
                });
            },
            select: function(event, ui) {
                $('input[name=\'ptt_taxcat_id\']').val(ui.item.id);
            }
        });
    }

    getTagsAutoComplete = function(e){
        var keyword = e.detail.value;
        tagify.loading(true).dropdown.hide.call(tagify)
        var list = [];
        fcom.ajax(fcom.makeUrl('Seller', 'tagsAutoComplete'), {keyword:keyword}, function(t) {          
            var ans = $.parseJSON(t);
            for (i = 0; i < ans.length; i++) {            
                list.push({
                    "id" : ans[i].id,
                    "value" : ans[i].tag_identifier, 
                });
            } 
            tagify.settings.whitelist = list;
            tagify.loading(false).dropdown.show.call(tagify, keyword);
        });       
    }

    tagifyProducts = function() {
        var element = '#product_tags';
        if ('undefined' !== typeof $(element).attr('disabled')) {
            return;
        }
        $(element).siblings(".tagify").remove();
        tagify = new Tagify(document.querySelector(element), {
            whitelist: [],
            delimiters: "#",
            editTags: false,
        }).on('add', addTagData).on('remove', removeTagData).on('input', getTagsAutoComplete).on('focus', getTagsAutoComplete);;
    };

    addTagData = function (e) {
        let rt_id = e.detail.data.id;
        if (rt_id == '' || rt_id == undefined) {
            if (1 > canEditTags) {
                fcom.displayErrorMessage(tagsEditErr);
                e.detail.tag.remove();
                return;
            }
        }
    };

    removeTagData = function(e) {
        var tag_id = e.detail.tag.id;
        var product_id = getProductId();
        if (1 > product_id || '' == tag_id) {
            return;
        }
        fcom.updateWithAjax(fcom.makeUrl('Seller', 'removeProductTag'), 'product_id=' + product_id + '&tag_id=' + tag_id, function(t) {});
        tagifyProducts();
    };
});

$(document).on('change', '#image_option_id', function() {
    let optionId = $(this).val();
    let fileType = $('#image_file_type').val();
    let recordId = $('#image_preq_id').val();
    let langId = $('#image_lang_id').val();
    productImages(recordId, fileType, optionId, langId);
});

$(document).on('change', '#image_lang_id', function() {
    let langId = $(this).val();
    let fileType = $('#image_file_type').val();
    let recordId = $('#image_preq_id').val();
    let optionId = $('#image_option_id').val();
    productImages(recordId, fileType, optionId, langId);
});