<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');

$countActions = 0;

if (!$isShopActive) {
    $countActions++;
}

if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) {
    if (User::canAddCustomProduct() && $userPrivilege->canEditProducts(UserAuthentication::getLoggedUserId(), true)) {
        $countActions++;
    }
    $countActions++;
    $countActions++;
}
?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo Labels::getLabel('LBL_Dashboard', $siteLangId); ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <?php if ($countActions <= 2) { ?>
                    <div class="links-inline">
                        <?php if (!$isShopActive) { ?>
                            <a class="btn btn btn-outline-gray btn-icon"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'shop'); ?>">
                                <?php echo Labels::getLabel('LBL_Create_Shop', $siteLangId); ?>
                            </a>
                        <?php } ?>
                        <?php if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                            <?php if (User::canAddCustomProduct() && $userPrivilege->canEditProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                                <a class="btn btn btn-outline-gray btn-icon  btn-add"
                                    href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>">
                                    <svg class="svg" width="18" height="18">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                        </use>
                                    </svg>
                                    <?php echo Labels::getLabel('LBL_Add_new_catalog', $siteLangId); ?>
                                </a>
                            <?php } ?>
                            <a class="btn btn btn-outline-gray btn-icon"
                                href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>">
                                <svg class="svg" width="18" height="18">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#products">
                                    </use>
                                </svg>
                                <?php echo Labels::getLabel('LBL_My_products', $siteLangId); ?>
                            </a>
                            <a class="btn btn btn-outline-gray btn-icon"
                                href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>">
                                <svg class="svg" width="18" height="18">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#inventory">
                                    </use>
                                </svg>
                                <?php echo Labels::getLabel('LBL_Shop_Inventory', $siteLangId); ?>
                            </a>

                        <?php } ?>
                    </div>
                <?php } else { ?>
                    <div class="dropdown">
                        <button class="btn btn-outline-gray  dropdown-toggle" type="button" id="dashboardDropdown"
                            data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true"
                            aria-expanded="false">
                            <?php echo Labels::getLabel('LBL_More_Actions', $siteLangId); ?>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-anim">
                            <?php if (!$isShopActive) { ?>
                                <li class="dropdown-menu-item">
                                    <a class="dropdown-menu-link"
                                        href="<?php echo UrlHelper::generateUrl('Seller', 'shop'); ?>">
                                        <?php echo Labels::getLabel('LBL_Create_Shop', $siteLangId); ?>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($userPrivilege->canViewProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                                <?php if (User::canAddCustomProduct() && $userPrivilege->canEditProducts(UserAuthentication::getLoggedUserId(), true)) { ?>
                                    <li class="dropdown-menu-item">
                                        <a class="dropdown-menu-link"
                                            href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>">
                                            <?php echo Labels::getLabel('LBL_Add_new_catalog', $siteLangId); ?>
                                        </a></a>
                                    </li>
                                <?php } ?>
                            <?php } ?>
                            <li class="dropdown-menu-item">
                                <a class="dropdown-menu-link"
                                    href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>">
                                    <?php echo Labels::getLabel('LBL_My_products', $siteLangId); ?>
                                </a>
                            </li>
                            <li class="dropdown-menu-item">
                                <a class="dropdown-menu-link"
                                    href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>">
                                    <?php echo Labels::getLabel('LBL_Shop_Inventory', $siteLangId); ?>
                                </a>
                            </li>
                        </ul>
                    </div>
                <?php } ?>
            </div>
        </div>

        <div class="content-body">
            <?php
            if (
                $userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true) ||
                $userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true) ||
                $userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)
            ) {
                ?>
                <div class="js-widget-scroll widget-scroll">
                    <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) {
                        if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <div class="widget widget-stats">
                                <?php /* <a href="<?php echo UrlHelper::generateUrl('Seller', 'sales'); ?>"> */ ?>
                                <div class="card">
                                    <div class="card-head">
                                        <a class="card-title" href="javascript:void(0)"
                                            onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)">
                                            <?php echo Labels::getLabel('LBL_My_Sales', $siteLangId); ?>
                                        </a>
                                        <i class="icn">
                                            <svg class="svg" width="16" height="16">
                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#my-sales">
                                                </use>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="card-body">
                                        <div class="stats">
                                            <ul class="stats-number">
                                                <li class="stats-number-item">
                                                    <button class="stats-number-btn" type="button"
                                                        onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)"
                                                        class="stats-list">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Completed_Sales', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php
                                                            $totalSoldSales = isset($ordersStats['totalSoldSales']) ? $ordersStats['totalSoldSales'] : 0;
                                                            echo CommonHelper::displayMoneyFormat($totalSoldSales);
                                                            ?>
                                                        </span>
                                                    </button>
                                                </li>
                                                <li class="stats-number-item">
                                                    <button class="stats-number-btn" type="button"
                                                        onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo Stats::INPROCESS_SALES; ?>)"
                                                        class="stats-list">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Inprocess_Sales', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php
                                                            $totalInprocessSales = isset($ordersStats['totalInprocessSales']) ? $ordersStats['totalInprocessSales'] : 0;
                                                            echo CommonHelper::displayMoneyFormat($totalInprocessSales);
                                                            ?>
                                                        </span>
                                                    </button>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                                <?php /* </a> */ ?>
                            </div>
                        <?php } ?>
                        <div class="widget widget-stats">
                            <?php /* <a href="<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>"> */ ?>
                            <div class="card">
                                <div class="card-head">
                                    <a class="card-title" href="javascript:void(0)"
                                        onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)">
                                        <?php echo Labels::getLabel('LBL_My_Rental_Sales', $siteLangId); ?>
                                    </a>
                                    <i class="icn"><svg class="svg" width="16" height="16">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#my-sales">
                                            </use>
                                        </svg>
                                    </i>
                                </div>
                                <div class="card-body">
                                    <div class="stats">
                                        <ul class="stats-number">
                                            <li class="stats-number-item">
                                                <button class="stats-number-btn" type="button"
                                                    onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)"
                                                    class="stats-list">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Completed_Sales', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php
                                                        $totalSoldRentalSales = isset($ordersStats['totalSoldRentalSales']) ? $ordersStats['totalSoldRentalSales'] : 0;
                                                        echo CommonHelper::displayMoneyFormat($totalSoldRentalSales);
                                                        ?>
                                                    </span>
                                                </button>
                                            </li>
                                            <li class="stats-number-item">
                                                <button class="stats-number-btn" type="button"
                                                    onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>', <?php echo Stats::INPROCESS_SALES; ?>)"
                                                    class="stats-list">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Inprocess_Sales', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php $totalInprocessRentalSales = isset($ordersStats['totalInprocessRentalSales']) ? $ordersStats['totalInprocessRentalSales'] : 0;
                                                        echo CommonHelper::displayMoneyFormat($totalInprocessRentalSales);
                                                        ?>
                                                    </span>
                                                </button>
                                            </li>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php /* </a> */ ?>
                        </div>


                    <?php } ?>
                    <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                        <div class="widget widget-stats">
                            <div class="card">
                                <div class="card-head">
                                    <a class="card-title" href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>">
                                        <?php echo Labels::getLabel('LBL_Credits', $siteLangId); ?>
                                    </a>

                                    <i class="icn"><svg class="svg" width="16" height="16">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#credits">
                                            </use>
                                        </svg>
                                    </i>
                                </div>
                                <div class="card-body">
                                    <div class="stats">
                                        <ul class="stats-number">
                                            <li class="stats-number-item">
                                                <span class="total">
                                                    <?php echo Labels::getLabel('LBL_Total', $siteLangId); ?>
                                                </span>
                                                <span class="total-numbers">
                                                    <?php echo CommonHelper::displayMoneyFormat($userBalance); ?>
                                                </span>
                                            </li>
                                            <li class="stats-number-item">
                                                <span class="total">
                                                    <?php echo Labels::getLabel('LBL_Credits_earned_today', $siteLangId); ?>
                                                </span>
                                                <span class="total-numbers">
                                                    <?php echo CommonHelper::displayMoneyFormat($txnsSummary['total_earned']); ?>
                                                </span>
                                            </li>
                                        </ul>

                                    </div>
                                </div>

                            </div>
                        </div>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <div class="widget widget-stats">
                            <?php /* <a href="<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>"> */ ?>
                            <div class="card">
                                <div class="card-head">
                                    <a class="card-title"
                                        href="<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>">
                                        <?php echo Labels::getLabel('LBL_Rental_Order', $siteLangId); ?>
                                    </a>
                                    <i class="icn"><svg class="svg" width="16" height="16">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#order">
                                            </use>
                                        </svg>
                                    </i>
                                </div>
                                <div class="card-body">
                                    <div class="stats">
                                        <ul class="stats-number">
                                            <li class="stats-number-item">
                                                <button class="stats-number-btn" type="button"
                                                    onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)"
                                                    class="stats-list">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Completed_Orders', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php
                                                        $totalSoldCount = isset($ordersStats['totalSoldRentalCount']) ? $ordersStats['totalSoldRentalCount'] : 0;
                                                        echo FatUtility::int($totalSoldCount);
                                                        ?>
                                                    </span>
                                                </button>
                                            </li>
                                            <li class="stats-number-item">
                                                <button class="stats-number-btn" type="button"
                                                    onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('SellerOrders', 'rentals'); ?>', <?php echo Stats::INPROCESS_SALES; ?>)"
                                                    class="stats-list">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Pending_Orders', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php
                                                        $pendingOrders = $rentalOrdersCount - $totalSoldCount;
                                                        echo $pendingOrders;
                                                        ?>
                                                    </span>
                                                </button>
                                            </li>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <?php /* </a> */ ?>
                        </div>

                        <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <div class="widget widget-stats">
                                <?php /* <a href="<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>" > */ ?>
                                <div class="card">
                                    <div class="card-head">
                                        <a class="card-title" href="<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>">
                                            <?php echo Labels::getLabel('LBL_Order', $siteLangId); ?>
                                        </a>
                                        <i class="icn"><svg class="svg" width="16" height="16">
                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#order">
                                                </use>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="card-body">
                                        <div class="stats">
                                            <ul class="stats-number">
                                                <li class="stats-number-item">
                                                    <button class="stats-number-btn" type="button"
                                                        onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo Stats::COMPLETED_SALES; ?>)"
                                                        class="stats-list">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Completed_Orders', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php
                                                            $totalSoldCount = isset($ordersStats['totalSoldCount']) ? $ordersStats['totalSoldCount'] : 0;
                                                            echo FatUtility::int($totalSoldCount);
                                                            ?>
                                                        </span>
                                                    </button>
                                                </li>
                                                <li class="stats-number-item">
                                                    <button class="stats-number-btn" type="button"
                                                        onClick="redirectOrderfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo Stats::INPROCESS_SALES; ?>)"
                                                        class="stats-list">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Pending_Orders', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php
                                                            $pendingOrders = $ordersCount - $totalSoldCount;
                                                            echo $pendingOrders;
                                                            ?>
                                                        </span>
                                                    </button>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                                <?php /* </a> */ ?>
                            </div>
                        <?php }
                    } ?>
                    <?php if ($userPrivilege->canViewSubscription(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <?php if (FatApp::getConfig('CONF_ENABLE_SELLER_SUBSCRIPTION_MODULE')) { ?>
                            <div class="widget widget-stats">
                                <div class="card">
                                    <div class="card-head">
                                        <a class="card-title"
                                            href="<?php echo UrlHelper::generateUrl('Seller', 'subscriptions'); ?>">
                                            <?php echo Labels::getLabel('LBL_Active_Subscription', $siteLangId); ?>
                                        </a>
                                        <i class="icn"><svg class="svg" width="16" height="16">
                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#messages">
                                                </use>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="card-body">
                                        <div class="stats">
                                            <ul class="stats-number">
                                                <?php if ($pendingDaysForCurrentPlan >= 0) { ?>
                                                    <li class="stats-number-item">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Remaining', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php echo $pendingDaysForCurrentPlan; ?>
                                                            <?php echo Labels::getLabel('LBL_Days', $siteLangId); ?>
                                                        </span>
                                                    </li>
                                                    <li class="stats-number-item">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Allowed_Products', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php echo ($remainingAllowedProducts > 0) ? $remainingAllowedProducts : 0; ?>
                                                        </span>
                                                    </li>
                                                <?php } else { ?>
                                                    <li class="stats-number-item">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Subscription_Name', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php echo $subscriptionName; ?>
                                                        </span>
                                                    </li>
                                                    <li class="stats-number-item">
                                                        <span class="total">
                                                            <?php echo Labels::getLabel('LBL_Expires_On', $siteLangId); ?>
                                                        </span>
                                                        <span class="total-numbers">
                                                            <?php echo (isset($subscriptionTillDate)) ? $subscriptionTillDate : ''; ?>
                                                        </span>
                                                    </li>
                                                <?php } ?>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)) {
                        if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <div class="widget widget-stats">
                                <div class="card">
                                    <div class="card-head">
                                        <a class="card-title"
                                            href="<?php echo UrlHelper::generateUrl('Seller', 'orderReturnRequests'); ?>">
                                            <?php echo Labels::getLabel('LBL_Sale_Refund', $siteLangId); ?>
                                        </a>
                                        <i class="icn"><svg class="svg" width="16" height="16">
                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#refund">
                                                </use>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="card-body">
                                        <div class="stats">

                                            <ul class="stats-number">
                                                <li class="stats-number-item">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Refunded_Orders', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php echo isset($ordersStats['refundedOrderCount']) ? FatUtility::int($ordersStats['refundedOrderCount']) : 0; ?>
                                                    </span>
                                                </li>
                                                <li class="stats-number-item">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Refunded_Amount', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php
                                                        $refundedOrderAmount = isset($ordersStats['refundedOrderAmount']) ? $ordersStats['refundedOrderAmount'] : 0;
                                                        echo CommonHelper::displayMoneyFormat($refundedOrderAmount);
                                                        ?>
                                                    </span>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        <?php }
                    } ?>
                    <?php if ($userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true)) {
                        if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                            <div class="widget widget-stats">
                                <div class="card">
                                    <div class="card-head">
                                        <a class="card-title" href="javascript:void(0)"
                                            onClick="redirectfunc('<?php echo UrlHelper::generateUrl('Seller', 'Sales'); ?>', <?php echo FatApp::getConfig("CONF_DEFAULT_CANCEL_ORDER_STATUS", null, ''); ?>)">
                                            <?php echo Labels::getLabel('LBL_Sale_Cancellation', $siteLangId); ?>
                                        </a>
                                        <i class="icn"><svg class="svg" width="16" height="16">
                                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#cancel">
                                                </use>
                                            </svg>
                                        </i>
                                    </div>
                                    <div class="card-body">
                                        <div class="stats">
                                            <ul class="stats-number">
                                                <li class="stats-number-item">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Cancelled_Orders', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php echo isset($ordersStats['cancelledOrderCount']) ? FatUtility::int($ordersStats['cancelledOrderCount']) : 0; ?>
                                                    </span>
                                                </li>
                                                <li class="stats-number-item">
                                                    <span class="total">
                                                        <?php echo Labels::getLabel('LBL_Cancelled_Orders_Amount', $siteLangId); ?>
                                                    </span>
                                                    <span class="total-numbers">
                                                        <?php
                                                        $cancelledOrderAmount = isset($ordersStats['cancelledOrderAmount']) ? $ordersStats['cancelledOrderAmount'] : 0;
                                                        echo CommonHelper::displayMoneyFormat($cancelledOrderAmount);
                                                        ?>
                                                    </span>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>

                                </div>
                            </div>
                        <?php }
                    } ?>
                </div>
            <?php } ?>
            <?php if ($userPrivilege->canViewSales(UserAuthentication::getLoggedUserId(), true)) {
                if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                    <div class="row">
                        <div class="col-xl-6 mb-4">
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Sales_Graph', $siteLangId); ?>
                                    </h5>
                                </div>
                                <div class="card-body  graph">
                                    <?php $this->includeTemplate('_partial/seller/sellerSalesGraph.php', array('saleGraphData' => $saleGraphData)); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 mb-4">
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Latest_Orders', $siteLangId); ?>
                                    </h5>
                                    <?php if (count($orders) > 0) { ?>
                                        <div class="action">
                                            <a href="<?php echo UrlHelper::generateUrl('seller', 'sales'); ?>"
                                                class="link-underline">
                                                <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="card-table">
                                    <div class="scroll scroll-x js-scrollable table-wrap">
                                        <table class="table table-justified">
                                            <thead>
                                                <tr class="">
                                                    <th width="60%">
                                                        <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                    </th>
                                                    <th width="20%">
                                                        <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                                    </th>
                                                    <th width="20%"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (count($orders) > 0) {
                                                    foreach ($orders as $orderId => $row) {
                                                        $orderDetailUrl = UrlHelper::generateUrl('seller', 'viewOrder', array($row['op_id']));
                                                        $prodOrBatchUrl = '';
                                                        if ($row['op_is_batch']) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'BatchProduct', array($row['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                        } else {
                                                            if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                            }
                                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($row['selprod_product_id'], "SMALL", $row['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                        }
                                                        /* $prodName = '';
                                                      if($row['op_selprod_title']!=''){
                                                      $prodName.= $row['op_selprod_title'].'<br/>';
                                                      }
                                                      $prodName.= $row['op_product_name']; */
                                                        ?>
                                                        <tr>

                                                            <td>
                                                                <div class="product-profile">

                                                                    <a class="product-profile-thumbnail"
                                                                         <?php echo HtmlHelper::profileImgAttr(); ?> href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>"><img
                                                                            src="<?php echo $prodOrBatchImgUrl; ?>"
                                                                            title="<?php echo $row['op_product_name']; ?>"
                                                                            alt="<?php echo $row['op_product_name']; ?>"></a>

                                                                    <div class="product-profile-data">
                                                                        <date class="date">
                                                                            <?php echo FatDate::format($row['order_date_added']); ?>
                                                                        </date>
                                                                        <?php if ($row['op_selprod_title'] != '') { ?>
                                                                            <div class="product-profile-title">
                                                                                <a title="<?php echo $row['op_selprod_title']; ?>"
                                                                                    href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                    <?php echo $row['op_selprod_title']; ?>
                                                                                </a>
                                                                            </div>
                                                                        <?php } else { ?>
                                                                            <div class="product-profile-title-sub">
                                                                                <?php echo $row['op_product_name']; ?>
                                                                                <a title="<?php echo $row['op_product_name']; ?>"
                                                                                    href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                    <?php echo $row['op_product_name']; ?>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                        <div class="product-profile-brand">
                                                                            <?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>:
                                                                            <?php echo CommonHelper::displayNotApplicable($siteLangId, $row['op_brand_name']); ?>
                                                                        </div>
                                                                        <?php if ($row['op_selprod_options'] != '') { ?>
                                                                            <div class="item__specification">
                                                                                <?php echo $row['op_selprod_options']; ?>
                                                                            </div>
                                                                        <?php } ?>
                                                                        <div class="item__specification">
                                                                            <span
                                                                                class="badge badge-inline <?php echo $classArr[$row['orderstatus_color_class']]; ?>">
                                                                                <?php
                                                                                echo $row['orderstatus_name'];
                                                                                /* $paymentMethodCode = Plugin::getAttributesById($row['order_pmethod_id'], 'plugin_code');
                                                                              if (strtolower($paymentMethodCode) == 'cashondelivery' && $row['opshipping_fulfillment_type'] == Shipping::FULFILMENT_PICKUP) {
                                                                              echo Labels::getLabel('LBL_PAY_ON_PICKUP', $siteLangId);
                                                                              } else {
                                                                              echo $row['orderstatus_name'];
                                                                              } */
                                                                                ?>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="item__price">
                                                                    <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($row, 'netamount', false, User::USER_TYPE_SELLER)); ?>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <ul class="actions">
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            title="<?php echo Labels::getLabel('LBL_View_Order', $siteLangId); ?>"
                                                                            href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>"><i
                                                                                class="fa fa-eye"></i></a>
                                                                    </li>
                                                                    <?php if (!in_array($row["op_status_id"], $notAllowedStatues)) { ?>
                                                                        <li class="actions-item">
                                                                            <a class="actions-link"
                                                                                href="<?php echo UrlHelper::generateUrl('seller', 'cancelOrder', array($row['op_id'])); ?>"
                                                                                title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>"><i
                                                                                    class="fas fa-times"></i></a>
                                                                        </li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <tr>
                                                        <td colspan="3">
                                                            <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <!--  [ RENTAL DATA -->
                <?php if (ALLOW_RENT) { ?>
                    <div class="row">
                        <div class="col-xl-6 mb-4">
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Rental_Graph', $siteLangId); ?>
                                    </h5>
                                </div>
                                <div class="card-body graph">
                                    <?php $this->includeTemplate('_partial/seller/sellerRentalGraph.php', array('dashboardInfo' => $dashboardInfo)); ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-6 mb-4">
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Recent_Rental_Orders', $siteLangId); ?>
                                    </h5>
                                    <?php if (count($rentalOrders) > 0) { ?>
                                        <div class="action">
                                            <a href="<?php echo UrlHelper::generateUrl('sellerOrders', 'rentals'); ?>"
                                                class="link-underline">
                                                <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="card-table">
                                    <div class="scroll scroll-x js-scrollable table-wrap">
                                        <table class="table table-justified">
                                            <thead>
                                                <tr class="">
                                                    <th width="60%">
                                                        <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                    </th>
                                                    <th width="20%">
                                                        <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                                    </th>
                                                    <th width="20%"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (count($rentalOrders) > 0) {
                                                    foreach ($rentalOrders as $orderId => $row) {
                                                        $orderDetailUrl = UrlHelper::generateUrl('seller', 'viewOrder', array($row['op_id']));
                                                        $prodOrBatchUrl = '';
                                                        if ($row['op_is_batch']) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'BatchProduct', array($row['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                        } else {
                                                            if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                            }
                                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($row['selprod_product_id'], "SMALL", $row['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                            if ($row['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($row['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                            }
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td>
                                                                <div class="product-profile">
                                                                    <a class="product-profile-thumbnail"
                                                                         <?php echo HtmlHelper::profileImgAttr(); ?> href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>"><img
                                                                            src="<?php echo $prodOrBatchImgUrl; ?>"
                                                                            title="<?php echo $row['op_product_name']; ?>"
                                                                            alt="<?php echo $row['op_product_name']; ?>"></a>

                                                                    <div class="product-profile-data">
                                                                        <date class="date">
                                                                            <?php echo FatDate::format($row['order_date_added']); ?>
                                                                        </date>
                                                                        <?php if ($row['op_selprod_title'] != '') { ?>
                                                                            <div class="product-profile-title">
                                                                                <a title="<?php echo $row['op_selprod_title']; ?>"
                                                                                    href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                    <?php echo $row['op_selprod_title']; ?>
                                                                                </a>
                                                                            </div>
                                                                        <?php } else { ?>
                                                                            <div class="product-profile-title-sub">
                                                                                <?php echo $row['op_product_name']; ?>
                                                                                <a title="<?php echo $row['op_product_name']; ?>"
                                                                                    href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                    <?php echo $row['op_product_name']; ?>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                        <div class="product-profile-brand">
                                                                            <?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>:
                                                                            <?php echo CommonHelper::displayNotApplicable($siteLangId, $row['op_brand_name']); ?>
                                                                        </div>
                                                                        <?php if ($row['op_selprod_options'] != '') { ?>
                                                                            <div class="item__specification">
                                                                                <?php echo $row['op_selprod_options']; ?>
                                                                            </div>
                                                                        <?php } ?>
                                                                        <div class="item__specification">
                                                                            <span
                                                                                class="badge badge-inline <?php echo $classArr[$row['orderstatus_color_class']]; ?>">
                                                                                <?php echo $row['orderstatus_name']; ?>
                                                                            </span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="item__price">
                                                                    <?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($row, 'netamount', false, User::USER_TYPE_SELLER) + $row['addon_amount']); ?>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <ul class="actions">
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            title="<?php echo Labels::getLabel('LBL_View_Order', $siteLangId); ?>"
                                                                            href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>"><i
                                                                                class="fa fa-eye"></i></a>
                                                                    </li>
                                                                    <?php if (!in_array($row["op_status_id"], $notAllowedStatues) && $row['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                                                                        <li class="actions-item">
                                                                            <a class="actions-link"
                                                                                href="<?php echo UrlHelper::generateUrl('seller', 'cancelOrder', array($row['op_id'])); ?>"
                                                                                title="<?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>"><i
                                                                                    class="fas fa-times"></i></a>
                                                                        </li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <tr>
                                                        <td colspan="3">
                                                            <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <!-- ] -->


            <?php } ?>
            <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                <div class="row">
                    <div class="col-lg-12 col-md-12 mb-4">
                        <div class="card">
                            <div class="card-head">
                                <h5 class="card-title ">
                                    <?php echo Labels::getLabel('LBL_Transaction_History', $siteLangId); ?>
                                </h5>
                                <?php if (count($transactions) > 0) { ?>
                                    <div class="action">
                                        <a href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>"
                                            class="link-underline">
                                            <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="card-table ">
                                <div class="scroll scroll-x js-scrollable table-wrap">
                                    <table class="table table-justified">
                                        <thead>
                                            <tr class="">
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Txn._Id', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Credit', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Debit', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Balance', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Comments', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (count($transactions) > 0) {
                                                foreach ($transactions as $row) {
                                                    ?>
                                                    <tr>
                                                        <td>
                                                            <div class="txn__id">
                                                                <?php echo Transactions::formatTransactionNumber($row['utxn_id']); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__date">
                                                                <?php echo FatDate::format($row['utxn_date']); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__credit">
                                                                <?php echo CommonHelper::displayMoneyFormat($row['utxn_credit']); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__debit">
                                                                <?php echo CommonHelper::displayMoneyFormat($row['utxn_debit']); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__balance">
                                                                <?php echo CommonHelper::displayMoneyFormat($row['balance']); ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__comments">
                                                                <?php echo $row['utxn_comments']; ?>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="txn__status"><span
                                                                    class="badge badge-inline <?php echo $txnStatusClassArr[$row['utxn_status']] ?>">
                                                                    <?php echo $txnStatusArr[$row['utxn_status']]; ?>
                                                                </span>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <?php
                                                }
                                            } else {
                                                ?>
                                                <tr>
                                                    <td colspan="7">
                                                        <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php }

            if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                <div class="row">
                    <?php if ($userPrivilege->canViewReturnRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <div class="col-xl-6 col-md-12 mb-4">
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Return_requests', $siteLangId); ?>
                                    </h5>
                                    <?php if (count($returnRequests) > 0) { ?>
                                        <div class="action">
                                            <a href="<?php echo UrlHelper::generateUrl('seller', 'orderReturnRequests'); ?>"
                                                class="link-underline">
                                                <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="card-table ">
                                    <div class="scroll scroll-x js-scrollable table-wrap">
                                        <table class="table table-justified">
                                            <thead>
                                                <tr class="">
                                                    <th width="60%">
                                                        <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                    </th>
                                                    <th width="10%">
                                                        <?php echo Labels::getLabel('LBL_Qty', $siteLangId); ?>
                                                    </th>
                                                    <th width="20%">
                                                        <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                    </th>
                                                    <th width="10%"></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (count($returnRequests) > 0) {
                                                    foreach ($returnRequests as $row) {
                                                        $orderDetailUrl = UrlHelper::generateUrl('seller', 'viewOrder', array($row['op_id']));
                                                        $prodOrBatchUrl = '';
                                                        if ($row['op_is_batch']) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                        } else {
                                                            if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                            }
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td>
                                                                <div class="product-profile-data">
                                                                    <div class="request__date">
                                                                        <?php echo FatDate::format($row['orrequest_date']); ?>
                                                                    </div>
                                                                    <div class="product-profile-title">
                                                                        <a title="<?php echo Labels::getLabel('LBL_Invoice_number', $siteLangId); ?>"
                                                                            href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_invoice_number']; ?>
                                                                        </a>
                                                                    </div>
                                                                    <div class="product-profile-title">
                                                                        <?php if ($row['op_selprod_title'] != '') { ?>
                                                                            <a title="<?php echo $row['op_selprod_title']; ?>"
                                                                                href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                <?php echo $row['op_selprod_title']; ?>
                                                                            </a>
                                                                        <?php } else { ?>
                                                                            <a title="<?php echo $row['op_product_name']; ?>"
                                                                                href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                <?php echo $row['op_product_name']; ?>
                                                                            </a>
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="request__qty">
                                                                    <?php echo $row['orrequest_qty']; ?>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="request__status"> <span
                                                                        class="badge badge-inline <?php echo $OrderRetReqStatusClassArr[$row['orrequest_status']]; ?>">
                                                                        <?php echo $OrderReturnRequestStatusArr[$row['orrequest_status']]; ?>
                                                                    </span></div>
                                                            </td>
                                                            <td>
                                                                <?php $url = UrlHelper::generateUrl('Seller', 'ViewOrderReturnRequest', array($row['orrequest_id'])); ?>
                                                                <ul class="actions">
                                                                    <li class="actions-item">
                                                                        <a class="actions-link"
                                                                            title="<?php echo Labels::getLabel('LBL_View_Request', $siteLangId); ?>"
                                                                            href="<?php echo !empty($url) ? $url : 'javascript:void(0)'; ?>">
                                                                            <i class="fa fa-eye"></i>
                                                                        </a>
                                                                    </li>
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <tr>
                                                        <td colspan="4">
                                                            <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?php if ($userPrivilege->canViewCancellationRequests(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <div class="col-xl-6 col-md-12 mb-4">
                            <!-- <div class="card">
                        <?php // $this->includeTemplate('_partial/userDashboardMessages.php');
                                ?>
                </div> -->
                            <div class="card">
                                <div class="card-head">
                                    <h5 class="card-title ">
                                        <?php echo Labels::getLabel('LBL_Cancellation_requests', $siteLangId); ?>
                                    </h5>
                                    <?php if (count($cancellationRequests) > 0) { ?>
                                        <div class="action">
                                            <a href="<?php echo UrlHelper::generateUrl('seller', 'orderCancellationRequests'); ?>"
                                                class="link-underline">
                                                <?php echo Labels::getLabel('Lbl_View_All', $siteLangId); ?>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="card-table ">
                                    <div class="scroll scroll-x js-scrollable table-wrap">
                                        <table class="table table-justified">
                                            <thead>
                                                <tr class="">
                                                    <th width="40%">
                                                        <?php echo Labels::getLabel('LBL_Order_Particulars', $siteLangId); ?>
                                                    </th>
                                                    <th width="50%">
                                                        <?php echo Labels::getLabel('LBL_Request_detail', $siteLangId); ?>
                                                    </th>
                                                    <th width="10%">
                                                        <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                if (count($cancellationRequests) > 0) {
                                                    foreach ($cancellationRequests as $row) {
                                                        $orderDetailUrl = UrlHelper::generateUrl('seller', 'viewOrder', array($row['op_id']));
                                                        $prodOrBatchUrl = '';
                                                        if ($row['op_is_batch']) {
                                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($row['op_selprod_id']));
                                                        } else {
                                                            if (Product::verifyProductIsValid($row['op_selprod_id']) == true) {
                                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($row['op_selprod_id']));
                                                            }
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td>
                                                                <div class="product-profile-data">
                                                                    <div class="request__date">
                                                                        <?php echo FatDate::format($row['ocrequest_date']); ?>
                                                                    </div>
                                                                    <div class="product-profile-title">
                                                                        <a title="<?php echo Labels::getLabel('Lbl_Invoice_number', $siteLangId) ?>"
                                                                            href="<?php echo !empty($orderDetailUrl) ? $orderDetailUrl : 'javascript:void(0)'; ?>">
                                                                            <?php echo $row['op_invoice_number']; ?>
                                                                        </a>
                                                                    </div>
                                                                    <div class="product-profile-title">
                                                                        <?php if ($row['op_selprod_title'] != '') { ?>
                                                                            <a title="<?php echo $row['op_selprod_title']; ?>"
                                                                                href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                <?php echo $row['op_selprod_title']; ?>
                                                                            </a>
                                                                        <?php } else { ?>
                                                                            <a title="<?php echo $row['op_product_name']; ?>"
                                                                                href="<?php echo !empty($prodOrBatchUrl) ? $prodOrBatchUrl : 'javascript:void(0)'; ?>">
                                                                                <?php echo $row['op_product_name']; ?>
                                                                            </a>
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div class="request__reason">
                                                                    <?php echo Labels::getLabel('Lbl_Reason', $siteLangId) ?>:
                                                                    <?php echo $row['ocreason_title']; ?>
                                                                </div>
                                                                <div class="request__comments">
                                                                    <?php echo Labels::getLabel('Lbl_Comments', $siteLangId) ?>:
                                                                    <?php echo $row['ocrequest_message']; ?>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <span
                                                                    class="badge badge-inline <?php echo $cancelReqStatusClassArr[$row['ocrequest_status']]; ?>">
                                                                    <?php echo $OrderCancelRequestStatusArr[$row['ocrequest_status']]; ?>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                    }
                                                } else {
                                                    ?>
                                                    <tr>
                                                        <td colspan="3">
                                                            <?php $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId), false); ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
    </div>
</main>
<style>
    .stats-list {
        display: contents;
    }
</style>
<script>
    
    /******** for tooltip ****************/
    $('.info--tooltip-js').hover(function () {
        $(this).toggleClass("is-active");
        return false;
    }, function () {
        $(this).toggleClass("is-active");
        return false;
    });

      
</script>

<style>
    .widget-scroll{
        display: flex;
        flex-wrap: wrap;
    }
    .widget-scroll .widget-stats{
        flex:1 1 calc(32% - 10px);
    }
</style>