<?php defined('SYSTEM_INIT') or die('Invalid Usage.');  ?>

<?php require_once(CONF_DEFAULT_THEME_PATH . 'seller/sellerCustomProductTop.php'); ?>

<div class="card card-tabs">
    <div class="card-head">
        <ul class="nav nav-tabs tabs-grcustom navTabsJs">
            <li class="nav-item">
                <button type="button" class="nav-link " onclick="customProductForm(<?php echo $product_id ?>);"><?php echo Labels::getLabel('LBL_Basic', $siteLangId); ?></button>
            </li>
            <li class="nav-item is-active">
                <button class="nav-link ">
                    <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                </button>
            </li>
        </ul>
    </div>
    <div class="card-body">
        <div class="tabs-content form">
            <div class="row">
                <div class="col-md-12">
                    <?php
                        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                        $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                        if (!empty($translatorSubscriptionKey) && $product_lang_id != $siteDefaultLangId) { ?>
                    <div class="row justify-content-end">
                        <div class="col-auto mb-4">
                            <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="customProductLangForm(<?php echo $product_id; ?>, <?php echo $product_lang_id; ?>, 1)">
                                <svg class="svg" width="24" height="24">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                                </svg>
                            </button>
                        </div>
                    </div>
                    <?php } ?>
                    <?php
                        $customProductLangFrm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
                        $customProductLangFrm->developerTags['colClassPrefix'] = 'col-lg-6 ';
                        $customProductLangFrm->developerTags['fld_default_col'] = 6;
                        //$customProductLangFrm->setFormTagAttribute('onsubmit', 'setupCustomProductLang(this); return(false);');
                        $fld = $customProductLangFrm->getField('product_description');
                        $fld->setWrapperAttribute('class', 'col-lg-12');
                        $fld->developerTags['col'] = 12;
                        $langFld = $customProductLangFrm->getField('lang_id');
                        $langFld->setfieldTagAttribute('onChange', "customProductLangForm(" . $product_id . ", this.value);");
                        echo $customProductLangFrm->getFormHtml();
                        ?>

                </div>
            </div>
        </div>
    </div>
</div>
<script>
var frm = $('form[name=frmCustomProductLang]');
var validator = $(frm).validation({
    errordisplay: 3
});
$(frm).submit(function(e) {
    e.preventDefault();
    if (validator.validate() == false) {
        return;
    }
    if (!$(frm).validate()) return;
    var data = fcom.frmData(frm);
    fcom.updateWithAjax(fcom.makeUrl('Seller', 'setupCustomProductLang'), data, function(t) {
        runningAjaxReq = false;
        $.mbsmessage.close();
        fcom.resetEditorInstance();

        if (t.lang_id > 0) {
            customProductLangForm(t.product_id, t.lang_id);
            return;
        }
        fcom.scrollToTop($("#listing"));

        return;
    });
});
</script>