<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$imagesFrm->setFormTagAttribute('id', 'frmCustomProductImage');
$imagesFrm->setFormTagAttribute('class', 'form');
$imagesFrm->developerTags['colClassPrefix'] = 'col-md-';
$imagesFrm->developerTags['fld_default_col'] = 6;

$optionFld = $imagesFrm->getField('option_id');
$optionFld->addFieldTagAttribute('class', 'option-js');

$langFld = $imagesFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$img_fld = $imagesFrm->getField('prod_image');
$img_fld->addFieldTagAttribute('onChange', 'popupImage(this)');
$img_fld->addFieldTagAttribute('accept', 'image/*');

$img_fld = $imagesFrm->getField('prod_size_chart');
if (!empty($img_fld)) {
    $img_fld->addFieldTagAttribute('onChange', 'popupSizeChartImage(this)');
}
?>
<div class="modal-dialog modal-lg modal-dialog-centered" role="document" id="custom-product-image-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo Labels::getLabel('LBL_Upload_image', $siteLangId); ?></h5>

            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

            </button>
        </div>
        <div class="modal-body">
            <div id="cropperBox-js"></div>
            <div class="tabs-data" id="mediaForm-js">
                <div class="row">
                    <div class="col-md-12">
                        <?php 
                        /* [ MEDIA INSTRUCTIONS START HERE */
                        $tpl = new FatTemplate('', '');
                        $tpl->set('siteLangId', $siteLangId);
                        echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                        /* ] */    
                        ?>
                    </div>

                    <?php echo $imagesFrm->getFormHtml(); ?>
                    <div id="imageupload_div"></div>
                </div>

                <!-- [ PRODUCT SPECIFICATION SECTION -->
                <?php if ($hideButtons == 0) { ?>
                <input type="hidden" name="langId" value="<?php echo $siteDefaultLangId; ?>" />
                <div class="specifications-form-<?php echo $siteDefaultLangId; ?>"></div>
                <div class="specifications-list-<?php echo $siteDefaultLangId; ?>"></div>
                <?php } ?>
                <!-- ] -->

                <?php if ($hideButtons == 0) { ?>
                <div class="row">
                    <div class="col">
                        <input onclick="
                            <?php if ($productType == Product::PRODUCT_TYPE_PHYSICAL) { ?>
                                        productShipping(<?php echo $product_id; ?>);
                            <?php } else { ?>
                                        productOptionsAndTag(<?php echo $product_id; ?>);
                                   <?php } ?>" class="btn btn-outline-brand" type="button" name="btn_back" value="<?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>">
                        <?php /* <input onclick="goToCatalog();" type="button" class="btn btn-brand" name="btn_Finish" value="<?php echo Labels::getLabel('LBL_Finish', $siteLangId); ?>"> */ ?>
                    </div>
                    <div class="col-auto"><input onclick="goToCatalog();" type="button" class="btn btn-brand" name="btn_Finish" data-text="<?php echo Labels::getLabel('LBL_Save_And_Next', $siteLangId); ?>" value="<?php echo Labels::getLabel('LBL_Finish', $siteLangId); ?>"></div>


                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>