<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/dashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('SellerRequests'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php echo Labels::getLabel('LBL_Custom_Product_Request', $siteLangId); ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <div class="col-auto js-approval-btn"></div>
                </div>
            </div>
        </div>
        <div class="content-form"></div>
        <div class="content-body">
            <div class="card card-tabs">
                <div class="card-head">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs tabs_nav-js">
                        <li class="nav-item">
                            <a class="nav-link tabs_001" rel="tabs_001" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Initial_Setup', $siteLangId); ?> <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Setup_Basic_Details', $siteLangId); ?>">
                                </i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link tabs_002" rel="tabs_002" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Attribute_&_Specifications', $siteLangId); ?>
                                <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Add_Attribute_&_Specifications', $siteLangId); ?>"></i></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link tabs_003" rel="tabs_003" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Options_And_Tags', $siteLangId); ?>
                                <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Add_Options_And_Tags', $siteLangId); ?>"></i>

                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link tabs_004" rel="tabs_004" href="javascript:void(0)"><?php echo Labels::getLabel('LBL_Shipping_Information', $siteLangId); ?>
                                <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Setup_Dimentions_And_Shipping_Information', $siteLangId); ?>"></i>
                            </a>
                        </li>
                        <?php if (FatApp::getConfig('CONF_USE_CUSTOM_FIELDS', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
                        <li class="nav-item">
                            <a class="nav-link tabs_006 <?php echo (!$isCustomFields) ? "disabled" : ""; ?>" rel="tabs_006" <?php echo (!$isCustomFields) ? "disabled" : ""; ?> href="javascript:void(0)"> <?php echo Labels::getLabel('LBL_Custom_Fields', $siteLangId); ?>
                                <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Add_Category_Based_Custom_Fields', $siteLangId); ?>"></i>
                            </a>
                        </li>
                        <?php } ?>
                        <li class="nav-item">
                            <a class="nav-link tabs_005" rel="tabs_005" href="javascript:void(0)"> <?php echo Labels::getLabel('LBL_Media', $siteLangId); ?>
                                <i class="tabs-icon fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Add_Option_Based_Media', $siteLangId); ?>"></i>

                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tabs-content">
                        <div id="tabs_001" class="tabs-panel" style="display: block;"></div>
                        <div id="tabs_002" class="tabs-panel" style="display: none;"> </div>
                        <div id="tabs_003" class="tabs-panel" style="display: none;"></div>
                        <div id="tabs_004" class="tabs-panel" style="display: none;"></div>
                        <div id="tabs_005" class="tabs-panel" style="display: none;"></div>
                        <div id="tabs_006" class="tabs-panel" style="display: none;"></div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>
<script>
var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;

$(document).ready(function() {
    customCatalogProductForm(<?php echo $preqId; ?>);
});
</script>

<script>
$(document).ready(function() {
    $('a').on('click', function(e) {
        if ($(this).hasClass('disabled')) {
            e.preventDefault();
            e.stopPropagation();
        }
    })
})
</script>

<style>
.disabled {
    color: #dcdcdc !important;
}
</style>