<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading">
                    <?php if (User::canAddCustomProduct() && ($action == 'catalog')) { ?>
                        <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_To_Inventory', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('sellerInventories', 'products'); ?>">
                            <svg class="svg" width="24" height="24">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                                </use>
                            </svg>
                        </a>
                    <?php } ?>
                    <?php
                    if ($type == 1) {
                        echo Labels::getLabel('LBL_Seller_Products', $siteLangId);
                        $contentPage = Extrapage::SELLER_PRODUCT_INSTRUCTIONS;
                    } else {
                        echo Labels::getLabel('LBL_Marketplace_Products', $siteLangId);
                        $contentPage = Extrapage::MARKETPLACE_PRODUCT_INSTRUCTIONS;
                    }
                    ?>
                    <a href="javascript:void(0)" onClick="productInstructions(<?php echo $contentPage; ?>)" ><i class="fa fa-question-circle" ></i></a>
                </h2>
            </div>
            <?php $this->includeTemplate('_partial/productPagesTabs.php', array('siteLangId' => $siteLangId, 'controllerName' => $controllerName, 'action' => $action, 'canEdit' => $canEdit, 'type' => $type), false); ?>
        </div>
        <div class="content-form">
            <?php
            $frmSearchCatalogProduct->setFormTagAttribute('id', 'frmSearchCatalogProduct');
            $frmSearchCatalogProduct->setFormTagAttribute('class', 'form form-search');
            $frmSearchCatalogProduct->setFormTagAttribute('onsubmit', 'searchCatalogProducts(this); return(false);');
            $frmSearchCatalogProduct->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_by_keyword/EAN/ISBN/UPC_code', $siteLangId));
            $frmSearchCatalogProduct->developerTags['colClassPrefix'] = 'col-md-';

            $keywordFld = $frmSearchCatalogProduct->getField('keyword');
            $keywordFld->setFieldTagAttribute('id', 'tour-step-3');
            $keywordFld->developerTags['col'] = 8;

            $submitFld = $frmSearchCatalogProduct->getField('btn_submit');
            $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
            $submitFld->setWrapperAttribute('class', 'col-lg-2');
            $submitFld->developerTags['col'] = 2;


            $fldClear = $frmSearchCatalogProduct->getField('btn_clear');
            $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
            $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
            $fldClear->setWrapperAttribute('class', 'col-lg-2');
            $fldClear->developerTags['col'] = 2;
            echo $frmSearchCatalogProduct->getFormHtml();
            ?>

        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-table">
                    <div id="listing"> </div>
                </div>
            </div>
        </div>
    </div>
</main>
<script>
    $(document).ready(function() {
        searchCatalogProducts(document.frmSearchCatalogProduct);
    });

    $(".btn-inline-js").click(function() {
        $(".box-slide-js").slideToggle();
    });
</script>