<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$layout = Language::getLayoutDirection($langId);
$isAutoComplete = (!empty(FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, ''))) ? 1 : 0;
if (count($productSpecifications) > 0) { ?>
    <div class="row" dir="<?php echo $layout; ?>">
        <div class="col-md-12">
            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                <?php
                $arr_flds = array(
                    'prod_spec_name' => Labels::getLabel('LBL_Specification_Name', $siteLangId),
                    'prod_spec_value' => Labels::getLabel('LBL_Specification_Value', $siteLangId),
                    'prod_spec_group' => Labels::getLabel('LBL_Specification_Group', $siteLangId),
                    'action' => ''
                );

                $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-justified'));
                $th = $tbl->appendElement('thead')->appendElement('tr');
                foreach ($arr_flds as $key => $val) {
                    if ($key == 'prodspec_name' || $key == 'prod_spec_value' || $key == 'prod_spec_group') {
                        $e = $th->appendElement('th', array('width' => '27%'), $val);
                    } else {
                        $e = $th->appendElement('th', array(), $val);
                    }
                }

                foreach ($productSpecifications as $keyData => $specification) {
                    $tr = $tbl->appendElement('tr');
                    foreach ($arr_flds as $key => $val) {
                        if($key == 'action'){
                            $td = $tr->appendElement('td',['nowrap'=>"nowrap"]);
                        }else{
                            $td = $tr->appendElement('td');
                        }
                        
                        switch ($key) { 
                            case 'action':
                                $ul = $td->appendElement('ul', array('class' => 'actions'));
								$li = $ul->appendElement("li", array("class" => "actions-item"));

                                $li->appendElement('button', array('type'=>'button','class' => 'actions-link', 'title' => Labels::getLabel('LBL_Edit', $siteLangId), 'onClick' => 'prodSpecificationSection(' . $langId . ',' . $keyData . ')'), '<i class="fa fa-edit"></i>', true);
                                if ($siteDefaultLang == $langId || $isAutoComplete == 0) {
                                    $li->appendElement('button', array('type'=>'button','class' => 'actions-link', 'title' => Labels::getLabel('LBL_Delete', $siteLangId), 'onClick' => 'deleteProdSpec(' . $keyData . ',' . $langId . ')'), '<i class="fa fa-trash"></i>', true);
                                }
                                break;
                            default:
                                $td->appendElement('plaintext', array(), $specification[$key], true);
                                break;
                        }
                    }
                }
                echo $tbl->getHtml();
                ?>
            </div>
        </div>
    </div>
    <br>
    <?php
} else {
    if ($siteDefaultLang != $langId) {
        $message = Labels::getLabel('LBL_No_Specifications_addded_yet', $siteLangId);
        $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
    }
}
?>