<div class="modal-dialog modal-dialog-centered modal-lg" role="document" id="catalog-info-modal">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo Labels::getLabel('LBL_Catalog_info', $siteLangId); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
            </button>
        </div>
        <div class="modal-body">
            <div class="white--bg padding20">
                <div class="row">
                    <div class="col-lg-6  col-sm-12 col-xm-12 clearfix">
                        <?php if ($productImagesArr) { ?>
                            <div class="js-product-gallery product-gallery" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
                                <?php
                                foreach ($productImagesArr as $afile_id => $image) {
                                    $mainImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'product', array($product['product_id'], 'MEDIUM', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                    $thumbImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'product', array($product['product_id'], 'THUMB', 0, $image['afile_id'])), CONF_IMG_CACHE_TIME, '.jpg');
                                ?>
                                    <?php if (isset($imageGallery) && $imageGallery) { ?>
                                        <a href="<?php echo $mainImgUrl; ?>" class="gallery" rel="gallery">
                                        <?php } ?>
                                        <img src="<?php echo $mainImgUrl; ?>">
                                        <?php if (isset($imageGallery) && $imageGallery) { ?>
                                        </a>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        <?php
                        } else {
                            $mainImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'product', array(0, 'MEDIUM', 0)), CONF_IMG_CACHE_TIME, '.jpg');
                        ?>
                            <div class="item__main"><img src="<?php echo $mainImgUrl; ?>"></div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-6  col-sm-12 col-xm-12">
                        <div class="product-description">
                            <div class="product-description-inner">
                                <div class="products__title products__title_catalog"><?php echo $product['product_name']; ?></div>
                                <div class="gap"></div>
                                <div class="cms">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Category', $siteLangId); ?>:</th>
                                                <td><?php echo $product['prodcat_name']; ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Brand', $siteLangId); ?>:</th>
                                                <td><?php echo ($product['brand_name']) ? $product['brand_name'] : Labels::getLabel('LBL_N/A', $siteLangId); ?></td>
                                            </tr>
                                            <tr>
                                                <th><?php echo Labels::getLabel('LBL_Product_Model', $siteLangId); ?>:</th>
                                                <td><?php echo ($product['product_model']) ? $product['product_model'] : Labels::getLabel('LBL_N/A', $siteLangId); ?></td>
                                            </tr>
                                            <?php
                                                if ($product['product_min_selling_price'] > 0) {
                                            ?>
                                                    <tr>
                                                        <th><?php echo Labels::getLabel('LBL_Minimum_Selling_Price', $siteLangId); ?>:</th>
                                                        <td><?php echo CommonHelper::displayMoneyFormat($product['product_min_selling_price']); ?></td>
                                                    </tr>
                                                <?php
                                                }
                                                $taxArr = Tax::getSaleTaxCatArr($siteLangId);
                                                if (array_key_exists($product['ptt_taxcat_id_rent'], $taxArr)) {
                                                ?>
                                                    <tr>
                                                        <th><?php echo Labels::getLabel('LBL_Tax_Category', $siteLangId); ?>:</th>
                                                        <td><?php echo $taxArr[$product['ptt_taxcat_id_rent']]; ?></td>
                                                    </tr>
                                            <?php
                                                }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php if (count($productSpecifications) > 0) { ?>
                                    <div class="gap"></div>
                                    <div class="box box--gray box--radius box--space">
                                        <div class="h6"><?php echo Labels::getLabel('LBL_Specifications', $siteLangId); ?>:</div>
                                        <div class="list list--specification">
                                            <ul>
                                                <?php
                                                $count = 1;
                                                foreach ($productSpecifications as $key => $specification) {
                                                    if ($count > 5) {
                                                        continue;
                                                    }
                                                ?>
                                                    <li>
                                                        <?php
                                                        echo '<span>' . $specification['prodspec_name'] . ' </span> ';
                                                        echo !empty($specification['prodspec_value']) ? ":" . $specification['prodspec_value'] : '';

                                                        if ($specification['prodspec_is_file'] == 1) {
                                                            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $product['product_id'], $specification['prodspec_id'], $siteLangId);
                                                            if (!empty($fileData)) {
                                                                $fileArr = explode('.', $fileData['afile_name']);
                                                                $fileTypeIndex = count($fileArr) - 1;
                                                                $fileType = strtolower($fileArr[$fileTypeIndex]);
                                                                $imageTypes = array('gif', 'jpg', 'jpeg', 'png', 'svg', 'bmp', 'tiff','webp','avif');
                                                                $attachmentUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id']), CONF_WEBROOT_FRONT_URL);
                                                                if (in_array($fileType, $imageTypes)) {
                                                                    $imageUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id'], 50, 50), CONF_WEBROOT_FRONT_URL);

                                                                    $fileHtml = "<a target='_blank' href='" . $attachmentUrl . "' class='spcification-image--js'><img src='" . $imageUrl . "' class='img-thumbnail' style='max-width:150px;' /></a>";
                                                                } else {
                                                                    $fileHtml = "<a href='" . $attachmentUrl . "' title='" . $fileData['afile_name'] . "' download><i class='fa fa-download' aria-hidden='true'></i></a>";
                                                                }
                                                                echo '<br/>' . $fileHtml;
                                                            }
                                                        }

                                                        ?>
                                                    </li>
                                                <?php
                                                    $count++;
                                                }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var layoutDirection = '<?php echo CommonHelper::getLayoutDirection(); ?>';
    if (layoutDirection == 'rtl') {
        $('.js-product-gallery').slick({
            dots: true,
            arrows: false,
            autoplay: false,
            pauseOnHover: false,
            slidesToShow: 1,
            draggable: true,
            rtl: true,
        });
    } else {
        $('.js-product-gallery').slick({
            dots: true,
            arrows: false,
            autoplay: false,
            pauseOnHover: false,
            slidesToShow: 1,
            draggable: true,
        });
    }
</script>