<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php');
?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Requests', $siteLangId); ?>
                </h2>
            </div>
            <?php if ($canEdit && !$noRecordFound) { ?>
            <div class="content-header-toolbar">
                <div class="dropdown">
                    <button class="btn btn-outline-gray  dropdown-toggle" type="button" id="dashboardDropdown"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-haspopup="true"
                        aria-expanded="false">
                        <?php echo Labels::getLabel('LBL_New_Request', $siteLangId); ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-anim">
                        <?php if (FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0)) { ?>
                        <li class="dropdown-menu-item">
                            <a class="dropdown-menu-link"
                                href="<?php echo UrlHelper::generateUrl('Seller', 'customCatalogProductForm'); ?>"><?php echo Labels::getLabel('LBL_Marketplace_Product', $siteLangId); ?></a>
                        </li>
                        <?php } ?>
                        <?php if (FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) { ?>
                        <li class="dropdown-menu-item">
                            <button class="dropdown-menu-link"
                                onClick="addBrandReqForm(0)"><?php echo Labels::getLabel('LBL_Brand', $siteLangId); ?></button>
                        </li>
                        <?php } ?>
                        <?php if (FatApp::getConfig('CONF_PRODUCT_CATEGORY_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) { ?>
                        <li class="dropdown-menu-item">
                            <button class="dropdown-menu-link"
                                onClick="addCategoryReqForm(0)"><?php echo Labels::getLabel('LBL_Category', $siteLangId); ?></button>
                        </li>
                        <?php } ?>
                    </ul>
                </div>

            </div>
            <?php } ?>
        </div>
        <div class="content-body">
            <?php if ($noRecordFound) { ?>
            <div class="card">
                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <div class="info">
                                <svg class="svg" height="20" width="20">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#info">
                                    </use>
                                </svg>

                                <?php echo Labels::getLabel('LBL_Generate_requests_using_buttons_below', $siteLangId); ?>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-center">
                        <?php if (FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0)) { ?>
                        <div class="col-md-4">
                            <div class="no-data-found">
                                <div class="img">
                                    <img src="<?php echo CONF_WEBROOT_URL; ?>images/retina/no-product-requests.svg"
                                        width="70px" height="70px">
                                </div>
                                <div class="data">
                                    <div class="action">
                                        <a class="btn btn-outline-gray qwer  btn-add"
                                            href="<?php echo UrlHelper::generateUrl('Seller', 'customCatalogProductForm'); ?>">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#add">
                                                </use>
                                            </svg>
                                            <?php echo Labels::getLabel('LBL_New_Product_Request', $siteLangId); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        <?php if (FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) { ?>
                        <div class="col-md-4">
                            <div class="no-data-found">
                                <div class="img">
                                    <img src="<?php echo CONF_WEBROOT_URL; ?>images/retina/no-brand-requests.svg"
                                        width="70px" height="70px">
                                </div>
                                <div class="data">
                                    <div class="action">
                                        <button type="button" class="btn btn-outline-gray qwer  btn-add"
                                            onClick="addBrandReqForm(0)">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                                </use>
                                            </svg>
                                            <?php echo Labels::getLabel('LBL_New_Brand_Request', $siteLangId); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                        <?php if (FatApp::getConfig('CONF_PRODUCT_CATEGORY_REQUEST_APPROVAL', FatUtility::VAR_INT, 0)) { ?>
                        <div class="col-md-4">
                            <div class="no-data-found">
                                <div class="img">
                                    <img src="<?php echo CONF_WEBROOT_URL; ?>images/retina/no-category-requests.svg"
                                        width="70px" height="70px">
                                </div>
                                <div class="data">
                                    <div class="action">
                                        <button type="button" class="btn btn-outline-gray qwer  btn-add"
                                            onClick="addCategoryReqForm(0)">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#add">
                                                </use>
                                            </svg>
                                            <?php echo Labels::getLabel('LBL_New_Category_Request', $siteLangId); ?>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } else { ?>
            <div id="listing" class="card card-tabs">
                <?php echo Labels::getLabel('LBL_Processing...', $siteLangId); ?>
            </div>
            <?php } ?>

        </div>
    </div>
</main>
<?php if (FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0) == 0 && FatApp::getConfig('CONF_BRAND_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) == 0 && FatApp::getConfig('CONF_PRODUCT_CATEGORY_REQUEST_APPROVAL', FatUtility::VAR_INT, 0) == 0) { ?>
<script>
$(document).ready(function() {
    <?php if ($reqProducts > 0) { ?>
    searchCustomCatalogProducts(document.frmSearchCustomCatalogProducts);
    <?php } elseif ($reqBrands) { ?>
    searchBrandRequests(document.frmSearchBrandRequest);
    <?php } else { ?>
    searchProdCategoryRequests();
    <?php } ?>
});
</script>
<?php } else { ?>
<script>
var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
var canRequestCustomProduct =
    <?php echo FatApp::getConfig('CONF_SELLER_CAN_REQUEST_CUSTOM_PRODUCT', FatUtility::VAR_INT, 0); ?>;
$(document).ready(function() {
    if (canRequestCustomProduct) {
        searchCustomCatalogProducts(document.frmSearchCustomCatalogProducts);
    } else {
        searchBrandRequests(document.frmSearchBrandRequest);
    }
});
</script>
<?php } ?>