<?php
$arr = [];
if ($orderDetail['order_is_rfq']) {
    $arr = array(
        'controller' => 'requestforquotes',
        'action' => 'vieworder'
    );
}
$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php', $arr);
$shippingCharges = CommonHelper::orderProductAmount($orderDetail, 'shipping');
$orderStatusLbl = Labels::getLabel('LBL_AWAITING_SHIPMENT', $siteLangId);
$orderStatus = '';
if (!empty($orderDetail["thirdPartyorderInfo"]) && isset($orderDetail["thirdPartyorderInfo"]['orderStatus'])) {
    $orderStatus = $orderDetail["thirdPartyorderInfo"]['orderStatus'];
    $orderStatusLbl = strpos($orderStatus, "_") ? str_replace('_', ' ', $orderStatus) : $orderStatus;
}
$orderDetailLbl = '<a class="btn btn-back" title="' . Labels::getLabel('LBL_Back', $siteLangId) . '"
        href="' . UrlHelper::generateUrl('sellerOrders', 'rentals') . '">
        <svg class="svg" width="24" height="24">
            <use xlink:href="' . CONF_WEBROOT_URL . 'images/dashboard/retina/sprite.svg#back">
            </use>
        </svg>
    </a> ';
$orderDetailLbl .= Labels::getLabel('LBL_Rental_Order', $siteLangId);
if ($orderDetail['order_is_rfq']) {

    $orderDetailLbl = '<a class="btn btn-back" title="' . Labels::getLabel('LBL_Back', $siteLangId) . '"
        href="' . UrlHelper::generateUrl('requestForQuotes', 'rfqOrder') . '">
        <svg class="svg" width="24" height="24">
            <use xlink:href="' . CONF_WEBROOT_URL . 'images/dashboard/retina/sprite.svg#back">
            </use>
        </svg>
    </a> ';

    $orderDetailLbl .= Labels::getLabel('LBL_RFQ_Order', $siteLangId);
}

$securityHtml = $taxOptionsHtml = $pickupAddressHtml = $durationDiscountHtml = $volumnDiscountHtml = $shippingHtml = $couponDiscountHtml = $addonAmountHtml = '';
$processingStatuses = array_diff($processingStatuses, [OrderStatus::ORDER_DELIVERED]);
$processingStatuses = array_merge($processingStatuses, [OrderStatus::ORDER_PAYMENT_CONFIRM, OrderStatus::ORDER_CASH_ON_DELIVERY, OrderStatus::ORDER_PAY_AT_STORE]);
?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading no-print">
                    <?php echo $orderDetailLbl; ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline no-print">
                    <?php 
                    if($orderDetail['op_pending_amount'] > 0 && $orderDetail['op_payment_status'] == Orders::ORDER_PAYMENT_PARTIAL){
                    ?>
                    <button type="button" onclick="sendPaymentRequest(<?php echo $orderDetail['op_id']; ?>)"
                        class="btn btn-outline-gray qwer no-print"
                        title="<?php echo Labels::getLabel('LBL_Send_Payment_Request', $siteLangId); ?>">
                        <?php echo Labels::getLabel('LBL_Send_Payment_Request', $siteLangId); ?>
                    </button>
                    <?php } ?>
                    <?php if (in_array($orderDetail['orderstatus_id'], $processingStatuses) && $canEdit && $orderDetail['order_is_rfq'] == applicationConstants::NO) { ?>
                        <a class="btn btn-outline-gray qwer no-print"
                            href="<?php echo UrlHelper::generateUrl('seller', 'cancelOrder', array($orderDetail['op_id'])); ?>">
                            <?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>
                        </a>
                    <?php } ?>

                    

                    <?php
                    if ($shippedBySeller && true === $canShipByPlugin && ('CashOnDelivery' == $orderDetail['plugin_code'] || Orders::ORDER_PAYMENT_PAID == $orderDetail['order_payment_status']) && $orderDetail['opshipping_type'] == Shipping::SHIPPING_SERVICES) {
                        $opId = $orderDetail['op_id'];
                        $plugin = new Plugin();
                        $keyName = $plugin->getDefaultPluginKeyName(Plugin::TYPE_SHIPPING_SERVICES);
                        if (empty($orderDetail['opship_response']) && empty($orderDetail['opship_tracking_number']) && 'EasyPost' != $keyName) {
                            $orderId = $orderDetail['order_id'];
                            ?>
                            <button onclick='generateLabel(<?php echo $opId; ?>)' class="btn btn-outline-gray qwer no-print"
                                title="<?php echo Labels::getLabel('LBL_GENERATE_LABEL', $siteLangId); ?>">
                                <?php echo Labels::getLabel('LBL_GENERATE_LABEL', $siteLangId); ?>
                            </button>
                        <?php } elseif (!empty($orderDetail['opship_response']) && 'EasyPost' != $keyName) { ?>
                            <a target="_blank"
                                href="<?php echo UrlHelper::generateUrl("ShippingServices", 'previewLabel', [$orderDetail['op_id']]); ?>"
                                class="btn btn-outline-gray qwer no-print"
                                title="<?php echo Labels::getLabel('LBL_PREVIEW_LABEL', $siteLangId); ?>">
                                <?php echo Labels::getLabel('LBL_PREVIEW_LABEL', $siteLangId); ?>
                            </a>
                        <?php }
                        if ((!empty($orderStatus) && 'awaiting_shipment' == $orderStatus && !empty($orderDetail['opship_response']) || 'EasyPost' == $keyName) && empty($orderDetail['opship_tracking_number'])) {
                            if ('EasyPost' == $keyName) {
                                $label = Labels::getLabel('LBL_BUY_SHIPMENT_&_GENERATE_LABEL', $siteLangId);
                            } else {
                                $label = Labels::getLabel('LBL_PROCEED_TO_SHIPMENT', $siteLangId);
                            }
                            ?>
                            <button type="button" onclick="proceedToShipment(<?php echo $orderDetail['op_id']; ?>)"
                                class="btn btn-outline-gray qwer no-print" title="<?php echo $label; ?>">
                                <?php echo $label; ?>
                            </button>
                            <?php
                        }
                    }
                    if ($thread_id > 0) { ?>
                        <a class="btn btn-outline-gray qwer no-print"
                            href="<?php echo UrlHelper::generateUrl('Account', 'viewMessages', array($thread_id, $message_id)); ?>">
                            <?php echo Labels::getLabel('LBL_View_Order_Message', $siteLangId); ?>
                        </a>
                    <?php } else { ?>
                        <button type="button" onclick="sendOrderMessage(<?php echo $orderDetail['op_id']; ?>, 'seller')"
                            class="btn btn-outline-gray qwer no-print"
                            title="<?php echo Labels::getLabel('LBL_Send_message_to_buyer', $siteLangId); ?>">
                            <?php echo Labels::getLabel('LBL_Send_message_to_buyer', $siteLangId); ?>
                        </button>
                    <?php } ?>

                    <?php if ($orderDetail['order_is_rfq'] == applicationConstants::YES) { ?>
                        <a class="btn btn-outline-gray qwer no-print"
                            href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'view', array($orderDetail['order_rfq_id'])); ?>"
                            target="_blank">
                            <?php echo Labels::getLabel('LBL_View_RFQ', $siteLangId); ?>
                        </a>
                    <?php } ?>

                </div>
            </div>

        </div>

        <div class="content-body">
            <div class="card">
                <div class="card-head">
                    <h5 class="card-title">
                        <div class="order-number">
                            <small class="sm-txt">
                                <?php echo Labels::getLabel('LBL_Order', $siteLangId); ?> #
                            </small>
                            <span class="numbers">
                                <?php echo $orderDetail['op_invoice_number']; ?>
                                <?php
                                if ($orderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                    if (strtotime($orderDetail['opd_rental_start_date']) <= strtotime(date('Y-m-d 00:00:00')) && strtotime($orderDetail['opd_rental_end_date']) >= strtotime(date('Y-m-d 00:00:00')) && in_array($orderDetail['op_status_id'], OrderStatus::statusArrForRentalExpireNote())) {
                                        if (date('Y-m-d 00:00:00') == $orderDetail['opd_rental_end_date']) {
                                            $dateToRentalEnd = 0;
                                        } else {
                                            $dateToRentalEnd = CommonHelper::getDifferenceBetweenDates(date('Y-m-d 00:00:00'), $orderDetail['opd_rental_end_date'], 0, ProductRental::DURATION_TYPE_DAY);
                                        }


                                        if ($dateToRentalEnd >= 3) {
                                            $rentalEndMsgClass = 'alert-success';
                                        } elseif ($dateToRentalEnd >= 2) {
                                            $rentalEndMsgClass = 'alert-warning';
                                        } else {
                                            $rentalEndMsgClass = 'alert-danger';
                                        }
                                        ?>
                                        <span class="notice <?php echo $rentalEndMsgClass; ?>">
                                            <?php echo $dateToRentalEnd . ' ' . Labels::getLabel('LBL_Day(s)_Remaining_to_end_Rental', $siteLangId) ; ?>
                                        </span>
                                    <?php } elseif (strtotime($orderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d h:i:s')) && in_array($orderDetail['op_status_id'], OrderStatus::statusArrForLateChargeNote())) {
                                        ?>
                                        <span class="notice">
                                            <?php echo Labels::getLabel('LBL_Rental_Duration_Ended._Late_Charges_may_be_Apply', $siteLangId); ?>
                                        </span>
                                        <?php
                                    }

                                    if (isset($parentOrderDetail) && !empty($parentOrderDetail)) {
                                        echo '<span class="notice ">' . Labels::getLabel('LBL_This_order_is_extended_from_', $siteLangId) . ' <a href="' . UrlHelper::generateUrl('SellerOrders', 'viewOrder', array($parentOrderDetail['op_id'])) . '">#' . $parentOrderDetail['op_invoice_number'] . '</a> </span>';
                                    }
                                    if (isset($extendedChildData) && !empty($extendedChildData)) {
                                        echo '<span class="notice ">' . Labels::getLabel('LBL_This_order_is_extended_By', $siteLangId) . ' <a href="' . UrlHelper::generateUrl('SellerOrders', 'viewOrder', array($extendedChildData['opd_op_id'])) . '">#' . $extendedChildData['opd_order_id'] . '</a> </span>';
                                    }
                                }
                                ?>
                            </span>
                        </div>
                    </h5>
                    <div class="btn-group orders-actions">
                        <a href="<?php echo UrlHelper::generateUrl('Seller', 'viewInvoice', [$orderDetail['op_id']]); ?>"
                            class="btn btn-outline-gray">
                            <svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#print">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Print_order_detail', $siteLangId); ?>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="table-wrap">
                                <table class="table table-orders  table-justified">
                                    <thead>
                                        <tr class="">
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Items_Summary', $siteLangId); ?>
                                            </th>
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Total_Price', $siteLangId); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $cartTotalAmount = CommonHelper::orderProductAmount($orderDetail, 'cart_total');
                                        $couponDiscount = CommonHelper::orderProductAmount($orderDetail, 'DISCOUNT');
                                        $shippingCharges = CommonHelper::orderProductAmount($orderDetail, 'SHIPPING');
                                        $totalTaxes = CommonHelper::orderProductAmount($orderDetail, 'TAX');
                                        $volumnDiscountAmount = CommonHelper::orderProductAmount($orderDetail, 'VOLUME_DISCOUNT');
                                        $durationDiscountAmount = CommonHelper::orderProductAmount($orderDetail, 'DURATION_DISCOUNT');
                                        $rewardPointTotal = CommonHelper::orderProductAmount($orderDetail, 'REWARDPOINT');
                                        $totalSecurityAmount = $orderDetail['opd_rental_security'] * $orderDetail['op_qty'];
                                        $orderNetTotal = CommonHelper::orderProductAmount($orderDetail, 'netamount', false, User::USER_TYPE_SELLER);

                                        $prodOrBatchUrl = '';
                                        if ($orderDetail['op_is_batch']) {
                                            $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($orderDetail['op_selprod_id']));
                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'BatchProduct', array($orderDetail['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                        } else {
                                            if (Product::verifyProductIsValid($orderDetail['op_selprod_id']) == true) {
                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($orderDetail['op_selprod_id']));
                                            }
                                            $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($orderDetail['selprod_product_id'], "SMALL", $orderDetail['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');

                                            if ($orderDetail['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($orderDetail['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                            }
                                        }
                                        $optionsHtml = ($orderDetail['op_selprod_options'] != '') ? ' | ' . $orderDetail['op_selprod_options'] : "";

                                        $productTitle = (trim($orderDetail['op_selprod_title']??'') == '') ? $orderDetail['op_product_identifier'] : $orderDetail['op_selprod_title'];

                                        $productImgHtml = '<td><div class="product-profile"> 
                                                
                                                <a class="product-profile-thumbnail " '.HtmlHelper::profileImgAttr().' href="' . $prodOrBatchUrl . '">
                                                    <img src="' . $prodOrBatchImgUrl . '" title="' . $orderDetail['op_product_name'] . '" alt="' . $orderDetail['op_product_name'] . '" />
                                                </a>
                                                
                                                <div class="product-profile-data">
                                                    <div class="product-profile-title">
                                                        <a title="' . $productTitle . '" href="' . $prodOrBatchUrl . '">
                                                            ' . $productTitle . '
                                                        </a>
                                                    </div>
                                                    <div class="product-profile-options"> ' . Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $orderDetail['op_qty'] . ' ' . $optionsHtml . '
                                                </div>
                                                    
                                                </div>
                                                </div></td>';


                                        $roundingOffTotal = $orderDetail['op_rounding_off'];
                                        $totalLateCharges = $orderDetail['charge_total_amount'];
                                        $addonTotal = 0;

                                        $isShipping = true;
                                        if (Shipping::FULFILMENT_PICKUP == $orderDetail['opshipping_fulfillment_type']) {
                                            $isShipping = false;
                                            $pickupAddressHtml .= '<div class="address-info">';
                                            $pickupAddressHtml .= '<p>' . $orderDetail['addr_name'] . '</p>';
                                            $address1 = !empty($orderDetail['addr_address1']) ? '<p>' . $orderDetail['addr_address1'] . '</p>' : '';
                                            $address2 = !empty($orderDetail['addr_address2']) ? '<p>' . $orderDetail['addr_address2'] . '</p>' : '';
                                            $city = !empty($orderDetail['addr_city']) ? $orderDetail['addr_city'] : '';
                                            $state = !empty($orderDetail['state_name']) ? ', ' . $orderDetail['state_name'] : ', ' . $orderDetail['state_identifier'];
                                            $zip = !empty($orderDetail['addr_zip']) ? '(' . $orderDetail['addr_zip'] . ')' : '';
                                            $stateStr = '<p>' . $city . $state . $zip . '</p>';
                                            $country = !empty($orderDetail['country_name']) ? ' <p>' . $orderDetail['country_name'] . '</p>' : '<p> ' . $orderDetail['country_code'] . '</p>';
                                            $pickupAddressHtml .= $address1 . $address2 . $stateStr . $country;

                                            $pickupAddressHtml .= '<p class="c-info"><strong><i class="fas fa-mobile-alt mr-2"></i> ' . $orderDetail['addr_dial_code'] . ' ' . $orderDetail['addr_phone'] . '</strong></p>';

                                            $pickupAddressHtml .= '</div>';
                                        } else {
                                            $shippingHtml .= '<tr>' . $productImgHtml . '<td>' . $orderDetail['opshipping_label'] . '</td><td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'SHIPPING'), true, false, true, false, true) . '</td></tr>';
                                        }

                                        $couponDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'DISCOUNT'), true, false, true, false, true) . '</td></tr>';

                                        if ($orderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                            $securityHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(($orderDetail['opd_rental_security'] * $orderDetail['op_qty']), true, false, true, false, true) . '</td></tr>';
                                            $durationDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'DURATION_DISCOUNT'), true, false, true, false, true) . '</td></tr>';
                                        } else {
                                            $volumnDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'VOLUME_DISCOUNT'), true, false, true, false, true) . '</td></tr>';
                                        }

                                        if (empty($orderDetail['taxOptions'])) {
                                            $taxOptionsHtml .= '<tr>
                                        ' . $productImgHtml . '
                                        <td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'TAX'), true, false, true, false, true) . '</td>
                                        </tr>';
                                        } else {
                                            $taxOptionsHtml .= '<tr>' . $productImgHtml . '<td>';
                                            foreach ($orderDetail['taxOptions'] as $key => $val) {
                                                $taxOptionsHtml .= '<strong>' . CommonHelper::displayTaxPercantage($val, true) . '</strong> : ' . CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true) . '<br />';
                                            }
                                            $taxOptionsHtml .= '</td></tr>';
                                        }
                                        ?>
                                        <tr>
                                            <td>
                                                <div class="product-profile">
                                                    <a class="product-profile-thumbnail xxl "
                                                        <?php echo HtmlHelper::profileImgAttr(); ?> href="<?php echo $prodOrBatchUrl; ?>">
                                                        <img src="<?php echo $prodOrBatchImgUrl; ?>"
                                                            title="<?php echo $orderDetail['op_product_name']; ?>"
                                                            alt="<?php echo $orderDetail['op_product_name']; ?>" />
                                                    </a>
                                                    <div class="product-profile-data">
                                                        <div class="product-profile-title">
                                                            <a title="<?php echo $productTitle; ?>"
                                                                href="<?php echo $prodOrBatchUrl; ?>">
                                                                <?php echo $productTitle; ?>
                                                            </a><br />
                                                        </div>
                                                        <div class="product-profile-options">
                                                            <?php
                                                            echo Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $orderDetail['op_qty'];
                                                            if ($orderDetail['op_selprod_options'] != '') {
                                                                echo ' | ' . $orderDetail['op_selprod_options'];
                                                            }
                                                            ?>
                                                        </div>
                                                        <div class="product-profile-sold">
                                                            <?php echo Labels::getLabel('Lbl_Brand', $siteLangId) ?>:
                                                            <?php echo CommonHelper::displayNotApplicable($siteLangId, $orderDetail['op_brand_name']); ?>
                                                        </div>
                                                        <?php
                                                        if ($orderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                                            $duration = CommonHelper::getDifferenceBetweenDates($orderDetail['opd_rental_start_date'], $orderDetail['opd_rental_end_date'], $orderDetail['op_selprod_user_id'], $orderDetail['opd_rental_type']);
                                                            ?>
                                                            <div class="product-profile-range">
                                                                <small>
                                                                    
                                                                    <?php echo Labels::getLabel('LBL_From', $siteLangId) . ': ' . date('M d, Y H:i ', strtotime($orderDetail['opd_rental_start_date'])); ?>
																	<br/>
                                                                    <?php echo Labels::getLabel('LBL_To', $siteLangId) . ': ' . date('M d, Y H:i ', strtotime($orderDetail['opd_rental_end_date'])); ?>
                                                                </small>
                                                            </div>
															<?php if(0) { ?>
                                                            <div class="product-profile-range">
                                                                <small>
                                                                    <i class="icn">
                                                                        <svg width="12px" height="12px" class="svg">
                                                                            <use
                                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#time">
                                                                            </use>
                                                                        </svg>
                                                                    </i>
                                                                    <?php
                                                                    echo Labels::getLabel('LBL_Duration', $siteLangId) . ': ';
                                                                    echo CommonHelper::displayProductRentalDuration($duration, $orderDetail['opd_rental_type'], $siteLangId);
                                                                    ?>
                                                                </small>
                                                            </div>
                                                        <?php } }?>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
											<?php 
												if(!empty($orderDetail['opd_price_bifurcation'])) { ?>
													<button class="dotted" data-bs-toggle="modal" data-bs-target="#price-bifurcation-<?php echo $orderDetail['op_id']; ?>">
													<?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'cart_total'), true, false, true, false, true); ?>
													</button>
											<?php	} else {
													echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderDetail, 'cart_total'), true, false, true, false, true); 
												}
												?>
                                            </td>
                                        </tr>
                                        <?php if (!empty($attachedServices)) { ?>
                                            <tr class="row-addons">
                                                <td colspan="3">
                                                    <div class="addons">
                                                        <button class="addons_trigger collapsed" type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#service_<?php echo $orderDetail['op_id']; ?>"
                                                            aria-expanded="false"
                                                            aria-controls="service_<?php echo $orderDetail['op_id']; ?>">
                                                            <span class="txt">
                                                                <?php echo Labels::getLabel('LBL_Addons_And_Details', $siteLangId); ?>
                                                                <span class="count">
                                                                    <?php echo count($attachedServices); ?>
                                                                </span>
                                                            </span>
                                                            <i class="icn"></i>
                                                        </button>
                                                        <div class="collapse"
                                                            id="service_<?php echo $orderDetail['op_id']; ?>">
                                                            <ul class="addons-list">
                                                                <?php
                                                                foreach ($attachedServices as $service) {
                                                                    $addonImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($service['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');

                                                                    $addonTitle = (trim($service['op_selprod_title']) == '') ? $service['op_product_identifier'] : $service['op_selprod_title'];


                                                                    $addonImgHtml = '<td><div class="product-profile">                                                                        
                                                                        <button class="product-profile-thumbnail">
                                                                            <img src="' . $addonImgUrl . '" title="' . $service['op_product_name'] . '" alt="' . $service['op_product_name'] . '" />
                                                                        </button>
                                                                       
                                                                        <div class="product-profile-data">
                                                                            <div class="product-profile-title">
                                                                                ' . $addonTitle . '
                                                                            </div> <div class="product-profile-options"> ' . Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $service['op_qty'] . ' </div>
                                                                        </div></div></td>';

                                                                    $couponDiscountHtml .= '<tr>' . $addonImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'DISCOUNT'), true, false, true, false, true) . '</td></tr>';


                                                                    $addonTotal += CommonHelper::orderProductAmount($service, 'cart_total');
                                                                    $couponDiscount += CommonHelper::orderProductAmount($service, 'DISCOUNT');
                                                                    $shippingCharges += CommonHelper::orderProductAmount($service, 'SHIPPING');
                                                                    $totalTaxes += CommonHelper::orderProductAmount($service, 'TAX');
                                                                    $volumnDiscountAmount += CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT');
                                                                    $durationDiscountAmount += CommonHelper::orderProductAmount($service, 'DURATION_DISCOUNT');
                                                                    $rewardPointTotal += CommonHelper::orderProductAmount($service, 'REWARDPOINT');
                                                                    $totalSecurityAmount += $service['opd_rental_security'] * $service['op_qty'];
                                                                    $orderNetTotal += CommonHelper::orderProductAmount($service, 'netamount', false, User::USER_TYPE_SELLER);

                                                                    $roundingOffTotal += $service['op_rounding_off'];
                                                                    $totalLateCharges += $service['charge_total_amount'];

                                                                    $addonAmountHtml .= '<tr>' . $addonImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'cart_total'), true, false, true, false, true) . '</td></tr>';

                                                                    if (empty($service['taxOptions'])) {
                                                                        $taxOptionsHtml .= '<tr> 
                                                                ' . $addonImgHtml . '
                                                                <td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'TAX'), true, false, true, false, true) . '</td>
                                                                </tr>';
                                                                    } else {
                                                                        $taxOptionsHtml .= '<tr>' . $addonImgHtml . '<td>';
                                                                        foreach ($service['taxOptions'] as $key => $val) {
                                                                            $taxOptionsHtml .= '<strong>' . CommonHelper::displayTaxPercantage($val, true) . '</strong> : ' . CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true) . '<br />';
                                                                        }
                                                                        $taxOptionsHtml .= '</td></tr>';
                                                                    }
                                                                    ?>
                                                                    <li>
                                                                        <div class="addons-img">
                                                                            <img src="<?php echo $addonImgUrl; ?>"
                                                                                title="<?php echo $addonTitle; ?>"
                                                                                alt="<?php echo $addonTitle; ?>">
                                                                        </div>
                                                                        <div class="addons-name">
                                                                            <?php echo $addonTitle; ?>
                                                                        </div>
                                                                    </li>
                                                                <?php } ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>

                            <?php
                            /* if (!empty($orderDetail['comments'])) { */
                            if (!empty($orderStatusList)) {
                                $classArr = OrderStatus::orderStatusClassess();
                                ?>
                                <div class="timelines-wrap">
                                    <h5 class="card-title">
                                        <?php echo Labels::getLabel('LBL_Posted_Comments', $siteLangId); ?>
                                    </h5>
                                    <ul class="timeline">
                                        <?php if ($orderDetail['op_status_id'] == OrderStatus::ORDER_CANCELLED) { ?>
                                            <li class="enable shipped">
                                                <div class="timeline_data">
                                                    <div class="timeline_data_head">
                                                        <span class="order-status">
                                                            <em class="dot"></em>
                                                            <?php echo Labels::getLabel('LBL_Cancelled', $siteLangId); ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </li>
                                            <?php
                                        } else {
                                            $orderStatusList = array_values($orderStatusList);
                                            foreach ($orderStatusList as $key => $opStatus) {
                                                $postedComments = [array('oshistory_id' => 0)];
                                                $opStatusId = $opStatus['orderstatus_id'];
                                                if (!isset($orderDetail['comments'][$opStatusId])) {
                                                    foreach ($orderStatusList as $keyChild => $opStatusChild) {
                                                        $opStatusIdChild = $opStatusChild['orderstatus_id'];
                                                        if ($keyChild > $key && isset($orderDetail['comments'][$opStatusIdChild])) {
                                                            $postedComments = [array('oshistory_id' => 0, 'oshistory_date_added' => $orderDetail['comments'][$opStatusIdChild][0]['oshistory_date_added'])];
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    $postedComments = $orderDetail['comments'][$opStatusId];
                                                }

                                                $enableDisableClass = "disabled";
                                                if (isset($currentOrderStatusPriority) && $currentOrderStatusPriority >= $opStatus['priority']) {
                                                    $enableDisableClass = "enable";
                                                }
                                                if ($opStatusId == $orderDetail['op_status_id']) {
                                                    $enableDisableClass .= ' currently';
                                                }
                                                if (Shipping::FULFILMENT_PICKUP == $orderDetail['opshipping_fulfillment_type'] && $opStatusId == OrderStatus::ORDER_DELIVERED) {
                                                    $opStatus['orderstatus_name'] = Labels::getLabel('LBL_Picked', $siteLangId);
                                                }
                                                if ($orderDetail['order_payment_status'] != Orders::ORDER_PAYMENT_PAID && $opStatusId == OrderStatus::ORDER_PAYMENT_CONFIRM) {
                                                    $enableDisableClass .= " on-hold";
                                                }
                                                if ($orderDetail['op_payment_status'] != Orders::ORDER_PAYMENT_PAID && $opStatusId == OrderStatus::ORDER_PAYMENT_CONFIRM) {
                                                    $enableDisableClass .= " on-hold";
                                                }


                                                ?>
                                                <li
                                                    class="<?php echo $enableDisableClass; ?> <?php echo (isset($classArr[$opStatusId])) ? $classArr[$opStatusId] : "in-process" ?>">
                                                    <?php
                                                    foreach ($postedComments as $row) {
                                                        $attachedFiles = (isset($statusAttachedFiles[$row['oshistory_id']])) ? $statusAttachedFiles[$row['oshistory_id']] : [];
                                                        ?>
                                                        <div class="timeline_data">
                                                            <div class="timeline_data_head">
                                                                <?php if (isset($row['oshistory_date_added'])) { ?>
                                                                    <time class="timeline_date">
                                                                        <?php echo FatDate::format($row['oshistory_date_added']); ?>
                                                                    </time>
                                                                <?php } ?>
                                                                <span class="order-status"> <em class="dot"></em>
                                                                    <?php echo $opStatus['orderstatus_name']; ?>
                                                                </span>
                                                            </div>
                                                            <?php if ($row['oshistory_id'] > 0) { ?>
                                                                <div class="timeline_data_body">
                                                                    <?php if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_SHIPPED || ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_READY_FOR_RENTAL_RETURN && $row['oshistory_fullfillment_type'] == OrderProduct::RENTAL_ORDER_RETURN_TYPE_SHIP)) { ?>
                                                                        <?php if (empty($row['oshistory_courier'])) { ?>
                                                                            <h6><strong>
                                                                                    <?php echo Labels::getLabel('LBL_Tracking_Number', $siteLangId); ?>
                                                                                </strong>
                                                                            </h6>
                                                                            <div class="clipboard-wrap">
                                                                                <div class="clipboard">
                                                                                    <p class="clipboard_url">
                                                                                        <?php echo $row['oshistory_tracking_number']; ?>
                                                                                    </p>
                                                                                    <button class="clipboard_btn" data-bs-toggle="tooltip"
                                                                                        onclick="copyContent(this)"
                                                                                        title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                        data-original-title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"><i
                                                                                            class="far fa-copy"></i></button>
                                                                                </div>
                                                                                <?php
                                                                                $str = '';
                                                                                if (empty($orderDetail['opship_tracking_url']) && !empty($row['oshistory_tracking_number'])) {
                                                                                    $str .= " <span class='via'> VIA <em>" . CommonHelper::displayNotApplicable($siteLangId, $orderDetail["opshipping_label"]) . "</em></span>";
                                                                                } elseif (!empty($orderDetail['opship_tracking_url'])) {
                                                                                    $str .= " <a class='link-brand link-underline' href='" . $orderDetail['opship_tracking_url'] . "' target='_blank'>" . Labels::getLabel("MSG_TRACK", $siteLangId) . "</a>";
                                                                                }
                                                                                echo $str
                                                                                    ?>


                                                                            </div>
                                                                            <?php
                                                                        } else {
                                                                            $trackingNumber = $row['oshistory_tracking_number'];
                                                                            $carrier = $row['oshistory_courier'];
                                                                            echo ($row['oshistory_tracking_number']) ? '<h6><strong>' . Labels::getLabel('LBL_Tracking_Number', $siteLangId) . '</strong> </h6>' : '';
                                                                            if (trim($trackingNumber) != '') {
                                                                                ?>
                                                                                <div class="clipboard-wrap">
                                                                                    <div class="clipboard">
                                                                                        <p class="clipboard_url">
                                                                                            <?php echo $row['oshistory_tracking_number']; ?>
                                                                                        </p>
                                                                                        <button class="clipboard_btn" data-bs-toggle="tooltip"
                                                                                            title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                            data-original-title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                            onclick="copyContent(this)"><i
                                                                                                class="far fa-copy"></i></button>
                                                                                    </div>

                                                                                </div>
                                                                                <?php
                                                                                if ($row['oshistory_orderstatus_id'] != OrderStatus::ORDER_READY_FOR_RENTAL_RETURN) {
                                                                                    echo " <span class='via'>";
                                                                                    echo Labels::getLabel('LBL_VIA', $siteLangId);
                                                                                    ?>
                                                                                    <em>
                                                                                        <?php echo CommonHelper::displayNotApplicable($siteLangId, $orderDetail["opshipping_label"]); ?>
                                                                                    </em>
                                                                                    <?php
                                                                                    echo "</span>";
                                                                                } else {
                                                                                    if (trim($row['oshistory_tracking_url']) != '') {
                                                                                        echo " <a class='link-brand link-underline' href='" . $row['oshistory_tracking_url'] . "'  target='_blank'>" . Labels::getLabel("MSG_TRACK", $siteLangId) . "</a>";
                                                                                    }

                                                                                    echo " <span class='via'>" . Labels::getLabel('LBL_VIA', $siteLangId) . " <em>" . $carrier . " </em></span>";
                                                                                }
                                                                                ?>
                                                                                <?php
                                                                            }
                                                                        }
                                                                    }
                                                                    if (isset($statusAddressData[$row['oshistory_id']])) {
                                                                        $dropOffAddress = $statusAddressData[$row['oshistory_id']];
                                                                        ?>
                                                                        <div class="my-addresses-body mb-2 p-0">
                                                                            <address class="delivery-address">
                                                                                <h5>
                                                                                    <span>
                                                                                        <?php echo $dropOffAddress['addr_name']; ?>
                                                                                    </span>
                                                                                    <span class="tag">
                                                                                        <?php echo $dropOffAddress['addr_title']; ?>
                                                                                    </span>
                                                                                </h5>
                                                                                <p>
                                                                                    <?php echo $dropOffAddress['addr_address1'] . ','; ?>
                                                                                    <?php echo $dropOffAddress['addr_city'] . ','; ?>
                                                                                    <?php echo $dropOffAddress['state_name'] . ','; ?>
                                                                                    <?php echo $dropOffAddress['country_name']; ?>
                                                                                    <br>
                                                                                    <?php echo Labels::getLabel("LBL_Zip", $siteLangId) . ': ' . $dropOffAddress['addr_zip'] ?>

                                                                                </p>
                                                                                <p class="phone-txt">
                                                                                    <svg class="svg" width="16" height="16">
                                                                                        <use
                                                                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                                                        </use>
                                                                                    </svg>
                                                                                    <?php echo Labels::getLabel("LBL_Phone", $siteLangId) . ': ' . $dropOffAddress['addr_dial_code'] . ' ' . $dropOffAddress['addr_phone']; ?><br>
                                                                                </p>
                                                                            </address>
                                                                        </div>

                                                                        <?php
                                                                    }
                                                                    if (!empty($attachedFiles)) {
                                                                        ?>
                                                                        <div class="attached-files">
                                                                            <h6>
                                                                                <strong>
                                                                                    <?php echo Labels::getLabel('LBL_Attached_Files', $siteLangId); ?>
                                                                                </strong>
                                                                            </h6>
                                                                            <ul>
                                                                                <?php foreach ($attachedFiles as $attachedFile) { ?>
                                                                                    <li>
                                                                                        <a href="<?php echo UrlHelper::generateUrl('seller', 'downloadBuyerAtatchedFile', array(CommonHelper::encryptId($attachedFile['afile_record_id']), 0, CommonHelper::encryptId($attachedFile['afile_id']))); ?>"
                                                                                            title="<?php echo $attachedFile['afile_name']; ?>">
                                                                                            <i class="fa fa-download"></i>
                                                                                            <?php echo $attachedFile['afile_name']; ?>
                                                                                        </a>
                                                                                    </li>
                                                                                <?php } ?>
                                                                            </ul>
                                                                        </div>
                                                                    <?php } ?>

                                                                    <p>
                                                                        <?php echo !empty(trim(($row['oshistory_comments']))) ? html_entity_decode(nl2br($row['oshistory_comments'])) : ""; ?>
                                                                    </p>
                                                                </div>
                                                            <?php } ?>
                                                            <?php
                                                            if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) {
                                                                if ($opStatusId == OrderStatus::ORDER_RENTAL_RETURNED && (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_RENTAL_RETURNED, $orderDetail['checklistPoints']))) {
                                                                    ?>
                                                                    <button class="dotted" data-bs-toggle="modal"
                                                                        data-bs-target="#returned_checklist_points_modal">
                                                                        <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                                                                    </button>
                                                                <?php }
                                                                if ($opStatusId == OrderStatus::ORDER_SHIPPED && (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_SHIPPED, $orderDetail['checklistPoints']))) {
                                                                    ?>
                                                                    <button class="dotted" data-bs-toggle="modal"
                                                                        data-bs-target="#shipped_checklist_points_modal">
                                                                        <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                                                                    </button>
                                                                <?php } else if ((Shipping::FULFILMENT_PICKUP == $orderDetail['opshipping_fulfillment_type'] && $opStatusId == 7) && (!empty($orderDetail['checklistPoints']) && array_key_exists(7, $orderDetail['checklistPoints']))) { ?>
                                                                        <button class="dotted" data-bs-toggle="modal"
                                                                            data-bs-target="#shipped_checklist_points_modal">
                                                                        <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                                                                        </button>
                                                                <?php } ?>
                                                            <?php } ?>
                                                        </div>
                                                    <?php } ?>
                                                </li>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            <?php } ?>


                            <?php
                            if ($canEdit && $displayForm) {
                                if (!empty($extendChildOrder)) {
                                    echo '<div class="section--repeated no-print text-danger extend-order-section">' . Labels::getLabel('LBL_This_order_is_extended_.To_check_or_change_status_of_this_order_click_here', $siteLangId) . ' <a href="' . CommonHelper::generateUrl('SellerOrders', 'viewOrder', array($extendChildOrder['opd_op_id'])) . '">#' . $extendChildOrder['opd_order_id'] . '</a>' . '</div>';
                                } else {
                                    ?>
                                    <div class="section--repeated no-print">
                                        <h5>
                                            <?php echo Labels::getLabel('LBL_Comments_on_order', $siteLangId); ?>
                                        </h5>
                                        <?php

                                        $securityLabelHtml = '<small>' . Labels::getLabel("LBL_Refunable_Security_amount_is", $siteLangId). CommonHelper::displayMoneyFormat($orderDetail['totalSecurityAmount']) . '</small>';

                                        $frm->setFormTagAttribute('onsubmit', 'updateStatus(this); return(false);');
                                        $frm->setFormTagAttribute('class', 'form markAsShipped-js');
                                        $frm->developerTags['colClassPrefix'] = 'col-md-';
                                        $frm->developerTags['fld_default_col'] = 6;

                                        $statusFld = $frm->getField('op_status_id');
                                        $statusFld->setFieldTagAttribute('class', 'status-js fieldsVisibility-js');

                                        $fld1 = $frm->getField('customer_notified');
                                        $fld1->setFieldTagAttribute('class', 'notifyCustomer-js');

                                        $fld = $frm->getField('opship_tracking_url');
                                        if (null != $fld) {
                                            $fld->setFieldTagAttribute('pattern', '^(https?|ftp):\/\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*(\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*)?$');
                                            $fld->setFieldTagAttribute('placeholder', 'https://example.com');
                                            $fld->htmlAfterField = '<small>' . Labels::getLabel("LBL_Example", $siteLangId) . ' : https://example.com' . '</small>';
                                        }

                                        if ($orderDetail['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                            $fldSecurityType = $frm->getField('refund_security_type');
                                            $fldSecurityType->setFieldTagAttribute('completeamount', $orderDetail['totalSecurityAmount']);

                                            $fldsAmount = $frm->getField('refund_security_amount');
                                            $fldsAmount->htmlAfterField = $securityLabelHtml;

                                            $returnDateFld = $frm->getField('opd_mark_rental_return_date');
                                            if ($orderDetail['opd_mark_rental_return_date'] != '0000-00-00 00:00:00' && $orderDetail['opd_mark_rental_return_date'] != "") {
                                                $returnDateFld->value = $orderDetail['opd_mark_rental_return_date'];
                                                $returnDateFld->setFieldTagAttribute('readonly', 'readonly');
                                                if ($orderDetail['charge_total_amount'] > 0) {
                                                   $returnDateFld->htmlAfterField = "<small class='note'>" . CommonHelper::displayMoneyFormat($orderDetail['charge_total_amount'], true, false).' '.Labels::getLabel("LBL_Late_Charges_will_be_apply", $siteLangId) . "</small>";
                                                }
                                            } else {
                                                $returnDateFld->value = date('Y-m-d h:i:s');
                                                if (strtotime($orderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d h:i:s'))) {
                                                    $returnDateFld->htmlAfterField = "<small class='note'>" . Labels::getLabel("LBL_Note:_Late_Charges_May_be_apply", $siteLangId) . "</small>";
                                                }
                                            }

                                            $returnQty = $frm->getField('return_qty');
                                            $buyerReturnQty = ($orderDetail['op_return_qty'] > 0) ? $orderDetail['op_return_qty'] : $orderDetail['op_qty'];
                                            if ($buyerReturnQty == 1) {
                                                $returnQty->value = $buyerReturnQty;
                                                // $returnQty->setFieldTagAttribute('class', 'disabled-input');
                                                // $returnQty->setFieldTagAttribute('readonly', 'readonly');
                                            }

                                            if ($rentalReturnStatus != $orderDetail['op_status_id']) {
                                                $fldSecurityType->setWrapperAttribute('class', 'div_refund_security');
                                                $fldsAmount->setWrapperAttribute('class', 'div_refund_security');

                                                $fileFld = $frm->getField('file');
                                                $fileFld->setWrapperAttribute('class', 'div_refund_security');

                                                $lateChrgFld = $frm->getField('apply_late_charges');
                                                if (!empty($lateChrgFld)) {
                                                    $lateChrgFld->developerTags['col'] = 12;
                                                    $lateChrgFld->setWrapperAttribute('class', 'div_refund_security');
                                                }

                                                $returnDateFld->setWrapperAttribute('class', 'div_refund_security');
                                                $returnQty->setWrapperAttribute('class', 'div_refund_security');
                                            }
                                        }
                                        $uploadFilesPreviewFld = $frm->getField('uploadFilesPreview');
                                        if (!empty($uploadFilesPreviewFld)) {
                                            $uploadFilesPreviewFld->developerTags['col'] = 12;
                                        }
                                        $cmtFld = $frm->getField('comments');
                                        $cmtFld->setWrapperAttribute('id', 'comments_wrapper');
                                        $cmtFld->developerTags['col'] = 12;


                                        $fldBtn = $frm->getField('btn_submit');
                                        $fldBtn->setFieldTagAttribute('class', 'btn btn-brand');
                                        echo $frm->getFormHtml();
                                        ?>
                                    </div>
                                    <?php
                                }
                            }
                            ?>


                        </div>
                        <div class="col-md-4">
                            <div class="ml-xl-2">
                                <div class="order-block">
                                    <h4>
                                        <?php echo Labels::getLabel('LBL_Order_Summary', $siteLangId); ?>
                                    </h4>
                                    <ul class="cart-summary">
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo FatDate::format($orderDetail['order_date_added']); ?>
                                            </span>
                                        </li>
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Cart_Total', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($cartTotalAmount, true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <?php if ($addonTotal > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#addon_modal">
                                                        <?php echo Labels::getLabel('LBL_Addon_Total', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($addonTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>


                                        <?php if ($durationDiscountAmount != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#duration_discount_modal">
                                                        <?php echo Labels::getLabel('LBL_Duration_Discount', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($durationDiscountAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>

                                        <?php if ($volumnDiscountAmount != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#volume_modal">
                                                        <?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($volumnDiscountAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($totalSecurityAmount > 0) { ?>
                                            <li class="cart-summary-item ">
                                                <span class="label"><button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#security_modal">
                                                        <?php echo Labels::getLabel('LBL_Security_Amount', $siteLangId); ?>
                                                    </button></span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalSecurityAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>

                                        <?php if ($shippingCharges > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#shipping_modal">
                                                        <?php echo Labels::getLabel('LBL_Shipping_Price', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($orderDetail['op_tax_collected_by_seller']) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#tax_modal">
                                                        <?php echo Labels::getLabel('LBL_Taxes', $siteLangId); ?>
                                                        <?php /* <em class="count">5</em> */ ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalTaxes, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($roundingOffTotal > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Rounding_Up', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } elseif (0 > $roundingOffTotal) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>

                                        <?php /* if ($couponDiscount != 0) { ?>
                                   <li class="discounted">
                                       <span class="label"><button class="dotted" data-bs-toggle="modal"
                                               data-bs-target="#discount_modal"><?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?></button></span>
                                       <span
                                           class="value"><?php echo CommonHelper::displayMoneyFormat($couponDiscount, true, false, true, false, true); ?></span>
                                   </li>
                                   <?php } */ ?>

                                        <?php /* if ($rewardPointTotal != 0) { ?>
                                   <li class="discounted">
                                       <span
                                           class="label"><?php echo Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId); ?></span>
                                       <span
                                           class="value"><?php echo CommonHelper::displayMoneyFormat($rewardPointTotal, true, false, true, false, true); ?></span>
                                   </li>
                                   <?php } */ ?>
                                        <li class="cart-summary-item highlighted">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Order_Total_Amount', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($orderNetTotal, true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                    </ul>

                                </div>
                                <?php
                                if ($totalLateCharges > 0) {
                                    $chargeLbl = ($orderDetail['charge_status'] != BuyerLateChargesHistory::STATUS_PENDING) ? Labels::getLabel('Lbl_Late_Charges_Apply', $siteLangId) : Labels::getLabel('Lbl_Late_Charges_May_be_Apply', $siteLangId);
                                    ?>
                                    <div class="order-block">
                                        <ul class="cart-summary pt-0">
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('Lbl_Late_Charges', $siteLangId) ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalLateCharges, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                <?php } ?>
                                <?php /* $totalSaving = $couponDiscount + $volumnDiscountAmount + $durationDiscountAmount + $rewardPointTotal; */ ?>
                                <?php $totalSaving = $volumnDiscountAmount + $durationDiscountAmount; ?>
                                <?php if ($totalSaving != 0) { ?>
                                    <div class="total-savings">
                                        <img class="total-savings-img"
                                            src="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/savings.svg" alt="">
                                        <p>
                                            <?php echo Labels::getLabel('LBL_Buyer\'s_total_savings_amount_on_this_order', $siteLangId); ?>
                                        </p>
                                        <span class="amount">
                                            <?php echo CommonHelper::displayMoneyFormat((-$totalSaving), true, false, true, false, true); ?>
                                        </span>
                                    </div>
                                <?php } ?>

                                <div class="order-block">
                                    <h5 class="mt-0">
                                        <?php echo Labels::getLabel('LBL_Customer_Details', $siteLangId); ?>
                                    </h5>
                                    <div class="list-specification">
                                        <ul>
                                            <li>
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Customer_Name', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo $orderDetail['user_name']; ?>
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                                <?php if ($orderDetail['order_discount_total'] != 0) { ?>
                                    <div class="total-savings">
                                        <img class="total-savings-img"
                                            src="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/savings.svg" alt="">
                                        <p>
                                            <?php echo Labels::getLabel('LBL_The_discount_on_this_order_is_being_borne_by_the_platform', $siteLangId); ?>
                                        </p>
                                        <span class="amount">
                                            <?php
                                             echo CommonHelper::displayMoneyFormat(($orderDetail['op_discount_total']), true, false, true, false, true); ?>
                                        </span>
                                    </div>
                                <?php } ?>

                                <?php if (!empty($orderDetail['payments']) || !empty($orderDetail['shippingAddress'])) { ?>
                                    <div class="order-block">
                                        <h4>
                                            <?php echo Labels::getLabel('LBL_Order_Details', $siteLangId); ?>
                                        </h4>
                                        <?php if (!empty($orderDetail['shippingAddress'])) { ?>
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Shipping_Details', $siteLangId); ?>
                                            </h5>
                                            <div class="address-info">
                                                <?php
                                                $shippingAddress = '<p>' . $orderDetail['shippingAddress']['oua_name'] . '</p>';
                                                if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_address1'] . '</p>';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_address2'] . '</p>';
                                                }

                                                $shippingAddress .= '<p>';
                                                if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_state'] != '') {
                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_state'] . ', ';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                    $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                }
                                                $shippingAddress .= '</p>';

                                                if ($orderDetail['shippingAddress']['oua_country'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_country'] . '</p>';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                    $shippingAddress .= '<p class="c-info"><strong><i class="fas fa-mobile-alt mr-2"></i> ' . $orderDetail['shippingAddress']['oua_dial_code'] . ' ' . $orderDetail['shippingAddress']['oua_phone'] . '</strong></p>';
                                                }
                                                echo $shippingAddress
                                                    ?>
                                            </div>
                                        <?php } ?>

                                        <?php if (!empty($orderDetail['payments'])) { ?>
                                            <hr class="dotted">
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Payment_History', $siteLangId); ?>
                                            </h5>
                                            <?php foreach ($orderDetail['payments'] as $row) { ?>
                                                <div class="payment-mode">
                                                    <div class="cc-payment">
                                                        <span class="cc-num">
                                                            <?php echo $row['opayment_method']; ?>
                                                        </span>
                                                        <span class="cc-num">
                                                            <?php echo CommonHelper::displayMoneyFormat($row['opayment_amount'], true, false, true, false, true); ?>
                                                        </span>
                                                        <span class="cc-num">
                                                            <?php echo FatDate::format($row['opayment_date']); ?>
                                                        </span>
                                                    </div>
                                                    <div class="txt-id">
                                                        <p>
                                                            <strong>
                                                                <?php echo Labels::getLabel('LBL_Transaction_number', $siteLangId); ?>
                                                            </strong>
                                                            <br>
                                                            <?php echo $row['opayment_gateway_txn_id']; ?>
                                                        </p>

                                                    </div>
                                                    <div class="cc-payment">
                                                        <?php echo nl2br($row['opayment_comments']); ?>
                                                        <?php
                                                        $class = '';
                                                        if (Orders::ORDER_PAYMENT_CANCELLED == $row['opayment_txn_status']) {
                                                            $class = "label-danger badge-danger";
                                                        } elseif (Orders::ORDER_PAYMENT_PENDING == $row['opayment_txn_status']) {
                                                            $class = "label-info badge-info";
                                                        } elseif (Orders::ORDER_PAYMENT_PAID == $row['opayment_txn_status']) {
                                                            $class = "label-success badge-success";
                                                        }
                                                        ?>
                                                        <span class="badge badge-inline <?php echo $class; ?>">
                                                            <?php echo $orderStatusArr[$row['opayment_txn_status']]; ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <div class="order-block">
                                    <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                        data-bs-target="#billing-address" aria-expanded="false"
                                        aria-controls="billing-address">
                                        <?php echo Labels::getLabel('LBL_Billing_Details', $siteLangId); ?> : <i
                                            class="dropdown-toggle-custom-arrow"></i>
                                    </h4>
                                    <div class="collapse" id="billing-address">
                                        <div class="order-block-data">
                                            <div class="address-info">
                                                <?php
                                                $billingAddress = '<p>' . $orderDetail['billingAddress']['oua_name'] . '</p>';
                                                if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_address1'] . '</p>';
                                                }

                                                if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_address2'] . '</p>';
                                                }

                                                $billingAddress .= '<p>';

                                                if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                    $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ', ';
                                                }

                                                if ($orderDetail['billingAddress']['oua_state'] != '') {
                                                    $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                }

                                                if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                    $billingAddress .= ', ' . $orderDetail['billingAddress']['oua_zip'];
                                                }
                                                $billingAddress .= '</p>';

                                                if ($orderDetail['billingAddress']['oua_country'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_country'] . '</p>';
                                                }

                                                if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                    $billingAddress .= '<p class="c-info"><strong> <i class="fas fa-mobile-alt mr-2"></i> ' . $orderDetail['billingAddress']['oua_dial_code'] . ' ' . $orderDetail['billingAddress']['oua_phone'] . '</strong></p>';
                                                }
                                                echo $billingAddress;
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if (trim($pickupAddressHtml) != '') { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#pickup-address" aria-expanded="false"
                                            aria-controls="pickup-address">
                                            <?php echo Labels::getLabel('LBL_Pickup_Address:', $siteLangId); ?>
                                            <i class="dropdown-toggle-custom-arrow"></i>
                                        </h4>

                                        <div class="collapse" id="pickup-address">
                                            <?php /* <hr class="dotted"> */ ?>
                                            <div class="order-block-data">
                                                <?php echo $pickupAddressHtml; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if (!empty($verificationFldsData)) { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#verification-data" aria-expanded="false"
                                            aria-controls="verification-data">
                                            <?php echo Labels::getLabel('LBL_Verification_Data', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <?php
                                        $verificationData = [];
                                        foreach ($verificationFldsData as $val) {
                                            $verificationData[$val['ovd_vfld_id']][] = $val;
                                        }
                                        ?>
                                        <div class="collapse" id="verification-data">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <ul class="">
                                                        <?php foreach ($verificationData as $key => $val) { ?>
                                                            <li>
                                                                <span class="label">
                                                                    <?php echo $val[0]['ovd_vflds_name']; ?>
                                                                </span>
                                                                <span class="value text-break">
                                                                    <?php
                                                                    if ($val[0]['ovd_vflds_type'] == VerificationFields::FLD_TYPE_TEXTBOX) {
                                                                        echo (trim($val[0]['ovd_value']) != '') ? $val[0]['ovd_value'] : Labels::getLabel('LBL_N/A', $siteLangId);
                                                                    } else {
                                                                        $downloadUrl = UrlHelper::generateUrl('SellerOrders', 'downloadAttachedFile', array(CommonHelper::encryptId($orderDetail['order_order_id']), CommonHelper::encryptId($val[0]['ovd_vfld_id'])));
                                                                        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_VERIFICATION_ATTACHMENT, $orderDetail['order_order_id'], $val[0]['ovd_vfld_id'], 0, true, 0, false);
                                                                        if (empty($file_row)) {
                                                                            echo Labels::getLabel('LBL_N/A', $siteLangId);
                                                                        } else {
                                                                            echo '<a download href="' . $downloadUrl . '"> ' . $file_row['afile_name'] . '</a>';
                                                                        }
                                                                    }
                                                                    ?>
                                                                </span>
                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php
                                if (!empty($attachment) && $orderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                    ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#signature-data" aria-expanded="false"
                                            aria-controls="signature-data">
                                            <?php echo Labels::getLabel('LBL_Signature', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <div class="collapse" id="signature-data">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <img class="attached-img"
                                                        src="<?php echo CommonHelper::generateUrl('image', 'signature', array($attachment['afile_record_id'], 0, 'ORIGINAL', $attachment['afile_id'], true), CONF_WEBROOT_FRONT_URL); ?>"
                                                        title="<?php echo $attachment['afile_name']; ?>"
                                                        alt="<?php echo $attachment['afile_name']; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php
                                } ?>
                                <?php if (!empty($shopAgreementArr) && 0) { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#rental-agreement" aria-expanded="false"
                                            aria-controls="rental-agreement">
                                            <?php echo Labels::getLabel('LBL_Rental_Agreement', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <div class="collapse" id="rental-agreement">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <ul class="">
                                                        <?php
                                                        foreach ($shopAgreementArr as $key => $val) {
                                                            $afileName = AttachedFile::getAttributesById($val['agreementFileId'], 'afile_name');
                                                            ?>
                                                            <li>
                                                                <span class="label">
                                                                    <?php echo Labels::getLabel('LBL_Shop_Name', $siteLangId); ?>
                                                                </span>
                                                                <span class="value">
                                                                    <?php echo $val['shopName']; ?>
                                                                </span>
                                                            </li>
                                                            <li>
                                                                <span class="label">
                                                                    <?php echo Labels::getLabel('LBL_Shop_Agreement', $siteLangId); ?>
                                                                </span>
                                                                <span class="value">
                                                                    <a download
                                                                        href="<?php echo CommonHelper::generateUrl('Seller', 'downloadDigitalFile', [CommonHelper::encryptId($key), CommonHelper::encryptId($val['agreementFileId']), AttachedFile::FILETYPE_SHOP_AGREEMENT]); ?>"
                                                                        title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                        <?php echo $afileName; ?>
                                                                    </a>
                                                                </span>
                                                            </li>
                                                        <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        
                    </div>
                    <?php
                    if(!empty($orderDetail['partialPaymentLog'])){
                    ?>
                    <div class="row mt-5">
                        <div class="col-md-12">

                            <div class="card">
                                <div class="card-head"><h5 class="card-title"><?php echo Labels::getLabel('LBL_Payment_Log', $siteLangId); ?>   </div>
                                <div class="card-table">
                                <div class="table-responsive table-scrollable js-scrollable tablewrap">
                                    <table class="table table-justified">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Type', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Comment', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Txn_Id', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                                </th>
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            foreach($orderDetail['partialPaymentLog'] as $key => $val){
                                                ?>
                                                <tr>
                                                    <td>
                                                        <?php echo $val['oppl_created_at']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['status_title']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['oppl_comment']; ?>
                                                        <?php
                                                    $attachedFile = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_FLEXI_PAYMENT_ATTACHMENT, $val['oppl_id']);
                                                    if (!empty($attachedFile)) {
                                                        ?>
                                                         <?php
                                                        foreach ($attachedFile as $attach) {
                                                            ?>
                                                            <a class="actions-link" href="<?php echo UrlHelper::generateUrl('Account', 'downloadAttachedFileMsg', array(CommonHelper::encryptId($attach['afile_id']))); ?>" data-bs-toggle='tooltip' data-placement='top' data-original-title='<?php echo $attach['afile_name']; ?>' title='<?php echo $attach['afile_name']; ?>' download>
                       

                                                                <span data-bs-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $attach['afile_name']; ?>"><svg class='svg' width='28' height='28'>
                                                                <use xlink:href=' <?php echo CONF_WEBROOT_URL ?>images/retina/sprite.svg#dash-downloads'></use></svg></span>
                                                            </a>
                                                        <?php }
                                                    } ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['opayment_gateway_txn_id']; ?>
                                                    </td>
                                                    <td>
                                                        
                                                        <?php 
                                                        if($key == 0){
                                                            echo  CommonHelper::displayMoneyFormat(($val['oppl_amount']+$orderDetail['op_discount_total']), true, false, true, false, true) ; 
                                                            $txtCoupon = Labels::getLabel('MSG_Upfront_paid_%s_+_Discount_beared_by_platform_%s', $siteLangId);
                                                            $txtCoupon = sprintf($txtCoupon, CommonHelper::displayMoneyFormat($val['oppl_amount'], true, false, true, false, true), CommonHelper::displayMoneyFormat($orderDetail['op_discount_total'], true, false, true, false, true));
                                                            if($orderDetail['op_discount_total'] > 0){
                                                                echo '&nbsp;<svg width="14px" height="14px" data-bs-toggle="tooltip" data-bs-html="true" data-placement="right" title="'.$txtCoupon.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 9.5C12.8284 9.5 13.5 8.82843 13.5 8C13.5 7.17157 12.8284 6.5 12 6.5C11.1716 6.5 10.5 7.17157 10.5 8C10.5 8.82843 11.1716 9.5 12 9.5ZM14 15H13V10.5H10V12.5H11V15H10V17H14V15Z"></path></svg>';
                                                            }
                                                        }else{
                                                            echo  CommonHelper::displayMoneyFormat($val['oppl_amount'], true, false, true, false, true) ; 
                                                        }
                                                        

                                                        ?>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                            ?>
                                        </tbody>
                                        <thead>
                                            <tr>
                                            <td colspan="6">
                                                    <strong>
                                                    <?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>&nbsp;&nbsp;: &nbsp;&nbsp;&nbsp;
                                                    <?php echo CommonHelper::displayMoneyFormat($orderDetail['op_pending_amount'], true, false, true, false, true) ?>
                                                    </strong>
                                                </td>

                                               
                                            </tr>
                                        </thead></div>
                                </table></div>
                                </div>
                            </div>

                                
                            </div>
                        </div>
                        <?php } ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php if ($totalSecurityAmount > 0) { ?>
    <!-- Modal -->
    <div class="modal fade" id="security_modal" tabindex="-1" role="dialog" aria-labelledby="securityModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="securityModalLabel">
                        <?php echo Labels::getLabel('LBL_Security_List', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $securityHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($totalSecurityAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($taxOptionsHtml != '') { ?>
    <div class="modal fade" id="tax_modal" tabindex="-1" role="dialog" aria-labelledby="taxModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="taxModalLabel">
                        <?php echo Labels::getLabel('LBL_Tax_List', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $taxOptionsHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <?php if ($roundingOffTotal != 0) { ?>
                        <div class="row w-100">
                            <div class="col">
                                <span>
                                    <?php echo ($roundingOffTotal > 0) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>
                                    :
                                </span>
                            </div>
                            <div class="col-auto">
                                <span>
                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                </span>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($totalTaxes, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($isShipping) { ?>
    <div class="modal fade" id="shipping_modal" tabindex="-1" role="dialog" aria-labelledby="shippingModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shippingModalLabel">
                        <?php echo Labels::getLabel('LBL_Shipping_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $shippingHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($volumnDiscountAmount != 0) { ?>
    <div class="modal fade" id="volume_modal" tabindex="-1" role="dialog" aria-labelledby="volumeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="volumeModalLabel">
                        <?php echo Labels::getLabel('LBL_Volume_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $volumnDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($volumnDiscountAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php } ?>
<?php if ($durationDiscountAmount != 0) { ?>
    <div class="modal fade" id="duration_discount_modal" role="dialog" aria-labelledby="durationDiscountModalLabel"
        aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="durationDiscountModalLabel">
                        <?php echo Labels::getLabel('LBL_Duration_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $durationDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($durationDiscountAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($couponDiscount != 0) { ?>
    <div class="modal fade" id="discount_modal" role="dialog" aria-labelledby="discountModalLabel" aria-hidden="true"
        tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="discountModalLabel">
                        <?php echo Labels::getLabel('LBL_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $couponDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($couponDiscount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if (!empty($attachedServices)) { ?>
    <div class="modal fade" id="addon_modal" role="dialog" aria-labelledby="addonModalLabel" aria-hidden="true"
        tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addonModalLabel">
                        <?php echo Labels::getLabel('LBL_Addons_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Addon_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $addonAmountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($addonTotal, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
    <?php if ((Shipping::FULFILMENT_PICKUP == $orderDetail['opshipping_fulfillment_type']) && (!empty($orderDetail['checklistPoints']) && array_key_exists(7, $orderDetail['checklistPoints']))) { ?>
        <div class="modal fade" id="shipped_checklist_points_modal" role="dialog" aria-labelledby="shippedChecklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="shippedChecklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_DELIVERED])) { ?>
                                <table class="table">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId); ?></th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_DELIVERED] as $sku => $selectedChecklistPoints) {
                                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="modal-footer px-0">
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <?php if (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_SHIPPED, $orderDetail['checklistPoints'])) { ?>
        <div class="modal fade" id="shipped_checklist_points_modal" role="dialog" aria-labelledby="shippedChecklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="shippedChecklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED])) { ?>
                                <table class="table">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId); ?></th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED] as $sku => $selectedChecklistPoints) {
                                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="modal-footer px-0">
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <?php if (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_RENTAL_RETURNED, $orderDetail['checklistPoints'])) { ?>
        <div class="modal fade" id="returned_checklist_points_modal" role="dialog" aria-labelledby="checklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="checklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED])) { ?>
                                <table class="table rental-returned">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId) . ' (' . Labels::getLabel('LBL_SHIPPED', $siteLangId) . ')'; ?>
                                        </th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId) . ' (' . Labels::getLabel('LBL_RENTAL_RETURNED', $siteLangId) . ')'; ?>
                                        </th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED] as $key => $selectedChecklistPoints) {

                                            $shippedValue = "";
                                            if (array_key_exists(OrderStatus::ORDER_SHIPPED, $orderDetail['checklistPoints'])) {
                                                if ($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                                    $shippedValue = implode(', ', explode(PHP_EOL, $orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value']));
                                                } else {
                                                    $shippedValue = $orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value'];
                                                }
                                            }

                                            $value = "";
                                            if ($selectedChecklistPoints['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                                $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            } else {
                                                $value = $selectedChecklistPoints['opcp_cp_value'];
                                            }
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <?php if (!empty($shippedValue)) { ?>
                                                        <span class="value"><?php echo $shippedValue; ?></span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="modal-footer px-0">
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
<?php } ?>

<?php
if(!empty($orderDetail['opd_price_bifurcation'])) { 
$childOpId = $orderDetail['op_id'];
$rentalPriceDetail = json_decode(html_entity_decode($orderDetail['opd_price_bifurcation']), true);
$quantity = $orderDetail['op_qty'];
?>
	<div class="modal fade" id="price-bifurcation-<?php echo $childOpId; ?>" tabindex="-1" role="dialog" aria-labelledby="priceDetailLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="priceDetailLabel">
                        <?php echo Labels::getLabel('LBL_Price_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body">
                    <?php 
					include(CONF_DEFAULT_THEME_PATH . '_partial/product/price-breakup.php'); 
					?>
                </div>
            </div>
        </div>
    </div>
	<script>
	var child_op_id = '<?php echo $childOpId; ?>';
	$('#price-bifurcation-'+child_op_id).insertAfter('.wrapper');
	</script>
<?php } ?>

<script>
    var canShipByPlugin = <?php echo (true === $canShipByPlugin ? 1 : 0); ?>;
    var orderShippedStatus = <?php echo OrderStatus::ORDER_SHIPPED; ?>;

    var SHIPPING_STATUS = <?php echo FatApp::getConfig("CONF_DEFAULT_SHIPPING_ORDER_STATUS"); ?>;
    var RENTAL_RETURN_STATUS = <?php echo FatApp::getConfig("CONF_DEFAULT_RENTAL_RETURNED_ORDER_STATUS"); ?>;
    var PRODUCT_CATEGORY_ID = <?php echo $orderDetail['prodcat_id']; ?>;
    var SHIPPED_STATUS_ID = <?php echo OrderStatus::ORDER_SHIPPED; ?>;
    var DELIVERED_STATUS_ID = <?php echo OrderStatus::ORDER_DELIVERED; ?>;
    var RENTAL_RETURNED_STATUS_ID = <?php echo OrderStatus::ORDER_RENTAL_RETURNED; ?>;
    var requiredChecklist = false;

    $('#security_modal').insertAfter('.wrapper');
    $('#tax_modal').insertAfter('.wrapper');
    $('#shipping_modal').insertAfter('.wrapper');
    $('#volume_modal').insertAfter('.wrapper');
    $('#duration_discount_modal').insertAfter('.wrapper');
    $('#discount_modal').insertAfter('.wrapper');
    $('#addon_modal').insertAfter('.wrapper');
    $('#shipped_checklist_points_modal').insertAfter('.wrapper');
    $('#returned_checklist_points_modal').insertAfter('.wrapper');

    $(document).ready(function () {
        $('input[name="opd_mark_rental_return_date"]').datetimepicker({
        /* minDate: new Date('<?php echo date('Y-m-d 00:00:00', strtotime($orderDetail['opd_rental_start_date'])); ?>'), */
        maxDate: new Date('<?php echo date('Y-m-d H:i:s'); ?>')
        });
    });
</script>

<?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
    <script>
        $("select[name='op_status_id']").change(function () {
            requiredChecklist = false;
            let selectedStatusId = $("select[name='op_status_id']").val();
            if (selectedStatusId == SHIPPED_STATUS_ID || selectedStatusId == DELIVERED_STATUS_ID || selectedStatusId ==
                RENTAL_RETURNED_STATUS_ID) {
                var data = {
                    selectedStatusId: selectedStatusId,
                    opId: $("input[name='op_id']").val(),
                    prodCatId: PRODUCT_CATEGORY_ID,
                    parentOpID: $("input[name='opd_extend_from_op_id']").val(),
                };
                fcom.ajax(fcom.makeUrl('SellerOrders', 'getChecklistPoints'), data, function (t) {
                    var response = $.parseJSON(t);
                    $("#checklist_points").remove();
                    if (response && Object.keys(response.checklistData).length > 0) {
                        requiredChecklist = true;
                        $("#comments_wrapper").closest('.row').after(response.html);
                    }
                });
            } else {
                $("#checklist_points").remove();
            }
        });
    </script>
<?php } ?>

<style>
    .disabled-input {
        color: rgba(0, 0, 0, 0.38) !important;
        background-color: rgba(0, 0, 0, 0.12) !important;
        box-shadow: none;
        cursor: initial;
        border-color: transparent !important;
    }

    .sub-heading {
        font-size: 60%;
        text-align: right;
    }

    #checklist_options .checklist-fld-body .field-set {
        display: inline-block;
    }

    #checklist_options .checklist-fld-body .field-wraper {
        display: inline-block;
        margin-left: 2rem;
    }

    #returned_checklist_points_modal .modal-content,
    #shipped_checklist_points_modal .modal-content {
        max-height: 660px;
    }

    #returned_checklist_points_modal .modal-body,
    #shipped_checklist_points_modal .modal-body {
        overflow: auto;
    }

    #checklist_options .field-wraper {
        align-content: center;
    }

    .table tr td {
        position: relative;
        max-width: 5rem;
    }

    .table .sku-heading {
        font-weight: 600;
        line-height: 0.5;
        background: #efefef;
    }

    .checklist-fld-body {
        padding: 0.5rem;
        display: flex;
    }

    .checklist-form-section {
        background-color: #f2f7ff;
        margin-top: 15px;
        padding: 0.5rem;
    }

    .checklist-form-section .form-heading {
        font-weight: 600;
    }
</style>