<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
if (empty($orderDate)) {
    $frmSrch->setFormTagAttribute('onSubmit', 'searchSalesReport(this); return false;');
    $frmSrch->setFormTagAttribute('class', 'form form-search');
    $frmSrch->developerTags['colClassPrefix'] = 'col-md-';
    $frmSrch->developerTags['fld_default_col'] = 4;


    $submitBtnFld = $frmSrch->getField('btn_submit');
    $submitBtnFld->setFieldTagAttribute('class', 'btn-block');
    $submitBtnFld->developerTags['col'] = 2;

    $cancelBtnFld = $frmSrch->getField('btn_clear');
    $cancelBtnFld->setFieldTagAttribute('class', 'btn-block');
    $cancelBtnFld->developerTags['col'] = 2;
}
?>

<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading">
                    <?php if (!empty($orderDate)) { ?>
                        <a class="btn btn-back"
                            title="<?php echo Labels::getLabel('LBL_Back_To_sales_Reports', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Reports', 'SalesReport'); ?>">
                            <svg class="svg" width="24" height="24">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                                </use>
                            </svg>
                        </a>
                    <?php } ?>
                    <?php echo Labels::getLabel('LBL_Sales_Report', $siteLangId); ?>
                </h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <?php
                    echo '<button type="button" class="btn btn-outline-gray qwer" onClick="exportSalesReport()" > <svg class="svg" width="18" height="18">
                    <use xlink:href="/images/dashboard/retina/sprite.svg#export">
                    </use>
                    </svg>' . Labels::getLabel('LBL_Export', $siteLangId) . '</button>';
                    ?>
                </div>
            </div>
        </div>
        <div class="content-form">
            <?php if (empty($orderDate)) { ?>
                <?php
                $frmSrch->setFormTagAttribute('class', 'form form-search');
                $submitFld = $frmSrch->getField('btn_submit');
                $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
                $fldClear = $frmSrch->getField('btn_clear');
                $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
                echo $frmSrch->getFormHtml();
                ?>

                <?php
            } else {
                echo $frmSrch->getFormHtml();
            }
            ?>

        </div>
        <div class="content-body">

            <div class="card">
                <p class="text-centeer p-3"><strong
                        class="text-danger"><?php  /* echo Labels::getLabel('LBL_Note', $siteLangId); ?> ::
<?php echo Labels::getLabel('LBL_We_have_not_considered_impact_of_cancels_in_this_report.', $siteLangId); */ ?></strong>
                </p>
                <div class="card-table">
                    <div class="listing-tbl" id="listingDiv">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>