<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?> <?php $this->includeTemplate('_partial/dashboardNavigation.php'); ?> <main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title"> <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Products_Performance_Report', $siteLangId); ?></h2>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <?php if ($reportType == 3) { ?>
                    <button type="button" class="btn btn-outline-gray qwer" id="performanceReportExport" onclick="exportMostFavProdReport()"><svg class="svg" width="18" height="18">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#export">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_Export', $siteLangId); ?></button>
                    <?php } else { ?>
                    <button type="button" class="btn btn-outline-gray qwer" id="performanceReportExport" onclick="exportProdPerformanceReport(<?php echo $reportType; ?>)"><svg class="svg" width="18" height="18">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#export">
                            </use>
                        </svg><?php echo Labels::getLabel('LBL_Export', $siteLangId); ?></button>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="content-body">

            
            <div class="card card-tabs">
                <div class="card-head">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs setactive-js">
                        <li class="nav-item <?php echo ($reportType == 1) ? "is-active" : ""; ?>"><a class="nav-link" href="<?php echo UrlHelper::generateUrl('Reports', 'ProductsPerformance', [1]); ?>"><?php echo Labels::getLabel('LBL_Top_Performing_Products', $siteLangId); ?></a></li>
                        <li class="nav-item <?php echo ($reportType == 2) ? "is-active" : ""; ?>"><a class="nav-link" href="<?php echo UrlHelper::generateUrl('Reports', 'ProductsPerformance', [2]); ?>"><?php echo Labels::getLabel('LBL_Most_Refunded_Products_Report', $siteLangId); ?></a></li>
                        <li class="nav-item <?php echo ($reportType == 3) ? "is-active" : ""; ?>"><a class="nav-link" href="<?php echo UrlHelper::generateUrl('Reports', 'ProductsPerformance', [3]); ?>"><?php echo Labels::getLabel('LBL_Most_WishList_Added_Products', $siteLangId); ?></a></li>
                    </ul>
                </div>
                <?php if ($reportType != 3) { ?>
                <div class="card-body search-section--js">
                    <?php
                        $srchFrm->setFormTagAttribute('onSubmit', 'productPerformanceSrch(this); return false;');
                        $srchFrm->setFormTagAttribute('class', 'form form-search');
                        $srchFrm->developerTags['colClassPrefix'] = 'col-md-';
                        $srchFrm->developerTags['fld_default_col'] = 3;
			
						if(ALLOW_SALE) {
							$sortFld = $srchFrm->getField('sort_by');
							$sortFld->developerTags['col'] = 2;
						}

                        $submitFld = $srchFrm->getField('btn_submit');
                        $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
                        $submitFld->developerTags['col'] = 2;
                        $fldClear = $srchFrm->getField('btn_clear');
                        $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
                        $fldClear->developerTags['col'] = 2;
                        echo $srchFrm->getFormHtml();
                        ?>
                </div>
                <?php } ?>
            </div>
           
            <div class="card">
                <div class="card-table">
                    <div id="listingDiv">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
var REPORT_TYPE = <?php echo $reportType ?>;
</script>