<?php defined('SYSTEM_INIT') or die('Invalid Usage.');?>
<ul class="list-group list-shipping">
    <?php if (!empty($locationsData)) {
        foreach ($locationsData as $countryId => $zoneLocations) {
            $zoneLocationData = $zoneLocations['locations'];
          
            foreach ($zoneLocationData as $zoneId => $countryLocs) {
                $statesArr = array_column($countryLocs, 'state_name');
                $shipRates = (isset($shipRatesData[$zoneId])) ? $shipRatesData[$zoneId] : array();
    ?>
                <li class="list-group-item zoneRates-js mt-3 border-top">
                    <div class="row justify-content-between">
                        <div class="col">
                            <div class="shipping-states">
                                <span class="box-icon">
                                    <svg class="svg" width="16" height="16">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#ri-global-fill"></use>
                                    </svg>
                                </span>
                                <div class="detail">
                                    <h6>
                                    <?php 
                                        if ($countryId == -1) {
                                            if (CommonHelper::isDistanceShippingEnabled()) {
                                                echo Labels::getLabel('LBL_Shipable_to_This_Address', $siteLangId);
                                            } else {
                                                echo Labels::getLabel('LBL_Shipable_to_All_Locations', $siteLangId);
                                            }
                                        } else {
                                            echo $zoneLocations['country_name'];
                                        } 
                                    ?>
                                    </h6>
                                    <?php if ($countryId != -1) { ?>
                                        <div><small><?php echo implode(', ', $statesArr); ?></small></div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (!empty($shipRates)) { ?>
                        <div class="scroll scroll-x js-scrollable table-wrap">
                            <table class="table table-justified table-rates mt-3">
                                <thead>
                                    <tr>
                                        <th><?php echo Labels::getLabel("LBL_Rate_Name", $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel("LBL_Duration(Days)", $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel("LBL_Cost", $siteLangId); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($shipRates as $rate) { ?>
                                        <tr>
                                            <td><?php echo $rate['shiprate_rate_name']; ?>
                                            </td>
                                            <td><?php echo $rate['shiprate_min_duration'] . ' (' . Labels::getLabel("LBL_Days", $siteLangId) . ')'; ?></td>
                                            <td>
                                                <?php if (CommonHelper::isDistanceShippingEnabled()) { ?>
                                                    <?php echo CommonHelper::displayMoneyFormat($rate['totalCost']); ?>
                                                <?php } else { ?>
                                                    <?php echo CommonHelper::displayMoneyFormat($rate['shiprate_cost']); ?>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    <?php } ?>
                </li>
        <?php }
        }
    } else { ?>
        <li class="list-group-item zoneRates-js">
            <div class="row justify-content-between">
                <div class="col">
                    <div class="shipping-states">
                        <span class="box-icon">
                            <svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#ri-global-fill"></use>
                            </svg>
                        </span>
                        <div class="detail">
                            <h6><?php echo Labels::getLabel('LBL_Not_Shipable', $siteLangId); ?></h6>
                        </div>
                    </div>
                </div>
            </div>
        </li>
    <?php } ?>
</ul>