<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$colMdVal = isset($colMdVal) ? $colMdVal : 3;
$displayProductNotAvailableLable = false;
if (trim(FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '')) != '') {
    $displayProductNotAvailableLable = true;
}

$session = (isset($_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products'])) ? $_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products'] : [];
$rentalTypeArr = applicationConstants::rentalTypeArr($siteLangId);

?>
<div class="listing-products -listing-products">
    <div id="productsList" class="listing-products--grid">
        <?php
        if ($products) { ?>
            <div class="product-listing" data-view="<?php echo $colMdVal; ?>">
                <?php
                $showActionBtns = !empty($showActionBtns) ? $showActionBtns : false;
                $isWishList = isset($isWishList) ? $isWishList : 0;
                ?>
                <?php
                foreach ($products as $product) {
                    $productUrl = UrlHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                    $extraClsss = '';
                    ?>
                    <div class="product">
                        <div class="product-head">

                            <button type="button" onclick="removeFavProduct(<?php echo $product['selprod_id']; ?>)"
                                class="close-layer"></button>

                            <?php $uploadedTime = AttachedFile::setTimeParam($product['product_updated_on']); ?>


                        </div>

                        <div class="product-body">
                            <a class="product-img" aria-label="" title="<?php echo $product['selprod_title']; ?>"
                                href="<?php echo !isset($product['promotion_id']) ? UrlHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : UrlHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>">
                                <picture>
                                    <img loading='lazy'
                                        src="<?php echo UrlHelper::getCachedUrl(CommonHelper::generateUrl('image', 'product', array($product['product_id'], (isset($prodImgSize) && isset($i) && ($i == 1)) ? $prodImgSize : "AUTOCLAYOUT3", $product['selprod_id'], 0, $siteLangId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                        alt="<?php echo $product['prodcat_name']; ?>">
                                </picture>
                            </a>
                            <?php
                            $selprod_condition = true;
                            ?>
                        </div>

                        <div class="product-foot">
                            <a class="product-category" aria-label=""
                                href="<?php echo UrlHelper::generateUrl('Category', 'View', array($product['prodcat_id'])); ?>"><?php echo $product['prodcat_name']; ?>
                            </a>
                            <a class="product-name" aria-label="" title="<?php echo $product['selprod_title']; ?>"
                                href="<?php echo !isset($product['promotion_id']) ? UrlHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : UrlHelper::generateUrl('Products', 'track', array($product['promotion_record_id'])); ?>"><?php echo (mb_strlen($product['selprod_title']) > 50) ? mb_substr($product['selprod_title'], 0, 50) . "..." : $product['selprod_title']; ?>
                            </a>
                            <div class="product-price-block">
                                <!-- <div class="product-price">
                                    <div class="product-prices-per-day">
                                        <?php echo CommonHelper::displayMoneyFormat($product['rent_price']); ?>
                                        <span>
                                            <?php echo $rentalTypeArr[$product['sprodata_duration_type']]; ?>
                                        </span>
                                    </div>
                                </div> -->

                                <div class="product-price">
                                    <?php echo CommonHelper::displayMoneyFormat($product['theprice']); ?>
                                    <span>/
                                        <?php echo $rentalTypeArr[$product['sprodata_duration_type']]; ?>
                                    </span>
                                    <?php if ($product['special_price_found'] && $product['rent_price'] > $product['theprice']) { ?>
                                        <span class="slash">|</span>
                                        <del class="product-price-old">
                                            <?php echo CommonHelper::displayMoneyFormat($product['rent_price']); ?>
                                        </del>
                                        <span class="slash">&nbsp;</span>
                                        <span class="product-price-off">
                                            <?php echo CommonHelper::showProductDiscountedText($product, $siteLangId); ?>
                                        </span>
                                    <?php } ?>
                                </div>
                                <a class="btn btn-brand btn-round" aria-label=""
                                    href="<?php echo UrlHelper::generateUrl('products', 'view', [$product['selprod_id']]); ?>"><?php echo Labels::getLabel('LBL_RENT_NOW', $siteLangId); ?></a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>


            <?php
            $searchFunction = 'goToProductListingSearchPage';
            if (isset($pagingFunc)) {
                $searchFunction = $pagingFunc;
            }

            $postedData['page'] = (isset($page)) ? $page : 1;
            $postedData['recordDisplayCount'] = $recordCount;
            echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
            $pagingArr = array('pageCount' => $pageCount, 'page' => $postedData['page'], 'recordCount' => $recordCount, 'callBackJsFunc' => $searchFunction, 'removePageCentClass' => 1, 'siteLangId' => $siteLangId, 'pageSize' => $pageSize, 'removePageCentClass' => true); ?>
            <div class="collection-pager">
                <?php
                $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
                if (!isset($removePageSize)) {
                    ?>
                    <select name="pageSizeSelect" id="pageSizeSelect" class="custom-select sorting-select">
                        <?php foreach ($pageSizeArr as $key => $val) { ?>
                            <option value="<?php echo $key; ?>" <?php echo ($key == $pageSize) ? 'selected' : ''; ?>>
                                <?php echo $val; ?>
                            </option>
                        <?php } ?>
                    </select>
                <?php } ?>
            </div>

        <?php } else { ?>
            <?php
            $arr['recordDisplayCount'] = $recordCount;
            echo FatUtility::createHiddenFormFromData($arr, array('name' => 'frmProductSearchPaging', 'id' => 'frmProductSearchPaging'));
            $message = Labels::getLabel('LBL_No_Records_Found', $siteLangId);
            $this->includeTemplate('_partial/no-record-found.php', array('siteLangId' => $siteLangId, 'message' => $message));
            ?>
        <?php }
        ?>
    </div>
    <script>
        $(document).ready(function () {
            var e = document.getElementById("pageSizeSelect");
            if (e != undefined && e != null) {
                var pageSize = e.options[e.selectedIndex].value;
                $('#pageSize').val(pageSize);
            }
        })
    </script>
    <?php
    if (isset($postedData['vtype']) && $postedData['vtype'] == 'map') {
        foreach ($productsByShop as &$marker) {
            $contentString = '<ul>';
            foreach ($marker['products'] as $product) {
                $contentString .= '<li>
            <figure class="product-profile">
            <div class="product-profile-thumbnail"><img class="product-img" src="pic_trulli.jpg" alt="Trulli"></div>
  <figcaption class="product-name"><a href="' . $product['url'] . '">' . html_entity_decode($product['name']) . '</a></figcaption>
</figure>
            </li>';
            }
            $contentString .= '</ul>';
            unset($marker['products']);
            $marker['content'] = $contentString;
        }
        ?>
        <script>
            var markers = <?php echo json_encode($productsByShop); ?>;
            $( window ).on("load", function () {
                if (typeof map == 'undefined') {
                    setTimeout(()=>{
                        initMutipleMapMarker(markers, 'productMap--js', "<?php echo $lat; ?>", "<?php echo $lng; ?>", dragCallback);
                    },1000);
                } else {
                    clearMarkers();
                    createMarkers(markers);
                }
            });
        </script>
    <?php } ?>

    <style>
        .product-price del, .product-price-off {
            color: rgba(0, 0, 0, 0.97);
            font-size: 0.8rem;
            font-weight: 300;
        }
        .label {
            font-size: 0.75rem;
            font-weight: 400;
            padding: 4px 8px;
            text-align: center;
            white-space: nowrap;
            display: inline-block;
            border-radius: 3px;
        }
    </style>