<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$langFrm->setFormTagAttribute('class', 'web_form form_horizontal layout--' . $formLayout);
$langFrm->setFormTagAttribute('onsubmit', 'setupLangReason(this); return(false);');
$langFrm->developerTags['colClassPrefix'] = 'col-md-';
$langFrm->developerTags['fld_default_col'] = 12;

$langFld = $langFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "editReasonLangForm(" . $reasonId . ", this.value);");
?>
<div class="card">
    <div class="card-head">
        <h4><?php echo Labels::getLabel('LBL_Order_Cancel_Reason_Setup', $adminLangId); ?></h4>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-sm-12">
                <h1>
                    <?php //echo Labels::getLabel('LBL_Order_Cancel_Reason_Setup',$adminLangId); 
                    ?>
                </h1>

                <ul class="tabs_nav">
                    <li><button type="button" onclick="editReasonForm(<?php echo $reasonId ?>);"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></button></li>
                    <li class="<?php echo (0 == $reasonId) ? 'fat-inactive' : ''; ?>">
                        <button class="active">
                            <?php echo Labels::getLabel('LBL_Language_Data', $adminLangId); ?>
                        </button>
                    </li>
                </ul>
                <div class="tabs-panel_wrap">
                    <?php
                    $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                    $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
                    if (!empty($translatorSubscriptionKey) && $lang_id != $siteDefaultLangId) { ?>
                        <div class="row justify-content-end">
                            <div class="col-auto mb-4">
                                <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="editReasonLangForm(<?php echo $reasonId; ?>, <?php echo $lang_id; ?>, 1)">
                                    <svg class="svg" width="24" height="24">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="tabs-panel">
                        <?php echo $langFrm->getFormHtml(); ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>