<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo Labels::getLabel('LBL_Cancellation_Penalty_Rules', $siteLangId); ?>
                </h2>
                <span class="form-text text-muted">(
                    <?php echo Labels::getLabel('LBL_Valid_Only_With_Rental_Orders', $siteLangId); ?>)
                </span>
                <?php
                if (!empty($warningMsg)) {
                    echo "<div class='row mt-3'><div class='col-md-12'><h6>" . Labels::getLabel('LBL_Slots_Are_Missing_For_Following_Duartions', $siteLangId) . "</h6>
                    <ul class='missing-duration'>";
                    foreach ($warningMsg as $msg) {
                        echo '<li class="text-danger">' . $msg . '</li>';
                    }
                    echo "</ul>
                    <small class='form-text text-muted'>" . Labels::getLabel('LBL_For_Missing_Slots_100%_Refund_will_be_initiated.', $siteLangId) . "</small>
                    </div></div>";
                }
                ?>
            </div>
        </div>
        <div class="content-form">

            <?php
            if ($canEdit) {
                ?>

            <div id="ruleForm--js">
                <?php $this->includeTemplate('order-cancel-rules/form.php', array('siteLangId' => $siteLangId, 'frm' => $frm, 'isInfinty' => 0), false); ?>
            </div>
            <?php } ?>
            <?php
            $changeRuleTitle = Labels::getLabel('LBL_Enable_All_Rules', $siteLangId);
            $statusToChange = applicationConstants::ACTIVE;
            if (!empty($data) && $data[0]['ocrule_active'] == applicationConstants::ACTIVE) {
                $changeRuleTitle = Labels::getLabel('LBL_Disable_All_Rules', $siteLangId);
                $statusToChange = applicationConstants::INACTIVE;
            } ?>
        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-head">
                    <div class="btn-group">
                        <?php
                        if ($canEdit) {
                            ?>
                        <button type="button" class="btn btn-outline-gray qwer" title="<?php echo $changeRuleTitle; ?>"
                            onclick="changeCancelRuleStatus(<?php echo $statusToChange; ?>)">
                            <?php echo $changeRuleTitle; ?>
                        </button>
                        <?php } ?>
                        <button type="button" class="btn btn-outline-gray qwer"
                            title="<?php echo Labels::getLabel('LBL_View_Admin_Rules', $siteLangId); ?>"
                            onclick="viewAdminRules()">

                            <?php echo Labels::getLabel('LBL_View_Admin_Rules', $siteLangId); ?>
                        </button>
                        <?php
                        if ($canEdit) {
                            ?>
                        <button type="button" class="btn btn-outline-gray qwer formActionBtn-js formActions-css"
                            title="<?php echo Labels::getLabel('LBL_Delete_Rules', $siteLangId); ?>"
                            onclick="deleteSelected()">

                            <?php echo Labels::getLabel('LBL_REMOVE', $siteLangId); ?>
                        </button>
                        <?php } ?>
                    </div>
                </div>
                <div class="card-table">
                    <div id="listing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
    @media only screen and (max-width:390px) {
        .mobile-table .th , .mobile-table td{
            padding: 0.5rem 0 0.5rem 0.5rem;
        }
        .mobile-table thead th {
            padding: 1rem 0;
        }

        .btn.qwer {
            height: revert-layer;
            line-height: 1.5;
        }
        .actions-link.mobile-btn {
            width: 20px;
            height: 20px;
        }
    }
</style>