IS_PRODUCT_LISTING = true;
var searchArr = [];
var page = 1;
var dragTimeOutEvent;
$(document).ready(function () {
  /* [is use to reload page when user hit back button */
  $(window).on("popstate", function () {
    location.reload(true);
  });
  /* is use to reload page when user hit back button] */

  var frm = document.frmProductSearch;

  var frmSiteSearch = document.frmSiteSearch;
  $(frmSiteSearch.keyword).val($(frm.keyword).val());
  setSelectedCatValue($(frm.category).val());

  $.each(frm.elements, function (index, elem) {
    if (
      elem.type != "text" &&
      elem.type != "textarea" &&
      elem.type != "hidden" &&
      elem.type != "submit"
    ) {
      /* i.e for selectbox */
      $(elem).change(function () {
        reloadProductListing(frm);
        /*searchProducts(frm,0,0,1);*/
      });
    }
  });
  /* ] */

  /* form submit upon onchange of elements not inside form tag[ */
  if (typeof isBrandPage !== "undefined" && isBrandPage !== null) {
    $("input[name=brands]").attr("disabled", "disabled");
    $("input[name=brands]").parent("label").addClass("disabled");
  }

  /* PRODUCT TYPE SEARCH [ */
  $(document).on("change", "input[name=producttype]", function () {
    var id = $(this).parent().find("label").attr("id");
    resetListingFilter();
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    window.location.reload();
    /* reloadProductListing(frm); */
  });

  /* ] */

  $(document).on("change", "input[name=brands]", function () {
    var id = $(this).attr("data-id");
    var val = $(this).val();
    var title = $(this).attr("data-title");
    if ($(this).is(":checked")) {
      if ($("#" + id).length == 0) {
        /* $('ul.brandFilter-js').prepend('<li><label class="checkbox brand" id="brand_' + val + '"><input name="brands" data-id="brand_' + val + '" value="' + val + '" data-title="' + title + '" type="checkbox" checked="true"><i class="input-helper">' + title + '</i><label></li>'); */
        $("ul.brandFilter-js").prepend(
          '<li><label class="checkbox brand" id="brand_' +
            val +
            '"><input name="brands" data-id="brand_' +
            val +
            '" value="' +
            val +
            '" data-title="' +
            title +
            '" type="checkbox"><span class="lb-txt">' +
            title +
            '</span></label></li>'
        );
      }

      $("input:checkbox[name=brands]").each(function () {
        if ($(this).attr("data-id") == id) {
          $(this).prop("checked", true);
        }
      });
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      $("input:checkbox[name=brands]").each(function () {
        if ($(this).attr("data-id") == id) {
          $(this).prop("checked", false);
        }
      });
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
    /* //searchProducts(frm,0,0,1,1); */
  });

  $(document).on("change", "input[name=category]", function () {
    var id = $(this).parent().parent().find("label").attr("id");
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
    /* //searchProducts(frm,0,0,1,1); */
  });

  $(document).on("change", "input[name=optionvalues]", function () {
    var id = $(this).parent().parent().find("label").attr("id");
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
    /* //searchProducts(frm,0,0,1,1); */
  });

  $(document).on("change", "input[name=conditions]", function () {
    var id = $(this).parent().parent().find("label").attr("id");
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
    /* //searchProducts(frm,0,0,1,1); */
  });

  $(document).on("change", "input[name=free_shipping]", function () {
    alert("Pending...");
  });

  $(document).on("change", "select[name=pageSizeSelect]", function () {
    var selectedVal = $(this).val();
    $("#pageSize").val(selectedVal);
    removePageSideFromLink();
    removePaginationFromLink();
    reloadProductListing();
  });

  $(document).on("change", "input[name=pageSize]", function () {
    removePageSideFromLink();
    removePaginationFromLink();
    reloadProductListing();
  });

  $(document).on("change", "select[name=sortBy]", function () {
    removePageSideFromLink();
    removePaginationFromLink();
    reloadProductListing();
  });

  $(document).on("change", "input[name=out_of_stock]", function () {
    var id = $(this).parent().parent().find("label").attr("id");
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
    /* //searchProducts(frm,0,0,1,1); */
  });

  $(document).on("change", "input[name=priceFilterMinValue]", function (e) {
    validatePriceFilter();
    e.preventDefault();
    removePaginationFromLink();
    addPricefilter(true);
  });

  $(document).on("change", "input[name=priceFilterMaxValue]", function (e) {
    validatePriceFilter();
    e.preventDefault();
    removePaginationFromLink();
    addPricefilter(true);
  });

  /* $(document).on('keyup', 'input[name=priceFilterMinValue]', function (e) {
        var code = e.which;
        if (code == 13) {
            e.preventDefault();
            removePaginationFromLink();
            addPricefilter(true);
        }
    });

    $(document).on('keyup', 'input[name=priceFilterMaxValue]', function (e) {
        var code = e.which;
        if (code == 13) {
            e.preventDefault();
            removePaginationFromLink();
            addPricefilter(true);
        }
    }); */

  /* ] */

  $(window).on("load", function () {
    showSelectedFilters();
    initialize();
  });

  /* for toggling of grid/list view[ */

  $(document).on("click", ".list-grid-toggle", function () {
    /* //   var txt = $(".icon").hasClass('icon-grid') ? 'List' : 'Grid'; */
    $(".icon").toggleClass("icon-grid");
    if ($(".icon").hasClass("icon-grid")) {
      $("#productsList")
        .removeClass("listing-products--grid")
        .addClass("listing-products--list");
    } else {
      $("#productsList")
        .removeClass("listing-products--list")
        .addClass("listing-products--grid");
    }
    /* $(".label").text(txt); */
  });

  $(document).on("click", ".listing-grid-toggle--js", function () {
    $(".switch--link-js li").removeClass("active");
    var viewType = $(this).data("viewtype");

    var oldView = $("form[name=frmProductSearch] input[name=vtype]").val();
    $("form[name=frmProductSearch] input[name=vtype]").val(viewType);

    /* reload page if previsous views is map */
    if (oldView == "map") {
      window.location.href = getSearchQueryUrl(true);
    }
    $(this).parent("li").addClass("active");
    if (viewType == "list") {
      $("#productsList")
        .removeClass("listing-products--grid")
        .addClass("listing-products--list");
    } else if (viewType == "map") {
      window.location.href = getSearchQueryUrl(true);
    } else {
      $("#productsList")
        .removeClass("listing-products--list")
        .addClass("listing-products--grid");
    }
    var currUrl = getSearchQueryUrl(true);
    window.history.pushState("", "", currUrl);
    /* $(".label").text(txt); */
  });

  /* ] */

  /******** function for left collapseable links  ****************/
  $(".block__body-js").show();
  $(".block__head-js").click(function () {
    $(this).toggleClass("is-active");
  });

  $(".block__head-js").click(function () {
    $(this).siblings(".block__body-js").slideToggle("slow");
  });

  var ww = document.body.clientWidth;
  if (ww <= 1050) {
    $(".block__body-js").hide();
    $(".block__body-js:first").show();
  } else {
    $(".block__body-js").show();
  }

  $(document).on("mouseover", ".bfilter-js li", function () {
    $(".brandList-js").addClass("filter-directory_disabled");
    $(".filter-directory_list_title").addClass("filter-directory_disabled");
    $(".b-" + $(this).attr("data-item").toLowerCase()).removeClass(
      "filter-directory_disabled"
    );
    lbl = $(this).attr("data-item");
    $(".filter-directory_list_title").each(function () {
      txt = $(this).attr("data-item").trim().toUpperCase();
      if (txt == lbl.toUpperCase()) {
        $(this).removeClass("filter-directory_disabled");
      }
    });
  });

  $(document).on("mouseout", ".bfilter-js li", function () {
    $(".brandList-js").removeClass("filter-directory_disabled");
    $(".filter-directory_list_title").removeClass("filter-directory_disabled");
  });

  $(document).on("click", ".bfilter-js li", function (e) {
    e.preventDefault();
    $(".filter-directory_list").animate(
      {
        scrollLeft: $("#" + $(this).attr("data-item").toLowerCase()).position()
          .left,
      },
      1000
    );
  });

  $(document).on("mouseover mouseout", "#mapProducts--js li", function (e) {
    let shopId = $(this).data("shopid");
    $.each(mapMarker, function (index, marker) {
      if (typeof marker != "undefined") {
        let iconImage = fcom.makeUrl() + "images/pin.png";
        if (marker["refId"] == shopId && e.type == "mouseover") {
          iconImage = fcom.makeUrl() + "images/pin2.png";
        }
        marker.setIcon(iconImage);
        /* //google.maps.event.trigger( marker, 'click' ); */
      }
    });
  });

  if ($(window).width() < 1050) {
    if ($(".grids")[0]) {
      $(".grids").masonry({
        itemSelector: ".grids__item",
      });
    }
  }

  $(document).on("change", "input[name=attributes]", function () {
    var id = $(this).parent().parent().find("label").attr("id");
    if ($(this).is(":checked")) {
      addFilter(id, this);
      addToSearchQueryString(id, this);
    } else {
      removeFilter(id, this);
    }
    removePaginationFromLink();
    reloadProductListing(frm);
  });
});

/* function updateQueryStringParameter(uri, key, value) {
 var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
 var separator = uri.indexOf('?') !== -1 ? "&" : "?";
 if (uri.match(re)) {
 return uri.replace(re, '$1' + key + "=" + value + '$2');
 }
 else {
 return uri + separator + key + "=" + value;
 }
 } */

function autoKeywordSearch(keyword) {
  keyword = keyword.toUpperCase();
  var myarray = [];
  $(".filter-directory_list li").each(function () {
    txt = $(this).text().trim().toUpperCase();
    if (txt.indexOf(keyword) > -1) {
      caption = $(this).attr("data-caption");
      if (typeof caption !== "undefined") {
        myarray.push(caption.toUpperCase());
      }
      $(this).show();
    } else {
      $(this).hide();
    }
  });
  myarray = $.unique(myarray);
  $(".filter-directory_list_title").each(function () {
    txt = $(this).attr("data-item").trim().toUpperCase();
    if ($.inArray(txt, myarray) >= 0) {
      $(this).show();
    } else {
      $(this).hide();
    }
  });
}

function brandFilters() {
  var frm = document.frmProductSearch;
  var url = window.location.href;
  if ($currentPageUrl == removeLastSpace(url) + "/index") {
    url = fcom.makeUrl("Products", "brandFilters");
  } else {
    url = url.replace(
      $currentPageUrl,
      fcom.makeUrl("Products", "brandFilters")
    );
  }
  if (url.indexOf("products/brandFilters") == -1) {
    url = fcom.makeUrl("Products", "brandFilters");
  }
  /* //url = fcom.makeUrl('Products','filters'); */
  var data = fcom.frmData(frm);
  var brands = getSelectedBrands();
  if (brands.length) {
    data = data + "&brand=" + [brands];
  }
  $("body").removeClass("collection-sidebar--on");
  /* $.facebox(function () { */
  fcom.ajax(url, data, function (ans) {
    /* $.facebox(ans, 'faceboxWidth'); */
    $("#exampleModal").html(ans);
    $("#exampleModal").modal("show");
  });
  /* }); */
}

function htmlEncode(value) {
  return $("<div/>").text(value).html();
}

function addFilter(id, obj) {
  if (typeof id === "undefined") {
    return;
  }
  removePaginationFromLink();
  var click = "onclick=removeFilter('" + id + "',this)";
  $filter = $(obj).parent().text();
  $filterVal = htmlEncode($(obj).parent().text());

  if (
    $("#" + id).data("groupname") != undefined &&
    $("#" + id).data("groupname") != ""
  ) {
    $filterVal = $("#" + id).data("groupname") + " - " + $filterVal;
  }

  if (id == "rentaldatesfilter") {
    $filterVal = htmlEncode($(obj).attr("id"));
  }
  if (!$(".selected-filters").find("button").hasClass(id)) {
    if (id != "producttype_1" && id != "producttype_2") {
      $(".selected-filters").prepend(
        "<span class='chip selected-filters-link filtered__item'>" +
          $filterVal +
          " <button data-yk='" +
          id +
          "' class='remove btn-close " +
          id +
          "' " +
          click +
          "> </button></span>"
      );
    }
    if (id == "producttype_1") {
      $(".hide_on_no_product .product-type-items").html(langLbl.saleItem);
    } else if (id == "producttype_2") {
      $(".hide_on_no_product .product-type-items").html(langLbl.rentalItem);
    }
  }
  showSelectedFilters();
}

function resetListingFilter() {
  $('input[name="producttype"]').parent("li").removeClass("is-active");
  searchArr = [];
  /* $("input:checkbox[name=brands]").each(function(){
     $(this).prop( "checked", false );	
     }); */
  var shop_id = parseInt($("input[name=shop_id]").val());
  if (shop_id > 0) {
    if (document.frmSearch[0]) {
      document.frmSearch[0].reset();
    }
    if (document.frmSearch[1]) {
      document.frmSearch[1].reset();
    }
    $("input[id=keyword]").val("");
  }

  document.frmProductSearch.reset();
  document.frmProductSearchPaging.reset();
  var frm = document.frmProductSearch;
  $(".selected-filters button").each(function () {
    id = $(this).attr("data-yk");
    clearFilters(id, this);
  });

  updatePriceFilter();
  reloadProductListing(frm);
  showSelectedFilters();
}

function addPaginationInlink(page) {
  searchArr["page"] = page;
}

function validatePriceFilter() {
  var max = parseInt($("input[name=priceFilterMaxValue]").val());
  var min = parseInt($("input[name=priceFilterMinValue]").val());
  if (max <= min) {
    $("input[name=priceFilterMaxValue]").val(min + 1);
  }
}

function removePaginationFromLink() {
  if (typeof searchArr["page"] == "undefined") {
    return;
  }
  delete searchArr["page"];
  /*
    var frm = document.frmProductSearchPaging;
    $(frm.page).val(1);
    */
}

function removePageSideFromLink() {
  if (typeof searchArr["pagesize"] == "undefined") {
    return;
  }
  delete searchArr["pagesize"];
}

function showSelectedFilters() {
  if ($(".selected-filters:first button").length > 1) {
    $(".selected-filters").show();
    $(".filters-head").show();
  } else {
    $(".selected-filters").hide();
    $(".filters-head").hide();
  }
}

function removeFilter(id, obj) {
  if (id == "rentaldatesfilter") {
    $("." + id)
      .parent()
      .remove();
    delete searchArr["rentalstart"];
    delete searchArr["rentalend"];
    $('input[name="rentaldates"]').val("");
    $('input[name="rentalstart"]').val("");
    $('input[name="rentalend"]').val("");
  } else {
    $("." + id)
      .parent()
      .remove();
    $("#" + id)
      .find("input[type='checkbox']")
      .prop("checked", false);
    $("input:checkbox[name=brands]").each(function () {
      if ($(this).attr("data-id") == id) {
        $(this).prop("checked", false);
      }
    });
    $("input:checkbox[name=attributes]").each(function () {
      if ($(this).parent('label').attr("data-id") == id) {
        $(this).prop("checked", false);

      }
    });
  }
  var frm = document.frmProductSearch;
  /* form submit upon onchange of form elements select box[ */
  removeFromSearchQueryString(id);
  reloadProductListing(frm);
  /* //searchProducts(frm,0,0,1,1); */
  showSelectedFilters();
}

function clearFilters(id, obj) {
  $("." + id)
    .parent("span")
    .remove();
  if (id == "rentaldatesfilter") {
    $("." + id)
      .parent()
      .remove();
    delete searchArr["rentalstart"];
    delete searchArr["rentalend"];
    $('input[name="rentaldates"]').val("");
    $('input[name="rentalstart"]').val("");
    $('input[name="rentalend"]').val("");
  } else {
    $("#" + id)
      .find("input[type='checkbox']")
      .prop("checked", false);
    $("input:checkbox[name=brands]").each(function () {
      if ($(this).attr("data-id") == id) {
        $(this).prop("checked", false);
      }
    });
    $("input:checkbox[name=attributes]").each(function () {
      if ($(this).parent('label').attr("data-id") == id) {
        $(this).prop("checked", false);
      }
    });
  }
}

function addToSearchQueryString(id, obj) {
  if (typeof id === "undefined") {
    return;
  }
  /* //$filter = $(obj).parent().text(); */
  var attrVal = $(obj).attr("data-title");
  if (typeof attrVal !== "undefined" && attrVal !== false) {
    $filterVal = htmlEncode(removeSpecialCharacter(attrVal));
  } else {
    $filterVal = htmlEncode(removeSpecialCharacter($(obj).parent().text()));
  }
  $filterVal = $filterVal.trim().toLowerCase();
  /* //searchArr[id] = encodeURIComponent($filterVal.replace(/ /g,'-'));	 */
  if (id == "rentalstart" || id == "rentalend") {
    $filterVal = htmlEncode(removeSpecialCharacter(obj));
    searchArr[id] = $filterVal.replace(/ /g, "-");
  } else {
    searchArr[id] = $filterVal.replace(/ /g, "-");
  }
}

function removeSpecialCharacter($str) {
  return $str.replace(/[&\/\\#,+()$~%.'":*?<>{}]/g, "");
}

function removeFromSearchQueryString(key) {
  delete searchArr[key];
}

function setQueryParamSeperator(url) {
  if (url.indexOf("?") > -1) {
    return "&";
  }
  return "?";
}

function getSearchQueryUrl(includeBaseUrl) {
  url = "";
  itemSeperator = "&";
  valueSeperator = "-";

  if (typeof includeBaseUrl != "undefined" || includeBaseUrl != null) {
    url = $currentPageUrl;
  }
  var keyword = $("input[id=keyword]").val();
  if (keyword != "") {
    delete searchArr["keyword"];
    /* //keyword = encodeURIComponent(keyword); */
    url =
      url +
      setQueryParamSeperator(url) +
      "keyword" +
      valueSeperator +
      keyword.replace(/_/g, "-");
  }

  var category = parseInt($("input[id=searched_category]").val());
  if (category > 0) {
    delete searchArr["category"];
    url =
      url +
      setQueryParamSeperator(url) +
      "category" +
      valueSeperator +
      category;
  }

  for (var key in searchArr) {
    url =
      url +
      setQueryParamSeperator(url) +
      key.replace(/_/g, "-") +
      valueSeperator +
      searchArr[key];
  }

  if (
    $('input[name="rentalstart"]').val() != "" &&
    $('input[name="rentalend"]').val() != ""
  ) {
    url =
      url +
      setQueryParamSeperator(url) +
      "rentalstart" +
      valueSeperator +
      $('input[name="rentalstart"]').val();
    url =
      url +
      setQueryParamSeperator(url) +
      "rentalend" +
      valueSeperator +
      $('input[name="rentalend"]').val();
  }

  /* var currency = parseInt($("input[name=currency_id]").val());
     if(currency > 0){
     delete searchArr['currency'];
     url = url +setQueryParamSeperator(url)+'currency'+valueSeperator+currency;
     } */

  var featured = parseInt($("input[name=featured]").val());
  if (featured > 0) {
    url =
      url +
      setQueryParamSeperator(url) +
      "featured" +
      valueSeperator +
      featured;
  }

  var collection_id = parseInt($("input[name=collection_id]").val());
  if (collection_id > 0) {
    url =
      url +
      setQueryParamSeperator(url) +
      "collection" +
      valueSeperator +
      collection_id;
  }

  var shop_id = parseInt($("input[name=shop_id]").val());
  if (shop_id > 0) {
    url = url + setQueryParamSeperator(url) + "shop" + valueSeperator + shop_id;
  }

  var vtype = $("form[name=frmProductSearch] input[name=vtype]").val();
  url = url + setQueryParamSeperator(url) + "vtype" + valueSeperator + vtype;
  /* var page = parseInt($("input[name=page]").val());
    if(page > 1){
        url = url +setQueryParamSeperator(url)+'page-'+page;
     } */

  var e = document.getElementById("sortBy");
  if ($(e).is("select")) {
    var sortBy = e.options[e.selectedIndex].value;
  } else {
    var sortBy = e.value;
  }

  if (sortBy) {
    url =
      url +
      setQueryParamSeperator(url) +
      "sort" +
      valueSeperator +
      sortBy.replace(/_/g, "-");
  }

  var e = document.getElementById("pageSize");
  var pageSize = parseInt(e.value);
  if (pageSize > 0) {
    url =
      url +
      setQueryParamSeperator(url) +
      "pagesize" +
      valueSeperator +
      pageSize;
  }

  return encodeURI(url);
}

function addPricefilter(reloadPage) {
  if (typeof reloadPage == "undefined") {
    reloadPage = false;
  }
  $(".price").parent().remove();
  if (
    !$(".selected-filters").find("button").hasClass("price") &&
    priceInFilter
  ) {
    $(".selected-filters").prepend(
      "<span class='chip selected-filters-link filtered__item'> " +
        currencySymbolLeft +
        $("input[name=priceFilterMinValue]").val() +
        currencySymbolRight +
        " - " +
        currencySymbolLeft +
        $("input[name=priceFilterMaxValue]").val() +
        currencySymbolRight +
        " <button  data-yk='price' class='remove btn-close price' onclick='removePriceFilter(this)'></button></span>"
    );

    searchArr["price_min_range"] = $("input[name=priceFilterMinValue]").val();
    searchArr["price_max_range"] = $("input[name=priceFilterMaxValue]").val();
    searchArr["currency"] = langLbl.siteCurrencyId;
    var frm = document.frmProductSearch;
    if (reloadPage) {
      reloadProductListing(frm);
    }
  }

  showSelectedFilters();
  /* //searchProducts(frm,0,0,1,1); */
}

function removePriceFilter(reloadPage) {
  if (typeof reloadPage == "undefined") {
    reloadPage = true;
  }
  updatePriceFilter();
  var frm = document.frmProductSearch;
  delete searchArr["price_min_range"];
  delete searchArr["price_max_range"];
  delete searchArr["currency"];
  if (reloadPage) {
    reloadProductListing(frm);
  }
  /* //searchProducts(frm,0,0,1,1); */
  $(".price").parent().remove();
  showSelectedFilters();
}

function updatePriceFilter(minPrice, maxPrice, addPriceFilter) {
  if (typeof addPriceFilter == "undefined") {
    addPriceFilter = false;
  }

  if (typeof minPrice == "undefined" || typeof maxPrice == "undefined") {
    minPrice = $(".range-min-js").attr("min");
    maxPrice = $(".range-min-js").attr("max");
    $(".range-min-js").val(minPrice);
    $(".range-max-js").val(maxPrice);
  }

  $('input[name="priceFilterMinValue"]').val(minPrice);
  $('input[name="priceFilterMaxValue"]').val(maxPrice);

  if (addPriceFilter) {
    addPricefilter();
  }

  if (typeof rangeSlider == "function") {
    rangeSlider.noUiSlider.set([minPrice, maxPrice]);
  }
  updateRangeSliderUI();
}

(function () {
  updateRange = function (from, to) {
    if (typeof range !== "undefined") {
      range.update({
        from: from,
        to: to,
      });
    }
  };

  bannerAdds = function (url) {
    fcom.ajax(url, "", function (res) {
      $("#searchPageBanners").html(res);
    });
  };

  reloadProductListing = function (frm, page) {
    if (typeof page == "undefined") {
      page = 0;
    }

    var isMobileOrTablet = $(window).width() < 768;
    if (isMobileOrTablet) {
      var currentHeight = $("#productsList").height();
      $("#productsList").css("min-height", currentHeight + "px");
    }
    $("#productsList").html(fcom.getLoader());
    if (0 < page) {
      addPaginationInlink(page);
    } else {
      getSetSelectedOptionsUrl(frm);
    }
    var data = fcom.frmData(frm);
    var currUrl = getSearchQueryUrl(true);
    fcom.ajax(currUrl, data, function (res) {
      $("#productsList").replaceWith(res);
      if (isMobileOrTablet) {
        $("#productsList").css("min-height", "unset");
      }
      var frm = document.frmProductSearchPaging;
      var recordCount = parseInt($(frm.recordDisplayCount).val());
      $("#total_records").html(recordCount);
      $("#total_records_string").html($(frm.recordDisplayCountString).val());
      if (1 > recordCount) {
        $(".saveSearch-js").hide();
        $(".hide_on_no_product").hide();
      } else {
        $(".saveSearch-js").show();
        $(".hide_on_no_product").show();
      }
      if (12 > recordCount) {
        $('select[name="pageSizeSelect"]').hide();
      } else {
        $('select[name="pageSizeSelect"]').show();
      }
    });
    window.history.pushState("", "", currUrl);
    /* //window.location.href = getSearchQueryUrl(true); */
  };

  searchProducts = function (frm) {
    var keyword = $.trim($(frm.keyword).val());
    if (3 > keyword.length || "" === keyword) {
      $.mbsmessage(langLbl.searchString, true, "alert--danger");
      return;
    }
    $("input[id=keyword]").val(keyword);
    reloadProductListing(frm);
    $("#resetAll").css("display", "block");
  };

  function checkVtypeMapInUrl(url) {
    url = window.location.protocol + '/' + window.location.host+'/'+url;
    const urlObj = new URL(url);
    const searchParams = urlObj.searchParams;
    return searchParams.has('vtype-map');
}

  loadProductListingfilters = function (frm) {
    const searchParams = new URLSearchParams(window.location.search);

    $(".productFilters-js").html(fcom.getLoader());
    var url = window.location.href;
    if ($currentPageUrl == removeLastSpace(url) + "/index") {
      url = fcom.makeUrl("Products", "filters");
    } else {
      url = url.replace($currentPageUrl, fcom.makeUrl("Products", "filters"));
    }

    if (url.indexOf("products/filters") == -1) {
      url = fcom.makeUrl("Products", "filters");
    }

    let hasVtypeMap = checkVtypeMapInUrl(url);
    if(hasVtypeMap == false){
        frm.vtype.value= 'grid'; 
    }
    /* //url = fcom.makeUrl('Products','filters'); */
    var data = fcom.frmData(frm);
    fcom.ajax(url, data, function (res) {
      $(".productFilters-js").html(res);
      updateRangeSlider();
      getSetSelectedOptionsUrl(frm);
      $('input[name="producttype"]').parent("li").removeClass("is-active");
      $('input[name="producttype"]').each(function () {
        if ($(this).is(":checked")) {
          $('input[data-id="producttype_' + $(this).val() + '"')
            .parent("li")
            .addClass("is-active");
        }
      });
      if (
        typeof canFilterHide != "undefined" &&
        canFilterHide &&
        searchParams.size == 0 &&
        $("#productsList .block-empty").length > 0
      ) {
        $(".productFilters-js").hide();
      }
    });
  };

  updateRangeSlider = function () {
    const rangeInput = document.querySelectorAll(".range-input input"),
      priceInput = document.querySelectorAll(".price-input input");
    let priceGap = 0;
    let debounceTimeoutInput = null;
    let debounceTimeout = null;
    updateRangeSliderUI();
    priceInput.forEach((input) => {
      input.addEventListener("input", (e) => {
        clearTimeout(debounceTimeoutInput);
        debounceTimeoutInput = setTimeout(() => {
          let minPrice = Math.max(
              rangeInput[0].min,
              parseInt(
                $(e.target)
                  .parents(".price-input-js")
                  .find(".input-min-js")
                  .val()
              )
            ),
            maxPrice = Math.min(
              rangeInput[0].max,
              parseInt(
                $(e.target)
                  .parents(".price-input-js")
                  .find(".input-max-js")
                  .val()
              )
            );
          if (
            maxPrice - minPrice >= priceGap &&
            maxPrice <= rangeInput[1].max &&
            minPrice >= rangeInput[0].min
          ) {
            if ($(e.target).hasClass("input-min-js")) {
              rangeInput[0].value = minPrice;
              rangeInput[2].value = minPrice;
              priceInput[0].value = minPrice;
              priceInput[2].value = minPrice;
              updateRangeSliderUI();
            } else {
              rangeInput[1].value = maxPrice;
              rangeInput[3].value = maxPrice;
              priceInput[1].value = maxPrice;
              priceInput[3].value = maxPrice;
              updateRangeSliderUI();
            }
          } else {
            priceInput[0].value = rangeInput[0].min;
            priceInput[2].value = rangeInput[0].min;
            priceInput[1].value = rangeInput[0].max;
            priceInput[3].value = rangeInput[0].max;
          }
          priceInFilter = 1;
          addPricefilter(true);
        }, 500);
      });
    });
    rangeInput.forEach((input) => {
      input.addEventListener("input", (e) => {
        let minVal = parseInt(
            $(e.target).parents(".range-input-js").find(".range-min-js").val()
          ),
          maxVal = parseInt(
            $(e.target).parents(".range-input-js").find(".range-max-js").val()
          );
        if (maxVal - minVal < priceGap) {
          if ($(e.target).hasClass("range-min-js")) {
            rangeInput[0].value = maxVal - priceGap;
            rangeInput[2].value = maxVal - priceGap;
          } else {
            rangeInput[1].value = minVal + priceGap;
            rangeInput[3].value = minVal + priceGap;
          }
        } else {
          priceInput.forEach((e, i) => {
            if ($(e).hasClass("input-min-js")) {
              e.value = minVal;
              if (i == 0) {
                rangeInput[2].value = minVal;
              } else {
                rangeInput[0].value = minVal;
              }
            } else {
              e.value = maxVal;
              if (i == 1) {
                rangeInput[3].value = maxVal;
              } else {
                rangeInput[1].value = maxVal;
              }
            }
          });
          updateRangeSliderUI();
        }
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(() => {
          priceInFilter = 1;
          addPricefilter(true);
        }, 500);
      });
    });
    addPricefilter();
    showSelectedFilters();
  };

  updateRangeSliderUI = function () {
    let rangeInput = document.querySelectorAll(".range-input input"),
      range = document.querySelectorAll(".slider .progress");
    let inputMin = $(".price-input-js:first").find(".input-min-js").val();
    let inputMax = $(".price-input-js:first").find(".input-max-js").val();
    if (
      rangeInput.length > 0 &&
      parseInt(rangeInput[0].max) < parseInt(inputMax)
    ) {
      inputMax = rangeInput[0].max;
    } 
    range.forEach((e) => {

      if('rtl' == langLbl.layoutDirection){

        e.style.right =
          ((inputMin - rangeInput[0].min) /
            (rangeInput[0].max - rangeInput[0].min)) *
            100 +
          "%";
        e.style.left =
          100 -
          ((inputMax - rangeInput[0].min) /
            (rangeInput[0].max - rangeInput[0].min)) *
            100 +
          "%";

          
      }else{
          
        e.style.left =
        ((inputMin - rangeInput[0].min) /
          (rangeInput[0].max - rangeInput[0].min)) *
          100 +
        "%";
      e.style.right =
        100 -
        ((inputMax - rangeInput[0].min) /
          (rangeInput[0].max - rangeInput[0].min)) *
          100 +
        "%";
      }
   
    });
  };

  removeLastSpace = function (str) {
    return str.replace(/\/*$/, "");
  };

  getSelectedBrands = function () {
    var brands = [];
    $("input:checkbox[name=brands]:checked").each(function () {
      var id = $(this).attr("data-id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      brands.push($(this).val());
    });
    return brands;
  };

  getSetSelectedOptionsUrl = function (frm) {
    var data = fcom.frmData(frm);
    /* Product Type value pickup [ */
    var productType = "";
    $("input:radio[name=producttype]:checked").each(function () {
      var id = $(this).parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      productType = $(this).val();
    });
    if (productType != "") {
      data = data + "&productType=" + [productType];
    }

    if (
      $('input[name="rentalstart"]').val() != "" &&
      $('input[name="rentalend"]').val() != ""
    ) {
      addFilter("rentaldatesfilter", $('input[name="rentaldates"]'));
      data = data + "&rentalstart=" + $('input[name="rentalstart"]').val();
      data = data + "&rentalend=" + $('input[name="rentalend"]').val();
    }
    /* ] */

    /* Category filter value pickup[ */
    var category = [];
    $("input:checkbox[name=category]:checked").each(function () {
      var id = $(this).parent().parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      category.push($(this).val());
    });
    if (category.length) {
      data = data + "&category=" + [category];
    }
    /* ] */

    /* brands filter value pickup[ */
    var brands = getSelectedBrands();
    if (brands.length) {
      data = data + "&brand=" + [brands];
    }
    /* ] */

    /* Attributes filter value pickup[ */
    $("input:checkbox[name=attributes]:checked").each(function () {
      var id = $(this).parent().parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
    });
    /* ] */

    /* Option filter value pickup[ */
    var optionvalues = [];
    $("input:checkbox[name=optionvalues]:checked").each(function () {
      var id = $(this).parent().parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      optionvalues.push($(this).val());
    });
    if (optionvalues.length) {
      data = data + "&optionvalue=" + [optionvalues];
    }
    /* ] */

    /* condition filters value pickup[ */
    var conditions = [];
    $("input:checkbox[name=conditions]:checked").each(function () {
      var id = $(this).parent().parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      conditions.push($(this).val());
    });
    if (conditions.length) {
      data = data + "&condition=" + [conditions];
    }
    /* ] */

    /* Free Shipping Filter value pickup[ */

    /* ] */

    /* Out Of Stock Filter value pickup[ */
    $("input:checkbox[name=out_of_stock]:checked").each(function () {
      var id = $(this).parent().parent().find("label").attr("id");
      addToSearchQueryString(id, this);
      addFilter(id, this);
      data = data + "&out_of_stock=1";
    });
    /* ] */

    /* price filter value pickup[ */
    if (typeof $("input[name=priceFilterMinValue]").val() != "undefined") {
      data =
        data + "&min_price_range=" + $("input[name=priceFilterMinValue]").val();
    }

    if (typeof $("input[name=priceFilterMaxValue]").val() != "undefined") {
      data =
        data + "&max_price_range=" + $("input[name=priceFilterMaxValue]").val();
    }

    var defaultMinPrice = parseInt(
      $("input[name=priceFilterMinValue]").data("defaultvalue")
    );
    var minPrice = parseInt($("input[name=priceFilterMinValue]").val());
    var defaultMaxPrice = parseInt(
      $("input[name=priceFilterMaxValue]").data("defaultvalue")
    );
    var maxPrice = parseInt($("input[name=priceFilterMaxValue]").val());
    if (
      !isNaN(defaultMinPrice) &&
      !isNaN(defaultMaxPrice) &&
      (minPrice != defaultMinPrice || maxPrice != defaultMaxPrice)
    ) {
      addPricefilter(false);
    }

    return data;
  };

  goToProductListingSearchPage = function (page) {
    if (typeof page == undefined || page == null) {
      page = 1;
    }
    reloadProductListing(document.frmProductSearch, page);
    let id = $(document.frmProductSearch).attr('id');
    if(typeof id != undefined){
        $('html, body').animate({
          scrollTop: $('#'+id).offset().top
      }, 0);
    }
    
  };

  resendOtp = function (userId, getOtpOnly = 0) {
    $.mbsmessage(langLbl.processing, false, "alert--process");
    fcom.ajax(
      fcom.makeUrl("GuestUser", "resendOtp", [userId, getOtpOnly]),
      "",
      function (t) {
        t = $.parseJSON(t);
        if (1 > t.status) {
          $.mbsmessage(t.msg, false, "alert--danger");
          return false;
        }
        $.mbsmessage(t.msg, true, "alert--success");
        startOtpInterval();
      }
    );
    return false;
  };

  validateOtp = function (frm) {
    if (!$(frm).validate()) return;
    var data = fcom.frmData(frm);
    fcom.ajax(fcom.makeUrl("GuestUser", "validateOtp"), data, function (t) {
      t = $.parseJSON(t);
      if (1 == t.status) {
        window.location.href = t.redirectUrl;
      } else {
        invalidOtpField();
      }
    });
    return false;
  };

  dragCallback = function (dragendMap) {
    canSetCookie = true;
    codeLatLng(
      dragendMap.getCenter().lat(),
      dragendMap.getCenter().lng(),
      function (data) {
        displayGeoAddress(setGeoAddress(data));
        clearTimeout(dragTimeOutEvent);
        dragTimeOutEvent = setTimeout(function () {
          reloadProductListing(document.frmProductSearch);
          loadProductListingfilters(document.frmProductSearch);
        }, 1200);
      }
    );
  };
})();
