<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<main id="body" class="body enter-page">
    <section class="form-sign">
        <div class="form-sign-body">
            <?php
            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);

            $sizeType = 'CUSTOM';
            $logoClass = "logo-custom";
            if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                $sizeType = '16X9';
                $extraClass = '';
            } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                $sizeType = '1X1';
                $extraClass = '';
            }

            $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
            $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

            ?>
            <div class="form-sign-logo">
                <a href="<?php echo UrlHelper::generateFullFileUrl(); ?>">
                    <img class="<?php echo $logoClass; ?>" src="<?php echo $siteLogo; ?>"
                        alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                        title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                </a>
            </div>
            <div class="card-sign">
                <div class="card-sign_head">
                    <div class="section-head">
                        <div class="section-heading">
                            <h1>
                                <?php echo Labels::getLabel('LBL_Reset_Password', $siteLangId); ?>
                            </h1>
                            <p>
                                <?php echo Labels::getLabel("LBL_Don't_worry,happens_to_best_of_us.", $siteLangId); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-sign_body">
                    <?php
                    $frm->setRequiredStarPosition(Form::FORM_REQUIRED_STAR_POSITION_NONE);
                    $frm->setFormTagAttribute('class', 'form');
                    $frm->setValidatorJsObjectName('resetValObj');
                    $frm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
                    $frm->developerTags['fld_default_col'] = 12;
                    $frm->setFormTagAttribute('action', '');
                    $btnFld = $frm->getField('user_name');
                    $btnFld->developerTags['noCaptionTag'] = true;
                    $btnFld = $frm->getField('new_pwd');
                    $btnFld->developerTags['noCaptionTag'] = true;
                    $btnFld = $frm->getField('confirm_pwd');
                    $btnFld->developerTags['noCaptionTag'] = true;
                    $btnFld = $frm->getField('btn_submit');
                    $btnFld->developerTags['noCaptionTag'] = true;
                    $btnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
                    if (empty($user_password)) {
                        $btnFld->value = Labels::getLabel('LBL_SET_PASSWORD', $siteLangId);
                    }
                    $frm->setFormTagAttribute('onSubmit', 'resetpwd(this, resetValObj); return(false);');
                    $passFld = $frm->getField('new_pwd');
                    $passFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_NEW_PASSWORD', $siteLangId));
                    $confirmFld = $frm->getField('confirm_pwd');
                    $confirmFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_CONFIRM_NEW_PASSWORD', $siteLangId));
                    $fld = $frm->getField('user_name');
                    $fld->setFieldTagAttribute('disabled', 'disabled');
                    $fld->value = $credential_username;
                    echo $frm->getFormHtml();
                    ?>
                </div>
                <div class="card-sign_foot">
                    <ul class="others">
                        <li class="others-item">
                            <?php echo Labels::getLabel('LBL_Already_have_an_account?', $siteLangId); ?>
                            <a class="others-links link-brand link-underline"
                                href="<?php echo UrlHelper::generateUrl('GuestUser', 'loginForm'); ?>"
                                class="link-underline">
                                <?php echo Labels::getLabel('LBL_Log_in', $siteLangId); ?>
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
        </div>
    </section>
</main>