<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<main id="body" class="body enter-page">
    <?php
    if ($isRegisterForm == 0) {
        ?>
        <section class="form-sign">
            <div class="form-sign-body">
                <?php
                $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
                $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);
                $sizeType = 'CUSTOM';
                $logoClass = "logo-custom";
                if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                    $sizeType = '16X9';
                    $logoClass = '';
                } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                    $sizeType = '1X1';
                    $logoClass = '';
                }
                $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
                $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
                ?>

                <div class="form-sign-logo"> <a href="<?php echo UrlHelper::generateFullFileUrl(); ?>">
                        <img class="<?php echo $logoClass; ?>" src="<?php echo $siteLogo; ?>"
                            alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                            title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                    </a></div>

                <div class="card-sign">
                    <div class="card-sign_head">
                        <div class="section-head">
                            <div
                                class="section-heading <?php if (isset($smsPluginStatus) && true === $smsPluginStatus) { ?>otp-heading<?php } ?>">
                                <h1>
                                    <?php echo Labels::getLabel('LBL_Sign_In', $siteLangId); ?>
                                </h1>
                                <?php if (isset($smsPluginStatus) && true === $smsPluginStatus) { ?>
                                    <button type="button" class="link-underline  otp-link" data-form="frmLogin"
                                        onClick="signInWithPhone(this, true)">
                                        <?php echo Labels::getLabel('LBL_USE_PHONE_NUMBER_INSTEAD', $siteLangId); ?>
                                    </button>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-sign_body">
                        <?php $this->includeTemplate('guest-user/loginPageTemplate.php', $loginData, false); ?>
                    </div>
                    <div class="card-sign_foot">
                        <ul class="others">
                            <li class="others-item">
                                <?php echo Labels::getLabel("LBL_Don't_you_have_an_account?", $siteLangId); ?>
                                <a class="others-links link-brand link-underline"
                                    href="<?php echo UrlHelper::generateUrl('GuestUser', 'loginForm', array(applicationConstants::YES)); ?>">
                                    <?php echo sprintf(Labels::getLabel('LBL_Sign_Up', $siteLangId), FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId)); ?>
                                </a>
                            </li>
                        </ul>

                    </div>
                </div>
            </div>
        </section>
    <?php } else {
        require_once CONF_DEFAULT_THEME_PATH . 'guest-user/register-form-detail.php';
    } ?>
    <?php ?>

</main>