<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$this->includeTemplate('_partial/dashboardNavigation.php');
$merchantId = isset($userData[$keyName . '_merchantId']) ? $userData[$keyName . '_merchantId'] : '';
$serviceAccInfo = isset($userData['service_account']) ? $userData['service_account'] : '';
?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading"><?php echo $pluginName; ?></h2>
            </div>
        </div>
        <div class="content-form"></div>
        <div class="content-body">
            <div class="card">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <h6 class="m-0">
                        <?php echo Labels::getLabel('Lbl_MERCHANT_ID', $siteLangId); ?> :
                        <?php echo $merchantId;
                        if (empty($merchantId) && $userPrivilege->canEditAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)) { ?>
                            <a class="btn btn-outline-gray qwer" href="<?php echo UrlHelper::generateUrl($keyName, 'getAccessToken') ?>" title="<?php echo Labels::getLabel('Lbl_SETUP_MERCHANT_ACCOUNT', $siteLangId); ?>">

                                <?php echo Labels::getLabel('Lbl_SETUP_MERCHANT_ACCOUNT', $siteLangId); ?></a>
                        <?php }

                        if (empty($merchantId) && !$userPrivilege->canEditAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)) {
                            echo Labels::getLabel('LBL_YOU_ARE_NOT_ALLOWED_TO_SETUP_ACCOUNT', $siteLangId);
                        }
                        ?>
                    </h6>
                    <?php if (!empty($merchantId) && $userPrivilege->canEditAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)) { ?>
                        <button type="button" class="btn btn-brand btn-sm" onClick="serviceAccountForm();" id="userAccInfoBtn"><?php echo Labels::getLabel('Lbl_SERVICE_ACCOUNT_INFO', $siteLangId); ?></button>
                    <?php } ?>
                </div>
            </div>

            <?php if (!empty($merchantId) && !empty($serviceAccInfo)) { ?>

                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-3">
                            <?php echo Labels::getLabel('LBL_BATCH_SETUP', $siteLangId); ?>
                        </h5>
                        <div id="batchSetup"></div>
                    </div>
                </div>


                <div class="card">
                    <div class="card-table">
                        <div id="listing"></div>
                    </div>

                </div>
            <?php } ?>
        </div>
    </div>
</main>

<?php if (!empty($merchantId) && empty($serviceAccInfo) && $userPrivilege->canEditAdvertisementFeed(UserAuthentication::getLoggedUserId(), true)) { ?>
    <script>
        serviceAccountForm();
    </script>
<?php }
