<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$products = $orderInfo['orderProducts'];
$shippingMethod = '';
$groupProductsArr = [];
$isRentalOrder = false;

if (Orders::ORDER_PRODUCT == $orderInfo['order_type']) {
    foreach ($products as $key => $op) {
        $productImg = UrlHelper::generateFileUrl('Image', 'product', array($op['selprod_product_id'], 'MINI', $op['selprod_id'], 0));
        $shippingMethod .= !empty($op['opshipping_label']) ? '<li><img src="'. $productImg .'" alt="'. $op['selprod_title'] .'" title="'. $op['selprod_title'] .'" /> ' . $op['opshipping_label'] . '</li>' : '';
        if ($op['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
            if ($op['opd_product_type'] == SellerProduct::PRODUCT_TYPE_PRODUCT) {
                $opkey = date('Y-m-d', strtotime($op['opd_rental_start_date'])) .'_'. date('Y-m-d', strtotime($op['opd_rental_end_date'])). '_'. $op['selprod_id'];
                if (isset($groupProductsArr[$opkey])) {
                    $tempAddonData = (isset($groupProductsArr[$opkey]['addonsData'])) ? $groupProductsArr[$opkey]['addonsData'] : [];
                    $groupProductsArr[$opkey] = $op;
                    $groupProductsArr[$opkey]['addonsData'] = $tempAddonData;
                } else {
                    $groupProductsArr[$opkey] = $op;
                }
                $isRentalOrder = true;
            } else {
                $mainProductKey = date('Y-m-d', strtotime($op['opd_rental_start_date'])) .'_'. date('Y-m-d', strtotime($op['opd_rental_end_date'])). '_'. $op['opd_main_product_id'];;
                $groupProductsArr[$mainProductKey]['addonsData'][$key] = $op;
            }
        } else {
            $groupProductsArr[$key] = $op;
        }
    }
}

$fulfillmentType = Shipping::FULFILMENT_SHIP;
array_walk($orderFulFillmentTypeArr, function ($row) use (&$fulfillmentType) {
    if (Product::PRODUCT_TYPE_PHYSICAL == $row['op_product_type']) {
        $fulfillmentType = $row['opshipping_fulfillment_type'];
        return;
    }
});

$extendFromOrderIds = array_column($products, 'opd_extend_from_op_id');
?>

<table width="100%" border="2" cellpadding="20" style="border-collapse: collapse;">
    <tr>
        <td>
            <div style="text-align: center;">
                <h2><?php echo Labels::getLabel('LBL_THANK_YOU!', $siteLangId); ?></h2>
                <h3>
                    <?php
                    $msg = Labels::getLabel('LBL_ORDER_#{ORDER-ID}_TRANSACTION_COMPLETED!', $siteLangId);
                    $orderProducts = current($orderInfo['orderProducts']);
                    $orderDetailUrl = UrlHelper::generateUrl('Seller', 'viewSubscriptionOrder', array($orderProducts['ossubs_id']));
                    $orderDetailLinkHtml = $orderInfo['order_id'];
                    if (isset($orderProducts['ossubs_id'])) {
                        $orderDetailLinkHtml = '<a style="color: #3498db; text-decoration: none;" href="' . $orderDetailUrl . '">' . $orderInfo['order_id'] . '</a>';
                    }
                    $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderDetailLinkHtml]);
                    echo $msg;
                    ?>
                </h3>
                <?php if (!CommonHelper::isAppUser()) { ?>
                <p><?php echo CommonHelper::renderHtml($textMessage); ?></p>
                <?php } ?>

                <?php if ($orderInfo['order_type'] != Orders::ORDER_WALLET_RECHARGE) { ?>
                <p>
                    <svg class="svg" width="22px" height="22px">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#TimePlaced">
                        </use>
                    </svg>
                    <?php
                        $replace = [
                            '{TIME-PLACED}' => '<strong>' . Labels::getLabel('LBL_TIME_PLACED', $siteLangId) . '</strong>',
                            '{DATE-TIME}' => $orderInfo['order_date_added'],
                        ];
                        $msg = Labels::getLabel('LBL_{TIME-PLACED}:_{DATE-TIME}', $siteLangId);
                        $msg = CommonHelper::replaceStringData($msg, $replace);
                        echo $msg;
                        ?>
                </p>
                <?php } ?>
            </div>
            <table width="100%" cellspacing="0" cellpadding="0">
                <tr>
                    <td style="padding: 20px; text-align: left; width: 70%; box-sizing: border-box;">
                        <h5><?php echo Labels::getLabel('LBL_ORDER_DETAIL', $siteLangId); ?></h5>
                        <table>
                            <?php
                            foreach ($products as $subscription) {
                                ?>
                            <tr>
                                <td>
                                    <?php echo Labels::getLabel("LBL_COMMISION_RATE", $siteLangId); ?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;:
                                    <span><?php echo CommonHelper::displayComissionPercentage($subscription['ossubs_commission']); ?>%</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php echo Labels::getLabel("LBL_ACTIVE_PRODUCTS", $siteLangId); ?>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:
                                    <span><?php echo $subscription['ossubs_products_allowed']; ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php echo Labels::getLabel("LBL_PRODUCT_INVENTORY", $siteLangId); ?>&nbsp; &nbsp;:
                                    <span><?php echo $subscription['ossubs_inventory_allowed']; ?></span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php echo Labels::getLabel("LBL_IMAGES_PER_PRODUCT", $siteLangId); ?> :
                                    <span><?php echo $subscription['ossubs_images_allowed']; ?></span>
                                </td>
                            </tr>
                            <?php
                            }
                            ?>
                        </table>
                    </td>
                    <td style="padding: 20px; text-align: left; width: 30%; box-sizing: border-box;">
                        <h5><?php echo Labels::getLabel('LBL_ORDER_SUMMARY', $siteLangId); ?></h5>
                        <table>
                            <?php
                            if (0 < $orderInfo['order_reward_point_value'] || 0 < $orderInfo['order_discount_total']) {
                                $msg = "LBL_REWARD_POINTS";
                                $totalDiscount = $orderInfo['order_reward_point_value'];
                                if (!empty($orderInfo['order_discount_total']) && 0 < $orderInfo['order_discount_total']) {
                                    $msg .= "_&_DISCOUNT";
                                    $totalDiscount += $orderInfo['order_discount_total'];
                                }
                                ?>
                            <tr>
                                <td>
                                    <span class="label"><?php echo Labels::getLabel($msg, $siteLangId); ?>:</span>
                                    <span
                                        class="value">-<?php echo CommonHelper::displayMoneyFormat($totalDiscount); ?></span>
                                </td>
                            </tr>
                            <?php } 
                            if (0 < $orderInfo['order_volume_discount_total']) {
                                $msg = 'LBL_Loyalty/Volume_Discount';
                                $totalDiscount = $orderInfo['order_volume_discount_total'];
                            ?>
                            <tr>
                                <td>
                                    <span class="label"><?php echo Labels::getLabel($msg, $siteLangId); ?>:</span>
                                    <span
                                        class="value">-<?php echo CommonHelper::displayMoneyFormat($totalDiscount); ?></span>
                                </td>
                            </tr>
                            <?php } 
                            if (0 < $orderInfo['order_tax_charged']) { ?>
                            <tr>
                                <td>
                                    <span class="label"><?php echo Labels::getLabel('LBL_TAX', $siteLangId); ?>:</span>
                                    <span
                                        class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_tax_charged']); ?></span>
                                </td>
                            </tr>
                            <?php } ?>
                            <?php if (array_key_exists('order_rounding_off', $orderInfo) && $orderInfo['order_rounding_off'] != 0) { ?>
                            <tr>
                                <td>
                                    <span
                                        class="label"><?php echo (0 < $orderInfo['order_rounding_off']) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>:</span>
                                    <span
                                        class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_rounding_off']); ?></span>
                                </td>
                            </tr>
                            <?php } ?>

                            <?php 
                            if($orderInfo['order_type'] == Orders::ORDER_SUBSCRIPTION){
                                ?>
                                <?php if (0 < $orderProducts['ossubs_price']) { ?>
                                    <tr class="hightlighted">
                                    <td>
                                    <span class="label"><?php echo trim(Labels::getLabel('LBL_Sub_Total', $siteLangId)); ?></span>:
                                    <span class="value">
                                        <?php echo CommonHelper::displayMoneyFormat($orderProducts['ossubs_price']); ?>
                                    </span>
                                    </td>
                                    </tr>
                                <?php
                                    } ?>
                                <?php


                                $cardData  = json_decode(html_entity_decode($orderInfo['order_cart_data']),true);
                                if(!empty(abs($cardData['subscription_shopping_cart']['adjusted_amount']))){
                                    ?>
                                    <tr class="hightlighted">
                                        <td>
                                        <span
                                            class="label"><?php echo Labels::getLabel('LBL_Adjusted_Amount', $siteLangId); ?>:</span> 
                                        <span
                                            class="value">-<?php echo CommonHelper::displayMoneyFormat($cardData['subscription_shopping_cart']['adjusted_amount']); ?></span>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                            
                            <tr class="hightlighted">
                                <td>
                                    <span
                                        class="label"><?php echo Labels::getLabel('LBL_NET_AMOUNT', $siteLangId); ?>:</span>
                                    <span
                                        class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_net_amount']); ?></span>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>