<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<script>
    var data = {
        value: <?php echo $orderInfo['order_net_amount']; ?>,
        currency: '<?php echo $orderInfo['order_currency_code']; ?>'
    };
    events.purchase(data);
</script>
<?php
$products = $orderInfo['orderProducts'];
$shippingMethod = '';
$groupProductsArr = [];
$isRentalOrder = false;

if (Orders::ORDER_PRODUCT == $orderInfo['order_type']) {
    foreach ($products as $key => $op) {
        $productImg = UrlHelper::generateFileUrl('Image', 'product', array($op['selprod_product_id'], 'MINI', $op['selprod_id'], 0));
        $shippingMethod .= !empty($op['opshipping_label']) ? '<li><img src="' . $productImg . '" alt="' . $op['selprod_title'] . '" title="' . $op['selprod_title'] . '" /> ' . $op['opshipping_label'] . '</li>' : '';
        if ($op['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
            if ($op['opd_product_type'] == SellerProduct::PRODUCT_TYPE_PRODUCT) {
                $opkey = date('Y-m-d', strtotime($op['opd_rental_start_date'])) . '_' . date('Y-m-d', strtotime($op['opd_rental_end_date'])) . '_' . $op['selprod_id'];
                if (isset($groupProductsArr[$opkey])) {
                    $tempAddonData = (isset($groupProductsArr[$opkey]['addonsData'])) ? $groupProductsArr[$opkey]['addonsData'] : [];
                    $groupProductsArr[$opkey] = $op;
                    $groupProductsArr[$opkey]['addonsData'] = $tempAddonData;
                } else {
                    $groupProductsArr[$opkey] = $op;
                }
                $isRentalOrder = true;
            } else {
                $mainProductKey = date('Y-m-d', strtotime($op['opd_rental_start_date'])) . '_' . date('Y-m-d', strtotime($op['opd_rental_end_date'])) . '_' . $op['opd_main_product_id'];
                ;
                $groupProductsArr[$mainProductKey]['addonsData'][$key] = $op;
            }
        } else {
            $groupProductsArr[$key] = $op;
        }
    }
}

$fulfillmentType = Shipping::FULFILMENT_SHIP;
array_walk($orderFulFillmentTypeArr, function ($row) use (&$fulfillmentType) {
    if (Product::PRODUCT_TYPE_PHYSICAL == $row['op_product_type']) {
        $fulfillmentType = $row['opshipping_fulfillment_type'];
        return;
    }
});

$extendFromOrderIds = array_column($products, 'opd_extend_from_op_id');
?>
<main id="body" class="main body bg-main">
    <section class="section" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-11">
                    <div class="order-completed">
                        <div class="thanks-screen text-center">
                            <!-- Icon -->
                            <div class="success-animation">
                                <svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
                                    <circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"></circle>
                                    <path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"></path>
                                </svg>
                            </div>
                            <h2><?php echo Labels::getLabel('LBL_THANK_YOU!', $siteLangId); ?></h2>
                            <h3>
                                <?php
                              
                                if (Orders::ORDER_PRODUCT == $orderInfo['order_type']) {
                                    $msg = Labels::getLabel('LBL_YOUR_ORDER_{ORDER-ID}_HAS_BEEN_PLACED!', $siteLangId);
                                    $orderDetailUrl = UrlHelper::generateUrl('Buyer', 'viewOrder', array($orderInfo['order_id']));
                                    $orderDetailLinkHtml = '<a href="' . $orderDetailUrl . '" class="link-underline">#' . $orderInfo['order_id'] . '</a>';
                                    $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderDetailLinkHtml]);
                                } else if (Orders::ORDER_SUBSCRIPTION == $orderInfo['order_type']) {
                                    $msg = Labels::getLabel('LBL_ORDER_#{ORDER-ID}_TRANSACTION_COMPLETED!', $siteLangId);
                                    $orderProducts = current($orderInfo['orderProducts']);
                                    $orderDetailUrl = UrlHelper::generateUrl('Seller', 'viewSubscriptionOrder', array($orderProducts['ossubs_id']));
                                    $orderDetailLinkHtml = $orderInfo['order_id'];
                                    if (isset($orderProducts['ossubs_id'])) {
                                        $orderDetailLinkHtml = '<a href="' . $orderDetailUrl . '">' . $orderInfo['order_id'] . '</a>';
                                    }
                                    $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderDetailLinkHtml]);
                                } else if (Orders::ORDER_WALLET_RECHARGE == $orderInfo['order_type'] && !empty($orderInfo['is_flexi_payment'])) {
                                    $msg = Labels::getLabel('LBL_PARTIAL_PAYMENT_HAS_BEEN_RECEIVED_FOR_ORDER_#{ORDER-ID}', $siteLangId);
                                    $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderInfo['flexi_payment_order_id']]);
                                    $msg .= '<br>' . Labels::getLabel('LBL_What\'s_next?_You_can_make_additional_flexible_payments_from_your_dashboard.', $siteLangId);
                                }else if (Orders::ORDER_WALLET_RECHARGE == $orderInfo['order_type']) {
                                   
                                   
                                    $msg = Labels::getLabel('LBL_ORDER_#{ORDER-ID}_TRANSACTION_COMPLETED!', $siteLangId);
                                    $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderInfo['order_id']]);
                                }
                                /* $msg = CommonHelper::replaceStringData($msg, ['{ORDER-ID}' => $orderDetailLinkHtml]); */
                                echo $msg;
                                ?>
                            </h3>
                            <?php if (!CommonHelper::isAppUser()) { ?>
                                <p><?php echo CommonHelper::renderHtml($textMessage); ?></p>
                            <?php } ?>
                            <?php if ($orderInfo['order_type'] != Orders::ORDER_WALLET_RECHARGE) { ?>
                                <p class="">
                                    <svg class="svg" width="16" height="16">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#TimePlaced">
                                        </use>
                                    </svg>
                                    <?php
                                    $replace = [
                                        '{TIME-PLACED}' => '<strong>' . Labels::getLabel('LBL_TIME_PLACED', $siteLangId) . '</strong>',
                                        '{DATE-TIME}' => $orderInfo['order_date_added'],
                                    ];
                                    $msg = Labels::getLabel('LBL_{TIME-PLACED}:_{DATE-TIME}', $siteLangId);
                                    $msg = CommonHelper::replaceStringData($msg, $replace);
                                    echo $msg;
                                    ?>
                                    &nbsp;&nbsp;&nbsp;
                                    <span class="no-print">
                                        <a class="btn btn-icon btn-link"
                                            href="<?php echo ($orderInfo['order_type'] == Orders::ORDER_SUBSCRIPTION) ? UrlHelper::generateFullUrl('custom', 'paymentSuccess', [$orderInfo['order_id'], 'print']) : UrlHelper::generateUrl('buyer', 'viewInvoice', [$orderInfo['order_id']]); ?>">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#print">
                                                </use>
                                            </svg>
                                            <?php echo Labels::getLabel("LBL_PRINT", $siteLangId); ?></a>
                                    </span>
                                </p>
                            <?php } ?>
                        </div>

                        <ul class="completed-detail">
                            <?php
                            if (!empty($orderInfo['shippingAddress']) && in_array(0, $extendFromOrderIds)) {
                                $shippingAddress = $orderInfo['shippingAddress'];
                                ?>
                                <li class="completed-detail-item">
                                    <h4>

                                        <?php echo Labels::getLabel("LBL_SHIPPING_ADDRESS", $siteLangId); ?>
                                    </h4>
                                    <address class="delivery-address">
                                        <h5>
                                            <span>
                                                <?php echo $shippingAddress['oua_name']; ?>
                                            </span>
                                        </h5>
                                        <p>
                                            <?php echo $shippingAddress['oua_address1'] . ''; ?>
                                            <?php echo (strlen($shippingAddress['oua_address2']) > 0) ? $shippingAddress['oua_address2'] . '' : ''; ?>
                                            <?php echo (strlen($shippingAddress['oua_city']) > 0) ? $shippingAddress['oua_city'] . ',' : ''; ?>
                                            <?php echo (strlen($shippingAddress['oua_state']) > 0) ? $shippingAddress['oua_state'] . '' : ''; ?>
                                            <?php echo (strlen($shippingAddress['oua_country']) > 0) ? $shippingAddress['oua_country'] . '' : ''; ?>
                                            <?php echo (strlen($shippingAddress['oua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $shippingAddress['oua_zip'] . '' : ''; ?>
                                        </p>
                                        <p class="phone-txt">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                </use>
                                            </svg>
                                            <?php echo (strlen($shippingAddress['oua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $shippingAddress['oua_dial_code'] . ' ' . $shippingAddress['oua_phone'] : ''; ?>
                                        </p>
                                    </address>
                                </li>
                                <?php
                            }
                            if (Orders::ORDER_PRODUCT == $orderInfo['order_type']) {
                                if (!empty($orderFulFillmentTypeArr) && Shipping::FULFILMENT_PICKUP == $fulfillmentType && in_array(0, $extendFromOrderIds)) {
                                    ?>
                                    <li class="completed-detail-item">
                                        <h4>
                                            <?php echo Labels::getLabel('LBL_ORDER_PICKUP', $siteLangId); ?>
                                        </h4>
                                        <?php
                                        foreach ($orderFulFillmentTypeArr as $orderAddDet) {
                                            if (empty($orderAddDet['addr_id'])) {
                                                continue;
                                            }
                                            ?>
                                            <div class="inline-address">
                                                <strong>
                                                    <?php
                                                    if (!$isRentalOrder) {
                                                        $opshippingDate = isset($orderAddDet['opshipping_date']) ? $orderAddDet['opshipping_date'] . ' ' : '';
                                                        $timeSlotFrom = isset($orderAddDet['opshipping_time_slot_from']) ? $orderAddDet['opshipping_time_slot_from'] . ' - ' : '';
                                                        $timeSlotTo = isset($orderAddDet['opshipping_time_slot_to']) ? $orderAddDet['opshipping_time_slot_to'] : '';
                                                        $timeslot = ($timeSlotFrom . $timeSlotTo != '00:00:00 - 00:00:00') ? $timeSlotFrom . $timeSlotTo : "";
                                                        echo '#' . $orderAddDet['op_invoice_number'] . '<br>' . $opshippingDate . $timeslot;
                                                    }
                                                    ?>
                                                </strong>
                                                <address class="delivery-address">
                                                    <h5>
                                                        <span>
                                                            <?php echo $orderAddDet['addr_name']; ?>
                                                        </span>
                                                    </h5>
                                                    <p>
                                                        <?php echo $orderAddDet['addr_address1'] . ''; ?>
                                                        <?php echo (strlen($orderAddDet['addr_address2']) > 0) ? $orderAddDet['addr_address2'] . '' : ''; ?>
                                                        <?php echo (strlen($orderAddDet['addr_city']) > 0) ? $orderAddDet['addr_city'] . ',' : ''; ?>
                                                        <?php echo (strlen($orderAddDet['state_name']) > 0) ? $orderAddDet['state_name'] . '' : ''; ?>
                                                        <?php echo (strlen($orderAddDet['country_name']) > 0) ? $orderAddDet['country_name'] . '' : ''; ?>
                                                        <?php echo (strlen($orderAddDet['addr_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $orderAddDet['addr_zip'] . '' : ''; ?>
                                                    </p>
                                                    <p class="phone-txt">
                                                        <svg class="svg" width="16" height="16">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                            </use>
                                                        </svg>
                                                        <?php echo (strlen($orderAddDet['addr_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $orderAddDet['addr_dial_code'] . ' ' . $orderAddDet['addr_phone'] : ''; ?>
                                                    </p>
                                                </address>
                                            </div>
                                        <?php } ?>
                                    </li>
                                <?php } else if (!empty($shippingMethod)) { ?>
                                        <li class="completed-detail-item">
                                            <h4>
                                            <?php echo Labels::getLabel('LBL_SHIPPING_METHOD', $siteLangId); ?>
                                            </h4>
                                            <p><?php echo Labels::getLabel('LBL_PREFERRED_METHOD', $siteLangId); ?>: <br>
                                            <ol class="preferred-shipping-list">
                                            <?php echo $shippingMethod; ?>
                                            </ol>
                                            </p>
                                        </li>
                                    <?php
                                }
                                if (!empty($orderInfo['billingAddress'])) {
                                    ?>
                                    <li class="completed-detail-item">
                                        <?php $billingAddress = $orderInfo['billingAddress']; ?>
                                        <h4>

                                            <?php echo Labels::getLabel("LBL_BILLING_ADDRESS", $siteLangId); ?>
                                        </h4>
                                        <address class="delivery-address">
                                            <h5>
                                                <span>
                                                    <?php echo $billingAddress['oua_name']; ?>

                                                </span>
                                            </h5>
                                            <p>
                                                <?php echo $billingAddress['oua_address1'] . ''; ?>
                                                <?php echo (strlen($billingAddress['oua_address2']) > 0) ? $billingAddress['oua_address2'] . '' : ''; ?>
                                                <?php echo (strlen($billingAddress['oua_city']) > 0) ? $billingAddress['oua_city'] . ',' : ''; ?>
                                                <?php echo (strlen($billingAddress['oua_state']) > 0) ? $billingAddress['oua_state'] . '' : ''; ?>
                                                <?php echo (strlen($billingAddress['oua_country']) > 0) ? $billingAddress['oua_country'] . '' : ''; ?>
                                                <?php echo (strlen($billingAddress['oua_zip']) > 0) ? Labels::getLabel('LBL_Zip:', $siteLangId) . ' ' . $billingAddress['oua_zip'] . '' : ''; ?>
                                            </p>
                                            <p class="phone-txt">
                                                <svg class="svg" width="16" height="16">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                    </use>
                                                </svg>
                                                <?php echo (strlen($billingAddress['oua_phone']) > 0) ? Labels::getLabel('LBL_Phone:', $siteLangId) . ' ' . $billingAddress['oua_dial_code'] . ' ' . $billingAddress['oua_phone'] : ''; ?>
                                            </p>
                                        </address>
                                    </li>
                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="section py-0">
        <div class="container">
            <?php if ($orderInfo['order_type'] != Orders::ORDER_WALLET_RECHARGE) { ?>
                <div class="row justify-content-center">
                    <div class="col-xl-11">
                        <div class="cart-page">
                            <main class="cart-page-main">

                                <div class="cart-page-body">
                                    <div class="cart-table list-cart-page">
                                        <?php $shippingCharges = $subTotal = 0;
                                        $durationDiscountTotal = 0;
                                        $totalSecurityAmt = 0;
                                        $addonTotalAmt = 0;

                                        if (Orders::ORDER_PRODUCT == $orderInfo['order_type']) {
                                            foreach ($groupProductsArr as $key => $product) {
                                                $attachedAddons = (isset($product['addonsData'])) ? $product['addonsData'] : [];
                                                $totalSecurityAmt += $product['opd_rental_security'] * $product['op_qty'];
                                                $durationDiscountTotal += $product['opd_rental_duration_discount'];
                                                $productUrl = UrlHelper::generateUrl('Products', 'View', array($product['op_selprod_id']));
                                                $shopUrl = UrlHelper::generateUrl('Shops', 'View', array($product['op_shop_id']));

                                                $productTitle = ($product['op_selprod_title']) ? $product['op_selprod_title'] : $product['op_product_name'];

                                                if ($product['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                    $productUrl = "";
                                                    $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($product['op_selprod_id'], "THUMB", 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                } else {
                                                    $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['selprod_product_id'], "THUMB", $product['op_selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                }
                                                ?>
                                                <div class="cart-table-row" data-cols="1">
                                                    <div class="cart-table-col cart-table-col-1">
                                                        <div class="product-profile">

                                                            <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                                                                <img class="img-fluid" data-ratio="3:4"
                                                                    src="<?php echo $imageUrl; ?>"
                                                                    alt="<?php echo $productTitle; ?>"
                                                                    title="<?php echo $productTitle; ?>">
                                                                <span class="product-qty">
                                                                    <?php echo $product['op_qty']; ?>
                                                                </span>
                                                            </a>


                                                            <div class="product-profile-data">
                                                                <a class="title"
                                                                    href="<?php echo $productUrl; ?>"><?php echo $productTitle; ?></a>
                                                                <?php if (!empty($product['op_selprod_options'])) { ?>
                                                                    <div class="options">
                                                                        <p class="">
                                                                            <?php echo $product['op_selprod_options']; ?>
                                                                        </p>
                                                                    </div>
                                                                <?php } ?>
                                                                <?php
                                                                $subTotal += $txnAmount = ($product["op_unit_price"] * $product["op_qty"]);
                                                                $shippingCharges += $product['op_actual_shipping_charges'];
                                                                ?>
                                                                <?php if ($product['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { ?>
                                                                    <div class="product-price">
                                                                        <?php echo CommonHelper::displayMoneyFormat($txnAmount); ?>
                                                                    </div>
                                                                    <div class="dates">
                                                                        <?php echo Labels::getLabel("LBL_From:", $siteLangId) . ' ' . date('M d, Y H:i ', strtotime($product['opd_rental_start_date'])); ?>

                                                                        <?php echo Labels::getLabel("LBL_To_:", $siteLangId) . ' ' . date('M d, Y H:i ', strtotime($product['opd_rental_end_date'])); ?>
                                                                    </div>

                                                                    <?php if (!empty($attachedAddons)) {
                                                                        echo "<hr/>" . Labels::getLabel("LBL_Attached_Addons", $siteLangId) . " : <ul>";
                                                                        foreach ($attachedAddons as $addon) {
                                                                            $addonTotalAmt += $amount = ($addon["op_unit_price"] * $addon["op_qty"]);

                                                                            ?>
                                                                            <li>
                                                                                <?php echo $addon['op_selprod_title']; ?>
                                                                                <?php echo CommonHelper::displayMoneyFormat($amount); ?>
                                                                            </li>
                                                                        <?php }
                                                                        echo "</ul>";
                                                                    } ?>

                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php
                                            }
                                        } else {
                                            foreach ($products as $subscription) {
                                                $subTotal += $subscription['ossubs_price'];
                                                ?>
                                                <div class="cart-table-row">
                                                    <?php echo Labels::getLabel("LBL_COMMISION_RATE", $siteLangId); ?>
                                                    <span><?php echo CommonHelper::displayComissionPercentage($subscription['ossubs_commission']); ?>%</span>
                                                </div>
                                                <div class="cart-table-row">
                                                    <?php echo Labels::getLabel("LBL_ACTIVE_PRODUCTS", $siteLangId); ?>
                                                    <span><?php echo $subscription['ossubs_products_allowed']; ?></span>
                                                </div>
                                                <div class="cart-table-row">
                                                    <?php echo Labels::getLabel("LBL_PRODUCT_INVENTORY", $siteLangId); ?>
                                                    <span><?php echo $subscription['ossubs_inventory_allowed']; ?></span>
                                                </div>
                                                <div class="cart-table-row">
                                                    <?php echo Labels::getLabel("LBL_IMAGES_PER_PRODUCT", $siteLangId); ?>
                                                    <span><?php echo $subscription['ossubs_images_allowed']; ?></span>
                                                </div>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                            </main>
                            <aside class="cart-page-aside">
                                <div class="cart-total">
                                    <h5>
                                        <?php echo Labels::getLabel('LBL_ORDER_SUMMARY', $siteLangId); ?>
                                    </h5>
                                    <ul class="cart-summary">
                                        <?php if (0 < $subTotal) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Sub_Total', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($subTotal); ?>
                                                </span>
                                            </li>
                                            <?php
                                        } ?>
                                        <?php if ($totalSecurityAmt > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Rental_Security', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalSecurityAmt); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($addonTotalAmt > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Addon_Total_Amount', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($addonTotalAmt); ?>
                                                </span>
                                            </li>
                                        <?php } ?>


                                        <?php
                                        if (0 < $orderInfo['order_reward_point_value'] || 0 < $orderInfo['order_discount_total']) {
                                            $msg = "LBL_REWARD_POINTS";
                                            $totalDiscount = $orderInfo['order_reward_point_value'];
                                            if (!empty($orderInfo['order_discount_total']) && 0 < $orderInfo['order_discount_total']) {
                                                $msg .= "_&_DISCOUNT";
                                                $totalDiscount += $orderInfo['order_discount_total'];
                                            }
                                            ?>
                                            <li class="cart-summary-item">
                                                <span class="label"><?php echo Labels::getLabel($msg, $siteLangId); ?></span>
                                                <span class="value">-
                                                    <?php echo CommonHelper::displayMoneyFormat($totalDiscount); ?></span>
                                            </li>
                                            <?php
                                        }
                                        if (0 < $orderInfo['order_volume_discount_total']) {
                                            $msg = 'LBL_Loyalty/Volume_Discount';
                                            $totalDiscount = $orderInfo['order_volume_discount_total'];
                                            ?>
                                            <li class="cart-summary-item">
                                                <span class="label"><?php echo Labels::getLabel($msg, $siteLangId); ?></span>
                                                <span class="value">-
                                                    <?php echo CommonHelper::displayMoneyFormat($totalDiscount); ?></span>
                                            </li>
                                            <?php
                                        }

                                        if (0 < $durationDiscountTotal) {
                                            ?>
                                            <li class="cart-summary-item">
                                                <span
                                                    class="label"><?php echo Labels::getLabel('LBL_Duration_Discount', $siteLangId); ?></span>
                                                <span class="value">-
                                                    <?php echo CommonHelper::displayMoneyFormat($durationDiscountTotal); ?></span>
                                            </li>
                                            <?php
                                        }

                                        if (0 < $orderInfo['order_tax_charged']) {
                                            ?>
                                            <li class="cart-summary-item">
                                                <span
                                                    class="label"><?php echo Labels::getLabel('LBL_TAX', $siteLangId); ?></span>
                                                <span
                                                    class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_tax_charged']); ?></span>
                                            </li>
                                        <?php } ?>
                                        <?php if (0 < $shippingCharges) { ?>
                                            <li class="cart-summary-item">
                                                <span
                                                    class="label"><?php echo Labels::getLabel('LBL_Delivery_Charges', $siteLangId); ?></span>
                                                <span
                                                    class="value"><?php echo CommonHelper::displayMoneyFormat($shippingCharges); ?></span>
                                            </li>
                                        <?php } ?>
                                        <?php if (array_key_exists('order_rounding_off', $orderInfo) && $orderInfo['order_rounding_off'] != 0) { ?>
                                            <li class="cart-summary-item">
                                                <span
                                                    class="label"><?php echo (0 < $orderInfo['order_rounding_off']) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?></span>
                                                <span
                                                    class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_rounding_off']); ?></span>
                                            </li>
                                        <?php } ?>

                                        <?php
                                        if ($orderInfo['order_type'] == Orders::ORDER_SUBSCRIPTION) {
                                            $cardData = json_decode(html_entity_decode($orderInfo['order_cart_data']), true);
                                            if (!empty(abs($cardData['subscription_shopping_cart']['adjusted_amount']))) {
                                                ?>
                                                <li class="cart-summary-item">
                                                    <span
                                                        class="label"><?php echo Labels::getLabel('LBL_Adjusted_Amount', $siteLangId); ?></span>
                                                    <span
                                                        class="value">-<?php echo CommonHelper::displayMoneyFormat($cardData['subscription_shopping_cart']['adjusted_amount']); ?></span>
                                                </li>
                                                <?php
                                            }
                                        }
                                        ?>
                                        
                                        <?php 
                                        if(!empty($orderInfo['order_pending_amount']) && $orderInfo['order_pending_amount'] > 0){
                                            $orderTotalAmount = $orderInfo['order_net_amount']+$orderInfo['order_pending_amount'];
                                            ?>
                                         <li class="cart-summary-item">
                                            <span
                                                class="label"><?php echo Labels::getLabel('LBL_NET_AMOUNT', $siteLangId); ?></span>
                                            <span
                                                class="value"><?php echo CommonHelper::displayMoneyFormat($orderTotalAmount); ?></span>
                                        </li>
                                        <li class="cart-summary-item highlighted">
                                            <span
                                                class="label"><?php echo Labels::getLabel('LBL_Upfront_Amount', $siteLangId); ?></span>
                                            <span
                                                class="value"><?php echo CommonHelper::displayMoneyFormat(($orderTotalAmount-$orderInfo['order_pending_amount'])); ?></span>
                                        </li>
                                        <li class="cart-summary-item">
                                            <span
                                                class="label"><?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?></span>
                                            <span
                                                class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_pending_amount']); ?></span>
                                        </li>
                                            <?php
                                        } else {
                                            ?>
                                            <li class="cart-summary-item highlighted">
                                                <span
                                                    class="label"><?php echo Labels::getLabel('LBL_NET_AMOUNT', $siteLangId); ?></span>
                                                <span
                                                    class="value"><?php echo CommonHelper::displayMoneyFormat($orderInfo['order_net_amount']); ?></span>
                                            </li>
                                            <?php
                                        }
                                        ?>
                                        
                                    </ul>

                                </div>
                            </aside>
                        </div>
                    </div>
                </div>
            <?php } ?>


        </div>
    </section>
</main>
<?php if (true === $print) { ?>
    <script>
        $(document).ready(function () {
            setTimeout(() => {
                window.print();
            }, 1000);
            window.onafterprint = function () {
                location.href = history.back();
            }
        });
    </script>
    <?php
}
if (Orders::ORDER_PRODUCT == $orderInfo['order_type'] && !empty(FatApp::getConfig("CONF_ANALYTICS_ID"))) {
    ?>
    <script>
        $(document).ready(function () {
            ga('require', 'ecommerce');
            <?php
            echo EcommerceTrackingHelper::getTransactionJs([
                'id' => $orderInfo['order_id'],
                'shipping' => $shippingCharges,
                'tax' => $orderInfo['order_tax_charged'],
                'affiliation' => FatApp::getConfig("CONF_WEBSITE_NAME_" . $siteLangId),
                'currency' => $orderInfo['order_currency_code'],
                'revenue' => $orderInfo['order_net_amount']
            ]);
            foreach ($products as $product) {
                $productTitle = ($product['op_selprod_title']) ? $product['op_selprod_title'] : $product['op_product_name'];
                echo EcommerceTrackingHelper::getItemJs($orderInfo['order_id'], [
                    'name' => $productTitle,
                    'sku' => $product['op_selprod_sku'],
                    'price' => $product["op_unit_price"],
                    'quantity' => $product['op_qty']
                ]);
            }
            ?>
            ga('ecommerce:send');
        });
    </script>
<?php } ?>