<?php
$productUrl = !$isAppUser ? UrlHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : '';
$shopUrl = !$isAppUser ? UrlHelper::generateUrl('Shops', 'View', array($product['shop_id'])) : '';
$imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
?>
<div class="cart-table list-shippings" data-list="SHIPPING SUMMARY">
    <div class="cart-table-head shipping-select shipping-select-row">
        <div class="shop-name">
            <h6>
                <svg class="svg" width="20" height="20">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#manage-shop">
                    </use>
                </svg>
                <?php 
                if ($shipLevel == Shipping::LEVEL_SHOP || $product['isProductShippedBySeller']) {
                    echo $product['shop_name'];
                } else {
                    echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, null, '');
                }
                ?>
            </h6>
        </div>
        <div class="shipping-method">
            <?php
            $isAvailableForShipping = true;
            if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {

                $rates = isset($shippedByItemArr[$shipLevel]['rates']) ? $shippedByItemArr[$shipLevel]['rates'] : [];
                $sellerProductId = $product['selprod_id'];
                if ($cart_type == applicationConstants::PRODUCT_FOR_RENT) {
                    $sellerProductId = $selProdid;
                }

                $priceListCount = !empty($rates) && isset($rates[$sellerProductId]) ? count($rates[$sellerProductId]) : 0;
                if ($priceListCount > 0) {
                    $name = current($rates[$sellerProductId])['code'];
                    $showShippingOptions = true;
                    if (CommonHelper::isDistanceShippingEnabled()) {
                        $distance = current($rates[$sellerProductId])['shiprate_total_distance'];
                        if ($distance < 0) {
                            $showShippingOptions = false;
                        }
                    }                   
                    if ($showShippingOptions) { 
                        echo '<select class="form-control custom-select" name="shipping_services[' . $name . ']">';
                        foreach ($rates[$sellerProductId] as $key => $shippingcharge) {
                            $selected = '';
                            if (!empty($orderShippingData)) {
                                foreach ($orderShippingData as $shipdata) {
                                    if ($shipdata['opshipping_code'] == $name && ($key == $shipdata['opshipping_carrier_code'] . "|" . $shipdata['opshipping_label'] || $key == $shipdata['opshipping_rate_id'])) {
                                        $selected = 'selected=selected';
                                        break;
                                    }
                                }
                            }
                            $shipAmount = $shippingcharge['cost'];
                            if ($isFreeShipEnable && $shopLevelTotalAmount >= $isFreeShipAmount) {
                                $shipAmount = 0;
                            }
                            echo '<option ' . $selected . ' value="' . $key . '">' . $shippingcharge['title'] . ' ( ' . $shippingcharge['shiprate_min_duration'] . ' Day(s) -  ' . CommonHelper::displayMoneyFormat($shipAmount) . ' ) </option>';
                        }
                        echo '</select>';
                    } else {
                        $isAvailableForShipping = false;
                        echo '<span class="text-danger">'.Labels::getLabel('MSG_Shipping_Not_Available_At_Current_Address', $siteLangId).'</span>';
                    }
                } elseif ($product['product_type'] == Product::PRODUCT_TYPE_PHYSICAL) {
                    echo '<span class="text-danger">' . Labels::getLabel('MSG_Product_is_not_available_for_shipping', $siteLangId) . '</span>';
                    $isAvailableForShipping = false;
                }
            } else {
                echo Labels::getLabel('LBL_Shipping_not_applicable_on_extended_orders', $siteLangId);
            }
            ?>
        </div>
    </div>
    <div class="cart-table-row" data-cols="2">
        <div class="cart-table-col cart-table-col-1">
            <div class="product-profile">
                <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                    <img class="img-fluid" src="<?php echo $imageUrl; ?>" alt="<?php echo $product['product_name']; ?>"
                        title="<?php echo $product['product_name']; ?>">
                </a>
                <div class="product-profile-data">
                    <a class="title" href="<?php echo $productUrl; ?>"> 
                        <?php echo ($product['selprod_title']) ? $product['selprod_title'] : $product['product_name']; ?>
                    </a>
                    <?php if (isset($product['options']) && count($product['options'])) {
                        $optionStr = '';
                        foreach ($product['options'] as $option) {
                            $optionStr .= $option['optionvalue_name'] . '|';
                        }
                        echo '<div class="options"><p class="">' . rtrim($optionStr, '|') . '</p></div>';
                    } ?>

                     
                        
                        <?php
                            if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) {
                                $duration = CommonHelper::getDifferenceBetweenDates($product['rentalStartDate'], $product['rentalEndDate'], $product['selprod_user_id'], $product['sprodata_duration_type']);
                            ?>
                        <div class="dates">
                        <?php echo Labels::getLabel('LBL_Quantity', $siteLangId) ?> :
                                    <?php echo $product['quantity']; ?>
                        </div>
                        
                        <div class="dates">
                        <svg class="svg" width="16" height="16">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#calendar">
                                            </use>
                                        </svg>
                            <?php echo Labels::getLabel("LBL_From_:", $siteLangId) . ' ' . date('M d, Y', strtotime($product['rentalStartDate'])); ?>

                            <?php echo Labels::getLabel("LBL_To_:", $siteLangId) . ' ' . date('M d, Y', strtotime($product['rentalEndDate'])); ?>
                        </div>
						<?php } ?>
                        <?php
                        if($cart_type == applicationConstants::PRODUCT_FOR_EXTEND_RENTAL && isset($product['seller_product_upfront_percentage']) && $product['seller_product_upfront_percentage'] != 100){
                        
                        ?>
                   <div class="options">
                        <label class="switch switch-sm switch-icon" for="switch<?php echo md5($product['key']); ?>"><input value="1" <?php echo !empty($product['isParialPaymentEnabled'])?'checked':'' ?> name="partial_payment_<?php echo md5($product['key']) ?>" type="checkbox" id="switch<?php echo md5($product['key']); ?>" onclick="cart.updatePaymentMethod('<?php echo md5($product['key']); ?>', 'checkout')"></label>
                    </div>
                        <?php
                    }
                     ?>
                </div>
            </div>
        </div>
        <div class="cart-table-col cart-table-col-2">
            <?php if (!$isAvailableForShipping) { ?>
            <ul class="actions">
                <li class="actions-item">
                    <button class="actions-link" type="button"
                        onclick="cart.remove('<?php echo md5($product['key']); ?>', 'checkout')"
                        title="<?php echo Labels::getLabel('Lbl_Remove_From_Cart', $siteLangId); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#remove">
                            </use>
                        </svg>
                    </button>
                </li>
            </ul>
            <?php } ?>
        </div>
    </div>
</div>