<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div id="shipping-summary" class="step">
    <div class="step-section">
        <div class="step-body">
            <ul class="review-block">
                <li class="">
                    <div class="review-block-head">

                        <div class="review-block-title">
                            <?php echo Labels::getLabel('LBL_Billing_to:', $siteLangId); ?>
                        </div>

                        <div class="review-block-action">
                            <button class="link-underline" type="button"
                                title="<?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>"
                                onClick="showAddressList()">
                                <?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>
                            </button>
                            <button class="link-underline" onclick="showAddressFormDiv(0);"
                                title="<?php echo Labels::getLabel('LBL_Add_New_Address', $siteLangId); ?>"
                                name="addNewAddress" href="javascript:void(0)">
                                <?php echo Labels::getLabel('LBL_Add_New_Address', $siteLangId); ?>
                            </button>
                        </div>
                    </div>
                    <div class="review-block-body">
                        <div class="delivery-address">
                            <p>
                                <?php echo $addresses['addr_name'] . ', ' . $addresses['addr_address1']; ?>
                                <?php
                                if (strlen($addresses['addr_address2']) > 0) {
                                    echo ", " . $addresses['addr_address2'];
                                    ?>
                                <?php } ?>
                            </p>
                            <p>
                                <?php echo $addresses['addr_city'] . ", " . $addresses['state_name'] . ", " . $addresses['country_name'] . ", " . $addresses['addr_zip']; ?>
                            </p>
                            <?php
                            if (strlen($addresses['addr_phone']) > 0) {
                                $addrPhone = $addresses['addr_dial_code'] . ' ' . $addresses['addr_phone'];
                                ?>
                                <p class="phone-txt">
                                    <svg class="svg" width="16" height="16">
                                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                        </use>
                                    </svg>
                                    <?php echo $addrPhone; ?>
                                </p>
                            <?php } ?>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <div class="step-section">
        <div class="step-head">
            <h5 class="step-title">
                <?php
                $cartObj = new Cart();
                if ($cartObj->hasPhysicalProduct()) {
                    echo Labels::getLabel('LBL_Pickup_Summary', $siteLangId);
                } else {
                    echo Labels::getLabel('LBL_REVIEW_CHECKOUT', $siteLangId);
                }
                ?>
            </h5>
        </div>
        <div class="step-body p-0">
            <div class="cart-table list-shippings" data-list="PICKUP SUMMARY-BUY">
                <?php
                ksort($shippingRates);
                $levelNo = -1;

                foreach ($shippingRates as $pickUpBy => $levelItems) {
                    if (isset($levelItems['products']) && count($levelItems['products']) > 0) {
                        $productData = current($levelItems['products']);
                        ?>
                        <div class="cart-table-head shipping-select shipping-select-row">
                            <div class="shop-name">
                                <h6>
                                    <i class="icn">
                                        <svg class="svg" width="16" height="16">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#manage-shop">
                                            </use>
                                        </svg>
                                    </i>
                                    <?php echo ($pickUpBy == 0) ? FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, null, '') : $productData['shop_name']; ?>
                                </h6>
                            </div>
                        </div>
                        <?php
                        foreach ($levelItems['products'] as $product_key => $product) {
                            $productUrl = !$isAppUser ? UrlHelper::generateUrl('Products', 'View', array($product['selprod_id'])) : 'javascript:void(0)';
                            $shopUrl = !$isAppUser ? UrlHelper::generateUrl('Shops', 'View', array($product['shop_id'])) : 'javascript:void(0)';
                            $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                            ?>
                            <div class="cart-table-row" data-cols="2">
                                <div class="cart-table-col cart-table-col-1">
                                    <div class="product-profile product-profile-sm">
                                        <div class="product-profile-thumbnail">
                                            <a href="<?php echo $productUrl; ?>">
                                                <img class="img-fluid" src="<?php echo $imageUrl; ?>"
                                                    alt="<?php echo $product['product_name']; ?>"
                                                    title="<?php echo $product['product_name']; ?>">
                                            </a>
                                        </div>
                                        <div class="product-profile-data">
                                            <div class="title">
                                                <a class="" href="<?php echo $productUrl; ?>">
                                                    <?php echo ($product['selprod_title']) ? $product['selprod_title'] : $product['product_name']; ?>
                                                </a>
                                            </div>
                                            <div class="options">
                                                <p class="">
                                                    <?php
                                                    if (isset($product['options']) && count($product['options'])) {
                                                        $optionStr = '';
                                                        foreach ($product['options'] as $option) {
                                                            $optionStr .= $option['optionvalue_name'] . '|';
                                                        }
                                                        echo rtrim($optionStr, '|');
                                                    }
                                                    ?>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="cart-table-col cart-table-col-2 text-right">
                                    <?php
                                    $lblText = Labels::getLabel('LBL_SELECT_PICKUP', $siteLangId);
                                    $recordId = ($pickUpBy == 0) ? 0 : $product['shop_id'];
                                    ?>
                                    <div class="js-slot-addr-<?php echo $product['selprod_id']; ?>" data-addr-id="">
                                        <input class="js-slot-id" type="hidden"
                                            name="slot_id[<?php echo $pickUpBy; ?>][<?php echo $product['selprod_id']; ?>]">
                                        <input class="js-slot-date" type="hidden"
                                            name="slot_date[<?php echo $pickUpBy; ?>][<?php echo $product['selprod_id']; ?>]">
                                        <?php
                                        if (count($levelItems['pickup_options']) > 0) {
                                            ?>
                                            <button class="link-brand link-underline" type="button"
                                                onclick="getSellProductsPickupAddresses(<?php echo $product['selprod_id']; ?>, <?php echo $pickUpBy; ?>, <?php echo $recordId; ?>)">
                                                <?php echo $lblText; ?>
                                            </button>

                                        <?php } else {
                                            if ($pickUpBy == 0) {
                                                echo Labels::getLabel('LBL_Pickup_address_not_configured_by_admin', $siteLangId);
                                            } else {
                                                echo Labels::getLabel('LBL_Pickup_address_not_configured_by_Seller', $siteLangId);
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="cart-table-row delivery-address js-slot-addr_<?php echo $product['selprod_id']; ?>"
                                style="display:none">
                                <address class="delivery-address">
                                </address>
                            </div>
                        <?php } ?>
                    <?php } ?>


                <?php } ?>
            </div>
        </div>
        <div class="step-foot">
            <div class="checkout-actions">
                <button type="button" class="btn btn-outline-brand btn-wide" onclick="showAddressList();">
                    <?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>
                </button>
                <?php if ($hasPhysicalProd) { ?>
                    <button type="button" class="btn btn-brand btn-wide " onClick="setUpPickUpForSell();">
                        <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                    </button>
                <?php } else { ?>
                    <button type="button" class="btn btn-brand btn-wide " onClick="loadPaymentSummary();">
                        <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                    </button>
                <?php } ?>
            </div>
        </div>
    </div>
</div>